#include <stdio.h>
#include <ctype.h>


/* =================================== */
/* Emember() - returns char position if character c is a member of string s, 
		0 otherwise. Char positions start with 1 for this purpose. */
Emember( c, s )
char c, s[];
{
int i;
for( i = 0; i < strlen( s ); i++ ) if( s[i] == c ) return( i+1 );
return( 0 );
}

/* =================================== */
/* Esmember() - returns 1 if string s is present as a token in sep-separated list t,
		0 otherwise.  Auth: Steve Grubb */
Esmember( s, t, sep )
char s[], t[], sep[];
{
char tok[100];
int i;
i = 0;
while( 1 ) {
	Egetchunk( tok, t, &i, sep );
	if( tok[0] == '\0' ) break;
	if( strcmp( tok, s ) == 0 ) return( 1 );
	}
return( 0 );
}

/* ================================== */
/* Ecounttokens() - returns number of tokens on line */

Ecounttokens( s )
char s[];
{
char tok[100];
int ix, j;
ix = 0;
for( j = 0; ; j++ ) {
	Egetchunk( tok, s, &ix, " 	");
	if( tok[0] == '\0' ) return( j );
	}
}

/* =================================== */
/* strip white-space off of front and end of string s */
Estrip_ws( s )
char s[];
{
int i, j;
/* find last significant char and put a null after it */
for( j = strlen( s ) -1; j >= 0; j-- )
	if( !Emember( s[j], " \t\n" )) break;
s[j+1] = '\0';
/* find 1st significant char at position i */
for( i = 0; i < strlen( s ); i++ ) 
	if( !Emember( s[i], " \t\n" )) break; 
strcpy( s, &s[i] );
}

/* ====================================== */
/* get rid of imbedded backslashes.. */
Estrip_bs( s )
char s[];
{
int i, j;
j = 0;
for( i = 0; i < strlen( s ); i++ ) if( s[i] != '\\' ) s[j++] = s[i];
s[j] = '\0';
}

/* ================= */
Esysdate( mon, day, yr )
int	*mon, *day, *yr ;
{
	int	tvec[2], *dtime ;

	time( tvec );
	dtime = (int *)(localtime( tvec ));
	*mon = *(dtime+4) + 1 ;
	*day = *(dtime+3)  ;
	*yr = *(dtime+5)  ;
}
/* ================= */
Esystime( hour, min, sec )
int	*hour, *min, *sec ;
{
	int	tvec[2], *dtime ;

	time( tvec );
	dtime = (int *)localtime( tvec );
	*hour = *(dtime+2) ;
	*min = *(dtime+1)  ;
	*sec = *(dtime)  ;
}
/* =========================================== */
/* Get lines, which are separated by a newline (\n) */
/* (different from Egetchunk in the handling of consecutive occurrences of the separator) */
Egetln( rtn, inbuf, i )
char rtn[];
char inbuf[];
int *i;
{
int n;

n = 0;
rtn[0] = '\0';
while( 1 ){
	if( inbuf[*i] == '\0' ) break;
	else if( inbuf[*i] == '\n' ) { (*i)++; break; }
	else rtn[n++] = inbuf[(*i)++];
	if( n >= 511 ) break; /* 512 max */
	}
rtn[n] = '\0' ;
}



/* ============================================ */
/* Get tokens, which are separated by any member of sepstring */

Egetchunk( rtn, line, i, sepstring )
char rtn[];
char line[];
int *i;
char sepstring[];
{

int n;

while( Emember( line[(*i)], sepstring ) ) (*i)++; 
n = 0;
rtn[0] = '\0';
while( 1 ){
	if( Emember( line[*i], sepstring ) || line[*i] == '\0' ) break;
	else rtn[n++] = line[(*i)++];
	}
rtn[n] = '\0' ;
}
/* ============ */
/* test routine */
/*
* main()
* {
* char foo[20];
* int ix;
* ix = 0;
* Egetchunk( foo, "\nhello\nworld", &ix, "\n" );
* printf( "1. (%s) ix=%d\n", foo, ix );
* Egetchunk( foo, "\nhello\nworld", &ix, "\n" );
* printf( "2. (%s) ix=%d\n", foo, ix );
* Egetchunk( foo, "\nhello\nworld", &ix, "\n" );
* printf( "3. (%s) ix=%d\n", foo, ix );
* }
*/

/* ============================================= */
/* Eexpand_tabs()
      Takes a string parameter 'in' and expands tabs into spaces, placing the
      result into parameter 'out'.  Analagous to BSD expand(1).
      steveg 910531
 */
Eexpand_tabs( out, in )
char in[], out[];
{
int i, j, k, l;

out[0] = '\0';
k = 0;
for( i = 0; i < strlen( in ); i++ ) {
	if( in[i] == '\t' ) {
		j =  8 - ( k % 8 ); /* 1 to 8 spaces needed */
		for( l = 0; l < j; l++ ) out[k++] = ' ';
		}
	else out[k++] = in[i];
	}
out[k] = '\0';
}

/* ======================================================== */
/* copy a file.  Mode is either "w" for create or "a" for append  */
Efilecopy( source, dest, mode )
char source[], dest[], mode[];
{
FILE *fp1, *fp2;
char buf[512];

fp1 = fopen( source, "r" );
if( fp1 == NULL ) { printf( "cant open %s to copy from\n", source ); return( 0 ); }
fp2 = fopen( dest, mode );
if( fp2 == NULL ) { printf( "cant open %s to copy to\n", dest ); return( 0 ); }

while( fgets( buf, 512, fp1 ) != NULL ) fprintf( fp2, "%s", buf );

fclose( fp1 ); fclose( fp2 );
return( 1 );
}

/* ======================================================== */
/* returns a char representation of a float (using %g format). */
char *
Eftoa( f )
double f;
{ 
static char buf[30];
sprintf( buf, "%g", f );
return( buf );
}
/* ==========================================
 * getok( )
*/
#define GETOKMAX        100
char *Egetok( string, index )
        char    string[];       /* array to obtain token from */
        int     *index;
        {
                static char     tok[GETOKMAX+1];
                register        n;
                while( Emember( string[(*index)], " \t\n" ) ) (*index)++;
                /* EAT( SPACE, TAB, EOR, string, (*index) ); */
                for( n=0;
                        n <= GETOKMAX &&
                        string[*index] != ' '  &&
                        string[*index] != '\t'  &&
                        string[*index] != '\n'  &&
                        string[*index] != '\0'  ;
                                tok[n++] = string[(*index)++] )  ;
                tok[n] = '\0' ;
                if( n > GETOKMAX ) fprintf( stderr, "token %s too long\n", tok );
                return(tok);
        }
/* ============================================ */
/* Get a certain line from a certain file.. */
/* returns 1 on success, 0 on fail */
/* no checking is done on the length of line string */
Efileline( filenm, ln, line )
char filenm[], line[];
int ln;
{
FILE *fp;
int n;

line[0] = '\0';
fp = fopen( filenm, "r" );
if( fp == NULL ) return( 0 );

n=0;
while( fgets( line, 512, fp ) != NULL ) {
	n++;
	if( n == ln ) { fclose( fp ); return( 1 ); }
	}
return( 0 );
}

/* ============================================== */
/* see if point (x,y) is on the line (or close to it) */
Eispointonline( x, y, x1, y1, x2, y2 )
double x, y, x1, y1, x2, y2;
{
double m, b;
int online;
double margin, fabs();

margin = 0.15; /* tolerance */

online = 0;
if( fabs( x1 - x2 ) < 0.05 ) {
	if( fabs( x - x1 ) < margin ) online = 1; /* approaching a vertical line */
	}
else	{ /* other lines.. */
	m = ( y2 - y1) / (x2 - x1 );
	if( fabs( m ) > 8.0 ) margin *= 8; /* slopes approaching vertical */
	b = y1 - ( m * x1 );
	if( fabs( y - (( m * x ) + b )) < margin ) online = 1;
	}
if( online ) {
	if( x1 < x2 && x >= x1 && x <= x2 ) return( 1 );
	else if( x1 > x2 && x <= x1 && x >= x2 ) return( 1 );
	else if( x1 == x2 ) {
		if( y1 < y2 && y >= y1 && y <= y2 ) return( 1 );
		else if( y1 > y2 && y <= y1 && y >= y2 ) return( 1 );
		}
	}
return( 0 );
}
/* ================================================== */
/* see if point( x, y ) overlaps with cirular (u, v) with radius r. */
Econtain( x, y, u, v, r )
double x, y, u, v, r;
{
double fabs();
if( fabs( x - u ) < r && fabs( y - v ) < r ) return( 1 );
else return( 0 );
}
/* ================================================== */
/* goodnum() - checks a token to see if it is a legal number,
	either float or integer, returns 1 if so, 0 if not a
	legal number.  Returns 2nd arg which is the position of
	the decimal point (if any).
*/
Egoodnum( str, prec )
char str[];
int *prec;
{
int l, p, bad, point, n;
char numstr[80], foo[80];

n = sscanf( str, "%s %s", numstr, foo );
if( n > 1 ) return( 0 );  /* multiple tokens==string */

l = strlen( numstr );
if( l < 1 ) return( 0 );
bad = 0; *prec = -1;
for( p = 0; p < strlen( numstr ); p++ ) { 
	if( numstr[p] == '.' ) { if( *prec == -1 ) *prec = p; else bad=1; }
	else if( p == 0 && l > 1 && ( numstr[p] == '-' || numstr[p] == '+' ) );
	else if( ! isdigit( numstr[p]) ) bad=1;
	}
if( bad ) return( 0 );
else return( 1 );
}

/* =============================== */
/* append str to buffer */

Eaddb( bb, str )
char bb[], str[];
{
int len;

len = strlen( bb );
sprintf( &bb[ len ], "%s", str );
}

