#include "elib.x"
/* draw a data point */
/* point styles are selected by the code string "symNSf.ff", where N is an integer
   0-9 selecting the shape, S is a lower-case character selecting the style, and
   f.ff is an optional shade, which overrides that selected as part of the style.  
   N and S are required.  See point1.g in the examples.
*/
#define NVARIAT 18
#define NSHAPE 8


Emark( x, y, code, r )
double x, y; 	/* point location in abs space */
char code[];	/* pre-set symbol name */
double r; 	/* radius of dot in absolute units */
{
int i;
double g, theta;
static char prevcode[10] = "";
static double prev_r, shade;
static int inc, ins;
static int nc[] =    {  3,  3,  4,  4,  5, 12, 3, 3 };	/* number of corners */
static int nt[] =    { 90,270,  0, 45, 90, 90, 0, 180 }; /* location (in deg) to start building point */
/* preset outline thicknesses.. */
static double ol[] = { .5,  1,1.5,  2, .5, .5, .5, .5, .5,  0,  0,  0,  0, 0, -0.5, -1, -1.5, -2 }; 
/* preset shades..  */
static double sh[] = { -1, -1, -1, -1,  1, .9, .7, .5, .3, .9, .7, .5, .3, 0, -1, -1,  -1,  -1 }; 
static double h[14][2]; /* the offsets */

/* no-op code */
if( strcmp( code, "sym00" ) == 0 ) return( 0 );

if( strcmp( code, prevcode ) != 0 || r != prev_r ) {
	strcpy( prevcode, code );
	prev_r = r;
	inc = ((code[3] - '0') -1 ) % NSHAPE;
	if( code[4] == '\0' ) code[4] = 'a';
	ins = (code[4] - 'a') % NVARIAT;
	if( strlen( code ) > 5 )shade = atof( &code[5] );
	else shade = sh[ins];

	theta = 360.0 / (double)nc[inc];
	/* get offsets */
	g = nt[inc];
	for( i = 0; i < nc[inc]; i++ ) {
		h[i][0] = r * cos( (g*3.1415927)/180.0 );
		h[i][1] = r * sin( (g*3.1415927)/180.0 );
		g += theta;
		}
	}

/* lock-on */
/* shade point */
if( shade >= 0 ) {
	Emov( x+h[0][0], y+h[0][1] );
	for( i = 1; i < nc[inc]; i++ ) Epath( x+h[i][0], y+h[i][1] );
	Eshade( shade );
	}

/* draw perimeter point */
if( ol[ins] > 0.0 ) {
	Elinetype( 0, ol[ins], 1.0 );
	Emov( x+h[0][0], y+h[0][1] );
	for( i = 1; i < nc[inc]; i++ ) Elin( x+h[i][0], y+h[i][1] );
	Elin( x+h[0][0], y+h[0][1] );
	Enormline();
	}

/* draw spokes */
if( ol[ins] < 0.0 ) {
	double fabs();
	Elinetype( 0, fabs(ol[ins]), 1.0 );
	for( i = 0; i < nc[inc]; i++ ) { Emov( x, y ); Elin( x+h[i][0], y+h[i][1] ); }
	Enormline();
	}
/* lock-off */

}


/* ======================================= */
/* draw a circle of n "sides" */
Ecircle( cx, cy, r, shade, outline )
double cx, cy; 	/* point location in abs space */
double r; 	/* radius of dot in absolute units */
double shade;	/* shade, from 0.0 to 1.0.  If shade < 0.0, no filling takes place. */
int outline;    /* if 1, circle will be outlined. */
{
double theta, x, y, g;
int i;
static double hx[32], hy[32];
static int first = 1;
int n;

n = 25;


if( first ) {
	first = 0;
	theta = 360.0 / (double)n;
	/* get offsets */
	g = 0.0;
	for( i = 0; i < n+1; i++ ) {
		hx[i] = cos( (g*3.1415927)/180.0 );
		hy[i] = sin( (g*3.1415927)/180.0 );
		g += theta;
		}
	}
if( shade >= 0.0 ) {
	for( i = 0; i < n+1; i++ ) {
		if( i == 0 ) Emov( cx+(r*hx[i]), cy+(r*hy[i]) );
		else Epath( cx+(r*hx[i]), cy+(r*hy[i]) );
		}
	Eshade( shade );
	}
if( outline ) {
	for( i = 0; i < n+1; i++ ) {
		if( i == 0 ) Emov( cx+(r*hx[i]), cy+(r*hy[i]) );
		else Elin( cx+(r*hx[i]), cy+(r*hy[i]) );
		}
	}
}
/* ========================================= */
/* draw an elipse */
Eellipse( cx, cy, r1, r2, shade, outline )
double cx, cy, r1, r2;
double shade;	/* shade, from 0.0 to 1.0.  If shade < 0.0, no filling takes place. */
int outline;    /* if 1, circle will be outlined. */
{
double theta, x, y, g;
int i;
static double hx[32], hy[32];
int n;

n = 25;

theta = 360.0 / (double)n;
/* get offsets */
g = 0.0;
for( i = 0; i < n+1; i++ ) {
        hx[i] = cos( (g*3.1415927)/180.0 );
        hy[i] = sin( (g*3.1415927)/180.0 );
        g += theta;
        }

if( shade >= 0.0 ) {
	for( i = 0; i < n+1; i++ ) {
       		if( i == 0 ) Emov( cx+(r1*hx[i]), cy+(r2*hy[i]) );
        	else Epath( cx+(r1*hx[i]), cy+(r2*hy[i]) );
		}
	Eshade( shade );
        }

if( outline ) {
	for( i = 0; i < n+1; i++ ) {
	        if( i == 0 ) Emov( cx+(r1*hx[i]), cy+(r2*hy[i]) );
	        else Elin( cx+(r1*hx[i]), cy+(r2*hy[i]) );
	        }
	}
}


