#include "elib.x"
#define MAXNEST 6

static int Enest = 0;				/* current object nest level */
static double Exmax[MAXNEST], Eymax[MAXNEST], Exmin[MAXNEST], Eymin[MAXNEST]; /*obj stack: bounding info*/
static int Ecalcflag[MAXNEST];			/* obj stack: does bb need to be calculated? */
static int Eid[MAXNEST];			/* obj stack: obj ids */
static int Ewhichend = 0;

/* ================================================= */
/* Begin an object. */
Eobjbegin( id )
int id;
{
char str[E_GPBUF];
int len;

if( Enest > (MAXNEST-1) ) { fprintf( stderr, "too many object nest levels\n" ); return( 0 ); }
Eid[ Enest ] = id;

/* if bb exists (but not in inheritance) , it need not be computed.. */
EIgetd( id, "*", "bb", &len );
if( len != 4 ) {
	Ecalcflag[ Enest ] = 1;
	Exmax[ Enest ] = -1.0; Exmin[ Enest ] = 20.0;
	Eymax[ Enest ] = -1.0; Eymin[ Enest ] = 20.0;
	}
else Ecalcflag[ Enest ] = 0;

/* set parent */
if( Enest >= 1 ) {
	sprintf( str, "%d", Eid[ Enest-1 ] );
	EImodattr( id, "", "*/parent", str );
	}
Enest++;
Esetobjectflag( 1 ); /* see pcode.c */
}
	
/* ================================================= */
/* End an object.  Save the bounding box we just calculated.. */
/* Returns the proc_id of the object. */
Eobjend( bbtyp )
char bbtyp[];
{
char str[E_GPBUF];
int i;

Enest--;
if( Enest <= 0 ) Enest = 0; 

if( ! (( Exmin[ Enest ] > Exmax[ Enest ] ) && ( Eymin[ Enest ] > Eymax[ Enest ] )) 
    && Ecalcflag[ Enest ] ) {
	sprintf( str, "%g %g %g %g", Exmin[ Enest ], Eymin[ Enest ], Exmax[ Enest ], Eymax[ Enest ] );
	EImodattr( Eid[ Enest ], "", "*/bb", str );
	EImodattr( Eid[ Enest ], "", "*/bbt", bbtyp );
	}
if( Enest == 0 ) Esetobjectflag( 0 ); /* see pcode.c */
return( Eid[ Enest ] );
}
/* ================================================= */
Echecknest()
{
return( Enest );
}

/* ================================================= */
/* check bounding box to see if we have new min or max.. */
/* (checks all active group nest levels..) */
Echeckbb( x, y )
double x, y;
{
int inest;

if( Enest == 0 ) return( 1 );  /* level 0 -- no need to keep info.. */

for( inest = 0; inest < Enest; inest++ ) {
	if( Ecalcflag[ inest ] == 1 ) {
		if( x > Exmax[ inest ] ) Exmax[ inest ] =  x;
		if( x < Exmin[ inest ] ) Exmin[ inest ] =  x;
		if( y > Eymax[ inest ] ) Eymax[ inest ] =  y;
		if( y < Eymin[ inest ] ) Eymin[ inest ] =  y;
		}
	}
}
/* =============================================== */
/* null out the bounding box of an object (and all ancestors), to */
/* forced them to be recalculated.  */
Enulloutbb( p )
int p;
{
int *parent, len;

while( 1 ) {
	if( !EIexists( p, "", "*/bb" )) return( 0 );

	EImodattr( p, "", "*/bb", "" );
	parent = EIgeti( p, "", "*/parent", &len );
	if( len < 1 ) return( 0 );
	else p = *parent;
	}
}

/* =============================================== */
/* show the zone of an object */

Eobjoutline( id )
int id;
{
double *p, *q, *r, *s;
char *typ;
/* remember the parameters from last highlight so we can turn it off */
static double op, oq, or, os;
static char otyp = '\0';
int len;

Ejournalsuspend();
Egraphenv( E_PUSH );
Elinetype( 0, 3.0, 1.0 );
if( otyp != '\0' ) { /* get rid of emphasis */
	Epenerase();
	if( otyp == 'B' ) Eblock( op, oq, or, os, -1.0, 1 );
	else if( otyp == 'L' ) { Emov( op, oq ); Elin( or, os ); }
	Ependraw();
	Elinetype( 1, 0.5, 1.0 );
	if( otyp == 'B' ) Eblock( op, oq, or, os, -1.0, 1 );
	else if( otyp == 'L' ) { Emov( op, oq ); Elin( or, os ); }
	Elinetype( 0, 3.0, 1.0 );
	}

if( id == E_NIL ) { otyp = '\0'; goto RETURN; }


if( ! EIexists( id, "*", "bb" )) goto RETURN;
p = EIgetd( id, "*", "bb", &len );
if( len != 4 ) goto RETURN;
q = p+1; r = p+2; s = p+3;
typ = EIgetc( id, "*","bbt", &len );

if( *typ == 'B' ) Eblock( *p, *q, *r, *s, -1.0, 1 );
else if( *typ == 'L' ) { Emov( *p, *q ); Elin( *r, *s ); }

otyp = (*typ); op = (*p); oq = (*q); or = (*r); os = (*s);


RETURN:
Egraphenv( E_POP );
Ejournalresume();
return( 0 );
}

/* =============================================== */
/* show the tentative zone of an object if translated or scaled by (x,y) */


Etentativeoutline( id, tx, ty, mode )
int id;
double tx, ty;
char mode[];  /* T for translate or S for scale */
{
double *p, *q, *r, *s;
char *typ;
/* remember the parameters from last highlight so we can turn it off */
static double op, oq, or, os;
static char otyp = '\0';
int len;

Ejournalsuspend();
Egraphenv( E_PUSH );
Elinetype( 0, 2.0, 1.0 );
if( otyp != '\0' ) {
	Epenerase();
	if( otyp == 'B' ) Eblock( op, oq, or, os, -1.0, 1 );
	else if( otyp == 'L' ) { Emov( op, oq ); Elin( or, os ); }
	Ependraw();
	}

if( id == E_NIL ) { Ewhichend = 0; otyp = '\0'; goto RETURN; } /* reset */

if( ! EIexists( id, "*", "bb" )) goto RETURN;
p = EIgetd( id, "*", "bb", &len );
if( len != 4 ) goto RETURN;
q = p+1; r = p+2; s = p+3;

typ = EIgetc( id, "*", "bbt", &len );

if( mode[0] == 'T' ) { /* translation (move,copy,show)*/
	if( *typ == 'B' ) Eblock( *p+tx, *q+ty, *r+tx, *s+ty, -1.0, 1 );
	else if( *typ == 'L' ) { Emov( *p+tx, *q+ty ); Elin( *r+tx, *s+ty ); }
	otyp= (*typ); op = *p+tx; oq = *q+ty; or=*r+tx; os = *s+ty;
	}
else if( mode[0] == 'S' ) { /* scaling (resize) */
	if( *typ == 'B' ) {
		Eblock( *p, *q, tx, ty, -1.0, 1 );
		op = *p; oq = *q; or=tx; os = ty;
		}
	else if( *typ == 'L' ) { 
		/* needs work */
		if( Ewhichend == 0 ) {
			if( (fabs(tx-*p)+fabs(ty-*q)) < (fabs(tx-*r)+fabs(ty-*s))) Ewhichend = 1;
			else Ewhichend = 2;
			}
		if( Ewhichend == 1 ) { Emov( tx, ty ); Elin( *r, *s ); op=tx; oq=ty; or=*r; os=*s; }
		else if( Ewhichend == 2 ) { Emov( *p, *q ); Elin( tx, ty ); op=*p; oq=*q; or=tx; os=ty; }
		}
	otyp = *typ;
	}

RETURN:
Egraphenv( E_POP );
Ejournalresume();
return( 0 );
}
/* =========================================== */
/* show all bounding boxes */
Eshowallbounds()
{
int i, n;
char *typ;
double *d1, *d2, *d3, *d4;
int len;
int ip;

Egraphenv( E_PUSH );
Ejournalsuspend();
Elinetype( 0, 3.0, 3.0 );
EIgetnextobj( E_AT_BEGINNING, 0 );
while( 1 ) {
	ip = EIgetnextobj( E_NEXT, 0 ); 
	if( ip < 0 ) break;

	if( ! EIexists( ip, "*", "bb" )) continue;
	d1 = EIgetd( ip, "*", "bb", &len );
	if( len != 4 ) continue;
	d2 = d1 + 1; d3 = d1 + 2; d4 = d1 + 3;

	typ = EIgetc( ip, "*", "bbt", &len );
	if( len < 1 ) continue;

        EIgetc( ip, "*", "display", &len );
        if( len < 1 ) continue; /* its invisible.. */
	
	if( *typ == 'B' ) Eblock( *d1, *d2, *d3, *d4, -1.0, 1 );
	else if( *typ == 'L' ) { Emov( *d1, *d2 ); Elin( *d3, *d4 ); }
	}
EIgetnextobj( E_DONE, 0 );
Ejournalresume();
Egraphenv( E_POP );
}
/* ============================================== */
