/*
COPA 1.0 - gui control panel kit for shell, C, perl etc.  
*              **      **                              *
Copyright 1991-1996 by Stephen C. Grubb.

Permission is hereby granted to USE this software for free.
Permission is hereby granted to MODIFY and/or REDISTRIBUTE 
this software for free, provided that no monetary gain is 
realized, and all attached authorship and copyright notices 
are preserved.

Inclusion of any portion (or derivation) of this software, 
including ancillary files, in any commercial product is not 
allowed without prior written permission of the author.  

See also the file 'Copyright'. 
*/





/* Postscript driver.	(c) 1989 Steve Grubb


	13 Nov 95 scg	upgraded to EPSF-3.0 guidelines, including:
			bounding box and page # information; and
			using "userdict begin" and "end" to ensure
			that dictionary stack is undisturbed.

			As far as I can tell, all operands pushed onto
			the operand stack will be popped.

			Added a closepath to the stroke operator.

			Added EPstdout to ensure that stdout doesn't get
			fclosed.
*/

#include <stdio.h>
#define YES 1
#define NO 0
#define PORTRAIT 0
#define LANDSCAPE 1
#define MARG_X 14 
#define MARG_Y 8 
#define PAGWIDTH 600;

static int EPorient;		/* paper orientation */
static int EPorgx, EPorgy;	/* location of origin on page */
static int EPtheta;		/* current rotation for page orientation */
static char EPfont[50];		/* current font name */
static int EPchdir;	 	/* char direction in degrees */
static int EPcurpointsz;		/* current char size in points */
static double EPlinewidth, EPdashmag; /* line thickness and dash magnif. */
static char EPlinetype[20];		/* line type */
static int EPstdout;		/* 1 if Epf is stdout */

double atof();
static FILE *Epf;

/* ============================= */
EPSsetup( name, f )    /* initialize */
char *name; /* arbitrary name */
char f[];  /* file to put code in */
{  
/* set globals */
EPorient = -1;
strcpy( EPfont, "/Helvetica" );
EPtheta = 0;
EPchdir = 0;
EPcurpointsz = 10;

EPstdout = 0;
if( f[0] == '-' ) {
	Epf = stdout;
	EPstdout = 1;
	}
else Epf = fopen( f, "w" );
if( Epf == NULL ) Epf = stdout;

/* print header */
fprintf( Epf,  "%%!PS-Adobe-3.0 EPSF-3.0\n" );
fprintf( Epf,  "%%%%Title: %s\n", name );
fprintf( Epf,  "%%%%Creator: elib 2.0\n" );
fprintf( Epf,  "%%%%Copyright: Generated by ELIB 2.0 (c) 1989-96 Stephen Grubb\n" );
fprintf( Epf,  "%%%%Copyright: and Johns Hopkins University School of Medicine.\n" );
fprintf( Epf,  "%%%%Copyright: stevegru@welchlink.welch.jhu.edu\n" );
fprintf( Epf,  "%%%%Copyright: 550 N. Broadway #900 Baltimore, Maryland 21205 USA\n" );
fprintf( Epf,  "%%%%Pages: (atend)\n%%%%BoundingBox: (atend)\n%%%%EndComments\n\n\n" );
fprintf( Epf,  "%%%%BeginProlog\n" );

	
/* set up macros (mainly to reduce output verbosity) */
fprintf( Epf,  "userdict begin\n" );
fprintf( Epf,  "/sset\n" );
fprintf( Epf,  "{ translate rotate } def \n" );
fprintf( Epf,  "/sclr\n" );
fprintf( Epf,  "{ rotate translate } def \n" );
fprintf( Epf,  "/mv { moveto } def\n" );
fprintf( Epf,  "/np { newpath } def\n" );
fprintf( Epf,  "/ln { lineto } def\n" );
/* fprintf( Epf,  "/st { closepath stroke } def\n" ); */ /* closepath added scg 11-9-95 */
fprintf( Epf,  "/st { stroke } def\n" ); /* closepath deleted scg 1-23-96 */
fprintf( Epf,  "/sh { show } def\n" );
fprintf( Epf,  "/cent { stringwidth pop sub 2 div 0 rmoveto } def\n" );
fprintf( Epf,  "/rjust { stringwidth pop sub 0 rmoveto } def\n" );

/* load default font */
fprintf( Epf,  "%s findfont\n", EPfont );
fprintf( Epf,  "%d scalefont setfont\n", (int) EPcurpointsz );

/* set up standard line width */
fprintf( Epf,  "1 setlinewidth\n" );

fprintf( Epf,  "%%%%EndProlog\n" ); 
}

/* ============================= */
EPSclose()
{
if( EPstdout ) return( 0 ); /* we don't want to close stdout */
if( Epf != NULL )fclose( Epf );
}


/* ============================= */
EPSmoveto( x, y )
double x, y;
{

/* convert to p.s. units (1/72 inch) */
x = ( x * 72.0 ) +MARG_X; y = ( y * 72.0 ) + MARG_Y; 
fprintf( Epf,  "np\n%-5.2f %-5.2f mv\n", x, y ); 
}


/* ============================= */
EPSlineto( x, y )
double x, y;
{
/* convert to p.s. units */
x = ( x * 72 ) +MARG_X; 
y = ( y * 72 ) +MARG_Y; 
fprintf( Epf,  "%-5.2f %-5.2f ln\n", x, y );
}

/* ============================== */
EPSstroke( )
{
fprintf( Epf, "st\n" );
}


/* ============================= */
EPSpath( x, y )
double x, y;
{
/* convert to p.s. units */
x = ( x * 72 ) +MARG_X; y = ( y * 72 ) + MARG_Y; 
fprintf( Epf,  "%-5.2f %-5.2f ln\n",  x, y );
}


/* ============================= */
EPSshade( s )
double s;
{
fprintf( Epf,  "closepath\n%3.2f setgray\nfill\n0 setgray\n", s );
}

/* ============================== */
EPSpaper( i )
int i;
{
if( EPorient != -1 ) return( 1 );		/* paper orientation - can only be done once per page */
if( i == 1 ) { /* handle landscape mode-- it's put into portrait mode before beginning each page */
	EPorgx = PAGWIDTH; 
	EPorgy = 0; 
	EPtheta = 90; 
	fprintf( Epf,  "%d %d %d sset\n", EPtheta, EPorgx, EPorgy );
	} 
EPorient = (int) i;
}


/* ================================= */
EPStext( com, x, y, s, w )
char com;
double x, y;
char s[];
double w;
{
char str[400];
int i, j, k;

x = (x*72)+MARG_X;  y = (y*72)+MARG_Y; w *= 72;

/* if text direction is not normal do a rotate then move.. */
if( EPchdir != 0 ) fprintf( Epf,  "%d %-5.2f %-5.2f sset 0 0 mv\n", EPchdir, x, y ); 
/* normal direction-- do a move.. */
else fprintf( Epf,  "%-5.2f %-5.2f mv ", x, y );

if( Emember( com, "CJ" )) Estrip_ws( s );

/* escape out parens */
for( i = 0, j = 0; i < strlen( s ); i++ ) {
	if( s[i] == '(' || s[i] == ')' ) { str[j++] = '\\'; str[j++] = s[i]; }
	else str[j++] = s[i];
	}
str[j] = '\0';

/* centered text */
if( com == 'C' ) fprintf( Epf,  "%-5.2f (%s) cent ", w, str ); 
else if( com == 'J' ) fprintf( Epf,  "%-5.2f (%s) rjust ", w, str );

/* do the string */
fprintf( Epf,  "(%s) sh\n", str );

if( EPchdir != 0 ) fprintf( Epf,  "%-5.2f %-5.2f %d sclr\n", -x, -y, -EPchdir ); /* restore */
}


/* ================================= */
EPSpointsize( p )
int p;
{
if( p != EPcurpointsz ) { 	/* char size (specified in points) */
	EPcurpointsz = p;
	fprintf( Epf,  "%s findfont\n", EPfont );
	fprintf( Epf,  "%d scalefont\nsetfont\n", p );
	}
}


/* ================================== */
EPSfont( f )
char f[];
{
if( strcmp( f, EPfont ) != 0 ) {
	strcpy( EPfont, f );
	fprintf( Epf,  "%s findfont\n", EPfont );
	fprintf( Epf,  "%d scalefont setfont\n", EPcurpointsz );
	}
}

/* ================================== */
EPSchardir( t )
int t;
{
EPchdir = t;
}


/* ================================== */
EPSlinetype( s, x, y )
char s[];
double x, y;
{
/* X = line width;  Y = dash pattern magnification (0.1 to 10)
 *  S indicates dash pattern.  If S is "0", an unbroken (normal) line is produced.
 *  If S is "1" through "8", a preset dash pattern is used.  Otherwise, S is
 *  assumed to hold the dash pattern string "[ n1 n2 n3.. ]".	
 */
static int dash[10][6]= { {0,0,0,0,0,0}, {1,1}, {3,1}, {5,1}, {2,1,1,1}, {4,1,1,1}, {6,1,1,1}, 
			  {2,1,1,1,1,1}, {4,1,1,1,1,1}, {6,1,1,1,1,1} };
int ltype, i;

if( x != EPlinewidth ) fprintf( Epf,  "%3.1f setlinewidth\n", x );
if( strcmp( s, EPlinetype )!= 0 ) {
	if( strlen( s ) < 1 || strcmp( s, "0" )==0 ) fprintf( Epf,  "[] 0 setdash\n" );
	else 	{
		if( strlen( s ) > 1 ) { 
			ltype = 0; 
			sscanf( s, "%d %d %d %d %d %d", &dash[0][0], &dash[0][1], &dash[0][2], 
				&dash[0][3], &dash[0][4], &dash[0][5] );
			}
		else ltype = atoi( s );
		fprintf( Epf,  "[" );
		for( i = 0; i < 6; i++ ) 
			if( dash[ ltype ][ i ] > 0 ) fprintf( Epf,  "%3.1f ", dash[ ltype ][ i ] * y );
		fprintf( Epf,  "] 0 setdash\n" );
		}
	}
EPlinewidth = x;
strcpy( EPlinetype, s );
}
	

/* =================================== */

EPSshow()
{
if( EPorient == 1 )fprintf( Epf,  "%d %d %d sclr\n", -EPorgx, -EPorgy, -EPtheta ); /* restore rotation */
EPorient = -1; 
fprintf( Epf, "showpage\n" );
}

/* =================================== */

EPSnewpage( p )
int p;
{
fprintf( Epf, "\n\n\n%%%%Page: %d %d\n", p, p );
}

/* =================================== */

/* EPStrailer( int pp, double x1, double y1, double x2, double y2 ) */
EPStrailer( pp, x1, y1, x2, y2 )
int pp; 
double x1, y1, x2, y2;
{
fprintf( Epf, "end\n" );
fprintf( Epf, "\n\n\n%%%%Trailer\n" );
fprintf( Epf, "%%%%Pages: %d\n", pp );
fprintf( Epf, "%%%%BoundingBox: %5.2f %5.2f %5.2f %5.2f\n",
  ( x1 * 72 ) + MARG_X, ( y1 * 72 ) + MARG_Y, ( x2 * 72 ) + MARG_X, ( y2 * 72 ) + MARG_Y );

fprintf( Epf, "%%%%EOF\n" );
}

