/* WILDCMP - compare two strings s1 and s2.  S2 may contain 
   wildcards (* and ?).

   Function returns 0 on a match;  < 0 if s1 < s2;   > 0 if s1 > s2
   Prints an error message and returns -999 on error.

   * wildcard limited to the following uses: *ppp; ppp*; pp*pp; *ppp*
   ? can be used anywhere.

   Double asterisks at beginning and end are also handled (means the
   same as single asterisk).

 */

#include <stdio.h>
#include <ctype.h>

Ewildcmp( s1, s2, len, casecare )
char *s1, *s2;
int len;
int casecare;
/* s1  = data value
   s2  = query value which can contain wildcards - not null terminated.
   len = length of s2
   casecare = 0 for case-insensitive, 1 for case-sensitive
 */
{
int i, nwc, wcp, stat;


if( len == 0 ) return( strlen( s1 ) );
else if( s2[0] == '*' ) {
	if( len == 1 ) return( 0 ); /* everything matches */
	}
else if( s2[0] == '?' ) ; /* can't tell yet */
else if( tolower( s1[0] ) < tolower( s2[0] ) ) return( -1 ); /* way off */
else if( tolower( s1[0] ) > tolower( s2[0] ) ) return( 1 );  /* way off */

/* strip off extraneous * at beginning and end.. */
if( s2[0] == '*' && s2[1] == '*' ) { s2 = &s2[1]; len--; }
if( s2[len-1] == '*' && s2[len-2] == '*' ) len--;

/* see if any wild cards were used.. */
nwc = 0;
for( i = 0; i < len; i++ ) if( s2[i] == '*' ) { nwc++; wcp = i; }

if( nwc < 1 ) {  /* straight match */
	if( strlen( s1 ) > len ) return( wcmp( s1, s2, strlen( s1 ), casecare));
	else return( wcmp( s1, s2, len, casecare ) ); 
	}

else if( nwc == 1 ) {                /* wildcard match */
	/* find beginning of what we need to compare */
	i = strlen( s1 ) - (len - (wcp+1) );

	/* case 1: wc at end.. */
	if( wcp == len-1 ) return( wcmp( s1, s2, len-1, casecare ) );

	/* case 2: wc at beginning.. */
	if( wcp == 0 ) return( wcmp( &s1[i], &s2[ 1 ], len-1, casecare ) );

	/* case 3: wc in middle.. */
	else	{
		stat = wcmp( s1, s2, wcp, casecare );
		stat += wcmp( &s1[i], &s2[ (wcp+1) ], strlen( &s1[i] ), casecare );
		return( stat );
		}
	}

else if( nwc == 2 ) {
	/* case 4: wc at beginning and end.. */
	if( wcp != (len-1) ) goto ERR;
	else if( s2[0] != '*' ) goto ERR;
	for( i = 0; i <= (strlen( s1 ) - len) + 2; i++ ) 
		if( wcmp( &s1[i], &s2[1], len-2, casecare ) == 0 ) return( 0 );

	return( -1 );
	}
else 	{
	ERR:
	fprintf( stderr, "Wild card match error.\n" );
	return( -999 );
	}
}

/* ============================= */
/* WCMP - compare two strings.  S2 may contain ? wildcards which matches any
       single character.  Len is the # of characters to check.
 */

wcmp( s1, s2, len, casecare )
char *s1, *s2;
int len;
int casecare;
{
int i;
for( i = 0; i < len; i++ ) {
	if( ! casecare ) {
		if( tolower(s1[i]) < tolower(s2[i]) && s2[i] != '?' ) 
			return( -1 );
		else if( tolower(s1[i]) > tolower(s2[i]) && s2[i] != '?' ) 
			return( 1 );
		}
	else	{
		if( s1[i] < s2[i] && s2[i] != '?' ) return( -1 );
		else if( s1[i] > s2[i] && s2[i] != '?' ) return( 1 );
		}
	}
return( 0 );
}
/* ============================= */
/* TEST MODULE
 * #include <stdio.h>
 * main()
 * {
 * char s1[100], s2[100];
 * int stat;
 * 
 * printf( "s1> " );
 * fgets( s1, 100, stdin );
 * 
 * printf( "s2> " );
 * fgets( s2, 100, stdin );
 * 
 * stat = Ewildcmp( s1, s2, strlen( s2 ), 0 );
 * printf( "\nstat=%d\n\n", stat );
 * }
 */ 
