/*
COPA 1.0 - gui control panel kit for shell, C, perl etc.  
*              **      **                              *
Copyright 1991-1996 by Stephen C. Grubb.

Permission is hereby granted to USE this software for free.
Permission is hereby granted to MODIFY and/or REDISTRIBUTE 
this software for free, provided that no monetary gain is 
realized, and all attached authorship and copyright notices 
are preserved.

Inclusion of any portion (or derivation) of this software, 
including ancillary files, in any commercial product is not 
allowed without prior written permission of the author.  

See also the file 'Copyright'. 
*/


/* ===========================
   X11 xlib interface for copa

   Revisions:
	950906 - fixed to work on color displays. scg
	950906 - now consults DISPLAY env variable to learn display host
	950907 - fixed problem with white text (change gc fillstyle temporarily)
	951109 - made font selection more robust and accessable via COPA_XFONT env var.
	951109 - reduced # of redraws when window is moved

   ===========================
*/
	

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <stdio.h>
#include "x11shades.h"

#define MAX_D_ROWS 1000		/* LIMIT */
#define DEFAULT_FONT "-adobe-courier-bold-r-normal"
#define MISC_FONT "-misc-fixed-medium-r-normal"    /* available on NDG xterminals */
#define LAST_RESORT_FONT "9x15"


#define E_EXPOSE 1010  /* window has been exposed and needs to be redrawn */
#define E_RESIZE 1011  /* window has been resized */

double Exsca_inv(), Eysca_inv();

static double EXWoldx = 0, EXWoldy = 0;
static int EXWwaitflag;
static Display	*EXWdisp;
static Window	EXWwin;
static int EXWscreen;
static GC EXWgc;
static int EXWlinewidth;
static int EXWcharsize;
static double EXWcurshade;
static char EXWdash[4][10][6]= {
		{ {1}, {1,1}, {3,1}, {5,1}, {2,1,1,1}, {4,1,1,1}, {6,1,1,1}, 
		  {2,1,1,1,1,1}, {4,1,1,1,1,1}, {6,1,1,1,1,1} },
		{ {2}, {2,2}, {6,2}, {10,2}, {4,2,2,2}, {8,2,2,2}, {12,2,2,2}, 
		  {4,2,2,2,2,2}, {8,2,2,2,2,2}, {12,2,2,2,2,2} },
		{ {3}, {3,3}, {9,3}, {15,3}, {6,3,3,3}, {12,3,3,3}, {18,3,3,3}, 
		  {6,3,3,3,3,3}, {12,3,3,3,3,3}, {18,3,3,3,3,3} },
		{ {4}, {4,4}, {12,4}, {20,4}, {8,4,4,4}, {16,4,4,4}, {24,4,4,4}, 
		  {8,4,4,4,4,4}, {16,4,4,4,4,4}, {24,4,4,4,4,4} }
			};
static int EXWndash[10] = { 1, 2, 2, 2, 4, 4, 4, 6, 6, 6 };

/* create pixmap tiles for shading.. */
static Pixmap EXW_s_00, EXW_s_10, EXW_s_20, EXW_s_30, EXW_s_40, EXW_s_50, EXW_s_60, 
	EXW_s_70, EXW_s_80, EXW_s_90, EXW_s1_0;

/* polygon vertexes */
static XPoint EXWvlist[MAX_D_ROWS];
static int EXWnvtx = 0;

static int EXWwinheight, EXWwinwidth;   /* current size of window */
static int EXWwinheight0, EXWwinwidth0; /* original size of window */
static int EXWupperleftx, EXWupperlefty; /* screen pixel position of upper left of window */
static int EXWclr = 0;
static double EXWtextscale = 1.0;

static XFontStruct *EXWfont; /* the full name of the current font */
static char EXWfontset[120]; /* the font short name - known to be available */
static int EXWmapped;



/* =========================== */
/* get the elib x environment handles.. */
EXWgethandle( display, window, gc )
Display *display;
Window *window;
GC *gc;
{
display = EXWdisp;
window = &EXWwin;
gc = &EXWgc;
}

/* ========================== */
EXWsetup( name, pixels_inch, x_max, y_max, upperleftx, upperlefty )
char name[];
int pixels_inch;
double x_max, y_max;
int upperleftx, upperlefty;
{
char inbuf[20];

XSizeHints win_size;
XEvent event;
int n = 1;
int nplanes; /* # of planes of display */
unsigned long fg, bg; /* forground and background for setting pixmaps */
char *userfont;
char *getenv();
int stat;

/* get window size in pixels */
EXWwinwidth =  (int)(x_max * pixels_inch ); 
EXWwinheight = (int)(y_max * pixels_inch );

/* remember original size.. */
EXWwinwidth0 = EXWwinwidth; 
EXWwinheight0 = EXWwinheight;

/* remember position */
EXWupperleftx = upperleftx;
EXWupperlefty = upperlefty;

/* initialize parameters */
EXWfont = NULL;
EXWlinewidth = 1;
EXWcharsize = 0;
EXWtextscale = 1.0;

/* open the display indicated in DISPLAY env var.. */
if(( EXWdisp = XOpenDisplay( NULL )) == NULL ){
	fprintf( stderr, "Display open failed\n" );
	exit( 1 );
	}

/* see if user font env variable is defined.. */
userfont = getenv( "COPA_XFONT" );

/* window size */
EXWscreen = DefaultScreen( EXWdisp );
win_size.flags = PPosition | PSize;
win_size.x = EXWupperleftx;
win_size.y = EXWupperlefty;
win_size.width = EXWwinwidth;
win_size.height = EXWwinheight;

/* create the window */
EXWwin = XCreateSimpleWindow (
	EXWdisp,
	RootWindow(EXWdisp, EXWscreen),	/*  parent window */
	win_size.x,
	win_size.y,		/*  location	  */
	win_size.width,
	win_size.height,	/*  size          */
	5,			/*  border	  */
	BlackPixel(EXWdisp,EXWscreen),	/*  forground	  */
	WhitePixel(EXWdisp,EXWscreen)	/*  background	  */
	);

XSetWMNormalHints( EXWdisp, EXWwin, &win_size );

XStoreName( EXWdisp, EXWwin, name );



/* set grays */
fg = BlackPixel(EXWdisp, EXWscreen);
bg = WhitePixel(EXWdisp, EXWscreen);
nplanes = XDisplayPlanes( EXWdisp, EXWscreen );
EXW_s_00 = XCreatePixmapFromBitmapData( EXWdisp, EXWwin, EXW_im_00, 16, 16, fg, bg, nplanes);
EXW_s_10 = XCreatePixmapFromBitmapData( EXWdisp, EXWwin, EXW_im_10, 16, 16, fg, bg, nplanes);
EXW_s_20 = XCreatePixmapFromBitmapData( EXWdisp, EXWwin, EXW_im_20, 16, 16, fg, bg, nplanes);
EXW_s_30 = XCreatePixmapFromBitmapData( EXWdisp, EXWwin, EXW_im_30, 16, 16, fg, bg, nplanes);
EXW_s_40 = XCreatePixmapFromBitmapData( EXWdisp, EXWwin, EXW_im_40, 16, 16, fg, bg, nplanes);
EXW_s_50 = XCreatePixmapFromBitmapData( EXWdisp, EXWwin, EXW_im_50, 16, 16, fg, bg, nplanes);
EXW_s_60 = XCreatePixmapFromBitmapData( EXWdisp, EXWwin, EXW_im_60, 16, 16, fg, bg, nplanes);
EXW_s_70 = XCreatePixmapFromBitmapData( EXWdisp, EXWwin, EXW_im_70, 16, 16, fg, bg, nplanes);
EXW_s_80 = XCreatePixmapFromBitmapData( EXWdisp, EXWwin, EXW_im_80, 16, 16, fg, bg, nplanes);
EXW_s_90 = XCreatePixmapFromBitmapData( EXWdisp, EXWwin, EXW_im_90, 16, 16, fg, bg, nplanes);
EXW_s1_0 = XCreatePixmapFromBitmapData( EXWdisp, EXWwin, EXW_im1_0, 16, 16, fg, bg, nplanes);


/*  create graphics context */
EXWgc = XCreateGC( EXWdisp, EXWwin, 0, NULL );

XSetForeground( EXWdisp, EXWgc, BlackPixel( EXWdisp, EXWscreen ));
XSetBackground( EXWdisp, EXWgc, WhitePixel( EXWdisp, EXWscreen )); /* added SCG 950907 */

XSetLineAttributes( EXWdisp, EXWgc, EXWlinewidth, LineSolid, CapButt, JoinMiter );

/* XSetFillStyle( EXWdisp, EXWgc, FillTiled ); */
XSetFillStyle( EXWdisp, EXWgc, FillSolid ); /* FillSolid is used for lines & text;
						we switch over to FillTiled for
						polygons below.. */

XSetTile( EXWdisp, EXWgc, EXW_s_00 );

/* find a font set to use.. */
stat = EXWloadfont( userfont, 10 ); 		/* user's choice font */
if( stat == 0 ) strcpy( EXWfontset, userfont );
else	{
	stat = EXWloadfont( DEFAULT_FONT, 10 ); /* default font */
	if( stat == 0 ) strcpy( EXWfontset, DEFAULT_FONT );
	else	{
		stat = EXWloadfont( MISC_FONT, 10 );    /* available on ndg xterms */
		if( stat == 0 ) strcpy( EXWfontset, MISC_FONT );
		else	{
			stat = EXWloadfont( "9x15", 0 );		/* last resort.. */
			if( stat == 0 ) strcpy( EXWfontset, LAST_RESORT_FONT );
			else {
				fprintf(stderr, "Error: cannot find a font.  Set the env var\n" ); 
				fprintf(stderr, "COPA_XFONT to hold the base name of an available\n");
				fprintf(stderr, "Xwindow font, e.g. -adobe-courier-bold-r-normal\n");
				exit();
				}
			}
		}
	}


/* Set up for events  */
/*  we want: (1) mouse clicks (2) Key presses (3) expose events (4) resize events */
XSelectInput (
	EXWdisp,
	EXWwin,
	ButtonPressMask | ExposureMask | KeyPressMask | StructureNotifyMask
	);


/* map the window */
XMapWindow( EXWdisp, EXWwin );
EXWmapped = 1;

/* wait for initial expose event to draw.. */
while( 1 ) {
	XNextEvent( EXWdisp, &event );
	if( event.type == Expose ) break;
	}
}

/* =============================== */
EXWevent( event )
XEvent event;
{
int x, y;
unsigned eid;
char s[10];
XEvent fooevent;
int index, status;
FILE *fp;

if( event.type == KeyPress ) {
	x = event.xkey.x;
	y = event.xkey.y;

	if( event.xkey.state == ShiftMask ) index = 1;
	else index = 0;
	eid = (unsigned) XLookupKeysym( &(event.xkey), index );
	if( eid >= 0xFFE1 && eid <= 0xFFEE ) EXWwaitflag = 0; /* screen out shift, control, alt, etc. */
	else	{
		eid &= 0x007F;
		EXWwaitflag = Ehandle_event( Exsca_inv( x ), Eysca_inv( y ), eid );
		}
	}
else if( event.type == ButtonPress ) {
	x = event.xbutton.x;
	y = event.xbutton.y;
	if( event.xbutton.button == Button1 ) eid = 1001;
	else if( event.xbutton.button == Button2 ) eid = 1002;
	else if( event.xbutton.button == Button3 ) eid = 1003;
	EXWwaitflag = Ehandle_event( Exsca_inv( x ), Eysca_inv( y ), eid );
	}
else if( event.type == Expose ) {
	if( event.xexpose.count == 0 ) {
		Ehandle_event( 0.0, 0.0, E_EXPOSE );
		}
	}

else if( event.type == ConfigureNotify ) { 

	/* on openwin, this event is generated when window is move, and when it is
	 * resized.  We need do nothing when it is simply moved; when it is resized
	 * we need to recalculate and redisplay everything.. */

	if( (double)event.xconfigure.width != EXWwinwidth ||
	   (double)(event.xconfigure.height) != EXWwinheight ) { /* if size changed.. */

		Ehandle_event( (double)(event.xconfigure.width), 
			(double)(event.xconfigure.height), E_RESIZE );
		Ehandle_event( 0.0, 0.0, E_EXPOSE );
		EXWwinwidth = event.xconfigure.width; 
		EXWwinheight = event.xconfigure.height;
		}
	}
}
/* ============================== */
/* Code driven resize of window.
   All parameters (except pixels_inch) may be sent as -1 = don't change */
   
/* EXWresizewin( int pixels_inch, int x, int y, double x_max, double y_max ) */
EXWresizewin( pixels_inch, x, y, x_max, y_max )
int pixels_inch, x, y;
double x_max, y_max;
{
XSizeHints win_size;

/* get window size in pixels, and consider it 'original' */
if( x_max > 0 ) { EXWwinwidth =  (int)(x_max * pixels_inch ); EXWwinwidth0 = EXWwinwidth; }
if( y_max > 0 ) {EXWwinheight = (int)(y_max * pixels_inch ); EXWwinheight0 = EXWwinheight; }

if( x > 0 ) EXWupperleftx = x;
if( y > 0 ) EXWupperlefty = y;

win_size.x = EXWupperleftx;
win_size.y = EXWupperlefty;
win_size.width = EXWwinwidth;
win_size.height = EXWwinheight;

/* create the window */
XMoveResizeWindow ( EXWdisp,
	EXWwin,
	win_size.x,
	win_size.y,	
	win_size.width,	
	win_size.height	);

/* XSetWMNormalHints( EXWdisp, EXWwin, &win_size ); */
XFlush(0);
return( 0 );
}

/* =============================== */
EXWwait()
{
XEvent event;
EXWwaitflag = 0;
while( ! EXWwaitflag ) {
	XNextEvent( EXWdisp, &event );
	EXWevent( event );
        }
}

/* ==================== dot */
EXWdot( x, y )
double x, y;
{
XDrawPoint( EXWdisp, EXWwin, EXWgc, Exsca( x ), Eysca( y ) );
}

/* ====================  line to */
EXWlineto(x,y)
double x, y;
{
int a, b, c, d;


a = Exsca( EXWoldx ); b = Eysca( EXWoldy ); c = Exsca( x ); d = Eysca( y );
XDrawLine( EXWdisp, EXWwin, EXWgc, a, b, c, d );
EXWoldx=x;
EXWoldy=y;
}

/* =====================  moveto */
EXWmoveto(x,y)
double x, y;
{
EXWoldx = x;
EXWoldy = y;
}

/* ===================== set point size of type */
/* XWpointsize */
EXWpointsize( p, aw )
int p;
double *aw; /* width of one character -- returned */
{
int newp;
int stat;

if( p == EXWcharsize ) return( 1 );
EXWcharsize = p;

/* use p to find equivalent size parameter for x font */
if( p <= 6 ) newp = 8; 
else if( p == 7 || p == 8 ) newp = 10; 
else if( p == 9 || p == 10 ) newp = 12; 
else if( p >= 11 && p <= 14 ) newp = 14;
else if( p >= 15 && p <= 18 ) newp = 18;
else newp = 24;

/* scale based upon pixels/inch */
newp = (int)(newp * EXWtextscale);

/* try to load a font.. */
stat = EXWloadfont( EXWfontset, newp ); 		/* load our font in the requested size.. */
if( stat != 0 ) {
	fprintf( stderr, "Error: Cannot load %s in the requested size (%d).\n", EXWfontset, p );
	exit(1);
	}

/* get the char size for our new font */
*aw = Exsca_inv( XTextWidth( EXWfont, "A", 1 ) );
return( 0 );
}

/* ======================== */
/* EXW LOADFONT - given short font name f, see if an X font is available for
   the requested size, or something close.. */
/* EXWloadfont( char *f, int size ) */
EXWloadfont( f, size )
char *f;
int size;
{
char fontname[100];
char ofslist[12];
int i, p;
Font fnt;

strcpy( ofslist, "EFDGCHBIAJ" ); /* used to vary the size.. */

if( f == NULL ) return( 1 );
if( (int) strlen( f ) < 1 ) return( 1 );
if( strcmp( f, LAST_RESORT_FONT ) == 0 ) {
	strcpy( fontname, f );
	EXWfont = XLoadQueryFont( EXWdisp, fontname );
	if( EXWfont == NULL ) return( 1 );
	goto LOAD_IT;
	}

for( i = 0; i < 10; i++ ) { /* try 10 times with varying sizes until we get a hit.. */
	p = size + ( ofslist[i] - 'E' );
	sprintf( fontname, "%s--%d-*-*-*-*-*-*-*", f, p );
	EXWfont = XLoadQueryFont( EXWdisp, fontname );
	if( EXWfont != NULL ) break;
	}
if( i == 10 ) return( 1 ); /* not found */

LOAD_IT:
fnt = XLoadFont( EXWdisp, fontname );
XSetFont( EXWdisp, EXWgc, fnt );
return( 0 );
}

/* ==================== EXWscaletext - when window is resized, to adjust text size */
EXWscaletext( f )
double f;
{
EXWtextscale = f;
}

/* ==================== EXWdisplay left adjusted text starting at current position */
EXWtext( s, aw )
char s[];
double *aw; /* actual string width in inches (sent back) */
{
/* XSetFillStyle( EXWdisp, EXWgc, FillSolid ); */  /* added SCG 950907 */
XDrawString( EXWdisp, EXWwin, EXWgc, Exsca( EXWoldx ), Eysca( EXWoldy ), s, strlen( s ) );
/* XSetFillStyle( EXWdisp, EXWgc, FillTiled ); */  /* added SCG 950907 */
*aw = Exsca_inv( XTextWidth( EXWfont, s, strlen( s ) ) );
EXWoldx += ( *aw );
}

/* ==================== EXWdisplay centered text */
EXWcentext( s, w, x, aw )
char s[];
double w;
double *x; /* actual X starting point in inches (sent back) */
double *aw; /* actual string width in inches (sent back) */
{
double width;

Estrip_ws( s );
width = Exsca_inv( XTextWidth( EXWfont, s, strlen( s ) ) );
EXWmoveto( EXWoldx+((w-width)/2.0), EXWoldy );
EXWtext( s, aw );
*x = Exsca_inv((int)( EXWoldx+((w-width)/2.0) ) );
}

/* ==================== EXWdisplay right-justified text */
EXWrightjust( s, w, x, aw )
char s[];
double w;
double *x; /* actual X starting point in inches (sent back) */
double *aw; /* actual string width in inches (sent back) */
{
double width;

Estrip_ws( s );
width = Exsca_inv( XTextWidth( EXWfont, s, strlen( s ) ) );
EXWmoveto( EXWoldx+(w-width), EXWoldy );
EXWtext( s, aw );
*x = Exsca_inv((int)(EXWoldx+(w-width) ));
}

/* ========= set line dotting attribs ============= */

EXWlinetype( t, w, mag )
char t[];
double w, mag;
{
int i, j, k;

if( (int) strlen( t ) < 1 ) return( 0 );
if( mag < 1 ) mag = 1;
if( mag > 4 ) mag = 4;
/* 
w_brush->width = (int)((w*1.6)+0.5);
w_texture->pattern = w_dash[ (int)mag-1 ][ atoi( t ) % 10 ];
*/
EXWlinewidth = (w*1.6) + 0.5;
if( t[0] == '0' ) {
	XSetLineAttributes( EXWdisp, EXWgc, EXWlinewidth, LineSolid, CapButt, JoinMiter );
	}
else	{
	XSetDashes( EXWdisp, EXWgc, 0, EXWdash[ (int)mag-1 ][ atoi(t)%10 ], EXWndash[ atoi(t)%10 ] );
	XSetLineAttributes( EXWdisp, EXWgc, EXWlinewidth, LineOnOffDash, CapButt, JoinMiter );
	}
}

/* ==================== add to "fill path" */
EXWpath( x, y )
double x, y;
{
if( EXWnvtx == 0 ) { EXWvlist[0].x = Exsca( EXWoldx ); EXWvlist[0].y = Eysca( EXWoldy ); EXWnvtx++; }
EXWvlist[ EXWnvtx ].x = (short) (Exsca(x));
EXWvlist[ EXWnvtx ].y = (short) (Eysca(y));
EXWnvtx++;
}

/* ==================== fill prev. defined polygon path with color c */
EXWshade( c )
double c; 
{
Pixmap pr;
if( c >= 0.0 && c <= 1.0 ) {
	if( c == 1.0 ) pr = EXW_s1_0;
	else if( c > .95 ) pr = EXW_s_90;
	else if( c > .90 ) pr = EXW_s_80;
	else if( c > .85 ) pr = EXW_s_70;
	else if( c > .75 ) pr = EXW_s_60;
	else if( c > .65 ) pr = EXW_s_50;
	else if( c > .55 ) pr = EXW_s_40;
	else if( c > .45 ) pr = EXW_s_30;
	else if( c > .35 ) pr = EXW_s_20;
	else if( c > .15 ) pr = EXW_s_10;
	else if( c >= 0.0 ) pr = EXW_s_00;
	else pr = (Pixmap ) 0;
	}

XSetTile( EXWdisp, EXWgc, pr );

XSetFillStyle( EXWdisp, EXWgc, FillTiled );   /* added SCG 11-10-95 */

XFillPolygon( EXWdisp, EXWwin, EXWgc, EXWvlist, EXWnvtx, Complex, CoordModeOrigin );

/* set fillstyle back to solif and set tile back to black.. */
XSetFillStyle( EXWdisp, EXWgc, FillSolid );   /* added SCG 11-10-95 */
XSetTile( EXWdisp, EXWgc, EXW_s_00 );
/* reset vertex counter */
EXWnvtx = 0;
}

/* ==================== set drawing color */
EXWcolor( c )
int c;
{
if( c == EXWclr ) return(1);
if( c == 0 ) { 
	XSetForeground( EXWdisp, EXWgc, BlackPixel( EXWdisp, EXWscreen ));
	XSetBackground( EXWdisp, EXWgc, WhitePixel( EXWdisp, EXWscreen )); /* added SCG 950907 */
	}
else if( c == 1 ) { 
	XSetForeground( EXWdisp, EXWgc, WhitePixel( EXWdisp, EXWscreen ));
	XSetBackground( EXWdisp, EXWgc, BlackPixel( EXWdisp, EXWscreen )); /* added SCG 950907 */
	}
EXWclr=c;
/* EXWtileflag = -1; */
}

/* ==================== asynchronous */
EXWasync()
{
XEvent event;
while( 1 ) {
	if( XCheckMaskEvent( EXWdisp, ButtonPressMask | ExposureMask | KeyPressMask | StructureNotifyMask , 
		&event ) != True ) return(1);
	EXWevent( event );
        }
}
/* ==================== */

EXWflush()
{
XFlush( EXWdisp );
}

/* ===================== */

EXWappear()
{
XEvent event;

if( EXWmapped ) return( 0 );

/* map the window */
XMapWindow( EXWdisp, EXWwin );
EXWmapped = 1;

/* redraw everything.. */
/* Egenall();   scg Nov 95 */
XFlush( EXWdisp );
}
/* ====================== */

EXWdisappear()
{
if( ! EXWmapped ) return( 0 );

/* unmap the window.. */
XUnmapWindow( EXWdisp, EXWwin );
EXWmapped = 0;
XFlush( EXWdisp );
}


#ifdef NEVER
if( event->count ) return; /* i.e. more expose events */

/* How big is the window? 
XGetGeometry( event->display, event->window, &r, &x, &y, &w, &h, &bw, &d );

/* clear window to make sure that contents of previous window do not cause problems */
XClearArea( event->display, event->window, 0, 0, w, h, 0 );

/* scale normalized picture to the largest square that fits in the window */
scale = w < h ? w:h;
#endif
