 
/*{{{F oszmfx.h*/
/*:::F oszmfx.h*/
/*}}}  */
/*{{{F ../oszill/osz.c*/
/*:::F ../oszill/osz.c*/
/*}}}  */

 
/* Program Body */
/*{{{  Includes*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>

#define MFX_INIT 1
#include "xbmfx.h"
#include "oszmfx.h"
#include "oszmfx.c"

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>

/*}}}  */
/*{{{  SubFunktionen*/
 
int WKeyPressed(void){
  return(0);
  };
char WReadKey(void){
  return(' ');
  };

/*}}}  */
/*{{{  Variablen und Defines*/
 
int OSZVMf_prd = 1;

#define LightGray  7
#define LightRed  13

#define SIGN_TEXTWIDTH 150

 
 
/*}}}  */
/*{{{  Pack_Text*/

#define PackTextLen 250
char *Pack_Text(char *str, char *nstr){
  char zstr[PackTextLen];
  int cc,ll;
  cc = 0;
  while((str[cc] == ' ') & (strlen(str) > cc)) {
    cc++;
    };
  ll = 0;
  while((ll< strlen((char *)str))&(ll<PackTextLen)){
    zstr[ll] = str[cc+ll];
    ll++;
    };
  if (strlen(str) >= PackTextLen) {
    zstr[PackTextLen-1] = 0;
    }
  else {
    zstr[strlen(str)] = 0;
    };
  while((zstr[strlen(zstr)-1] == ' ') & (strlen(zstr) > 0)) {
    zstr[strlen(zstr)-1] = 0;
    };
  strcpy(nstr,zstr);
  return(nstr);
  };
 

/*}}}  */
/*{{{  ConText*/
typedef struct {
  int XA,YA,XB,YB;
  char key[257];
  Display *dpy;
  Window window;
  GC gc;
  Screen *screen;
  int is_a_keywaiting;
  } OSZDSyOSZContxt;
/*}}}  */
/*{{{  Globales Setup, Colortexte*/

/* IO-Struct Descr for group SETUPA created by XW */

typedef struct {
 char *wname;
 int winw,winh;
 char OSZVGr_ColorTexte[32][200];
} DATA_SETUP;

  DATA_SETUP OSZSETUP= {
    "XbW Oszilloskop",
    800,  /* winw */
    600,  /* winh */
    /*{{{  ColorTexte*/
    {
    "black",
    "blue3",
    "green3",
    "cyan3",
    "red3",
    "magenta3",
    "sandybrown",
    "lightgray",
    "black",
    "lightblue1",
    "green1",
    "red1",
    "cyan1",
    "magenta1",
    "yellow",
    "white",
    
    "gold",
    "maroon",
    "tomato",
    "hotpink",
    
    "beige",
    "seagreen",
    "salmon",
    "purple",
    
    "dark khaki",
    "",
    "",
    "",
    
    "",
    "",
    "",
    ""
    },
    
    /*}}}  */
    };
 
/*}}}  */
/*{{{  Globale Variablen & Defines*/

int
  GrafObjCursor1Pos = 0,
  GrafObjCursor2Pos = 0,
  Multiline_CursorSet = 0;

  Font standard_font;
  Font grosser_font;
  OSZDSyOSZContxt OSZVSyConTxt;
  unsigned long int OSZVGr_ColorValues[64];
  static void *OSZSMs_DFramONFrames[4]={NULL,NULL,NULL,NULL};


#define ML_DRAW_LINES        0x0001
#define ML_DRAW_CLINES       0x4000
#define ML_GET_SIGNAL_VALUES 0x0002


typedef struct {
  int XA,YA,XB,YB;
 
  int bkc, bfc, dfc, txc;
 
  void *chn;
  } GenObjDgn;
 
GenObjDgn GrafikObj = {
  0,70,
  500,400,
 
  8, 15, 15, 8,
 
  NULL,
  };

  int Ozmxp;
  int Ozmyp;
/*}}}  */

/*{{{  X11-Subfunctions     * * * * * * * * * * * * * * * * * * * **/
#define LINE_CACHE_WORK  0
#define LINE_CACHE_FLUSH 1
#define LINE_CACHE_CLEAR 2
/*{{{  Cache_WDLine(int xa, int ya, int xb, int yb, int col, int sig, int flush){*/
void Cache_WDLine(int xa, int ya, int xb, int yb, int col, int sig, int flush){
  #define MAX_CACHE_LINES 16
  #define LINE_BUFSIZE 10000
  static int axa[MAX_CACHE_LINES] ={-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1};
  static int aya[MAX_CACHE_LINES] ={-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1};
  static int axb[MAX_CACHE_LINES] ={-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1};
  static int ayb[MAX_CACHE_LINES] ={-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1};
  static int acol[MAX_CACHE_LINES]={-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1};
  static int lcol[MAX_CACHE_LINES]={-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1};
  static XPoint points[MAX_CACHE_LINES*LINE_BUFSIZE];
  static int line_buf_counter[MAX_CACHE_LINES]={0,0,0,0, 0,0,0,0, 0,0,0,0 ,0,0,0,0};
 
  if (flush == LINE_CACHE_CLEAR){
    int ii;
    if (OSZVMf_prd){
      puts("Clearing Line Cache");
      };
    for (ii=0;ii<MAX_CACHE_LINES;ii++){
      axa[ii]=-1; aya[ii]=-1; axb[ii]=-1; ayb[ii]=-1; acol[ii]=-1;lcol[ii]=-1;
      line_buf_counter[ii]=0;
      };
    return;
    };
 
  if ((sig >= MAX_CACHE_LINES) | (sig < 0 )){
    if (!flush){
      XSetForeground(OSZVSyConTxt.dpy,OSZVSyConTxt.gc,
        OSZVGr_ColorValues[col] );
      XDrawLine(OSZVSyConTxt.dpy,OSZVSyConTxt.window,OSZVSyConTxt.gc,
        xa,ya,xb,yb);
      return;
      };
    };
  if (flush){
    int ii;
    if (OSZVMf_prd){
      puts("Flushing Line Cache");
      };
    for (ii=0; ii< MAX_CACHE_LINES; ii++){
      if ((lcol[ii] >=0 ) & (line_buf_counter[ii] >1)){
        if ((XMaxRequestSize(OSZVSyConTxt.dpy)-3/2)<line_buf_counter[ii]){
          printf("Sorry: Server buffer size allows only max. %ld lines at a time.\n",
            (XMaxRequestSize(OSZVSyConTxt.dpy)-3/2));
          exit(-1);
          };
        XSetForeground(OSZVSyConTxt.dpy,OSZVSyConTxt.gc,
          OSZVGr_ColorValues[lcol[ii]] );
        XDrawLines(OSZVSyConTxt.dpy,OSZVSyConTxt.window,OSZVSyConTxt.gc,
          &points[(ii*LINE_BUFSIZE)],
          line_buf_counter[ii],
          CoordModeOrigin);
        lcol[ii]=-1; /* Reset Cacheline */
        };
      line_buf_counter[ii]=0;
      };
    return;
    };
 
  if ( (xa>=axa[sig]-1)&(xa<=axa[sig]+1)){ goto draw; };
  if ( (ya>=aya[sig]-1)&(ya<=aya[sig]+1)){ goto draw; };
  if ( (xb>=axb[sig]-1)&(xb<=axb[sig]+1)){ goto draw; };
  if ( (yb>=ayb[sig]-1)&(yb<=ayb[sig]+1)){ goto draw; };
 
  if (col!=acol[sig]){ goto draw; };
  return;
 
  draw:
  axa[sig]=xa; aya[sig]=ya; axb[sig]=xb; ayb[sig]=yb; acol[sig]=col;
  if (line_buf_counter[sig] >= LINE_BUFSIZE-1){
    if (lcol[sig] >=0 ){
      if ((XMaxRequestSize(OSZVSyConTxt.dpy)-3/2)<line_buf_counter[sig]){
        printf("Sorry: Server buffer size allows only max. %ld lines at a time.\n",
          (XMaxRequestSize(OSZVSyConTxt.dpy)-3/2));
        exit(-1);
        };
      XSetForeground(OSZVSyConTxt.dpy,OSZVSyConTxt.gc,
        OSZVGr_ColorValues[lcol[sig]] );
      XDrawLines(OSZVSyConTxt.dpy,OSZVSyConTxt.window,OSZVSyConTxt.gc,
        &points[(sig*LINE_BUFSIZE)],
        line_buf_counter[sig],
        CoordModeOrigin);
      lcol[sig]=-1; /* Reset Cacheline */
      };
    line_buf_counter[sig]=0;
    };
  points[(sig*LINE_BUFSIZE)+line_buf_counter[sig]].x = xb;
  points[(sig*LINE_BUFSIZE)+line_buf_counter[sig]].y = yb;
  lcol[sig] = col;
  line_buf_counter[sig]++;
  };
/*}}}  */
/*{{{  WDLine(int xa, int ya, int xb, int yb, int col){*/
void WDLine(int xa, int ya, int xb, int yb, int col){
  XSetForeground(OSZVSyConTxt.dpy,OSZVSyConTxt.gc,
    OSZVGr_ColorValues[col] );
  XDrawLine(OSZVSyConTxt.dpy,OSZVSyConTxt.window,OSZVSyConTxt.gc,
    xa,ya,xb,yb);
  };
/*}}}  */
/*{{{  WDTextXY*/
void WDTextXY(int xa, int ya, char *msg, int col){
  XSetForeground(OSZVSyConTxt.dpy,OSZVSyConTxt.gc,
    OSZVGr_ColorValues[col] );
  XDrawString(OSZVSyConTxt.dpy, OSZVSyConTxt.window,OSZVSyConTxt.gc,
    xa,
    ya,
    msg,strlen(msg));
  };
/*}}}  */
/*{{{  OSZSGr_TLBox(       TC3,GNU,X11    Text-Box, linksbundig, oben*/
void OSZSGr_TLBox(
  int xa,int ya,
  int xb,int yb,
  char *msg,
  int fillcol, int textcol, int framecol){
 
  if (xb!=0){
    XSetForeground(OSZVSyConTxt.dpy,OSZVSyConTxt.gc,
      OSZVGr_ColorValues[fillcol] );
    XFillRectangle(
      OSZVSyConTxt.dpy,OSZVSyConTxt.window,
      OSZVSyConTxt.gc,
      xa+OSZVSyConTxt.XA,
      ya+OSZVSyConTxt.YA,xb-xa,yb-ya);
      };
  if (msg!=NULL) {
    XSetForeground(OSZVSyConTxt.dpy,OSZVSyConTxt.gc,
      OSZVGr_ColorValues[textcol] );
    XDrawString(OSZVSyConTxt.dpy, OSZVSyConTxt.window,OSZVSyConTxt.gc,
      xa+1+OSZVSyConTxt.XA,
      ya+15-2+OSZVSyConTxt.YA,
      msg,strlen(msg));
    };
  if (xb!=0){
    XSetForeground(OSZVSyConTxt.dpy,OSZVSyConTxt.gc,
      OSZVGr_ColorValues[framecol] );
    XDrawRectangle(OSZVSyConTxt.dpy,OSZVSyConTxt.window,
      OSZVSyConTxt.gc,
      xa+OSZVSyConTxt.XA,
      ya+OSZVSyConTxt.YA,
      xb-xa,yb-ya);
    };
  };
/*}}}  */
/*{{{  OSZSGr_TCBox(       TC3,GNU,X11    Text-Box, linksbundig, oben*/
void OSZSGr_TCBox(
  int xa,int ya,
  int xb,int yb,
  char *msg,
  int fillcol, int textcol, int framecol){
 
  if (xb!=0){
    XSetForeground(OSZVSyConTxt.dpy,OSZVSyConTxt.gc,
      OSZVGr_ColorValues[fillcol] );
    XFillRectangle(
      OSZVSyConTxt.dpy,OSZVSyConTxt.window,
      OSZVSyConTxt.gc,
      xa+OSZVSyConTxt.XA,
      ya+OSZVSyConTxt.YA,xb-xa,yb-ya);
      };
  if (msg!=NULL) {
    XSetForeground(OSZVSyConTxt.dpy,OSZVSyConTxt.gc,
      OSZVGr_ColorValues[textcol] );
    XDrawString(OSZVSyConTxt.dpy, OSZVSyConTxt.window,OSZVSyConTxt.gc,
      (xa+xb)/2-strlen(msg)*4+1+OSZVSyConTxt.XA,
      ya+15-2+OSZVSyConTxt.YA,
      msg,strlen(msg));
    };
  if (xb!=0){
    XSetForeground(OSZVSyConTxt.dpy,OSZVSyConTxt.gc,
      OSZVGr_ColorValues[framecol] );
    XDrawRectangle(OSZVSyConTxt.dpy,OSZVSyConTxt.window,
      OSZVSyConTxt.gc,
      xa+OSZVSyConTxt.XA,
      ya+OSZVSyConTxt.YA,
      xb-xa,yb-ya);
    };
  };
/*}}}  */
/*{{{  OSZSMs_SetClockCursor(  GNU,X11    Maustreiber Handcursor*/
Cursor OSZVMs_PtrPtrClock=0;
void OSZSMs_SetClockCursor(void){
  if(OSZVMs_PtrPtrClock == 0) {
    OSZVMs_PtrPtrClock = XCreateFontCursor(OSZVSyConTxt.dpy,XC_watch);
    };
  XDefineCursor(OSZVSyConTxt.dpy,OSZVSyConTxt.window,OSZVMs_PtrPtrClock);
  };
/*}}}  */
/*{{{  OSZSMs_SetArrowCursor(  GNU,X11    Maustreiber Pfeilcursor*/
Cursor OSZVMs_PtrPtrArrow=0;
void OSZSMs_SetArrowCursor(void){
  if(OSZVMs_PtrPtrArrow == 0) {
    OSZVMs_PtrPtrArrow = XCreateFontCursor(OSZVSyConTxt.dpy,XC_left_ptr);
    };
  XDefineCursor(OSZVSyConTxt.dpy,OSZVSyConTxt.window,OSZVMs_PtrPtrArrow);
  };
/*}}}  */

/*}}}  */
/*{{{  int CacheReadFile(void *target,int datyp, FILE *fp){*/
int CacheReadFile(double *target,int datyp, FILE *fp){
  #define DBUFSIZE (500000L*2)
  #define DBUF_EMPTY 0
  #define DBUF_USED  1
  #define DBUF_FULL 10
  static short dbuf[DBUFSIZE];
  static long dbuf_pt = 0;
  static int dbuf_stat = DBUF_EMPTY;
  static int dbuf_end = 0;
  static FILE *fpa=NULL;
 
  if (target == NULL){
    dbuf_pt=0;
    dbuf_stat = DBUF_EMPTY;
    dbuf_end = 0;
    fpa = NULL;
    return(0);
    };
  if ((dbuf_stat == DBUF_EMPTY) | (dbuf_pt == dbuf_end) | (fpa != fp)){
    dbuf_end = fread(&dbuf[0],sizeof(short),DBUFSIZE,fp);
    dbuf_pt = 0;
    dbuf_stat = DBUF_FULL;
    fpa = fp;
    if (dbuf_end == 0){
      dbuf_stat = DBUF_EMPTY;
      return(1);
      };
    };
 
  *target = dbuf[dbuf_pt];
  dbuf_pt++;
  dbuf_stat = DBUF_USED;
 
  return(0);
  };
/*}}}  */
/*{{{  OSZSSyXXXXMem(     TC3,GNU,X11    farcalloc bzw. calloc /-free*/
/*{{{  OSZSSyAlocMem(     TC3,GNU,X11    farcalloc bzw. calloc*/
void  *OSZSSyAlocMem(unsigned long a, unsigned long b){
  return(calloc(a,b));
  };
/*}}}  */
/*{{{  OSZSSyFreeMem(     TC3,GNU,X11    farfree bzw. free*/
void  OSZSSyFreeMem(void  *a){
  free(a);
  };
/*}}}  */
/*}}}  */
/*{{{  DrawSigName*/
void DrawSigName(char *name, int color, int yachse, int signr){
  int yy;
  yy = yachse-signr*15;
  OSZSGr_TLBox(Ozmxp+10,yy,Ozmxp+SIGN_TEXTWIDTH,yy+15,
      name,
      8,
      color,
      15);
  };
/*}}}  */
/*{{{  OSZSGr_BitXXXX(     t--,GNU,x//    Bit-Blitter fur Grafik*/
/*{{{  OSZSGr_BitBlit(     t--,GNU,x//    Bit-Blitter fur Grafik*/
void OSZSGr_BitBlit(void  *dest, int x, int y,
               void *source, int x1, int y1, int x2, int y2){
  XCopyArea(
    OSZVSyConTxt.dpy,
    OSZVSyConTxt.window,
    OSZVSyConTxt.window,
    OSZVSyConTxt.gc,
    x1,y1,
    x2-x1,y2-y1,
    x,y);
  };
/*}}}  */
/*{{{  OSZSGr_SavImag(     TC3,GNU,x//    Blit Image in Memory-Context*/
void  *OSZSGr_SavImag(int x1, int y1, int x2, int y2){
  Pixmap *pmap;
  pmap = OSZSSyAlocMem(sizeof(Pixmap),1);
  if (pmap==NULL){ return(NULL); };
 
  *pmap = XCreatePixmap(OSZVSyConTxt.dpy,OSZVSyConTxt.window,x2-x1+2,y2-y1+2,
      XDefaultDepthOfScreen(OSZVSyConTxt.screen));
  if (*pmap<=0){ return(NULL);};
 
  XCopyArea(OSZVSyConTxt.dpy,
    OSZVSyConTxt.window, /* src */
    *pmap,                /* target */
    OSZVSyConTxt.gc,
    x1,y1,
    x2-x1+1,y2-y1+1,
    1,1);
  return(pmap);
  };
/*}}}  */
/*{{{  OSZSGr_ResImag(     TC3,GNU,x//    Blit Image aus Memory-Context*/
void  OSZSGr_ResImag(void  *where,int x1, int y1,
  int x2, int y2){
  Pixmap *pmap;
  pmap = where;
  if (pmap==NULL){ return; };
 
  XCopyArea(OSZVSyConTxt.dpy,
    *pmap,                /* src */
    OSZVSyConTxt.window, /* dest */
    OSZVSyConTxt.gc,
    1,1,
    x2-x1+1,y2-y1+1,
    x1,y1);
  XFreePixmap(OSZVSyConTxt.dpy,*pmap);
  OSZSSyFreeMem(pmap);
  };
/*}}}  */
/*{{{  OSZSGr_DelImag(     TC3,GNU,x//    Memory-Context loeschen*/
void  OSZSGr_DelImag(void  *where){
  Pixmap *pmap;
  pmap = where;
  if (pmap==NULL){ return; };
 
  XFreePixmap(OSZVSyConTxt.dpy,*pmap);
  OSZSSyFreeMem(pmap);
  };
/*}}}  */
/*{{{  OSZSGr_CopImag(     TC3,GNU,x//    Blit Image aus Memory-Context*/
void  OSZSGr_CopImag(void  *where,int x1, int y1,
  int x2, int y2){
  Pixmap *pmap = where;
  XCopyArea(OSZVSyConTxt.dpy,
    *pmap,                 /* src */
    OSZVSyConTxt.window,  /* dest */
    OSZVSyConTxt.gc,
    0,0,
    x2-x1+1,y2-y1+1,
    x1,y1);
  };
/*}}}  */
 
/*{{{  OSZSGr_Line(        TC3,GNU        Linie zeichnen*/
void  OSZSGr_Line(int xa,int ya,int xb,int yb,unsigned char color){
  XSetForeground(OSZVSyConTxt.dpy,
    OSZVSyConTxt.gc,
    OSZVGr_ColorValues[color]);
  XSetLineAttributes(
    OSZVSyConTxt.dpy,
    OSZVSyConTxt.gc,
    1,
    LineSolid,
    CapRound,
    JoinRound);
 
  if (xb < 0 ) { xa = -xb; xb = 0; };
  if (yb < 0 ) { ya = -yb; yb = 0; };
  XDrawLine(
      OSZVSyConTxt.dpy,
      OSZVSyConTxt.window,
      OSZVSyConTxt.gc,
      xa+OSZVSyConTxt.XA,
      ya+OSZVSyConTxt.YA,
      xb+OSZVSyConTxt.XA,
      yb+OSZVSyConTxt.YA);
  };
/*}}}  */
/*{{{  OSZSGr_HLin(        TC3,GNU        Horizontale Linie (schnell)*/
void  OSZSGr_HLin(int xa,int xb,int ya,unsigned char color){
  OSZSGr_Line(xa,ya,xb,ya,color);
  };
/*}}}  */
/*{{{  OSZSGr_VLin(        TC3,GNU        Vertikale Linie (schnell)*/
void  OSZSGr_VLin(int xa,int ya,int yb,unsigned char color){
  OSZSGr_Line(xa,ya,xa,yb,color);
  };
/*}}}  */
/*{{{  OSZSGr_Ell(         TC3,!!!        Kreis bzw. Ellipse*/
void  OSZSGr_Ell(int xa,int ya,int stang,int endang,
              int ra,int rb,int farbe){
#ifdef OzSYSDEF_TC3_VERSION
  setcolor(farbe);
  ellipse(xa,ya,stang,endang,ra,rb);
#endif
  };
/*}}}  */
/*}}}  */
/*{{{  OSZSMs_CursorON(      TC3,g//,x??*/
void  OSZSMs_FramON(int xxa, int yya, int xxb, int yyb,
                         int xmin,int ymin,int xmax,int ymax,
                         int col1,int col2){
  int xa,ya,xb,yb;
  xa = xxa;ya = yya;xb = xxb;yb = yyb;
  if ((xa == xb) & (ya == yb)) {return;};
  if (xa > xb)   {xa=xxb;xb = xxa;};
  if (ya > yb)   {ya=yyb;yb = yya;};
  OSZSMs_DFramONFrames[0] = OSZSGr_SavImag(xmin,ya,xmax,ya);
  if (OSZSMs_DFramONFrames[0]==NULL){ puts("ERR: cannot alloc graphic mem!"); };
  OSZSMs_DFramONFrames[1] = OSZSGr_SavImag(xmin,yb,xmax,yb);
  if (OSZSMs_DFramONFrames[1]==NULL){ puts("ERR: cannot alloc graphic mem!"); };
  OSZSMs_DFramONFrames[2] = OSZSGr_SavImag(xa,ymin,xa,ymax);
  if (OSZSMs_DFramONFrames[2]==NULL){ puts("ERR: cannot alloc graphic mem!"); };
  OSZSMs_DFramONFrames[3] = OSZSGr_SavImag(xb,ymin,xb,ymax);
  if (OSZSMs_DFramONFrames[3]==NULL){ puts("ERR: cannot alloc graphic mem!"); };
  if ((ya >= ymin)&(ya <= ymax)){ OSZSGr_Line(xmin,ya,xmax,ya,col1); };
  if ((yb >= ymin)&(yb <= ymax)){ OSZSGr_Line(xmin,yb,xmax,yb,col2); };
  if ((xa >= xmin)&(xa <= xmax)){ OSZSGr_Line(xa,ymin,xa,ymax,col1); };
  if ((xb >= xmin)&(xb <= xmax)){ OSZSGr_Line(xb,ymin,xb,ymax,col2); };
  };
/*}}}  */
/*{{{  OSZSMs_CursorOFF(     TC3,g//,x??*/
void OSZSMs_FramOFF(int xxa,int yya,int xxb,int yyb,
                          int xmin, int ymin, int xmax, int ymax){
  int xa,ya,xb,yb;
  xa = xxa;ya = yya;xb = xxb;yb = yyb;
  if ((xa == xb) & (ya == yb)) {return;};
  if (xa > xb)   {xa=xxb;xb = xxa;};
  if (ya > yb)   {ya=yyb;yb = yya;};
  OSZSGr_ResImag(OSZSMs_DFramONFrames[3],xb, ymin, xb, ymax);
  OSZSGr_ResImag(OSZSMs_DFramONFrames[2],xa, ymin, xa, ymax);
  OSZSGr_ResImag(OSZSMs_DFramONFrames[1],xmin, yb, xmax, yb);
  OSZSGr_ResImag(OSZSMs_DFramONFrames[0],xmin, ya, xmax, ya);
  };
/*}}}  */

/*{{{  Generelle Typen*/

#define MAXachse   4
#define MAXkurve   4
#define MAXframe  16
#define MAXsignal 16 /* <== MAXkurve * MAXachse !!  */
#define MAXfiles  16
#define  SZKEN   16                     /* Groesse der Kennung in Bytes */
#define  SZUN    16                     /* Groesse der Einheitsbezeich. */
#define  SZFL    16                     /* Groesse der Float-Darstellung*/

typedef struct {
  short x;                              /* Abstand der Achsen vom Nullpkt*/
  short y;                              /* jeweils in Pixel v.links unten*/
} AchsenOffs;

typedef struct {
  short       AnzKoordAchsen;           /* Anzahl "Nullinien" im Oszill. */
  short       AnzKurvPrAchse;           /* Wieviele Signale pro Achse    */
  short       MaxXPixel;                /* Breite der Darstellung        */
  short       MaxYPixel;                /* Hoehe der Darstellung         */
  short       XOffs;                    /* Oszilloskop-Offset            */
  short       YOffs;                    /* Oszilloskop-Offset            */
  char        XZoom[SZFL];              /* Faktor (Schirmvergroesserung) */
  char        XRasterInc[SZFL];         /* Abstd der senkr. Teilstriche [Pixel] */
  AchsenOffs  ao[MAXachse];
} DSC_DSP;

typedef struct {
  char fname1[15];
  } FNAME;

typedef struct {
  FNAME FN[20];
  } FileDescr;

typedef struct {
  short AnzDatenFiles;
  short AnzSignale;
  short RF[MAXsignal];
  double xmag;
  double ymag;
  } DisplayDescr;

/*}}}  */

/*{{{  Grafik-Display Datenstrukturen*/

/* ====================================================================
   Display-Header
   ====================================================================
   OSZ kann Datenfiles mit und ohne Header darstellen.
   Wird ein Header erkannt, werden Defaultwerte fuer die Darstellung aus
   der Datenfile uebernommen. Dadurch koennen diverse Abfragen entfallen.
   Teil 1 muss am Beginn der Datei stehen, die anderen koennen beliebig
   positioniert sein.
 
   1.   unveraenderlicher Headerteil = Headerbeschreibung
   -------------------------------------------------------------------- */

typedef struct {
        short  szken;                   /* Groesse der Kennung in Bytes */
        short  szfl;                    /* Groesse der Float-Darstellung*/
        short  sz_unit;                 /* Zeichenzahl Signal-Einheiten */
        short  anz_sig;                 /* Zahl der Signale im Frame    */
        char   kenn[SZKEN];             /* Eintrag der File-Kennung     */
        long   scrof;                   /* Offset zum Oszilloskopdescr. */
        long   free1of;
        long   dsgof;                   /* Offset der Signalbeschreibung*/
        long   free2of;
        long   datof;                   /* Offset des 1. Datenframes    */
        long   anz_fr;                  /* Anzahl der Daten-Frames      */
        long   first_fr;                /* erster gueltiger frame (..=0)*/
        long   disp_fr;                 /* Displaybeginn mit frame(..=0)*/
        long   xoffs;                  /* x-Offset aller Sign[in ms]   */
        char   timstp[SZFL];            /* Zeittakt (pktkt*step*raff)[ms]*/
} DHD_DSC;



/* --------------------------------------------------------------------
   Signalbeschreibung
   -------------------------------------------------------------------- */
typedef struct {
        short  datype;                  /* Datentyp der Signale
                                                0 = short
                                                1 = double              */
        short  sigmax;                  /* Signalmaximum (mit z_fact)   */
        short  sigmin;                  /* Signalminimum (mit z_fact)   */

        char   z_fact[SZFL];            /* physikalische Einheiten/LSB  */
        char   bermax[SZFL];            /* Bereichsmaximum phys. Einh.  */
        char   bermin[SZFL];            /* Bereichsminimum phys. Einh.  */

        char   units[SZUN];             /* Bezeichnung der phys. Einheit*/
        short  farbe;                   /* Farbe der Kurve auf d. Schirm*/
        short  ltyp;                    /* Pixel (0) oder Polygonzug (1)*/
} DSC_SIG;



/*}}}  */
/*{{{  Fehlermeldungen*/

#define NO_FILE        11
#define HDR_TOO_SHORT  12
#define FILE_TOO_SHORT 13
/*}}}  */
/*{{{  Weitere globale Variablen*/

DisplayDescr G_DD;
char FileDirectory[51];
char DatFileName[60];

/*}}}  */
/*{{{  Globale Steuervariablen fuer Einzelfunktionen wie Zoom etc*/

double Ozzoomx=1;
double Ozzoomy=1;
int    Ozpixel=1;
int    Ozstartframe=0;
int c1xpos=0, c2xpos=0, c1ypos=2, c2ypos=2;
char   Ozsignalname[MAXsignal+2][100];
char   Ozaktsignal[100]=" Kein Signal";
int    Ozsignal=0,Ozfile=0;
int    Ozsignalrfnr=0;
int    Ozsignalselected=0;

/*}}}  */
/*{{{  Datenfile Header auswerten & Offsets lesen*/

void MAKE_NAME(char *sstr){
  sprintf(DatFileName,"%s%s",FileDirectory,sstr);
  };

/*{{{  OSZSSyfopen(       TC3,GNU,X11    allgemeines open*/
FILE *OSZSSyfopen(char *name, char *type){
  int ii;
  char sstr[200];
  strcpy(sstr,name);
  if ( (strstr(sstr,"@(dir)") != NULL) ||
      (strstr(sstr,"@(DIR)") != NULL) ){
    char pstr[200];
    char thepath[200];
    getcwd(thepath,199);
    strcpy(pstr,"\\");
    strcat(pstr,thepath);
    strcat(pstr,"\\");
    strcat(pstr,strstr(sstr,"@(dir)")+6);
    strcpy(sstr,pstr);
    };
  for (ii=0;ii<strlen(sstr);ii++){
    if (sstr[ii] == '\\'){
      sstr[ii] = '/';
      }
    else {
      if ((sstr[ii] >= 'A') & (sstr[ii] <= 'Z')){
        sstr[ii] = tolower(sstr[ii]);
        };
      };
    };
  if (OSZVMf_prd){
    FILE *fp;
    char *sres="FAILED";
    fp = fopen(sstr,type);
    if (fp != NULL){
      sres="OK";
      };
    printf(" >>>%s<<< to open %s (with %s)\n",sres,sstr,type);
    return(fp);
    }
  else {
    return(fopen(sstr,type));
    };
  };

/*}}}  */

int  ReadHeader(FileDescr *FD, int f_nr, DHD_DSC *header){
  FILE *fp=NULL;

  if (f_nr == -1){
      {
      int ii=0;
      MAKE_NAME(((char*)&FD->FN[ii]));
      while ((fp = OSZSSyfopen(DatFileName,"rb")) == NULL) {
        ii++;
        MAKE_NAME(((char*)&FD->FN[ii]));
        if (ii > G_DD.AnzDatenFiles){
          break;
          };
        };
      if (fp == NULL) { return(NO_FILE); };
      f_nr = ii;
      };
    }
  else {
    MAKE_NAME(((char*)&FD->FN[f_nr]));
    if ((fp = OSZSSyfopen(DatFileName,"rb")) == NULL) {return(NO_FILE);};
    };
  if (fread(header,1,sizeof(DHD_DSC),fp) != sizeof(DHD_DSC)){
    fclose(fp);return(HDR_TOO_SHORT);
    };
  fclose(fp);
  if (strcmp(header->kenn,"XBWIN-DISPLAY") != 0){
    return(1);
    };
  return(0);
  };

int  ReadSigDsc(FileDescr *FD, int f_nr, DHD_DSC *header,
                    DSC_SIG (*DS)[]){
  FILE *fp=NULL;

  if (f_nr == -1){
      {
      int ii=0;
      MAKE_NAME(((char*)&FD->FN[ii]));
      while ((fp = OSZSSyfopen(DatFileName,"rb")) == NULL) {
        ii++;
        MAKE_NAME(((char*)&FD->FN[ii]));
        if (ii > G_DD.AnzDatenFiles){
          break;
          };
        };
      if (fp == NULL) { return(NO_FILE); };
      f_nr = ii;
      };
    }
  else {
    MAKE_NAME(((char*)&FD->FN[f_nr]));
    if ((fp = OSZSSyfopen(DatFileName,"rb")) == NULL) {return(NO_FILE);};
    };
  if (fseek(fp,header->dsgof,SEEK_SET)){
    fclose(fp);return(FILE_TOO_SHORT);
    };
  if (fread(DS,1,MAXframe*sizeof(DSC_SIG),fp) !=
      MAXframe*sizeof(DSC_SIG)){
    fclose(fp);return(FILE_TOO_SHORT);
    };
  fclose(fp);
  return(0);
  };

int  ReadDspDsc(FileDescr *FD, int f_nr, DHD_DSC *header,
                    DSC_DSP *DP){
  FILE *fp=NULL;

  if (f_nr == -1){
      {
      int ii=0;
      MAKE_NAME(((char*)&FD->FN[ii]));
      while ((fp = OSZSSyfopen(DatFileName,"rb")) == NULL) {
        ii++;
        MAKE_NAME(((char*)&FD->FN[ii]));
        if (ii > G_DD.AnzDatenFiles){
          break;
          };
        };
      if (fp == NULL) { return(NO_FILE); };
      f_nr = ii;
      };
    }
  else {
    MAKE_NAME(((char*)&FD->FN[f_nr]));
    if ((fp = OSZSSyfopen(DatFileName,"rb")) == NULL) { return(NO_FILE);};
    };
  if (fseek(fp,header->scrof,SEEK_SET)){
    fclose(fp);return(FILE_TOO_SHORT);
    };
  if (fread(DP,1,sizeof(DSC_DSP),fp) != sizeof(DSC_DSP)){
    fclose(fp);return(FILE_TOO_SHORT);
    };
  fclose(fp);
  return(0);
  };

/*}}}  */
/*{{{  Metafile-Daten einfuegen wenn noetig*/

void  SetHeaderFromMTA(GenObjDgn *TO, DHD_DSC *header){
  double hh;

  /* ============== USER-Setup abfragen ================================== */
 
  header->first_fr = osz.startframe;
 
  hh = osz.displayframe ;
  if (hh > header->disp_fr){
    if (hh < header->anz_fr) {
      header->disp_fr = hh;
      }
    else {
      header->disp_fr = 0;
      };
    };
 
  sprintf(header->timstp,"%7.3f",osz.xinc);
  };





void  SetDspDscFromMTA(GenObjDgn *TO, DSC_DSP *DP){
  DP->AnzKoordAchsen = 4;
  DP->AnzKurvPrAchse = 4;
  DP->MaxXPixel = TO->XB;
  DP->MaxYPixel = TO->YB;
 
  DP->ao[0].x = osz.axo0;
  DP->ao[0].y = osz.ayo0;
  DP->ao[1].x = osz.axo1;
  DP->ao[1].y = osz.ayo1;
  DP->ao[2].x = osz.axo2;
  DP->ao[2].y = osz.ayo2;
  DP->ao[3].x = osz.axo3;
  DP->ao[3].y = osz.ayo3;
 
  };

 

/*}}}  */
/*{{{  Berechnung Pixelzahl aus Grafikdaten (mit Zoom etc)*/

#define CalcYPixel(yy,ysch,yo_sch,ysc_sch,yof_str,yzo_str,yof_achse,yof_diag,YB) \
  yy = YB - (((ysch+yo_sch)*ysc_sch+yof_str)*yzo_str+yof_achse+yof_diag)

#define CalcIPixel(xx,i,xinc_str,xo_str,xzo_str,xof_achse,xof_diag,XA)\
  xx = XA + ((i*xinc_str+xo_str)*xzo_str+xof_achse+xof_diag)

#define CalcXPixel(xx,xsch,xo_sch,xsc_sch,xo_str,xzo_str,xof_achse,xof_diag,XA)\
  xx = XA + (((xsch+xo_sch)*xsc_sch+xo_str)*xzo_str+xof_achse+xof_diag)

#define CalcYZoom(yzo_str,YB,YA,AnzAx,ymaxstr,ymin_str) \
  yzo_str = (YB-YA)/((AnzAx+1)*(ymaxstr-ymin_str))

#define CalcXZoom(xzo_str) \
  xzo_str = 1.0/((atof(G_HD.timstp)+0)*G_DD.xmag)

#define GetYPixel(yy,ysch,sig,axe) \
  CalcYPixel(yy,ysch,(0),atof(A_DS[sig].z_fact),0,yzoo_str,\
  ((G_DP.ao)[axe].y),G_DP.YOffs,TO->YB)

#define GetIPixel(xx,i,xinc) \
  CalcIPixel(xx,i,xinc,0,1,0,0,TO->XA)

/*}}}  */
/*{{{  Draw Multiline Hauptroutine*/

  DSC_DSP   G_DP = {1,1,400,300,0,0,"1.0","10.0",{0,0,0,0,0,0,0,0}};
 
void  DrawMultiLine(GenObjDgn *TO, int dmode,
  int c1xpos, int c2xpos, int c1ypos, int c2ypos, double zoomx, double zoomy){
/*{{{  Variablen*/
  char dummystring[300];
/* ==============Variablen============================================== */
 
  short
    FramVec[MAXsignal+2],
    AxesVec[MAXsignal+2],
    FrNrVec[MAXsignal+2];
 
  DHD_DSC   A_HD,
            G_HD = { SZKEN,SZFL,SZUN,0,"  ",0,0,0,0,0,0,0,0,0,"1.0" };
  FileDescr G_FD = {" "," "," "," "," "," "," "," "};
  DSC_SIG   A_DS[MAXframe+2];

  double
    AktSigV[MAXsignal+2]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

  double
    xz_fakt[MAXsignal+2],
    yz_fakt[MAXsignal+2],
    ya_cnst[MAXsignal+2];
  short
    xa_last[MAXsignal+2],
    ya_last[MAXsignal+2];

  double
    xstr_delta,xzoo_str,yzoo_str,ymaxstr,ymin_str,xa,ya,yb;
 
  FILE
    *fp;
  int
    retval,first_time_display,
    dfl,ii,ll,RealFramSiz,AktSigZahl,dummy,FirstIsX,
    k_nr,a_nr,settheframe,
    interleave = 0;
  char
    *FF;
  char
    sstr[60];
  long
    FrameNummer,startframe=0,FrameIncr;
/*}}}  */
  OSZSGr_TLBox(TO->XA,TO->YA,TO->XB,TO->YA+13,"",7,7,7);
  OSZSGr_TLBox(TO->XA,TO->YA+13,TO->XB,TO->YB,"",8,8,15);
 
  G_DD.xmag = osz.xmag;
  if (G_DD.xmag <= 0){ G_DD.xmag = 1.0;};
  if (Ozzoomx != 1){
    G_DD.xmag = Ozzoomx;
    };
 
  G_DD.ymag = osz.ymag;
  if (G_DD.ymag <= 0){ G_DD.ymag = 1.0;};
  if (Ozzoomy != 1){
    G_DD.ymag = Ozzoomy;
    };
  printf("Setze G_DD.ymag auf %12.5f\n",G_DD.ymag);

/*{{{  Interleave, Directory, Filezahl*/

  interleave = osz.intlv;
  FF = osz.FileDir;
  if (FF != NULL) {
    strncpy(FileDirectory,FF,50);
    FileDirectory[50]=0;
    Pack_Text(FileDirectory,FileDirectory);
    }
  else {
    strcpy(FileDirectory,"");
    };

  G_DD.AnzDatenFiles = osz.adf;
  if(G_DD.AnzDatenFiles <= 0){
    dmode |= 0x4000;
    goto viewport_ende;
    };
/*}}}  */
/*{{{  Filenamen*/

  for (dfl=0;dfl < G_DD.AnzDatenFiles;dfl++){
    switch(dfl){
      case  0: FF = osz.fp[0]; break;
      case  1: FF = osz.fp[1]; break;
      case  2: FF = osz.fp[2]; break;
      case  3: FF = osz.fp[3]; break;
      case  4: FF = osz.fp[4]; break;
      case  5: FF = osz.fp[5]; break;
      case  6: FF = osz.fp[6]; break;
      case  7: FF = osz.fp[7]; break;
      case  8: FF = osz.fp[8]; break;
      case  9: FF = osz.fp[9]; break;
      case 10: FF = osz.fp[10]; break;
      case 11: FF = osz.fp[11]; break;
      default: FF = ""; break;
      };
    if (FF == NULL){
      G_DD.AnzDatenFiles = dfl;
      dfl = 10000;
      }
    else {
      strncpy((char*)&G_FD.FN[dfl],FF,60);
      FF = (char*)&G_FD.FN[dfl];
      FF[60] = 0;
      Pack_Text(FF,FF);
      };
    };
 
/*}}}  */
/*{{{  USER-Setup abfragen (Datenbasis RADIS)*/

  /* ============== USER-Setup abfragen ================================== */

  if ((retval = ReadHeader(&G_FD,-1,&G_HD)) == 0) {
    ReadDspDsc(&G_FD,-1,&G_HD,&G_DP);
    ReadSigDsc(&G_FD,-1,&G_HD,&A_DS);
    }
  else {
    if (retval == NO_FILE) {
      puts("Could not read data file.");
      };
    dmode |= 0x4000;
    goto viewport_ende;
    };

  for (ll=0;ll<MAXsignal;ll++){
    FF = oszvideo.sig[ll];
    if (FF != NULL){
      strcpy(FF," ");
      }
    else {
      ll= MAXsignal+10;
      };
    };

 
  G_DD.AnzSignale = G_DP.AnzKoordAchsen * G_DP.AnzKurvPrAchse;

  /* =====================================================================
      globale Konstanten korrigieren
     ===================================================================== */

  SetHeaderFromMTA(TO, &G_HD);
  SetDspDscFromMTA(TO, &G_DP);
 
  if (atof(G_HD.timstp) == 0){
    sprintf(G_HD.timstp,"1.0");
    };

  if (atof(G_DP.XZoom) == 0.0) {
    strcpy(G_DP.XZoom,"1.0  ");
    };

  if (atof(G_DP.XRasterInc) == 0.0) {
    strcpy(G_DP.XRasterInc,"10.0  ");
    };
  for (ll=0;ll<MAXachse;ll++){
    if ((G_DP.ao)[ll].y == 0) {
      (G_DP.ao)[ll].y =(ll+1)*((TO->YB-TO->YA)/(G_DP.AnzKoordAchsen+1));
      };
    };

  startframe = Ozstartframe;
/*}}}  */
/*{{{  Null-Linien zeichnen*/

  /* ===================================================================== */
  /*  Die Null- Linien zeichnen                                            */
  /* ===================================================================== */

  if (dmode & ML_DRAW_LINES) {
/*    WSetLineStyle(DOTTED_LINE,0,NORM_WIDTH); */
    for (ll = 0; ll < G_DP.AnzKoordAchsen; ll++){
      ya = TO->YB - ( (G_DP.ao)[ll].y + G_DP.YOffs );
      xa =             (G_DP.ao)[ll].x + G_DP.XOffs  ;
      WDLine(TO->XA+xa,ya,TO->XB,ya,osz.col[ll*G_DP.AnzKurvPrAchse]);
      WDLine(Ozmxp,ya,Ozmxp+SIGN_TEXTWIDTH,ya,8);
      };
    };
/*}}}  */
/*{{{  X-Raster zeichnen*/

  /* ===================================================================== */
  /* Das X-Raster zeichnen */
  /* ===================================================================== */
  if ( atof(G_DP.XRasterInc) > 0){
    xstr_delta = 1.0 * atof(G_HD.timstp) * atof(G_DP.XRasterInc) * G_DD.xmag;
    sprintf(sstr,"%7.3f [s]",(double)xstr_delta/1000.0);
    xzoo_str =  xstr_delta/atoi(G_DP.XRasterInc);
 
    ya  = TO->YA+15; yb = TO->YB;
    }
  else {
    xstr_delta = 1.0 / G_DD.xmag;
    if (xstr_delta > 1) {
      ya  = TO->YA; yb = TO->YB;
      if (dmode & ML_DRAW_LINES) {
        for (ii=1;ii<TO->XB- TO->XA;ii++){
          if (xstr_delta < 20) {
/*            WSetLineStyle(SOLID_LINE,0,NORM_WIDTH);*/
            xa = 1.0 * ii * xstr_delta;
            if (xa > TO->XB) {
              ii=2000;
              }
            else {
              WDLine(xa+TO->XA,ya,xa+TO->XA,ya+3,LightGray);
              WDLine(xa+TO->XA,yb,xa+TO->XA,yb-3,LightGray);
              };
            }
          else {
            xa = 1.0 * ii * xstr_delta;
            if (xa > TO->XB) {
              ii=2000;
              }
            else {
              WDLine(xa+TO->XA,ya,xa+TO->XA,yb,LightGray);
              };
            };
          };
        };
      };
    };

 /* WSetLineStyle(SOLID_LINE,0,NORM_WIDTH);*/
/*}}}  */

  /* ============== Daten lesen ========================================== */
  Cache_WDLine(-1,-1,-1,-1,0,-1,LINE_CACHE_CLEAR);
  first_time_display= -1;
 
  puts("Drawing...\n");
  for (dfl=0;dfl<G_DD.AnzDatenFiles;dfl++){
 
    /*{{{  Datei-Setup abfragen*/
    /* ============== Datei-Setup abfragen =============================== */
    if (!ReadHeader(&G_FD,dfl,&A_HD)) {
      if (ReadSigDsc(&G_FD,dfl,&G_HD,&A_DS)){
        goto schulz;
        };
      }
    else {
      goto schulz;
      };
    
    MAKE_NAME(((char*)&G_FD.FN[dfl]));
    printf("Opening data file %s...\n",DatFileName);
    if ((fp = OSZSSyfopen(DatFileName,"rb")) == NULL) { goto schulz;};
    /*}}}  */
    /*{{{  In den FramVec eintragen, welche Kurven der aktuellen Datei darstellen*/
    
    
    
    /* =======================================================================
    In den FramVec eintragen, welche Kurven der aktuellen Datei
    dargestellt werden sollen.
    ======================================================================= */
    RealFramSiz=0;
    for (ll=0,ii=0;ll<G_DD.AnzSignale;ll++){
      /* Ist es eine Kurve der aktuellen Datei?? */
      if ( osz.rhf[ll]/256 == dfl ){
        if ( osz.rhf[ll] >= 0) {
          FramVec[ii] = osz.rhf[ll] & 0xFF;
          AxesVec[ii] = ll/G_DP.AnzKurvPrAchse;
          FrNrVec[ii] = ll;  /* Nummer des Signals im RF-Feld!! */
    
          sprintf(sstr,"YF%d",ll);
          ymaxstr =  atof(A_DS[FramVec[ii]].bermax);
          ymin_str =  atof(A_DS[FramVec[ii]].bermin);
          CalcYZoom(yzoo_str,TO->YB,TO->YA,G_DP.AnzKoordAchsen,ymaxstr,ymin_str);
          if (yzoo_str < 0)  { yzoo_str = 0 - yzoo_str; };
          if (yzoo_str == 0) { yzoo_str = 1.0; };
    
    
          if (osz.yzo[ll]<=0){ osz.yzo[ll]=1;}
          yzoo_str *= (G_DD.ymag * osz.yzo[ll]);
    
    
          /* ======= Signalnamen rausschreiben =========================== */
    
          FF = oszvideo.sig[ll];
    
          if (FF != NULL){
            strcpy(FF,(char*)(A_DS[ll].units));
            };
    
          sprintf(Ozsignalname[ll],A_DS[FramVec[ii]].units);
          switch(ll){
          /*{{{  */
            /*{{{  0*/
            case  0: if (osz.sgs[0] == 1) {
                       DrawSigName(A_DS[FramVec[ii]].units,
                                   osz.col[0],
                          TO->YB - ( (G_DP.ao)[AxesVec[ii]].y + G_DP.YOffs),
                                   ii-((int)(ii/G_DP.AnzKurvPrAchse)*G_DP.AnzKurvPrAchse));
                       ii++;
                       };
                     break;
            /*}}}  */
            /*{{{  1*/
            case  1: if (osz.sgs[1] == 1) {
                       DrawSigName(A_DS[FramVec[ii]].units,
                                   osz.col[1],
                          TO->YB - ( (G_DP.ao)[AxesVec[ii]].y + G_DP.YOffs  ),
                                   ii-((int)(ii/G_DP.AnzKurvPrAchse)*G_DP.AnzKurvPrAchse));
                       ii++;
                       };
                     break;
            /*}}}  */
            /*{{{  2*/
            case  2: if (osz.sgs[2] == 1) {
                       DrawSigName(A_DS[FramVec[ii]].units,
                                   osz.col[2],
                          TO->YB - ( (G_DP.ao)[AxesVec[ii]].y + G_DP.YOffs  ),
                                   ii-((int)(ii/G_DP.AnzKurvPrAchse)*G_DP.AnzKurvPrAchse));
                       ii++;
                       };
                     break;
            /*}}}  */
            /*{{{  3*/
            case  3: if (osz.sgs[3] == 1) {
                       DrawSigName(A_DS[FramVec[ii]].units,
                                   osz.col[3],
                          TO->YB - ( (G_DP.ao)[AxesVec[ii]].y + G_DP.YOffs  ),
                                   ii-((int)(ii/G_DP.AnzKurvPrAchse)*G_DP.AnzKurvPrAchse));
                       ii++;
                       };
                     break;
            /*}}}  */
            /*{{{  4*/
            case  4: if (osz.sgs[4] == 1) {
                       DrawSigName(A_DS[FramVec[ii]].units,
                                   osz.col[4],
                          TO->YB - ( (G_DP.ao)[AxesVec[ii]].y + G_DP.YOffs  ),
                                   ii-((int)(ii/G_DP.AnzKurvPrAchse)*G_DP.AnzKurvPrAchse));
                       ii++;
                       };
                     break;
            /*}}}  */
            /*{{{  5*/
            case  5: if (osz.sgs[5] == 1) {
                       DrawSigName(A_DS[FramVec[ii]].units,
                                   osz.col[5],
                          TO->YB - ( (G_DP.ao)[AxesVec[ii]].y + G_DP.YOffs  ),
                                   ii-((int)(ii/G_DP.AnzKurvPrAchse)*G_DP.AnzKurvPrAchse));
                       ii++;
                       };
                     break;
            /*}}}  */
            /*{{{  6*/
            case  6: if (osz.sgs[6] == 1) {
                       DrawSigName(A_DS[FramVec[ii]].units,
                                   osz.col[6],
                          TO->YB - ( (G_DP.ao)[AxesVec[ii]].y + G_DP.YOffs  ),
                                   ii-((int)(ii/G_DP.AnzKurvPrAchse)*G_DP.AnzKurvPrAchse));
                       ii++;
                       };
                     break;
            /*}}}  */
            /*{{{  7*/
            case  7: if (osz.sgs[7] == 1) {
                       DrawSigName(A_DS[FramVec[ii]].units,
                                   osz.col[7],
                          TO->YB - ( (G_DP.ao)[AxesVec[ii]].y + G_DP.YOffs  ),
                                   ii-((int)(ii/G_DP.AnzKurvPrAchse)*G_DP.AnzKurvPrAchse));
                       ii++;
                       };
                     break;
            /*}}}  */
            /*{{{  8*/
            case  8: if (osz.sgs[8] == 1) {
                       DrawSigName(A_DS[FramVec[ii]].units,
                                   osz.col[8],
                          TO->YB - ( (G_DP.ao)[AxesVec[ii]].y + G_DP.YOffs  ),
                                   ii-((int)(ii/G_DP.AnzKurvPrAchse)*G_DP.AnzKurvPrAchse));
                       ii++;
                       };
                     break;
            /*}}}  */
            /*{{{  9*/
            case  9: if (osz.sgs[9] == 1) {
                       DrawSigName(A_DS[FramVec[ii]].units,
                                   osz.col[9],
                          TO->YB - ( (G_DP.ao)[AxesVec[ii]].y + G_DP.YOffs  ),
                                   ii-((int)(ii/G_DP.AnzKurvPrAchse)*G_DP.AnzKurvPrAchse));
                       ii++;
                       };
                     break;
            /*}}}  */
            /*{{{  10*/
            case 10: if (osz.sgs[10] == 1) {
                       DrawSigName(A_DS[FramVec[ii]].units,
                                   osz.col[10],
                          TO->YB - ( (G_DP.ao)[AxesVec[ii]].y + G_DP.YOffs  ),
                                   ii-((int)(ii/G_DP.AnzKurvPrAchse)*G_DP.AnzKurvPrAchse));
                       ii++;
                       };
                     break;
            /*}}}  */
            /*{{{  11*/
            case  11: if (osz.sgs[11] == 1) {
                       DrawSigName(A_DS[FramVec[ii]].units,
                                   osz.col[11],
                          TO->YB - ( (G_DP.ao)[AxesVec[ii]].y + G_DP.YOffs  ),
                                   ii-((int)(ii/G_DP.AnzKurvPrAchse)*G_DP.AnzKurvPrAchse));
                       ii++;
                       };
                     break;
            /*}}}  */
            /*{{{  12*/
            case  12: if (osz.sgs[12] == 1) {
                       DrawSigName(A_DS[FramVec[ii]].units,
                                   osz.col[12],
                          TO->YB - ( (G_DP.ao)[AxesVec[ii]].y + G_DP.YOffs  ),
                                   ii-((int)(ii/G_DP.AnzKurvPrAchse)*G_DP.AnzKurvPrAchse));
                       ii++;
                       };
                     break;
            /*}}}  */
            /*{{{  13*/
            case  13: if (osz.sgs[13] == 1) {
                       DrawSigName(A_DS[FramVec[ii]].units,
                                   osz.col[13],
                          TO->YB - ( (G_DP.ao)[AxesVec[ii]].y + G_DP.YOffs  ),
                                   ii-((int)(ii/G_DP.AnzKurvPrAchse)*G_DP.AnzKurvPrAchse));
                       ii++;
                       };
                     break;
            /*}}}  */
            /*{{{  14*/
            case  14: if (osz.sgs[14] == 1) {
                       DrawSigName(A_DS[FramVec[ii]].units,
                                   osz.col[14],
                          TO->YB - ( (G_DP.ao)[AxesVec[ii]].y + G_DP.YOffs  ),
                                   ii-((int)(ii/G_DP.AnzKurvPrAchse)*G_DP.AnzKurvPrAchse));
                       ii++;
                       };
                     break;
            /*}}}  */
            /*{{{  15*/
            case  15: if (osz.sgs[15] == 1) {
                       DrawSigName(A_DS[FramVec[ii]].units,
                                   osz.col[15],
                          TO->YB - ( (G_DP.ao)[AxesVec[ii]].y + G_DP.YOffs),
                                   ii-(((int)(ii/G_DP.AnzKurvPrAchse))*G_DP.AnzKurvPrAchse));
                       ii++;
                       };
                     break;
            /*}}}  */
            default:break;
            };
          
          
          /*}}}  */
    
          };
        };
      };
    for (ll=0;ll<A_HD.anz_sig;ll++){
      if (A_DS[ll].datype) {
        RealFramSiz += sizeof(double);
        }
      else {
        RealFramSiz += sizeof(short);
        };
      };
    if (ii<=0) {goto ende_der_datei;};
    
    FramVec[ii] = -1;
    AktSigZahl = ii;
    /*}}}  */
    /*{{{  Datei anlesen*/
    
    /*
    ==================================================================
    Datei anlesen
    ==================================================================
    */
    
    {
      long spos;
    
      spos = ((double)(A_HD.first_fr+A_HD.disp_fr+startframe)
        *((double)atof(G_HD.timstp)/(double)atof(A_HD.timstp)));
      if (fseek(fp,A_HD.datof+spos*RealFramSiz,SEEK_SET)){ goto ende_der_datei;};
      };
    
    /* WSetThinSolidLineStyle();*/
    settheframe = 0;
    
    FirstIsX = 0;
    if (atof(A_HD.timstp) <= 0) {
      FirstIsX = 1;
      };
    
    first_time_display++;
    /*}}}  */
    /*{{{  Zoomfaktoren setzen*/
    
    for (ii=FirstIsX;ii<AktSigZahl;ii++){
    
      k_nr = FramVec[ii];
      a_nr = AxesVec[ii];
    
      ymaxstr =  atof(A_DS[FramVec[ii]].bermax);
      ymin_str =  atof(A_DS[FramVec[ii]].bermin);
    
      CalcYZoom(yzoo_str,TO->YB,TO->YA,G_DP.AnzKoordAchsen,ymaxstr,ymin_str);
      if (yzoo_str < 0) { yzoo_str = 0 - yzoo_str; };
      if (yzoo_str == 0) { yzoo_str = 1.0; };
    
      if (osz.yzo[FrNrVec[ii]]<=0){ osz.yzo[FrNrVec[ii]]=1;}
      yzoo_str *= (G_DD.ymag * osz.yzo[FrNrVec[ii]]);
    
      xz_fakt[ii] = (double)atof(A_HD.timstp) /
                    (double)(atof(G_HD.timstp) * G_DD.xmag);
      yz_fakt[ii] = yzoo_str*atof((char*)Pack_Text(A_DS[FramVec[ii]].z_fact,dummystring));
      ya_cnst[ii] = TO->YB
                    -((G_DP.ao)[a_nr].y)
                    -G_DP.YOffs
                 /*   -yzoo_str*0 */
                    -(yzoo_str*atof((char*)Pack_Text(A_DS[FramVec[ii]].z_fact,dummystring))
                    );
    
      };
    /*}}}  */
 
    /*{{{  Daten zeichnen??*/
    if (dmode & ML_DRAW_LINES) {
      FrameIncr = G_DD.xmag;
      if ((FrameIncr <= 1) | (!interleave)){
        FrameIncr = 1;
        };
    
      CacheReadFile(NULL,0,NULL);
      puts("Drawing pixels...\n");
      for (FrameNummer = 0;FrameNummer<G_HD.anz_fr;FrameNummer+=FrameIncr){
    
        /*{{{  fseek wenn INTERLEAVE (auskommentiert)*/
        
        /*
        
        if (FrameIncr > 1) {
          long spos;
        
          spos = ((double)(A_HD.first_fr+A_HD.disp_fr+startframe+FrameNummer)
            *((double)atof(G_HD.timstp)/(double)atof(A_HD.timstp)));
          if (fseek(fp,A_HD.datof+spos*RealFramSiz,SEEK_SET)){ goto ende_der_datei;};
          };
        
        */
        
        /*}}}  */
    
        /*{{{  Zeit eintragen*/
        
        for (ll=0;ll<A_HD.anz_sig;ll++){
          if (A_DS[ll].datype) {
            if ( CacheReadFile(&AktSigV[ll],1,fp) != 0){
              {
                char nstr[40];
                sprintf(nstr,"%7.3f [s]",
                  (double)(A_HD.first_fr+A_HD.disp_fr+startframe+FrameNummer)*
                    atof(G_HD.timstp)/1000.0
                  );
                OSZSGr_TLBox(TO->XB-140,TO->YA,TO->XB,TO->YA+13,
                  (char*)Pack_Text(nstr,dummystring),7,TO->txc,7);
                };
              goto ende_der_datei;
              };
            }
          else {
            if (CacheReadFile(&AktSigV[ll],0,fp) != 0) {
              {
                char nstr[40];
                sprintf(nstr,"%7.3f [s]",
                  (double)(A_HD.first_fr+A_HD.disp_fr+startframe+FrameNummer)*
                    atof(G_HD.timstp)/1000.0
                  );
                OSZSGr_TLBox(TO->XB-140,TO->YA,TO->XB,TO->YA+13,
                  (char*)Pack_Text(nstr,dummystring),7,TO->txc,7);
                };
              goto ende_der_datei;
              };
            };
          };
        /*}}}  */
        /*{{{  Pixel zeichnen*/
        /*
        ===================================================================
        Pixel zeichnen
        ===================================================================
        */
        
        for (ii=FirstIsX;ii<AktSigZahl;ii++){
          /* ==============================================================
          Wenn FirstIsX == 1:
          -------------------
          Der erste gewaehlte Wert ist kein Y, sondern ein X-Wert !!!
          Da der angewaehlte Wert genommen wird, koennen Kurven nach
          verschiedenen X-Datenreihen skaliert werden (!)
          Nachteil: Man MUSS dann mit dem ersten Signal der Achse ein
          X-Signal waehlen (mit dem PopUp-Objekt).
          ================================================================= */
        
          if (FirstIsX) {
            xa = AktSigV[0];
            }
          else {
            xa = (double)xz_fakt[ii]*FrameNummer;
            };
        
          if (xa > TO->XB-5) {
            if (!first_time_display) {
              char nstr[40];
              sprintf(nstr,"%7.3f [s]",
                (double)(A_HD.first_fr+A_HD.disp_fr+startframe+FrameNummer)*
                  atof(G_HD.timstp)/1000.0
                );
              OSZSGr_TLBox(TO->XB-140,TO->YA,TO->XB,TO->YA+13,
                  (char*)Pack_Text(nstr,dummystring),7,TO->txc,7);
              };
            goto ende_der_datei;
            };
        
          /*    k_nr = FramVec[ii]; */
          /*    a_nr = AxesVec[ii]; */
        
        
          /*    GetYPixel(ya,AktSigV[FramVec[ii]],FramVec[ii],a_nr); */
        
          { int dd;
            dd = (int)AktSigV[FramVec[ii]];
            if (dd > 32767){ dd -=65536; };
            ya = ya_cnst[ii]-yz_fakt[ii]*dd;
            };
        
          if ((ya > TO->YA) & (ya < TO->YB)) {
            if (FrameNummer > 0) {
              Cache_WDLine(xa_last[ii]+TO->XA,ya_last[ii],
                xa+TO->XA,ya,osz.col[FrNrVec[ii]],ii,LINE_CACHE_WORK);
              }
            else {
              if (!first_time_display) {
                char nstr[50];
                sprintf(nstr,"%7.3f [s]",
                  (double)(A_HD.first_fr+A_HD.disp_fr+startframe+FrameNummer)*
                    atof(G_HD.timstp)/1000.0
                  );
                OSZSGr_TLBox(TO->XA+40,TO->YA,TO->XA+140,TO->YA+13,
                  (char*)Pack_Text(nstr,dummystring),7,TO->txc,7);
                if (FrameIncr > 1) {
                  OSZSGr_TLBox(TO->XA+200,TO->YA,TO->XA+300,TO->YA+13,
                    "INTERLEAVE",7,LightRed,7);
                  };
                };
              };
            };
        
          xa_last[ii] = xa;
          ya_last[ii] = ya;
        
          };
        
        if (WKeyPressed()) {
          while (WKeyPressed()) {
            WReadKey();
            };
          if (!first_time_display) {
            char nstr[40];
            sprintf(nstr,"%7.3f [s]",
              (double)(A_HD.first_fr+A_HD.disp_fr+startframe+FrameNummer)*
                atof(G_HD.timstp)/1000.0
              );
            OSZSGr_TLBox(TO->XB-100,TO->YA,TO->XB,TO->YA+13,
              (char*)Pack_Text(nstr,dummystring),7,TO->txc,7);
            FrameNummer = G_HD.anz_fr + 10;
            };
          goto ende_der_datei;
          };
        /*}}}  */
    
        };
      puts("...done with drawing of pixels!\n");
      };
    
    /*}}}  */
    /*{{{  Signalwerte auslesen??*/
    if (dmode & ML_GET_SIGNAL_VALUES) {
      if (fseek(fp,A_HD.datof+(A_HD.first_fr+A_HD.disp_fr+ /* startframe+ */ c1xpos)*RealFramSiz,
        SEEK_SET)){ goto ende_der_datei;};
    
      for (ll=0;ll<A_HD.anz_sig;ll++){
        if (A_DS[ll].datype) {
          if ( fread(&AktSigV[ll],1,sizeof(double),fp) != sizeof(double)){
            goto ende_der_datei;
            };
          }
        else {
          if (fread(&dummy,1,sizeof(short),fp) != sizeof(short)) {
            goto ende_der_datei;
            };
          AktSigV[ll] = (double)dummy;
          };
        };
    
      for (ii=FirstIsX;ii<AktSigZahl;ii++){
        ya = ya_cnst[ii]-yz_fakt[ii]*AktSigV[FramVec[ii]];
        };
    
      if (fseek(fp,A_HD.datof+(A_HD.first_fr+A_HD.disp_fr+ /* startframe+ */ c2xpos)*RealFramSiz,
        SEEK_SET)){ goto ende_der_datei;};
    
      for (ll=0;ll<A_HD.anz_sig;ll++){
        if (A_DS[ll].datype) {
          if ( fread(&AktSigV[ll],1,sizeof(double),fp) != sizeof(double)){
            goto ende_der_datei;
            };
          }
        else {
          if (fread(&dummy,1,sizeof(short),fp) != sizeof(short)) {
            goto ende_der_datei;
            };
          AktSigV[ll] = (double)dummy;
          };
        };
    
      for (ii=FirstIsX;ii<AktSigZahl;ii++){
        ya = ya_cnst[ii]-yz_fakt[ii]*AktSigV[FramVec[ii]];
        };
      };
    
    /*}}}  */
 
    ende_der_datei:;
    Cache_WDLine(-1,-1,-1,-1,0,-1,LINE_CACHE_FLUSH);
    Cache_WDLine(-1,-1,-1,-1,0,-1,LINE_CACHE_CLEAR);
    fclose(fp);
    schulz:;
    };
  puts("...done with drawing!\n");


/*{{{  Signalnamen setzen*/

  {
    int akt_sig_nr,akt_sig;
    char *akt_sig_name;
    char sstr[40];

    akt_sig_nr = oszvideo.AktSigNr;
    if ((akt_sig_nr >= 0) & (akt_sig_nr < MAXsignal)) {
      sprintf(sstr,"col%d",akt_sig_nr);
      akt_sig = 1;
      };
    };
 
/*}}}  */
/*{{{  Routinen-ENDE: Abschluss, ViewPort zurueckladen...*/

  viewport_ende:;
 
    /* ===================================================================== */
    /* Den Cursor zeichnen                                                   */
    /* ===================================================================== */
 
    if (dmode == 0x4000) {
      if (dmode & ML_DRAW_LINES) {
        Multiline_CursorSet = 0;
        };
      }
    else {
      if (dmode & ML_DRAW_LINES) {
        Multiline_CursorSet = 1;
        };
      };

/*}}}  */
  };

/*}}}  */
/*{{{  Anzahl Frames bestimmen*/


long GetFrameCount(GenObjDgn *TO){
  /*{{{  Variablen*/
  FileDescr G_FD = {" "," "," "," "," "," "," "," "};
  DHD_DSC   G_HD = { SZKEN,SZFL,SZUN,0,"  ",0,0,0,0,0,0,0,0,0,"1.0" };
  char
    *FF;
  int dfl;
  
  
  
  /*}}}  */
  FF = osz.FileDir;
  if (FF != NULL) {
    strncpy(FileDirectory,FF,50);
    FileDirectory[50]=0;
    Pack_Text(FileDirectory,FileDirectory);
    }
  else {
    strcpy(FileDirectory,"");
    };
 
  G_DD.AnzDatenFiles = osz.adf;
  /*{{{  etc*/
  
    for (dfl=0;dfl < G_DD.AnzDatenFiles;dfl++){
      switch(dfl){
        case  0: FF = osz.fp[0]; break;
        case  1: FF = osz.fp[1]; break;
        case  2: FF = osz.fp[2]; break;
        case  3: FF = osz.fp[3]; break;
        case  4: FF = osz.fp[4]; break;
        case  5: FF = osz.fp[5]; break;
        case  6: FF = osz.fp[6]; break;
        case  7: FF = osz.fp[7]; break;
        case  8: FF = osz.fp[8]; break;
        case  9: FF = osz.fp[9]; break;
        case 10: FF = osz.fp[10]; break;
        case 11: FF = osz.fp[11]; break;
        default: FF = ""; break;
        };
      if (FF == NULL){
        G_DD.AnzDatenFiles = dfl;
        dfl = 10000;
        }
      else {
        strncpy((char*)&G_FD.FN[dfl],FF,60);
        FF = (char*)&G_FD.FN[dfl];
        FF[60] = 0;
        Pack_Text(FF,FF);
        };
      };
  
  /*}}}  */
  if (ReadHeader(&G_FD,-1,&G_HD) == 0) {
    SetHeaderFromMTA(TO, &G_HD);
    if (G_HD.anz_fr > 0) {
      return(G_HD.anz_fr);
      };
    };
  return(0);
  };
/*}}}  */

/*{{{  Icons und Oszilloskop-Funktionen*/
void OzSetSlider(double prozent);

/*{{{  int OzExit(void){*/
int OzBeenden=0;
int OzExit(void){
  OzBeenden = 1;
  return(1);
  };
/*}}}  */
/*{{{  int OzDraw(void){*/
int OzZeichnen = 0;
int OzDraw(void){
  OzZeichnen=1;
  return(1);
  };
/*}}}  */
/*{{{  int OzLeft(void){*/
int OzLeft(void){
  Ozstartframe = Ozstartframe - Ozpixel*Ozzoomx;
  if (Ozstartframe < 0){ Ozstartframe = 0; };
  OzZeichnen=1;
  return(1);
  };
/*}}}  */
/*{{{  int OzRight(void){*/
int OzRight(void){
  long ii;
  ii = GetFrameCount(&GrafikObj);
  Ozstartframe = Ozstartframe + Ozpixel*Ozzoomx;
  if (Ozstartframe > ii){
    Ozstartframe = ii-(Ozpixel*Ozzoomx*1.2);
    };
  if (Ozstartframe < 0){ Ozstartframe = 0; };
  OzZeichnen=1;
  return(1);
  };
/*}}}  */
/*{{{  int OzHRed(void){*/
int OzHRed(void){
  Ozzoomx = Ozzoomx*2.0;
  OzZeichnen=1;
  return(1);
  };
/*}}}  */
/*{{{  int OzHZoo(void){*/
int OzHZoo(void){
  return(0);
  };
/*}}}  */
/*{{{  int OzHEnl(void){*/
int OzHEnl(void){
  Ozzoomx = Ozzoomx/2.0;
  OzZeichnen=1;
  return(1);
  };
/*}}}  */
/*{{{  int OzMax(void){*/
int OzMax(void){
  double xzoom=1;
  long frames;
  frames = GetFrameCount(&GrafikObj);
  printf("Anz Frames: %ld\n", frames);
  printf("Bildbreite (Pixel): %d\n",Ozpixel);
  if (Ozpixel > 0){
    xzoom = (double)frames/(double)Ozpixel; /* Frames pro pixel */
    Ozzoomx = xzoom;
    printf("Zoomfaktor: %12.5f\n",xzoom);
    Ozstartframe = 0;
    };
  c1xpos=0;
  c2xpos=1;
  c1ypos=2;
  c2ypos=2;
  OzZeichnen=1;
  return(1);
  };
/*}}}  */
/*{{{  int OzLupe(void){*/
int OzLupe(void){
  double xzoom=1;
  double frames;
  int cx;
  cx = c2xpos-c1xpos;
  frames = GetFrameCount(&GrafikObj);
  printf("Anz Frames: %12.0f\n", frames);
  printf("Bildbreite (Pixel): %d\n",Ozpixel);
  printf("Cursor Abstand (Pixel): %d\n",cx);
  if (Ozpixel > 0){
    xzoom = (double)frames;
 
    Ozstartframe = Ozstartframe/xzoom;
 
    xzoom = Ozzoomx;
    xzoom = xzoom * cx;  /* Anzahl frames im Cursor */
    xzoom = xzoom / (double)Ozpixel;
    xzoom = xzoom * 1.2; /* Darf's auch etwas mehr sein? */
    Ozzoomx = xzoom;
    printf("Zoomfaktor: %12.5f\n",xzoom);
 
    Ozstartframe = Ozstartframe*xzoom;
    };
  c1xpos=0;
  c2xpos=1;
  c1ypos=2;
  c2ypos=2;
  OzZeichnen=1;
  return(1);
  };
/*}}}  */
/*{{{  int OzVRed(void){*/
int OzVRed(void){
  Ozzoomy = Ozzoomy/2.0;
  OzZeichnen=1;
  return(1);
  };
/*}}}  */
/*{{{  int OzVZoo(void){*/
int OzVZoo(void){
  return(0);
  };
/*}}}  */
/*{{{  int OzVEnl(void){*/
int OzVEnl(void){
  Ozzoomy = Ozzoomy*2.0;
  OzZeichnen=1;
  return(1);
  };
/*}}}  */
/*{{{  int OzSlide(void){*/
int OzSlide(void){
  return(0);
  };
/*}}}  */
/*{{{  int OzStart(void){*/
int OzStart(void){
  Ozstartframe=0;
  OzZeichnen=1;
  return(1);
  };
/*}}}  */
/*{{{  int OzEnd(void){*/
int OzEnd(void){
  long ii;
  ii = GetFrameCount(&GrafikObj);
  Ozstartframe = ii-(Ozpixel*Ozzoomx*1.2);
  if (Ozstartframe < 0){ Ozstartframe = 0; };
  OzZeichnen=1;
  return(1);
  };
/*}}}  */
 
/*{{{  Icons*/

#define OzMAXICONS 15

/*{{{  typedef struct {*/
typedef struct {
  int X;
  int Y;
  int FG;
  int BK;
  int (*Funktion)(void);
  int W;
  int H;
  char *Name;
  XImage *Image;
  } OSZIcon;
 
OSZIcon OSZIcons[OzMAXICONS]={
  {  10,  5, 15,8, OzExit,  64,32, "/xw/csource/icons/exit.xbm", NULL},
  {  60,  5, 8,15, OzDraw,  64,32, "/xw/csource/icons/draw.xbm", NULL},
  {  40, 40, 8,15, OzLeft,  30,32, "/xw/csource/icons/left.xbm", NULL},
  { 540, 40, 8,15, OzRight, 30,32, "/xw/csource/icons/right.xbm", NULL},
  { 380,  5, 8,15, OzHRed,  50,32, "/xw/csource/icons/hred.xbm", NULL},
 
  { 430,  5, 8,15, OzHZoo,  50,32, "/xw/csource/icons/hzoo.xbm", NULL},
  { 490,  5, 8,15, OzHEnl,  50,32, "/xw/csource/icons/henl.xbm", NULL},
  { 120,  5, 8,15, OzMax,   50,32, "/xw/csource/icons/max.xbm", NULL},
  { 170,  5, 8,15, OzLupe,  50,32, "/xw/csource/icons/lupe.xbm", NULL},
  { 220,  5, 8,15, OzVRed,  50,32, "/xw/csource/icons/vred.xbm", NULL},
 
  { 270,  5, 8,15, OzVZoo,  50,32, "/xw/csource/icons/vzoo.xbm", NULL},
  { 330,  5, 8,15, OzVEnl,  50,32, "/xw/csource/icons/venl.xbm", NULL},
  {  10, 40, 8,15, OzStart, 30,32, "/xw/csource/icons/start.xbm", NULL},
  { 570, 40, 8,15, OzEnd,   30,32, "/xw/csource/icons/end.xbm", NULL},
  };

void OzSetSlider(double prozent){
  };


/*}}}  */
 
/*{{{  void OSZLoadImages(void){*/
void OSZLoadImages(void){
  int ii;
  for(ii=0;ii<OzMAXICONS;ii++){
    unsigned char *pmap_data;
    XImage *image;
    int w,h,xh,yh;
    OSZIcons[ii].Image = NULL;
    OSZIcons[ii].W = 0;
    OSZIcons[ii].H = 0;
    if (XmuReadBitmapDataFromFile(
        OSZIcons[ii].Name,
        &w, &h,
        &pmap_data,
        &xh, &yh
        ) == BitmapSuccess){
      image = XCreateImage(
         OSZVSyConTxt.dpy,
         XDefaultVisualOfScreen(OSZVSyConTxt.screen),
         1,
         XYBitmap,
         0,
         pmap_data,
         w,
         h,
         8,
         0);
      OSZIcons[ii].Image = image;
      OSZIcons[ii].W = w;
      OSZIcons[ii].H = h;
      };
    };
  };
/*}}}  */
/*{{{  void OSZFreeImages(void){*/
void OSZFreeImages(void){
  int ii;
  for(ii=0;ii<OzMAXICONS;ii++){
    if (OSZIcons[ii].Image!=NULL){
      XDestroyImage(OSZIcons[ii].Image);
      OSZIcons[ii].Image = NULL;
      };
    };
  };
/*}}}  */
/*{{{  int OSZShowIcons(void){*/
int OSZShowIcons(void){
  int ii;
  char sstr[100];
  OzSetSlider((double)Ozstartframe*100.0/(double)GetFrameCount(&GrafikObj));
 
  for (ii=0;ii<OzMAXICONS;ii++){
    XSetForeground(OSZVSyConTxt.dpy,OSZVSyConTxt.gc,
        OSZVGr_ColorValues[OSZIcons[ii].FG] );
    XSetBackground(OSZVSyConTxt.dpy,OSZVSyConTxt.gc,
        OSZVGr_ColorValues[OSZIcons[ii].BK] );
    XPutImage(
      OSZVSyConTxt.dpy,
      OSZVSyConTxt.window,
      OSZVSyConTxt.gc,
      OSZIcons[ii].Image,
      0,0,
      OSZIcons[ii].X,
      OSZIcons[ii].Y,
      OSZIcons[ii].W,
      OSZIcons[ii].H
      );
    };
 
  sprintf(sstr,"%1.2e",Ozzoomx);
  WDTextXY(OSZIcons[5].X+3,OSZIcons[5].Y+OSZIcons[5].W/2-7,sstr,8);
  sprintf(sstr,"%1.2e",Ozzoomy);
  WDTextXY(OSZIcons[10].X+3,OSZIcons[10].Y+OSZIcons[5].W/2-7,sstr,8);
 
  return(0);
  };
/*}}}  */

/*}}}  */
/*{{{  ClickedSigName*/
int ClickedSigName(GenObjDgn *TO, DSC_DSP *DP, int mausx, int mausy){
  int ii,yy;
  int yachse,signr;
  if ( (mausx > TO->XB) & (mausx < TO->XB+SIGN_TEXTWIDTH) ) {
    ii=0;
    for (yachse=0;yachse<DP->AnzKoordAchsen;yachse++){
      for (signr=0;signr<DP->AnzKurvPrAchse;signr++){
        yy = TO->YB - ( (DP->ao)[yachse].y + DP->YOffs) - signr*15;
        if ( (mausy >  yy) & (mausy < yy+15) ){
          Ozsignal = osz.rhf[ii] & 0xFF;
          Ozfile = (osz.rhf[ii] & 0xFF00 ) >> 8;
          Ozsignalrfnr = ii;
          printf("Clicked Signal %d (file %d).\n",Ozsignal,Ozfile);
          sprintf(Ozaktsignal," %s",Ozsignalname[ii]);
          Ozsignalselected=1;
          return(ii);
          };
        ii++;
        };
      };
    };
  return(-1);
  };
/*}}}  */
/*{{{  int OzFunktion(int x, int y){*/
int OzFunktion(int x, int y){
  int ii;
  for (ii=OzMAXICONS-1;ii>=0;ii--){
    if (x >= OSZIcons[ii].X){
      if (x <= OSZIcons[ii].X+OSZIcons[ii].W){
        if (y >= OSZIcons[ii].Y){
          if (y <= OSZIcons[ii].Y+OSZIcons[ii].H){
            ii=(OSZIcons[ii].Funktion)();
            return(ii);
            };
          };
        };
      };
    };
  if ( (ii=ClickedSigName(&GrafikObj,&G_DP, x, y)) >= 0){
    return(1);
    };
  return(0);
  };
/*}}}  */
 
/*}}}  */
/*{{{  X11-Window * * * * * * * * * * * * * * * * * * * * * * * * **/
/*{{{  OSZFSydoXXXXXXXXXX(t--,g--,X11    X11 only*/
/*{{{  OSZFSydoDefineColor(       X11    Farbe allozieren (X11 only)*/
unsigned long  OSZFSydoDefineColor(int n){
  XColor exakt_color,screen_color;

  if ((XDefaultVisualOfScreen(OSZVSyConTxt.screen))->class == TrueColor
      || (XDefaultVisualOfScreen(OSZVSyConTxt.screen))->class == PseudoColor
      || (XDefaultVisualOfScreen(OSZVSyConTxt.screen))->class == DirectColor
      ||  (XDefaultVisualOfScreen(OSZVSyConTxt.screen))->class == StaticColor){
    if (XAllocNamedColor( OSZVSyConTxt.dpy, XDefaultColormapOfScreen(OSZVSyConTxt.screen),
        OSZSETUP.OSZVGr_ColorTexte[n-1], &screen_color, &exakt_color)) {
      return screen_color.pixel;
      };
    }
  else {
    switch (n){
      case 1: return(XBlackPixelOfScreen(OSZVSyConTxt.screen));
      case 2: return(XWhitePixelOfScreen(OSZVSyConTxt.screen));
      case 3: return(XBlackPixelOfScreen(OSZVSyConTxt.screen));
      };
    };
  return(0);
  };

/*}}}  */
/*{{{  OSZFSydoCreateWindow(      X11    Hauptwindow generieren*/
void OSZFSydoCreateWindow(void){
/*  int windowW = XWidthOfScreen(OSZVSyConTxt.screen)-10;  */
/*  int windowH = XHeightOfScreen(OSZVSyConTxt.screen)-10; */
  int windowW = OSZSETUP.winw;
  int windowH = OSZSETUP.winh;
  int windowX = 1;
  int windowY = 1;

  XSetWindowAttributes xswa;
 
  xswa.event_mask =   ExposureMask |
                      ButtonPressMask;

  xswa.background_pixel = OSZFSydoDefineColor(8);
  xswa.backing_store    = WhenMapped;
  xswa.save_under       = 0;
  xswa.cursor           = 5;

  OSZVGr_ColorValues[0]  = OSZFSydoDefineColor(1);
  OSZVGr_ColorValues[1]  = OSZFSydoDefineColor(2);
  OSZVGr_ColorValues[2]  = OSZFSydoDefineColor(3);
  OSZVGr_ColorValues[3]  = OSZFSydoDefineColor(4);
  OSZVGr_ColorValues[4]  = OSZFSydoDefineColor(5);
  OSZVGr_ColorValues[5]  = OSZFSydoDefineColor(6);
  OSZVGr_ColorValues[6]  = OSZFSydoDefineColor(7);
  OSZVGr_ColorValues[7]  = OSZFSydoDefineColor(8);
  OSZVGr_ColorValues[8]  = OSZFSydoDefineColor(9);
  OSZVGr_ColorValues[9]  = OSZFSydoDefineColor(10);
  OSZVGr_ColorValues[10] = OSZFSydoDefineColor(11);
  OSZVGr_ColorValues[11] = OSZFSydoDefineColor(12);
  OSZVGr_ColorValues[12] = OSZFSydoDefineColor(13);
  OSZVGr_ColorValues[13] = OSZFSydoDefineColor(14);
  OSZVGr_ColorValues[14] = OSZFSydoDefineColor(15);
  OSZVGr_ColorValues[15] = OSZFSydoDefineColor(16);
 
  OSZVGr_ColorValues[16] = OSZFSydoDefineColor(17);
  OSZVGr_ColorValues[17] = OSZFSydoDefineColor(18);
  OSZVGr_ColorValues[18] = OSZFSydoDefineColor(19);
  OSZVGr_ColorValues[19] = OSZFSydoDefineColor(20);
  OSZVGr_ColorValues[20] = OSZFSydoDefineColor(21);
  OSZVGr_ColorValues[21] = OSZFSydoDefineColor(22);
  OSZVGr_ColorValues[22] = OSZFSydoDefineColor(23);
  OSZVGr_ColorValues[23] = OSZFSydoDefineColor(24);
  OSZVGr_ColorValues[24] = OSZFSydoDefineColor(25);
  OSZVGr_ColorValues[25] = OSZFSydoDefineColor(26);
  OSZVGr_ColorValues[26] = OSZFSydoDefineColor(27);
  OSZVGr_ColorValues[27] = OSZFSydoDefineColor(28);
  OSZVGr_ColorValues[28] = OSZFSydoDefineColor(29);
  OSZVGr_ColorValues[29] = OSZFSydoDefineColor(30);
  OSZVGr_ColorValues[30] = OSZFSydoDefineColor(31);
  OSZVGr_ColorValues[31] = OSZFSydoDefineColor(32);
 
 
  OSZVSyConTxt.window =
    XCreateWindow(
      OSZVSyConTxt.dpy,
      XRootWindowOfScreen(OSZVSyConTxt.screen),
      windowX,
      windowY,
      windowW,
      windowH, 0,
      XDefaultDepthOfScreen(OSZVSyConTxt.screen),
      InputOutput,
      XDefaultVisualOfScreen(OSZVSyConTxt.screen),
      CWEventMask | CWBackPixel,
      &xswa
      );
  };


/*}}}  */
/*{{{  OSZFSydoUnmapWindows(      X11    Windowdarstellung ENDE*/
void OSZFSydoUnmapWindows(void){
  XUnmapWindow(OSZVSyConTxt.dpy, OSZVSyConTxt.window);
  XDestroyWindow(OSZVSyConTxt.dpy, OSZVSyConTxt.window);
  XCloseDisplay(OSZVSyConTxt.dpy);
  };
 


/*}}}  */
/*}}}  */
/*{{{  OSZSSyResetWM(     TC3,GNU,X11    HAUPTPROGRAMM DES XBW-SYSTEMS*/


int OSZSSyResetWM(void){
 
  OSZVSyConTxt.dpy = XOpenDisplay(0);
  if (!OSZVSyConTxt.dpy){
    printf("ERROR: Could not open X11 Display!");
    exit(-1);
    };
  OSZVSyConTxt.screen = XDefaultScreenOfDisplay(OSZVSyConTxt.dpy);
 
  XSynchronize(OSZVSyConTxt.dpy, False);

  OSZFSydoCreateWindow();
  {
    XGCValues xgcv;
    xgcv.foreground = OSZFSydoDefineColor(3);
    xgcv.background = OSZFSydoDefineColor(3);

    OSZVSyConTxt.gc = XCreateGC(OSZVSyConTxt.dpy,
          OSZVSyConTxt.window, GCForeground | GCBackground, &xgcv);
    };

  {
    standard_font = XLoadFont(OSZVSyConTxt.dpy,
      "-misc-*-*-r-normal-*-13-*-*-*-c-*-iso8859-1"
      );
    XSetFont(OSZVSyConTxt.dpy, OSZVSyConTxt.gc, standard_font);
 
    grosser_font = XLoadFont(OSZVSyConTxt.dpy,
      "-bitstream-*-*-r-normal-*-25-*-*-*-p-*-iso8859-1"
      );
    };

  {
    XSizeHints xsh;
 
    xsh.width =  OSZSETUP.winw;
    xsh.height = OSZSETUP.winh;
    xsh.flags = PSize;
 
    XSetWMNormalHints(OSZVSyConTxt.dpy, OSZVSyConTxt.window, &xsh);
    XStoreName(OSZVSyConTxt.dpy, OSZVSyConTxt.window, OSZSETUP.wname);
    XSetIconName(OSZVSyConTxt.dpy, OSZVSyConTxt.window, "Xbw-Osz");
    };
 
  XSelectInput(
    OSZVSyConTxt.dpy,
    OSZVSyConTxt.window,
      KeyPressMask|
      KeyReleaseMask|
      ButtonPressMask|
      ExposureMask|
      ButtonReleaseMask|
      OwnerGrabButtonMask|
      PointerMotionHintMask|
      PointerMotionMask|
      ButtonMotionMask|
      EnterWindowMask|
      LeaveWindowMask
    );

  OSZVSyConTxt.XA = 0;
  OSZVSyConTxt.YA = 0;
  OSZVSyConTxt.XB = OSZSETUP.winw;
  OSZVSyConTxt.YB = OSZSETUP.winh;

  XMapWindow(OSZVSyConTxt.dpy, OSZVSyConTxt.window);

  return(0);
  };

/*}}}  */
/*}}}  */
 
/* Endlosschleife */
/*{{{  int OzChild(void){*/
int OzChild(void){
  DSC_DSP   GO_DP = {1,1,400,300,0,0,"1.0","10.0",{0,0,0,0,0,0,0,0}};
 
  G_DP = GO_DP;
 
  ReadMFXGroup_osz(0,0);
  OSZSETUP.winw=750;
  OSZSETUP.winh=630;
  GrafikObj.XA=1;
  GrafikObj.YA=72;
  GrafikObj.XB=600;
  GrafikObj.YB=625;
  Ozpixel = GrafikObj.XB - GrafikObj.XA;
  Ozmxp = GrafikObj.XB-GrafikObj.XA;
  Ozmyp = GrafikObj.YB-GrafikObj.YA;
  Ozstartframe = osz.startframe;
  OSZSSyResetWM();
  OSZLoadImages();
  OSZShowIcons();
  OSZSMs_FramON(c1xpos,c2ypos,c2xpos,c1ypos,
                      GrafikObj.XA,GrafikObj.YA+15,
                      GrafikObj.XB-GrafikObj.XA,GrafikObj.YB,14,12);
  printf("Max lines allowed: %ld\n",(XMaxRequestSize(OSZVSyConTxt.dpy)-3/2));
  OzBeenden=0;
  OzZeichnen=0;
  /*{{{  Event-Loop*/
      { XEvent event;
        while (!OzBeenden) {
          XNextEvent(
            OSZVSyConTxt.dpy,
            &event);
  
          switch(event.type){
            case Expose:
            case EnterNotify:
                    OSZShowIcons();
                    OSZSMs_FramOFF(c1xpos,c2ypos,c2xpos,c1ypos,
                        GrafikObj.XA,GrafikObj.YA+15,
                        GrafikObj.XB-GrafikObj.XA,GrafikObj.YB);
                    OSZSMs_FramON(c1xpos,c2ypos,c2xpos,c1ypos,
                        GrafikObj.XA,GrafikObj.YA+15,
                        GrafikObj.XB-GrafikObj.XA,GrafikObj.YB,14,12);
              break;
            case KeyPress:
              {
                KeySym keysym;
                int n;
                char string[257];
                XKeyEvent *keyevent;
                keyevent = (XKeyEvent *)&event;
                strcpy(string,"");
                n = XLookupString(keyevent, string, 256, &keysym, NULL);
  
                strncpy( OSZVSyConTxt.key,string,255);
                OSZVSyConTxt.key[255] = 0;
  
                if ( (string[0] | 0x20) == 'q'){goto ende; };
                };
  
              OSZSMs_SetClockCursor();
              OSZSMs_FramOFF(c1xpos,c2ypos,c2xpos,c1ypos,
                        GrafikObj.XA,GrafikObj.YA+15,
                        GrafikObj.XB-GrafikObj.XA,GrafikObj.YB);
              OSZShowIcons();
              DrawMultiLine(&GrafikObj,ML_DRAW_LINES,c1xpos,c2xpos,c1ypos,c2ypos,1,1);
              OSZSMs_FramON(c1xpos,c2ypos,c2xpos,c1ypos,
                        GrafikObj.XA,GrafikObj.YA+15,
                        GrafikObj.XB-GrafikObj.XA,GrafikObj.YB,14,12);
              OSZSMs_SetArrowCursor();
              break;
            case MotionNotify:
              break;
            case ButtonPress:
              { int rootx,rooty,winx,winy,mask;
                Window root, child;
                if ( XQueryPointer(
                       OSZVSyConTxt.dpy,
                       OSZVSyConTxt.window,
                       &root, &child,
                       &rootx, &rooty,
                       &winx, &winy,
                       &mask
                       )
                     ){
                  while (mask & Button1Mask){
                    OSZSMs_SetClockCursor();
                    OSZSMs_FramOFF(c1xpos,c2ypos,c2xpos,c1ypos,
                        GrafikObj.XA,GrafikObj.YA+15,
                        GrafikObj.XB-GrafikObj.XA,GrafikObj.YB);
                    if (OzFunktion(winx,winy)){
                      if (OzZeichnen){
                        OzZeichnen=0;
                        OSZShowIcons();
                        DrawMultiLine(&GrafikObj,ML_DRAW_LINES,c1xpos,c2xpos,c1ypos,c2ypos,
                          Ozzoomx, Ozzoomy);
                        };
                      }
                    else {
                      c1xpos=winx;
                      c2ypos=winy;
                      };
                    OSZSMs_FramON(c1xpos,c2ypos,c2xpos,c1ypos,
                        GrafikObj.XA,GrafikObj.YA+15,
                        GrafikObj.XB-GrafikObj.XA,GrafikObj.YB,14,12);
                    XQueryPointer(
                       OSZVSyConTxt.dpy,
                       OSZVSyConTxt.window,
                       &root, &child,
                       &rootx, &rooty,
                       &winx, &winy,
                       &mask
                       );
                    OSZSMs_SetArrowCursor();
                    };
                  while (mask & Button3Mask){
                    OSZSMs_SetClockCursor();
                    OSZSMs_FramOFF(c1xpos,c2ypos,c2xpos,c1ypos,
                        GrafikObj.XA,GrafikObj.YA+15,
                        GrafikObj.XB-GrafikObj.XA,GrafikObj.YB);
                    c2xpos=winx;
                    c1ypos=winy;
                    OSZSMs_FramON(c1xpos,c2ypos,c2xpos,c1ypos,
                        GrafikObj.XA,GrafikObj.YA+15,
                        GrafikObj.XB-GrafikObj.XA,GrafikObj.YB,14,12);
                    XQueryPointer(
                       OSZVSyConTxt.dpy,
                       OSZVSyConTxt.window,
                       &root, &child,
                       &rootx, &rooty,
                       &winx, &winy,
                       &mask
                       );
                    OSZSMs_SetArrowCursor();
                    };
                  OSZShowIcons();
                  break;
                  };
                };
              break;
  
            };
          };
        };
  /*}}}  */
  ende:;
  OSZFSydoUnmapWindows();
  return(0);
  };
/*}}}  */

/* Hauptroutinen */
/*{{{  int OzSpawn(void){*/
int Ozspawn=0;
int OzSpawn(void){
  pid_t child;
  if (!Ozspawn){ return(0); };
  Ozspawn=0;
  if ((child=fork()) == -1){return(0);};
  if (child == 0){ return(1); /* Father process returning */ };
  printf(" XbW: forked process %d.\n",child);
  OzChild();
  printf(" XbW: terminated process %d.\n",child);
  exit(0);
  return(1);
  };
/*}}}  */
/*{{{  int OzCreate(void){*/
int OzCreate(void){
  Ozspawn=1;
  return(0);
  };
/*}}}  */
/*{{{  int OzCreateFast(void){*/
int OzCreateFast(void){
  Ozspawn=1;
  OzSpawn();
  return(0);
  };
/*}}}  */

int main(){
  OzChild();
  return(0);
  }


