/*{{{F runexp.c*/
/*:::F runexp.c*/
/*}}}  */

#include <plplot.h>

/* Variables and data arrays used by plot generators */

static PLCursor plc;
#define MAXP 100
 
int plot_data_xy(int lines, char *x, char *y, char *text,
                 int points, double (*data)[][2]){
    int i;
    PLFLT xmin=99999.9, xmax=0, ymin=99999.9, ymax=0;
    PLFLT xs[MAXP];
    PLFLT ys[MAXP];
 
    if (points > MAXP){ points = MAXP; puts("Array of Points too small"); }
    for (i=0;i<points;i++){
      if (xmin>(*data)[i][0]){ xmin = (*data)[i][0]; }
      if (xmax<(*data)[i][0]){ xmax = (*data)[i][0]; }
      if (ymin>(*data)[i][1]){ ymin = (*data)[i][1]; }
      if (ymax<(*data)[i][1]){ ymax = (*data)[i][1]; }
      xs[i]=(*data)[i][0];
      ys[i]=(*data)[i][1];
      }
 
    plssub(1, 1);

    plinit();
 
    plcol(1);
    plenv(xmin, xmax, ymin, ymax, 0, 0);
    plcol(2);
    pllab(x,y,text);
 
    plcol(4);
    if (!lines){
      plpoin(points, xs, ys, 1);  /* POINTS: dots */
      }
    else {
      /*plpoin(points, xs, ys, 9);  / * POINTS: circles */
      plpoin(points, xs, ys, 2);  /* POINTS: */
 
      plcol(3);
      plline(points, xs, ys);     /* LINE   */
      }
 
    puts("Middle mouse button: cursor position; right mouse button: Exit.");
    plGetCursor(&plc);

    plend();
    return(0);
    }


