

/* ========================================================================================
 
 
   runexp.c - a collection of routines that can be used to run and control
              experiments
 
 
   ======================================================================================== */


#include <stdlib.h>
#include <stdio.h>
#include <math.h>

 
#define MFX_INIT 1
#include "runexp.h"
#include "xbmfx.c"
#include "runexpmfx.c"
#include "runexpfuncs.c"

/*{{{F runexpfuncs.c*/
/*:::F runexpfuncs.c*/
/*}}}  */
 

/* Variables for controlling an application */
int output_value = 0;
int *input_value = &output_value;   /* here: input = output */

/* Variables for data */
#define MAXDS 300
int MAXD = MAXDS;
double data[MAXDS][2];
int data_frame = 0;

 
void show_parameters(char *function, int pcount, double (*parameter)[]){
  int ii;
  printf("%s started with %d parameters:\n",function,pcount);
  for (ii=0;ii<pcount;ii++){
    printf("  %12.7f (#%d)\n",(*parameter)[ii],ii+1);
    }
  }

int SetOutputValue(int pcount, double (*parameter)[]){
  show_parameters("Set Output Value",pcount,parameter);
 
  /* set output for experiment control channel */
  output_value = sqrt((double)data_frame * (*parameter)[0]);
  return(0);                     /* ^^^^^^^^^^^^^^ output scaling factor */
  }

int ReadInputValue(int pcount, double (*parameter)[]){
  show_parameters("Read Input Value",pcount,parameter);
 
  data[data_frame][1]=*input_value * (*parameter)[0]; /* Y input factor */
  return(0);
  }

int StoreDataFrame(int pcount, double (*parameter)[]){
  show_parameters("Store Data Frame",pcount,parameter);
 
  data[data_frame][0]=data_frame * (*parameter)[0];   /* X scaling factor */
  data_frame++;
 
  if(data_frame == (*parameter)[1]){                  /* End condition */
    puts("function 3 detects END condition");
    MAXD = data_frame;
    return(1);
    }
 
  if(data_frame > MAXD){                  /* End condition */
    puts("function 3 detects END condition because array too small");
    return(1);
    }
  return(0);
  }

 
int plot_data_xy(int lines, char *x, char *y, char *text, int points, double (*data)[][2]);
 
int PlotDataSet(int pcount, double (*parameter)[]){
  show_parameters("Plot Data Set",pcount,parameter);
  plot_data_xy(1, "(x)", "(y)", "#frXB Data (via PLPLOT)",MAXD,data);
  return(0);
  }
 
 
int make_standard_experiment( void ){
  puts("making standard module and variable tables");
 
   /* Var/Pointer: V/P  name      next     contents  pointer  comment */
  define_variable( "V", "YOut",   "",      "1000.0",          "Y Output Scale");
  define_variable( "V", "YIn",    "",      "1.0",             "Y Input Scale");
  define_variable( "V", "XIn",    "+1",    "10.0" ,           "X Scale");
  define_variable( "V", "#Frm",   "",      "20.0" ,           "# Frames");
  define_variable( "V", "",       "",      "",                "");
  define_variable( "P", "DemoPointer",  "",                "#Frm",  "Pointer to \"#Frm\" ");
  define_variable( "V", "DemoVariable", "@XIn",  "1.0",             "Next Variable is \"XIn\" ");
 
  generate_var_table();
 
                /* name next  f p            */
  define_module(   "Start",    "+1",     "Outp","YOut", 1,1, "Start of Loop"  );
  define_module(   "Input",    "+1",     "Inp", "YIn",  1,1, "Within Loop"    );
  define_module(   "Restart?", "@Start", "Stor","XIn",  1,1, "Check End"      );
  define_module(   "End",      "",       "Plot","",     1,1, "End of Program" );
 
  generate_mod_table();
 
  WriteMFXGroup_xbmods(NULL,NULL,NULL);
  WriteMFXGroup_xbparams(NULL,NULL,NULL);
  return 0;
  }

int main( int argc, char **argv){
  int ii;
  puts("\nXB Experiment Control");

  clear_xbmfx_var_table();
 
  set_parameters(XBMODE_TEST, XBBREAK_ASK);
 
  puts("making table of functions");
  function("Outp", "Output [Scale]",&SetOutputValue);
  function("Inp",  "Input  [YScale]",&ReadInputValue);
  function("Stor", "Store  [XScale] [#Frames]",&StoreDataFrame);
  function("Plot", "Plot Data Set",&PlotDataSet);
  WriteMFXGroup_xbfuncs(NULL,NULL,NULL);
 
  if (argc > 1){
    switch(argv[1][1]){
      case 'M': case 'm':
        make_standard_experiment();
        break;
      case 'S': case 's':
        make_standard_experiment();
        run_experiment();
        break;
      case 'N': case 'n': {
        char file[200];
        sprintf(file,"%s.xbmods.mfx",argv[2]);   ReadMFXGroup_xbmods(file,NULL);
        sprintf(file,"%s.xbparams.mfx",argv[2]); ReadMFXGroup_xbparams(file,NULL);
        generate_var_table();
        generate_mod_table();
        run_experiment();
        break;
        }
      }
    }
  else {
    ReadMFXGroup_xbmods(NULL,NULL);
    ReadMFXGroup_xbparams(NULL,NULL);
    generate_var_table();
    generate_mod_table();
    run_experiment();
    }
 
  for (ii=0;ii<data_frame;ii++){
    store_data_in_table(data[ii][0],data[ii][1]);
    };
 
  WriteMFXGroup_xbdata(NULL,NULL,NULL);
  return 0;
  }



