
/* ================= RUNEXP.H ============================================= */
 
#define XBMODE_TEST 1
#define XBMODE_RUN  2
#define XBBREAK_ON  1
#define XBBREAK_ASK 2
#define XBBREAK_OFF 3
 
#define ProgramName runexp


/* ----- these lists are usually imported by the application --------------- */
 
typedef struct {
 
  /* 100 Xb Modules */
 
  char name[100][30];     /* name to be used as a label                     */
  char nextoffset[100][30];
  char func[100][30];          /* function of funclist to execute           */
  char par[100][30];           /* params for function of funclist to execute           */
  int  repeat[100];            /* how often to repeat module (0= do not execute) */
  int  active[100];
  char   comment[100][200];
  } XbMods;

extern XbMods xbmods;

#ifdef MFX_INIT
  XbMods xbmods;
#endif

typedef struct {
  int mode;             /* controls program mode: test/run */
  int brk;              /* controls program break behaviour */
  char slot[4][20];       /* 8 adc input devices */
  char sig[4][4][20];       /* 8 dac output devices */
  char units[8][100];       /* Units of signal values */
 
  /* 100 Control Variables */
 
  char   type[100][30];             /* "V" = Variable, "P" = Pointer */
  char   name[100][30];
  char   nextoffset[100][30];
  char   content[100][200];
  char   comment[100][200];
 
  /* 12 commands for the 20 pushbuttons */
 
  char   cmd[12][200];
 
  } XbParams;

extern XbParams xbparams;

#ifdef MFX_INIT
  XbParams xbparams;
#endif
 
/* ----- these lists are usually generated by the application -------------- */

typedef struct {
 
  /* 100 Functions */
 
  char name[100][200];
  char   comment[100][200];
  } XbFuncs;
 
extern XbFuncs xbfuncs;

#ifdef MFX_INIT
  XbFuncs xbfuncs;
#endif


typedef struct {
  double X[100];
  double Y[100];
  } XbData;
 
extern XbData xbdata;

#ifdef MFX_INIT
  XbData xbdata;
#endif
 

/* ------------------------------------------------------------------------- */

/* ================= End of RUNEXP.H ======================================= */


