/*{{{F runexp.h*/
/*:::F runexp.h*/
/*}}}  */

 
#define NLEN       30   /* Name length */
#define MaxVar    100
#define MaxMod    100
#define MaxFunc   100
#define MaxData   100
#define MaxCmd     12
 
/* ----- these lists are usually imported by the application --------------- */
 
typedef struct {
  char name[NLEN];          /* name to be used as a label                     */
  int address;              /* number of module in list                     */
  int function;      /* number of function of funclist to execute           */
  int parameter;      /* no of 1st parameter for function */
  int next;           /* number of next module to execute if result of func=0
                             if result of function
                                       >0:  execute module (no=func result)
                                      =-1: repeat execution of function
                                      =-2: end execution of actual block    */
  int repeat;
  int active;
  } Mods;
 

typedef struct {
  int    next;                 /* number of next parameter; 0=endlist */
  char   name[NLEN];
  double *ptr;                 /* normally has the address of following */
                               /* par; if changed, works as a pointer */
  double par;                  /* variable content               */
  } Params;


/* ----- this list is usually generated by the application ----------------- */

typedef struct {
  char name[NLEN];
  char comment[NLEN];
  int (*func)(int pcount, double (*parameter)[]);
  } Funcs;
 
 
 Funcs funcs[MaxFunc];
 Mods mods[MaxMod];
 Params params[MaxVar];

int function(char *name, char *comment, int (*address)(int pcount, double (*parameter)[])){
  /*{{{  */
  static int cc = 1;
  
  strncpy(&funcs[cc].name[0],name,sizeof(funcs[0].name));
  funcs[cc].func=address;
  
  strncpy(&xbfuncs.name[cc-1][0],name,sizeof(xbfuncs.name[0]));
  strncpy(&xbfuncs.comment[cc-1][0],comment,sizeof(xbfuncs.comment[0]));
  
  cc++;
  return 0;
  }
  /*}}}  */
int find_function(char *name){
  /*{{{  */
  int ii;
  if (strlen(name)==0){ return(0); };
  for (ii=1;ii<MaxFunc;ii++){
    if (strcmp(name,funcs[ii].name)==0){
      return(ii);
      }
    }
  return 0;
  }
  /*}}}  */
int find_parameter(char *name){
  /*{{{  */
  int ii;
  if (strlen(name)==0){ return(0); };
  for (ii=1;ii<MaxVar;ii++){
    if (strncmp(name,params[ii].name,strlen(name))==0){
      return(ii);
      }
    }
  return 0;
  }
  /*}}}  */
int module(char *name, char *nextoffset, char *f, char *p, int repeat, int active){
  /*{{{  */
  static int cc = 1;
  strncpy(&mods[cc].name[0],name,sizeof(mods[0].name));
  mods[cc].repeat = repeat;
  mods[cc].active = active;
  mods[cc].next = 0;
  mods[cc].address=cc;
  if (strcmp(nextoffset,"+1")==0){
    mods[cc].next = cc+1;
    }
  if (nextoffset[0] == '@'){
    int ii;
    for (ii=1;ii<cc;ii++){
      if (strcmp(&nextoffset[1],mods[ii].name)==0){
        mods[cc].next=ii;
        }
      }
    }
  
  mods[cc].function=find_function(f);
  mods[cc].parameter=find_parameter(p);
  cc++;
  return 0;
  }
  /*}}}  */
static actvar = 1;
int normvar(char *name, char *nextoffset, double content){
  /*{{{  */
  strncpy(&params[actvar].name[0],name,sizeof(params[0].name));
  
  params[actvar].next = 0;
  if (strcmp(nextoffset,"+1")==0){
    params[actvar].next = actvar+1;
    }
  if (nextoffset[0] == '@'){
    int ii;
    for (ii=1;ii<actvar;ii++){
      if (strcmp(&nextoffset[1],params[ii].name)==0){
        params[actvar].next=ii;
        }
      }
    }
  
  
  params[actvar].ptr=&params[actvar].par;
  params[actvar].par=content;
  actvar++;
  
  return 0;
  }
  /*}}}  */
int varptr(char *name, char *nextoffset, char *pointer){
  /*{{{  */
  int ii;
  strncpy(&params[actvar].name[0],name,sizeof(params[0].name));
  
  params[actvar].next = 0;
  if (strcmp(nextoffset,"+1")==0){
    params[actvar].next = actvar+1;
    }
  if (nextoffset[0] == '@'){
    int ii;
    for (ii=1;ii<actvar;ii++){
      if (strcmp(&nextoffset[1],params[ii].name)==0){
        params[actvar].next=ii;
        }
      }
    }
  
  
  for (ii=1;ii<actvar;ii++){
    if (strcmp(pointer,&params[ii].name[0])==0){
      params[actvar].ptr=&params[ii].par;
      break;
      }
    }
  params[actvar].par=0;
  actvar++;
  
  return 0;
  }
  /*}}}  */
int variable(char *type, char *name, char *nextoffset, char *content){
  /*{{{  */
  switch(type[0]){
    case 'p':
    case 'P': {
                varptr(name,nextoffset,content);
                }
              break;
    case 'v':
    case 'V': {
                double dd = atof(content);
                normvar(name,nextoffset,dd);
                }
              break;
    default:  printf("\nERROR: wrong variable type specified (%s)\n",type);
    }
  return 0;
  }
  /*}}}  */

int generate_var_table(void){
  /*{{{  */
  int ii;
  
  for(ii=0;ii<MaxVar;ii++){
    if (strlen(xbparams.type[ii]) > 0){
      variable(xbparams.type[ii],xbparams.name[ii],
             xbparams.nextoffset[ii],
             xbparams.content[ii]);
      }
    }
  
  return 0;
  /*}}}  */
  }
int clear_xbmfx_var_table(void){
  /*{{{  */
  int ii;
  
  for(ii=0;ii<MaxVar;ii++){
    strcpy(xbparams.type[ii],"V");
    }
  
  return 0;
  /*}}}  */
  }
int generate_mod_table(void){
  /*{{{  */
  int ii;
  
  for(ii=0;ii<MaxMod;ii++){
    if (strlen(xbmods.name[ii]) > 0){
      module(xbmods.name[ii], xbmods.nextoffset[ii],
        &xbmods.func[ii][0],  &xbmods.par[ii][0],
        xbmods.repeat[ii], xbmods.active[ii]);
      }
    }
  
  return 0;
  /*}}}  */
  }
 
int execute_module(Mods *module){
  /*{{{  */
  int ret; int result=0;
  double parameters[10];
  
  int nextp=0,thisp;
  int pcount=0;
  int repeat=0;
  int active=0;
  
  thisp=module->parameter;
  if (thisp > 0){
    parameters[nextp++]= *(params[thisp].ptr);
    pcount=1;
    thisp=params[thisp].next;
  
    while(thisp>0){
      parameters[nextp++]= *(params[thisp].ptr);
      pcount++;
      thisp=params[thisp].next;
      }
    }
  
  repeat = module->repeat;
  active = module->active;
  if ((module->function>0) & active){
    int ii=0;
    for (ii=0;ii<repeat;ii++){
      if ((ret = ((*funcs[module->function].func)(pcount,&parameters)))){
        result = ret+module->address;
        }
      };
    };
  if (result==0){
    result=module->next;
    }
  return(result);
  }
  
  /*}}}  */
int run_experiment(void){
  /*{{{  */
  Mods *module;
  int next;
  module = &mods[1];
  while((next=execute_module(module))){
    module = &mods[next];
    }
  return 0;
  }
  
  
  /*}}}  */
int define_module(char *name, char *nextoffset, char *f, char *p,
    int repeat, int active, char *rem){
  /*{{{  */
  static int cc = 0;
  strncpy(&xbmods.name[cc][0],name,sizeof(mods[0].name));
  strncpy(&xbmods.nextoffset[cc][0],nextoffset,sizeof(xbmods.name[0]));
 
  strcpy(&xbmods.func[cc][0],f);
  strcpy(&xbmods.par[cc][0],p);
  strcpy(&xbmods.comment[cc][0],rem);
  xbmods.repeat[cc]=repeat;
  xbmods.active[cc]=active;
  cc++;
  return 0;
  }
  /*}}}  */
int define_variable(char *type, char *name, char *nextoffset, char *content,
    char *comment){
  /*{{{  */
  static int cc=0;
  strncpy(&xbparams.type[cc][0],type,sizeof(xbparams.type[0]));
  strncpy(&xbparams.content[cc][0],content,sizeof(xbparams.content[0]));
  strncpy(&xbparams.name[cc][0],name,sizeof(xbparams.name[0]));
  strncpy(&xbparams.nextoffset[cc][0],nextoffset,sizeof(xbparams.name[0]));
  strncpy(&xbparams.comment[cc][0],comment,sizeof(xbparams.comment[0]));
  cc++;
  return 0;
  }
  /*}}}  */

int xbwmfx_data_count=0;
int store_data_in_table(double x, double y){
  /*{{{  */
  int cc = xbwmfx_data_count;
  
  if (cc < MaxData){
    xbdata.X[cc]=x;
    xbdata.Y[cc]=y;
  
    cc++;
    xbwmfx_data_count=cc;
    return(1);
    }
  else {
    return 0;
    };
  }
  /*}}}  */

 
void set_parameters(int mode, int brk){
  xbparams.mode = mode;
  xbparams.brk = brk;
  };

