
/* ================ EXTENSIONS.C =============================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
 
#include "xbw.h"

/*{{{  Vereinfachungen*/
#define Wdw XbWDDb_DbIWdw
#define Obj XbWDDb_DbIObj

/*}}}  */
/*{{{  Verwaltung der Handle-Tabelle*/

/* Handle-Tabelle */
#define                     XbWDDb_MAXHANDLE 1000
XbWDDb_Handle        Handle[XbWDDb_MAXHANDLE];     /* Handles fuer Variablen */
int XbWVDb_NextFreeHandle=0;

/* Zugriffe auf DBK-Elemente (Variablen) ueber Handles */
#define  SetString(a)   ((char*)XbWFDb_SetGetString( a,NULL,XbWDDb_Put))
#define  GetString(a)   ((char*)XbWFDb_SetGetString( a,NULL,XbWDDb_Get))

void XbWPSy_GetNextHandle(int *handleno, char *list, char *grp, char *var, int mode){
  int ii;
  for (ii=0;ii<XbWDDb_MAXHANDLE;ii++){
    if (Handle[ii]==-1){
      if (*handleno >=0){ Handle[*handleno]=-1; };
      Handle[ii]   = XbWFDb_GetHandle(list,grp,var,mode);
      *handleno=ii;
      return;
      };
    };
  *handleno=-1;
  };
 
void XbWPSy_InitHandles(void){
  int ii;
  for (ii=0;ii< XbWDDb_MAXHANDLE;ii++){
    Handle[ii]=-1;
    };
  };
/*}}}  */
/*{{{  Verwaltung der Task-Tabelle*/

                     /* Fuer wenig zeitintensive Tasks,
                        die laufen sollen, wenn XbW gerade nichts zu tun hat
                        und einen Event vom XWindow bekommt. */

#define XbWDDb_MAXTASK 30
typedef struct {
 void (*TaskAdresse)( XbWDDb_DbIWdw  *TW);
 } TaskTableE;
 
TaskTableE TaskTable[XbWDDb_MAXTASK];

int XbWPSy_SystemManagerHook( XbWDDb_DbIWdw  *TW){
  int ii;
  for (ii=0;ii<XbWDDb_MAXTASK;ii++){
    if (TaskTable[ii].TaskAdresse != NULL){
      (TaskTable[ii].TaskAdresse)(TW);
      };
    };
  return(0);
  };

int XbWPSy_SystemManagerHookInit(void){
  int ii;
  for (ii=0;ii<XbWDDb_MAXTASK;ii++){
    TaskTable[ii].TaskAdresse=NULL;
    };
  return(0);
  };
 
int XbWPSy_SystemManagerHookAdd(int *no, void *adr){
  int ii;
  for (ii=0;ii<XbWDDb_MAXTASK;ii++){
    if (TaskTable[ii].TaskAdresse == NULL){
      if (no >= 0){
        TaskTable[*no].TaskAdresse=NULL;
        };
      TaskTable[ii].TaskAdresse=adr;
      *no=ii;
      return(ii);
      };
    };
  *no=-1;
  return(-1);
  };
 

/*}}}  */
/*{{{  Verwaltung der Objekthooks*/

/* Tabelle der benutzerdefinierten Objektfunktionen */
#define                             XbWDDb_MAXOBJECT 1000
typedef struct {
  int used;
  char *EditTyp;
  char *DispTyp;
  int (*EditFuncAdresse)(
      XbWDDb_DbIWdw  *TW, XbWDDb_DbIObj  *TO,
      int *DisplayAfterEdit,
      int ObjektMausXPosition, int ObjektMausYPosition);
  int (*DispFuncAdresse)(
      XbWDDb_DbIWdw  *TW,
      XbWDDb_DbIObj  *TO);
  } XbWDDb_UserObjectE;
 
XbWDDb_UserObjectE        UserObject[XbWDDb_MAXOBJECT];


void XbWPSy_ObjectHookInit(void){
  int ii;
  for (ii=0;ii<XbWDDb_MAXOBJECT;ii++){
    UserObject[ii].used=0;
    };
  };

void XbWPSy_AddObjectHook(int *hookno, char *edittyp, void *editfunc, char *disptyp, void *dispfunc){
  int ii;
  for (ii=0;ii<XbWDDb_MAXOBJECT;ii++){
    if (UserObject[ii].used==0){
      UserObject[ii].used=1;
      UserObject[ii].EditTyp=edittyp;
      UserObject[ii].DispTyp=disptyp;
      UserObject[ii].EditFuncAdresse=editfunc;
      UserObject[ii].DispFuncAdresse=dispfunc;
      return;
      };
    };
  };


/* Hierhin springt das System, wenn es einen "@"-Objekttyp
   findet.                                                     */
 

int XbWPSy_EditObjectHook(
      char *ObjectEditTyp,
      XbWDDb_DbIWdw  *TW, XbWDDb_DbIObj  *TO,
      int *DisplayAfterEdit,
      int editmode,
      int ObjektMausXPosition, int ObjektMausYPosition){
  int ii;
  int retval=XbWDMf_CommandErr;
  XbWFOb_SetViewPort(TW,TO); /* Viewport auf Objekt einstellen */
  *DisplayAfterEdit=0;
  if (editmode!=XbWDOb_DrawRedBox){
    for (ii=0;ii<XbWDDb_MAXOBJECT;ii++){
      if (strcmp(ObjectEditTyp,UserObject[ii].EditTyp) == 0){
        retval=(UserObject[ii].EditFuncAdresse)(TW,TO,DisplayAfterEdit,
          ObjektMausXPosition,ObjektMausYPosition);
        };
      };
    };
  XbWFGr_ResPort();           /* Viewport zuruecksetzen        */
  return(retval);
  };



int  XbWPSy_DisplayObjectHook(
    char *ObjectDispTyp,  XbWDDb_DbIWdw  *TW,
                          XbWDDb_DbIObj  *TO){
  int ii;
  int retval=XbWDMf_CommandErr;
  XbWFOb_SetViewPort(TW,TO); /* Viewport auf Objekt einstellen */
  for (ii=0;ii<XbWDDb_MAXOBJECT;ii++){
    if (strcmp(ObjectDispTyp,UserObject[ii].DispTyp) == 0){
      retval=(UserObject[ii].DispFuncAdresse)(TW,TO);
      };
    };
  XbWFGr_ResPort();           /* Viewport zuruecksetzen        */
  return(retval);
  };




/*}}}  */
/*{{{  Taskstart ausfuehren (Noch nicht fertig!)*/

/* Hierhin springt das System, wenn es eine Task starten soll. */

 
int  XbWPSy_EXETaskStartHook(
    char *TaskName        , XbWDDb_DbIWdw  *TW,
    XbWDDb_DbIObj  *TO)    {
  char sstr[200];
  sprintf(sstr,"Internal task not found: %s\n",TaskName);
  XbWFTb_Message(sstr);
/*  return(XbWDMf_CommandOk); */
  sprintf(sstr,"Trying to start up external task %s\n",TaskName);
  XbWFTb_Message(sstr);
  return(XbWDMf_EXETaskStart); /* jetzt wird statt dessen versucht, eine externe Task  */
                               /* gleichen Namens zu starten */
  };

/*}}}  */

/*{{{  Tabelle fuer Benutzerkommandos*/

typedef struct {
  char name[30];
  int (*function)(char *Command, XbWDDb_DbIWdw  *TW, void  *(*p)[], int (*t)[] );
  } FuncTable;   /* KOMMANDO       WINDOW                PARAMETER          PARAMETERTYP */

#include "extensions/commands.c"
 
/*}}}  */
/*{{{  int  XbWPSy_MetaCommandHook(*/
int  XbWPSy_MetaCommandHook(
    char *Command,
    XbWDDb_DbIWdw  *TW,
    void  *(*p)[], int (*t)[]){
  int ii=0;
  while(strlen(FunctionTable[ii].name)> 0){
    if (strcmp(Command,FunctionTable[ii].name) == 0) {
      if (FunctionTable[ii].function!=NULL){
        return(FunctionTable[ii].function(Command,TW,p,t));
        }
      else {
        return(XbWDMf_CommandErr);
        };
      };
    ii++;
    };
  return(XbWDMf_CommandErr);
  };
/*}}}  */

/*{{{  Initialisierung*/

void XbWPSy_InitHooks(void){
  XbWPSy_InitHandles();
  XbWPSy_SystemManagerHookInit();
  XbWPSy_ObjectHookInit();
  };
 
/*}}}  */

/* ===== Ende EXTENSIONS.C ===============================ENDE= */
