%{

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>

int yyerror(char*s){ printf(s); return(0); }
void create_c_files(void);
int write_c_files(char *s, char *pgm);
 
int struct_defined=0;
 
FILE *fp_xbc;
FILE *fp_xbm;
FILE *fp_wdw;
FILE *fp_trl;

FILE *fp_wmfx;
FILE *fp_rmfx;
FILE *fp_dmfx;
FILE *fp_dwdw;

char pgmname[100];
char c_struct_name[100];
char c_var_name[100];
int obj=0;
#define START_MFX_ENTRY 0
int mfx_entry=START_MFX_ENTRY;
#define START_OBJ_YPOS 4
#define END_OBJ_YPOS 25
int obj_ypos=START_OBJ_YPOS;
int OP_ROW = 4;
char LstObj[100];
int LstObjMfxNr;
#define OP_COL (END_OBJ_YPOS - START_OBJ_YPOS-1)

char wdwname[5];
char mfxname[5]="mfi";
int wdwnr=0;
int WDW_WIDTH = 60;
 
void MakeWindow(int nr){
  /*{{{  */
  char li[1000];
  sprintf(wdwname,"WD%02d",nr);
  wdwname[4]=0;
  
  fprintf(fp_wdw,"\n\n%%----------------------------------------------------\n");
  fprintf(fp_wdw,"wdw( %s %d %d %d 40 StandardWDW ); %%Get a Window\n",
    wdwname,wdwnr,wdwnr+2,WDW_WIDTH);
  fprintf(fp_wdw,"@window/gimmicks( %s (\" '%s' Window %s (P) by XbW\") );  %% Get some buttons\n",wdwname,pgmname,wdwname);
  
  fprintf(fp_wdw,"ng( KEY (\"%s:27.0\")); c( K (\"IconAllWdw(); SelectWdw(MAIN);\")); eg(); /* ESC:Reset All */\n\n",
    wdwname);
  
  fclose(fp_dwdw);
  fp_dwdw=fopen("makemfx.dwdw","r");
  if (fp_dwdw==NULL){puts("ERR: can't read scratch file!");exit(1);}
  while(!feof(fp_dwdw)){
    if(fgets(li,1000,fp_dwdw)){
      fputs(li,fp_wdw);
      }
    }
  fclose(fp_dwdw);
  unlink("makemfx.dwdw");
  fp_dwdw=fopen("makemfx.dwdw","w");
  }
  
  /*}}}  */
void NewWindow(void){
  /*{{{  */
  sprintf(wdwname,"WD%02d",wdwnr+1);
  wdwname[4]=0;
  };
  
  /*}}}  */
void NewObject(void){
  /*{{{  */
  obj++;
  mfx_entry++;
  obj_ypos++;
  if (obj_ypos>END_OBJ_YPOS){
    wdwnr++;
    obj_ypos=START_OBJ_YPOS;
    obj=START_OBJ_YPOS;
    MakeWindow(wdwnr);
    }
  else {
    sprintf(wdwname,"WD%02d",wdwnr+1);
    wdwname[4]=0;
    };
  };
  /*}}}  */
void NextWindow(int object_rows){
  /*{{{  */
  if (obj_ypos+object_rows>END_OBJ_YPOS){ obj_ypos=END_OBJ_YPOS+1; };
  NewWindow();
  NewObject();
  };
  /*}}}  */
void VArrayXY(char *typ,char *ArrayName,int nox,int noy,int xmax,int ymax,int slen){
    /*{{{  */
    int ii,jj;
    switch(typ[0]){
      case 'I': fprintf(fp_dwdw,"%%_____%s___(Integer V-Array[%d][%d])______________________________\n",
                  ArrayName,nox,noy);
                break;
      case 'T': fprintf(fp_dwdw,"%%_____%s___(String V-Array[%d][%d])_______________________________\n",
                  ArrayName,nox,noy);
                break;
      case 'S': fprintf(fp_dwdw,"%%_____%s___(Short V-Array[%d][%d])________________________________\n",
                  ArrayName,nox,noy);
                break;
      case 'D': fprintf(fp_dwdw,"%%_____%s___(Double V-Array[%d][%d])________________________________\n",
                  ArrayName,nox,noy);
                break;
      }
    
    obj++;
    mfx_entry++;
    for(jj=0;jj<ymax;jj++){
      for(ii=0;ii<xmax;ii++){
        /*{{{  */
        fprintf(fp_dwdw,"o( %s%04d  A A %d %d 12 1 std);",
          wdwname,obj,9+ii*12,obj_ypos+jj+1);
        fprintf(fp_dwdw,"bg( %s%04d (\".\") (ptr)MFX:%s.%s[%d][%d] );",
          wdwname,obj,mfxname,ArrayName,jj,ii);
        fprintf(fp_dwdw," pn(aln (ptr)OBJ:%s.aln); pn(agn (ptr)OBJ:%s.agn);",
          LstObj,LstObj);
        fprintf(fp_dwdw," pn(an (ptr)OBJ:%s.an); i(ao %d);",LstObj,
          ii+jj*nox);
        if (ii+jj>0){
          fprintf(fp_dwdw,"  cn(epO %s%04d );",wdwname,obj-1);
          };
        if ((ii!=xmax-1)||(jj!=ymax-1)){
          fprintf(fp_dwdw,"cn(edO %s%04d );",wdwname,obj+1);
          };
        fprintf(fp_dwdw," eg(); \n");
        mfx_entry++;
        obj++;
        };
        /*}}}  */
      };
    }
    /*}}}  */
void ArrayXY(char *typ,char *ArrayName,int nox, int noy,int slen){
    /*{{{  */
    int ii,jj;
    int xmax,ymax;
    xmax=nox; if (xmax > OP_ROW){ xmax=OP_ROW; };
    ymax=noy; if (ymax > OP_COL){ ymax=OP_COL; };
    NextWindow(obj_ypos+ymax+1);
    
    fprintf(fp_dwdw,"o( %s%04dlst S S 100 100 1 1 rem);\n",wdwname,obj);
    fprintf(fp_dwdw,"bg( %s%04dlst (\".\") (\" \") );\n",wdwname,obj);
    fprintf(fp_dwdw,"  s(aln 4 MFX); s(agn 100 %s); i(an %d); eg();\n",
      mfxname,mfx_entry-1);
    sprintf(LstObj,"%s%04dlst",wdwname,obj);
    LstObjMfxNr=mfx_entry-1;
    
    switch(typ[0]){
      case 'I': fprintf(fp_dwdw,"%%_____%s___(Integer Array[%d][%d])______________________________\n",
                  ArrayName,nox,noy);
                break;
      case 'T': fprintf(fp_dwdw,"%%_____%s___(String Array[%d][%d])_______________________________\n",
                  ArrayName,nox,noy);
                break;
      case 'S': fprintf(fp_dwdw,"%%_____%s___(Short Array[%d][%d])________________________________\n",
                  ArrayName,nox,noy);
                break;
      case 'D': fprintf(fp_dwdw,"%%_____%s___(Double Array[%d][%d])________________________________\n",
                  ArrayName,nox,noy);
                break;
      }
    fprintf(fp_dwdw,"o( %s%02dt S . 1 %d 12 1 rem); bg( %s%02dt . (\"%s\") ); eg();\n",
      wdwname,obj,obj_ypos,wdwname,obj,ArrayName);
    for(ii=0;ii<xmax;ii++){   /* Horiz. Text */
      /*{{{  */
      fprintf(fp_dwdw,"o( %s%02dxt%04d S . %d %d 12 1 rem); bg( %s%02dxt%04d . (\"x+%d\")  ); ",
        wdwname,obj,ii,9+12*ii,obj_ypos,wdwname,obj,ii,ii);
      if (ii==0){
        fprintf(fp_dwdw,"cn(raK (\"(int)OBJ:%s.an-=%d[%d];\"));",
          LstObj,(int)(xmax*0.7),LstObjMfxNr);
        };
      if (ii>=xmax-1){
        fprintf(fp_dwdw,"cn(raK (\"(int)OBJ:%s.an+=%d[%d];\"));",
          LstObj,(int)(xmax*0.7),nox-xmax+LstObjMfxNr);
        };
      fprintf(fp_dwdw,"eg();\n");
      /*}}}  */
      };
    for(ii=0;ii<ymax;ii++){   /* Vert. Text */
      /*{{{  */
      fprintf(fp_dwdw,"o( %s%02dyt%04d S . 1 %d 12 1 rem); bg( %s%02dyt%04d . (\"y+%d\") ); ",
        wdwname,obj,ii,obj_ypos+ii+1,wdwname,obj,ii,ii);
      if (ii==0){
        fprintf(fp_dwdw,"cn(raK (\"(int)OBJ:%s.an-=%d[%d];\"));",
          LstObj,(int)((ymax+1)*(xmax+1)*0.8),LstObjMfxNr);
        };
      if (ii>=ymax-1){
        fprintf(fp_dwdw,"cn(raK (\"(int)OBJ:%s.an+=%d[%d];\"));",
          LstObj,(int)((ymax+1)*(xmax+1)*0.8),LstObjMfxNr+noy-((xmax+1)*(ymax+1)));
        };
      fprintf(fp_dwdw,"eg();\n");
      /*}}}  */
      };
    
    if ((xmax < nox) || (ymax < noy)){
      VArrayXY(typ,ArrayName,nox,noy,xmax,ymax,slen);
      }
    else {
      for(jj=0;jj<ymax;jj++){
        for(ii=0;ii<xmax;ii++){
          /*{{{  */
          switch(typ[0]){
            case 'I': fprintf(fp_dwdw,"o( %s%04d  I I %d %d 12 1 std); bg( %s%04d (\".\") (ptr)MFX:%s.%s[%d][%d] );",
                        wdwname,obj,9+ii*12,obj_ypos+jj+1,wdwname,obj,mfxname,ArrayName,
                        jj,ii);
                      break;
            case 'T': fprintf(fp_dwdw,"o( %s%04d  S S %d %d 12 1 std); bg( %s%04d (\".\") (ptr)MFX:%s.%s[%d][%d] );",
                        wdwname,obj,9+ii*12,obj_ypos+jj+1,wdwname,obj,mfxname,ArrayName,
                        jj,ii);
                      break;
            case 'S': fprintf(fp_dwdw,"o( %s%04d  I I %d %d 12 1 std); bg( %s%04d (\".\") (ptr)MFX:%s.%s[%d][%d] );",
                        wdwname,obj,9+ii*12,obj_ypos+jj+1,wdwname,obj,mfxname,ArrayName,
                        jj,ii);
                      break;
            case 'D': fprintf(fp_dwdw,"o( %s%04d  D D %d %d 12 1 std); bg( %s%04d (\".\") (ptr)MFX:%s.%s[%d][%d] );",
                        wdwname,obj,9+ii*12,obj_ypos+jj+1,wdwname,obj,mfxname,ArrayName,
                        jj,ii);
                      fprintf(fp_dwdw,"  ff( (\"%%8.4f\") (\"\") 1.0);");
                      break;
            }
          if (ii+jj>0){
            fprintf(fp_dwdw,"  cn(epO %s%04d );",wdwname,obj-1);
            };
          if ((ii!=xmax-1)||(jj!=ymax-1)){
            fprintf(fp_dwdw,"cn(edO %s%04d );",wdwname,obj+1);
            };
            fprintf(fp_dwdw," eg(); \n");
          mfx_entry++;
          obj++;
          };
          /*}}}  */
        };
      };
    
    for (jj=0;jj<noy;jj++){
      for (ii=0;ii<nox;ii++){
        switch(typ[0]){
          case 'I': fprintf(fp_dmfx,"i( %s[%d][%d] 0);\n",ArrayName,jj,ii);
                    break;
          case 'T': fprintf(fp_dmfx,"s( %s[%d][%d] %d (\"  \") );\n",
                      ArrayName,jj,ii,slen);
                    break;
          case 'D': fprintf(fp_dmfx,"d( %s[%d][%d] 0.0000001 );\n",
                      ArrayName,jj,ii);
                    break;
          case 'S': fprintf(fp_dmfx,"i( %s[%d][%d] 0);\n",
                      ArrayName,jj,ii);
                    break;
          }
        }
      }
    switch(typ[0]){
      case 'I': printf("integer %s[%d][%d]\n",ArrayName,nox,noy);
                break;
      case 'T': printf("string %s[%d][%d]\n",ArrayName,nox,noy);
                break;
      case 'D': printf("double %s[%d][%d]\n",ArrayName,nox,noy);
                break;
      case 'S': printf("short %s[%d][%d]\n",ArrayName,nox,noy);
                break;
      }
    obj_ypos+=(2+ymax);
    }
    /*}}}  */
void ArrayX(char *typ,char *ArrayName,int no,int slen){
    /*{{{  */
    int ii,jj,xmax,ymax;
    if(no > OP_ROW){ xmax=OP_ROW; } else {xmax=no;};
    ymax=no/OP_ROW+1;
    NextWindow(obj_ypos+ymax+1);
    switch(typ[0]){
      case 'I': fprintf(fp_dwdw,"%%_____%s___(Integer Array[%d])______________________________\n",
                ArrayName,no);
                break;
      case 'T': fprintf(fp_dwdw,"%%_____%s___(String Array[%d])_______________________________\n",
                ArrayName,no);
                break;
      case 'S': fprintf(fp_dwdw,"%%_____%s___(Short Array[%d])________________________________\n",
                ArrayName,no);
                break;
      case 'D': fprintf(fp_dwdw,"%%_____%s___(Double Array[%d])_______________________________\n",
                ArrayName,no);
                break;
      }
    fprintf(fp_dwdw,"o( %s%02dt S . 1 %d 12 1 rem); bg( %s%02dt . (\"%s\") ); eg();\n",
      wdwname,obj,obj_ypos,wdwname,obj,ArrayName);
    for(ii=0;ii<xmax;ii++){   /* Horiz. Text */
      /*{{{  */
      fprintf(fp_dwdw,"o( %s%02dxt%04d S . %d %d 12 1 rem); bg( %s%02dxt%04d . (\"x+%02d\") ); eg();\n",
        wdwname,obj,ii,9+12*ii,obj_ypos,wdwname,obj,ii,ii);
      /*}}}  */
      };
    for(ii=0;ii<ymax;ii++){   /* Vert. Text */
      /*{{{  */
      fprintf(fp_dwdw,"o( %s%02dyt%04d S . 1 %d 12 1 rem); bg( %s%02dyt%04d . (\"[%02d]\") ); eg();\n",
        wdwname,obj,ii,obj_ypos+ii+1,wdwname,obj,ii,ii*OP_ROW);
      /*}}}  */
      };
    for(jj=0;jj<ymax;jj++){
      for(ii=0;ii<xmax;ii++){
        /*{{{  */
        switch(typ[0]){
          case 'I': fprintf(fp_dwdw,"o( %s%04d  I I %d %d 12 1 std); bg( %s%04d (\".\") (ptr)MFX:%s.%s[%d] );",
                    wdwname,obj,9+ii*12,obj_ypos+jj+1,wdwname,obj,mfxname,ArrayName,jj*xmax+ii);
                    break;
          case 'T': fprintf(fp_dwdw,"o( %s%04d  S S %d %d 12 1 std); bg( %s%04d (\".\") (ptr)MFX:%s.%s[%d] );",
                    wdwname,obj,9+ii*12,obj_ypos+jj+1,wdwname,obj,mfxname,ArrayName,jj*xmax+ii);
                    break;
          case 'S': fprintf(fp_dwdw,"o( %s%04d  I I %d %d 12 1 std); bg( %s%04d (\".\") (ptr)MFX:%s.%s[%d] );",
                    wdwname,obj,9+ii*12,obj_ypos+jj+1,wdwname,obj,mfxname,ArrayName,jj*xmax+ii);
                    break;
          case 'D': fprintf(fp_dwdw,"o( %s%04d  D D %d %d 12 1 std); bg( %s%04d (\".\") (ptr)MFX:%s.%s[%d] );",
                    wdwname,obj,9+ii*12,obj_ypos+jj+1,wdwname,obj,mfxname,ArrayName,jj*xmax+ii);
                    fprintf(fp_dwdw,"  ff( (\"%%8.4f\") (\"\") 1.0);");
                    break;
          }
        if (ii+jj>0){
          fprintf(fp_dwdw,"  cn(epO %s%04d );",wdwname,obj-1);
          };
        if ((ii!=xmax-1)||(jj!=ymax-1)){
          fprintf(fp_dwdw,"cn(edO %s%04d );",wdwname,obj+1);
          };
          fprintf(fp_dwdw," eg(); \n");
        mfx_entry++;
        obj++;
        };
        /*}}}  */
      };
    for (ii=0;ii<no;ii++){
      switch(typ[0]){
        case 'I': fprintf(fp_dmfx,"i( %s[%d] 0);\n",ArrayName,ii);
                  break;
        case 'T': fprintf(fp_dmfx,"s( %s[%d] %d (\" \") );\n",ArrayName,ii,slen);
                  break;
        case 'S': fprintf(fp_dmfx,"i( %s[%d] 0);\n",ArrayName,ii);
                  break;
        case 'D': fprintf(fp_dmfx,"s( %s[%d] 0);\n",ArrayName,ii);
                  break;
        }
      }
    switch(typ[0]){
      case 'I':  printf("integer %s[%d]\n",ArrayName,no);
                 break;
      case 'T':  printf("string %s[%d] (len=%d)\n",ArrayName,no,slen);
                 break;
      case 'S':  printf("short %s[%d]\n",ArrayName,no);
                 break;
      case 'D':  printf("double %s[%d]\n",ArrayName,no);
                 break;
      }
    obj_ypos+=(2+ymax);
    }
    /*}}}  */
 

%}

%union { char sstr[100]; int val; };
 
%token <sstr>  NUMBER
%token <sstr>  NAME
%token <sstr>  INT
%token <sstr>  DOUBLE
%token <sstr>  STRING
%token <sstr>  SHORT
%token <sstr>  TYPEDEF
%token <sstr>  STRUCT
%token <sstr>  EXTERN
%token <sstr>  DEFINE
%token <sstr>  IFDEF
%token <sstr>  ENDIF
%token <sstr>  PGMNAME
%token <sstr>  MFXINIT
%type  <sstr>  v

%left  ']'
%right  '['
%left  '}'
%right  '{'
%left   ';'

%left  HIPREC

%%
 
 
input:   /* empty */
       | input v { }
       ;
v:  TYPEDEF STRUCT '{'            {
    /*{{{  */
    printf("PARSING typedef struct {\n");
    create_c_files();
    }
    /*}}}  */
  | '}' NAME ';' {
    /*{{{  */
    printf("} PARSED: %s\n",$2);
    sprintf(c_struct_name,$2);
    }
    /*}}}  */
  | EXTERN NAME NAME ';'          {
    /*{{{  */
    sprintf(c_var_name,$3);
    printf("\nJust found \"extern %s %s\"; I will use that declaration.\n",
      $2,$3);
    }
    /*}}}  */
  | DEFINE NAME NAME            { }
  | DEFINE NAME NUMBER          { }
  | DEFINE PGMNAME NAME           {
    /*{{{  */
    char sstr[100];
    int ii;
    strcpy(pgmname,$3);
    printf("\nI think \"%s\" is the program you want to execute.\n",pgmname);
    
    sprintf(sstr,"%smfx.c",pgmname); for(ii=0;ii<strlen(sstr);ii++){sstr[ii]=tolower(sstr[ii]);}
    fp_xbc=fopen(sstr,"w"); if (fp_xbc==NULL){puts("ERR: can't write output file!");exit(1);}
    sprintf(sstr,"%smfx.mta",pgmname); for(ii=0;ii<strlen(sstr);ii++){sstr[ii]=tolower(sstr[ii]);}
    fp_xbm=fopen(sstr,"w"); if (fp_xbm==NULL){puts("ERR: can't write output file!");exit(1);}
    sprintf(sstr,"%swdw.mta",pgmname); for(ii=0;ii<strlen(sstr);ii++){sstr[ii]=tolower(sstr[ii]);}
    fp_wdw=fopen(sstr,"w"); if (fp_wdw==NULL){puts("ERR: can't write output file!");exit(1);}
    
    fprintf(fp_wdw,"/*==================================================\n");
    fprintf(fp_wdw,"  xbw %s\n",sstr);
    fprintf(fp_wdw,"  exit\n");
    fprintf(fp_wdw,"  ==================================================*/\n");
    
    fprintf(fp_wdw,"\nMalloc(400);\n@start( %s color );\n",pgmname);
    fprintf(fp_wdw,"@%smfx();                        %% Read MFX Group Definitions\n",pgmname);
    }
    /*}}}  */
  | IFDEF         { puts("Found MFX Data Initialization..."); }
  | ENDIF         {
    puts("End of MFX Data Initialization");
    write_c_files(c_var_name,pgmname);
    }
  | INT '(' '*' NAME '[' NUMBER ']' ')' '(' INT NAME ',' DOUBLE '(' '*' NAME ')' '[' ']' ')' ';' {
    /*{{{  */
    printf("int (*%s[%s])(int %s, double (*%s)[]); function addresses will not be exported.\n",
      $4,$6,$11,$16);
    }
    /*}}}  */
  | DOUBLE '*' NAME '[' NUMBER ']' ';' {
    /*{{{  */
    printf("double *%s[%s]; pointers will not be exported.\n",$3,$5);
    }
    /*}}}  */
  | INT NAME ';'                  {
    /*{{{  */
    NewWindow();
    fprintf(fp_dmfx,"i( %s 0 );\n",$2);
    fprintf(fp_dwdw,"%%_____%s___(Integer)______________________________\no( %s%02dt S . 1 %d 8 1 rem); bg( %s%02dt . %s ); eg();\n",
      $2,wdwname,obj,obj_ypos,wdwname,obj,$2);
    fprintf(fp_dwdw,"o( %s%02d  I I 9 %d 8 1 std); bg( %s%02d (\".\") (ptr)MFX:%s.%s );",
      wdwname,obj,obj_ypos,wdwname,obj,mfxname,$2);
    fprintf(fp_dwdw,"  cn(epO %s%02d );",wdwname,obj-1);
    fprintf(fp_dwdw,"cn(edO %s%02d );eg(); \n",wdwname,obj+1);
    fprintf(fp_wmfx,"  XbWMFX_PutInteger(&thestruct.%s,\"%s\");\n",$2,$2);
    fprintf(fp_rmfx,"  if(XbWMFX_GetInteger(&thestruct.%s)){goto error;}\n",$2);
    printf("integer %s\n",$2);
    NewObject();
    }
    /*}}}  */
  | INT NAME '[' NUMBER ']' ';'   {
    /*{{{  */
    int no=atoi($4);
    
    ArrayX("I",$2,no,0);
    /*{{{  */
    
    fprintf(fp_wmfx,"  { int i;\n"
                    "    for(i=0;i<%d;i++){\n"
                    "      char sstr[100];\n"
                    "      sprintf(sstr,\"%s[%%d]\",i);\n"
                    "      XbWMFX_PutInteger(&thestruct.%s[i],sstr);\n"
                    "      }\n"
                    "    }\n",no,$2,$2);
    fprintf(fp_rmfx,"  { int i;\n"
                    "    for(i=0;i<%d;i++){\n"
                    "      if(XbWMFX_GetInteger(&thestruct.%s[i])){ goto error; }\n"
                    "      }\n"
                    "    }\n",no,$2);
    /*}}}  */
    NewObject();
    }
    /*}}}  */
  | INT NAME '[' NUMBER ']' '[' NUMBER ']' ';'   {
    /*{{{  */
    int nox=atoi($4); int noy=atoi($7);
    ArrayXY("I",$2,nox,noy,0);
    /*{{{  */
    fprintf(fp_wmfx,"  { int i,j;\n"
                    "    for(i=0;i<%d;i++){\n"
                    "      for(j=0;j<%d;j++){\n"
                    "        char sstr[100];\n"
                    "        sprintf(sstr,\"%s[%%d][%%d]\",i,j);\n"
                    "        XbWMFX_PutInteger(&thestruct.%s[i][j],sstr);\n"
                    "        }\n"
                    "      }\n"
                    "    }\n",nox,noy,$2,$2);
    fprintf(fp_rmfx,"  { int i,j;\n"
                    "    for(i=0;i<%d;i++){\n"
                    "      for(j=0;j<%d;j++){\n"
                    "        if(XbWMFX_GetInteger(&thestruct.%s[i][j])){\n"
                    "          goto error;\n"
                    "          }\n"
                    "        }\n"
                    "      }\n"
                    "    }\n",nox,noy,$2);
    /*}}}  */
    NewObject();
    obj_ypos+=(2+noy);
    }
    /*}}}  */
  | INT NAME '[' NUMBER ']' '[' NUMBER ']' '[' NUMBER ']' ';'   {
    /*{{{  */
    { int ii,jj,kk, nox,noy,noz;
      nox=atoi($4);
      noy=atoi($7);
      noz=atoi($10);
      for (ii=0;ii<nox;ii++){
        for (jj=0;jj<noy;jj++){
          for (kk=0;kk<noz;kk++){
            fprintf(fp_dmfx,"i( %s[%d][%d][%d] 0);\n",$2,ii,jj,kk);
            }
          }
        }
      fprintf(fp_wmfx,"  { int i,j,k;\n"
                      "    for(i=0;i<%d;i++){\n"
                      "      for(j=0;j<%d;j++){\n"
                      "        for(k=0;k<%d;k++){\n"
                      "          char sstr[100];\n"
                      "          sprintf(sstr,\"%s[%%d][%%d][%%d]\",i,j,k);\n"
                      "          XbWMFX_PutInteger(&thestruct.%s[i][j][k],sstr);\n"
                      "          }\n"
                      "        }\n"
                      "      }\n"
                      "    }\n",nox,noy,noz,$2,$2);
      fprintf(fp_rmfx,"  { int i,j,k;\n"
                      "    for(i=0;i<%d;i++){\n"
                      "      for(j=0;j<%d;j++){\n"
                      "        for(k=0;k<%d;k++){\n"
                      "          if(XbWMFX_GetInteger(&thestruct.%s[i][j][k])){goto error;}\n"
                      "          }\n"
                      "        }\n"
                      "      }\n"
                      "    }\n",nox,noy,noz,$2);
      printf("integer %s[%s][%s][%s]\n",$2,$4,$7,$10);
      }
    }
    /*}}}  */
  | DOUBLE NAME ';'               {
    /*{{{  */
    NewWindow();
    fprintf(fp_dmfx,"d( %s 0.0000001);\n",$2);
    fprintf(fp_dwdw,"%%_____%s___(Double Float)______________________________\no( %s%02dt S . 1 %d 8 1 rem); bg( %s%02dt . %s ); eg();\n",
      $2,wdwname,obj,obj_ypos,wdwname,obj,$2);
    
    fprintf(fp_dwdw,"o( %s%02d D D 9 %d 15 1 std);\n",
      wdwname,obj,obj_ypos);
    fprintf(fp_dwdw,"bg( %s%02d (\".\") (ptr)MFX:%s.%s );  %% Object Head\n",
      wdwname,obj,mfxname,$2);
    fprintf(fp_dwdw,"  ff( (\"%%14.7f\") (\"\") 1 );\n          %% Object Body with Display Format\n");
    fprintf(fp_dwdw,"  cn(epO %s%02d );",wdwname,obj-1);
    fprintf(fp_dwdw,"cn(edO %s%02d );eg(); \n",wdwname,obj+1);
    fprintf(fp_wmfx,"  XbWMFX_PutDouble(&thestruct.%s,\"%s\");\n",$2,$2);
    fprintf(fp_rmfx,"  if(XbWMFX_GetDouble(&thestruct.%s)){goto error;}\n",$2);
    printf("double %s\n",$2);
    NewObject();
    }
    /*}}}  */
  | DOUBLE NAME '[' NUMBER ']' ';'   {
    /*{{{  */
    int no;
    no=atoi($4);
    
    ArrayX("D",$2,no,0);
    
    
    fprintf(fp_wmfx,"  { int i;\n"
                    "    for(i=0;i<%d;i++){\n"
                    "      char sstr[100];\n"
                    "      sprintf(sstr,\"%s[%%d]\",i);\n"
                    "      XbWMFX_PutDouble(&thestruct.%s[i],sstr);\n"
                    "      }\n"
                    "    }\n",no,$2,$2);
    fprintf(fp_rmfx,"  { int i;\n"
                    "    for(i=0;i<%d;i++){\n"
                    "      if(XbWMFX_GetDouble(&thestruct.%s[i])){goto error;}\n"
                    "      }\n"
                    "    }\n",no,$2);
    
    NewObject();
    }
    /*}}}  */
  | DOUBLE NAME '[' NUMBER ']' '[' NUMBER ']' ';'   {
    /*{{{  */
    int nox=atoi($4); int noy=atoi($7);
    ArrayXY("D",$2,nox,noy,0);
    fprintf(fp_wmfx,"  { int i,j;\n"
                    "    for(i=0;i<%d;i++){\n"
                    "      for(j=0;j<%d;j++){\n"
                    "        char sstr[100];\n"
                    "        sprintf(sstr,\"%s[%%d][%%d]\",i,j);\n"
                    "        XbWMFX_PutDouble(&thestruct.%s[i][j],sstr);\n"
                    "        }\n"
                    "      }\n"
                    "    }\n",nox,noy,$2,$2);
    fprintf(fp_rmfx,"  { int i,j;\n"
                    "    for(i=0;i<%d;i++){\n"
                    "      for(j=0;j<%d;j++){\n"
                    "        if(XbWMFX_GetDouble(&thestruct.%s[i][j])){goto error;}\n"
                    "        }\n"
                    "      }\n"
                    "    }\n",nox,noy,$2);
    NewObject();
    obj_ypos+=(2+noy);
    }
    /*}}}  */
  | DOUBLE NAME '[' NUMBER ']' '[' NUMBER ']' '[' NUMBER ']' ';'   {
    /*{{{  */
    { int ii,jj,kk, nox,noy,noz;
      nox=atoi($4);
      noy=atoi($7);
      noz=atoi($10);
      for (ii=0;ii<nox;ii++){
        for (jj=0;jj<noy;jj++){
          for (kk=0;kk<noz;kk++){
            fprintf(fp_dmfx,"d( %s[%d][%d][%d] 0.0000001 );\n",$2,ii,jj,kk);
            }
          }
        }
    
      fprintf(fp_wmfx,"  { int i,j,k;\n"
                      "    for(i=0;i<%d;i++){\n"
                      "      for(j=0;j<%d;j++){\n"
                      "        for(k=0;k<%d;k++){\n"
                      "          char sstr[100];\n"
                      "          sprintf(sstr,\"%s[%%d][%%d][%%d]\",i,j,k);\n"
                      "          XbWMFX_PutDouble(&thestruct.%s[i][j][k],sstr);\n"
                      "          }\n"
                      "        }\n"
                      "      }\n"
                      "    }\n",nox,noy,noz,$2,$2);
      fprintf(fp_rmfx,"  { int i,j,k;\n"
                      "    for(i=0;i<%d;i++){\n"
                      "      for(j=0;j<%d;j++){\n"
                      "        for(k=0;k<%d;k++){\n"
                      "          if(XbWMFX_GetDouble(&thestruct.%s[i][j][k])){goto error;}\n"
                      "          }\n"
                      "        }\n"
                      "      }\n"
                      "    }\n",nox,noy,noz,$2);
      printf("double %s[%s][%s][%s]\n",$2,$4,$7,$10);
      }
    }
    /*}}}  */
  | STRING NAME '[' NUMBER ']' ';'{
    /*{{{  */
    NewWindow();
    fprintf(fp_dmfx,"s( %s %s (\" \") );\n",$2,$4);
    fprintf(fp_dwdw,"%%_____%s___(Text String)__________________________\no( %s%02dt S . 1 %d 8 1 rem); bg( %s%02dt . %s ); eg();\n",
      $2,wdwname,obj,obj_ypos,wdwname,obj,$2);
    fprintf(fp_dwdw,"o( %s%02d S S 9 %d 40 1 std); bg( %s%02d  (\".\") (ptr)MFX:%s.%s );",
      wdwname,obj,obj_ypos,wdwname,obj,mfxname,$2);
    fprintf(fp_dwdw,"  cn(epO %s%02d );",wdwname,obj-1);
    fprintf(fp_dwdw,"cn(edO %s%02d );eg(); \n",wdwname,obj+1);
    fprintf(fp_wmfx,"  XbWMFX_PutString(thestruct.%s,\"%s\");\n",$2,$2);
    fprintf(fp_rmfx,"  if(XbWMFX_GetString(thestruct.%s)){goto error;}\n",$2);
    printf("string %s\n",$2);
    NewObject();
    }
    /*}}}  */
  | STRING NAME '[' NUMBER ']' '[' NUMBER ']' ';'   {
    /*{{{  */
    int no=atoi($7);
    int slen=atoi($4);
    
    ArrayX("T",$2,no,slen);
    /*{{{  */
    fprintf(fp_wmfx,"  { int i;\n"
                    "    for(i=0;i<%d;i++){\n"
                    "      char sstr[100];\n"
                    "      sprintf(sstr,\"%s[%%d]\",i);\n"
                    "      XbWMFX_PutString(&thestruct.%s[i][0],sstr);\n"
                    "      }\n"
                    "    }\n",no,$2,$2);
    fprintf(fp_rmfx,"  { int i;\n"
                    "    for(i=0;i<%d;i++){\n"
                    "      if(XbWMFX_GetString(&thestruct.%s[i][0])){goto error;}\n"
                    "      }\n"
                    "    }\n",no,$2);
    /*}}}  */
    NewObject();
    
    }
    /*}}}  */
  | STRING NAME '[' NUMBER ']' '[' NUMBER ']' '[' NUMBER ']' ';'   {
    /*{{{  */
    int nox=atoi($7);
    int noy=atoi($10);
    int slen=atoi($4);
    
    ArrayXY("T",$2,nox,noy,slen);
    /*{{{  */
    /*{{{  */
    fprintf(fp_wmfx,"  { int i,j;\n"
                    "    for(i=0;i<%d;i++){\n"
                    "      for(j=0;j<%d;j++){\n"
                    "        char sstr[100];\n"
                    "        sprintf(sstr,\"%s[%%d][%%d]\",i,j);\n"
                    "        XbWMFX_PutString(&thestruct.%s[i][j][0],sstr);\n"
                    "        }\n"
                    "      }\n"
                    "    }\n",nox,noy,$2,$2);
    fprintf(fp_rmfx,"  { int i,j;\n"
                    "    for(i=0;i<%d;i++){\n"
                    "      for(j=0;j<%d;j++){\n"
                    "        if(XbWMFX_GetString(&thestruct.%s[i][j][0])){goto error;}\n"
                    "        }\n"
                    "      }\n"
                    "    }\n",nox,noy,$2);
    /*}}}  */
    /*}}}  */
    NewObject();
    }
    /*}}}  */
  | SHORT NAME ';'                {
    /*{{{  */
    NewWindow();
    fprintf(fp_dmfx,"i( %s 0 );\n",$2);
    fprintf(fp_dwdw,"%%_____%s___(Integer)______________________________\no( %s%02dt S . 1 %d 8 1 rem); bg( %s%02dt . %s ); eg();\n",
      $2,wdwname,obj,obj_ypos,wdwname,obj,$2);
    fprintf(fp_dwdw,"o( %s%02d I I 9 %d 8 1 std); bg( %s%02d  (\".\") (ptr)MFX:%s.%s );",
      wdwname,obj,obj_ypos,wdwname,obj,mfxname,$2);
    fprintf(fp_dwdw,"  cn(epO %s%02d );",wdwname,obj-1);
    fprintf(fp_dwdw,"cn(edO %s%02d );eg(); \n",wdwname,obj+1);
    fprintf(fp_wmfx,"  XbWMFX_PutShort(&thestruct.%s,\"%s\");\n",$2,$2);
    fprintf(fp_rmfx,"  if(XbWMFX_GetShort(&thestruct.%s)){goto error;}\n",$2);
    printf("short %s\n",$2);
    NewObject();
    }
    /*}}}  */
  | SHORT NAME '[' NUMBER ']' ';'   {
    /*{{{  */
    int no=atoi($4);
    
    ArrayX("S",$2,no,0);
    /*{{{  */
    fprintf(fp_wmfx,"  { int i;\n"
                    "    for(i=0;i<%d;i++){\n"
                    "      char sstr[100];\n"
                    "      sprintf(sstr,\"%s[%%d]\",i);\n"
                    "      XbWMFX_PutShort(&thestruct.%s[i],sstr);\n"
                    "      }\n"
                    "    }\n",no,$2,$2);
    fprintf(fp_rmfx,"  { int i;\n"
                    "    for(i=0;i<%d;i++){\n"
                    "      if(XbWMFX_GetShort(&thestruct.%s[i])){goto error;}\n"
                    "      }\n"
                    "    }\n",no,$2);
    /*}}}  */
    NewObject();
    }
    /*}}}  */
  | SHORT NAME '[' NUMBER ']' '[' NUMBER ']' ';'   {
    /*{{{  */
    int nox=atoi($4); int noy=atoi($7);
    ArrayXY("S",$2,nox,noy,0);
    /*{{{  */
    fprintf(fp_wmfx,"  { int i,j;\n"
                    "    for(i=0;i<%d;i++){\n"
                    "      for(j=0;j<%d;j++){\n"
                    "        char sstr[100];\n"
                    "        sprintf(sstr,\"%s[%%d][%%d]\",i,j);\n"
                    "        XbWMFX_PutShort(&thestruct.%s[i][j],sstr);\n"
                    "        }\n"
                    "      }\n"
                    "    }\n",nox,noy,$2,$2);
    fprintf(fp_rmfx,"  { int i,j;\n"
                    "    for(i=0;i<%d;i++){\n"
                    "      for(j=0;j<%d;j++){\n"
                    "        if(XbWMFX_GetShort(&thestruct.%s[i][j])){goto error;}\n"
                    "        }\n"
                    "      }\n"
                    "    }\n",nox,noy,$2);
    /*}}}  */
    NewObject();
    obj_ypos+=(2+noy);
    }
    /*}}}  */
  | SHORT NAME '[' NUMBER ']' '[' NUMBER ']' '[' NUMBER ']' ';'   {
    /*{{{  */
    { int ii,jj,kk, nox,noy,noz;
      nox=atoi($4);
      noy=atoi($7);
      noz=atoi($10);
      for (ii=0;ii<nox;ii++){
        for (jj=0;jj<noy;jj++){
          for (kk=0;kk<noz;kk++){
            fprintf(fp_dmfx,"i( %s[%d][%d][%d] 0);\n",$2,ii,jj,kk);
            }
          }
        }
      fprintf(fp_wmfx,"  { int i,j,k;\n"
                      "    for(i=0;i<%d;i++){\n"
                      "      for(j=0;j<%d;j++){\n"
                      "        for(k=0;k<%d;k++){\n"
                      "          char sstr[100];\n"
                      "          sprintf(sstr,\"%s[%%d][%%d][%%d]\",i,j,k);\n"
                      "          XbWMFX_PutShort(&thestruct.%s[i][j][k],sstr);\n"
                      "          }\n"
                      "        }\n"
                      "      }\n"
                      "    }\n",nox,noy,noz,$2,$2);
      fprintf(fp_rmfx,"  { int i,j,k;\n"
                      "    for(i=0;i<%d;i++){\n"
                      "      for(j=0;j<%d;j++){\n"
                      "        for(k=0;k<%d;k++){\n"
                      "          if(XbWMFX_GetShort(&thestruct.%s[i][j][k])){goto error;}\n"
                      "          }\n"
                      "        }\n"
                      "      }\n"
                      "    }\n",nox,noy,noz,$2);
      printf("short %s[%s][%s][%s]\n",$2,$4,$7,$10);
      }
    }
    /*}}}  */
  ;
%%
 
int put_lval_number(char *sst){strcpy(yylval.sstr,sst);      return(NUMBER); }
int put_lval_name(char *sst){  strcpy(yylval.sstr,sst);      return(NAME);   }
int put_lval_integer(void){    strcpy(yylval.sstr,"int");    return(INT);    }
int put_lval_double(void){     strcpy(yylval.sstr,"double"); return(DOUBLE); }
int put_lval_string(void){     strcpy(yylval.sstr,"char");   return(STRING); }
int put_lval_short(void){      strcpy(yylval.sstr,"short");  return(SHORT);  }
int put_lval_typedef(void){    strcpy(yylval.sstr,"typedef");return(TYPEDEF);}
int put_lval_struct(void){     strcpy(yylval.sstr,"struct"); return(STRUCT); }
int put_lval_extern(void){     strcpy(yylval.sstr,"extern"); return(EXTERN); }
int put_lval_define(void){     strcpy(yylval.sstr,"define"); return(DEFINE); }
int put_lval_ifdef(void){      strcpy(yylval.sstr,"ifdef");  return(IFDEF);  }
int put_lval_endif(void){      strcpy(yylval.sstr,"endif");  return(ENDIF);  }
int put_lval_pgmname(void){    strcpy(yylval.sstr,"pgmname");return(PGMNAME);}
int put_lval_mfxinit(void){    strcpy(yylval.sstr,"mfxinit");return(MFXINIT);}
 
 
void create_c_files(void){
  c_var_name[0]=0;
  obj=4;
  fp_wmfx=fopen("makemfx.wmfx","w"); if (fp_wmfx==NULL){puts("ERR: can't write scratch file!");exit(1);}
  fp_rmfx=fopen("makemfx.rmfx","w"); if (fp_rmfx==NULL){puts("ERR: can't write scratch file!");exit(1);}
  fp_dmfx=fopen("makemfx.dmfx","w"); if (fp_dmfx==NULL){puts("ERR: can't write scratch file!");exit(1);}
  fp_dwdw=fopen("makemfx.dwdw","w"); if (fp_dwdw==NULL){puts("ERR: can't write scratch file!");exit(1);}
  }
 
int write_c_files(char *s, char *pgm){
  char sstr[100];
  int ii;
 
  fclose(fp_dmfx);
  fclose(fp_rmfx);
  fclose(fp_wmfx);
  fclose(fp_dwdw);
 
  system("cp /xw/xbmfx/* .");
  fprintf(fp_xbc,"/*  XbW MetaFile eXchange (Interface to Applications): XBMFX  */\n");
 
  if (!struct_defined){
    struct_defined = 1;
    fprintf(fp_xbc,"\n#ifdef ALREADY_DEFINED_MFX_%s /*  #def'd ? */\n",s);
    fprintf(fp_xbc,"\n#else \n");
    fprintf(fp_xbc,"\n#define ALREADY_DEFINED_MFX_%s 1 \n",s);
    fprintf(fp_xbc,"\n#ifndef ProgramName /* Extra Module */\n");
    fprintf(fp_xbc,"#include <stdlib.h>\n");
    fprintf(fp_xbc,"#include <stdio.h>\n");
    fprintf(fp_xbc,"#include <string.h>\n");
    fprintf(fp_xbc,"#define MFX_INIT 1\n");
    fprintf(fp_xbc,"#include \"xbmfx.h\"\n");
    fprintf(fp_xbc,"#include \"%smfx.h\"\n",pgm);
    fprintf(fp_xbc,"\n#endif /*ProgramName*/\n");
    }
 
  fprintf(fp_xbc,"\n#ifdef thestruct\n");
  fprintf(fp_xbc,"#undef thestruct\n");
  fprintf(fp_xbc,"#endif\n");
 
  if (!c_var_name[0]){
    fprintf(fp_xbc,"#define thestruct MFX_%s\n\n",s);
    fprintf(fp_xbc,"%s MFX_%s;\n\n",s,s);
  } else {
    fprintf(fp_xbc,"#define thestruct %s\n\n",c_var_name);
    }
 
  fprintf(fp_xbc,"int WriteMFXGroup_%s(char*filename, char*dataset, char *mode){\n",c_var_name);
  /*{{{  */
  fprintf(fp_xbc,"  if (filename == NULL) { filename = \"%s.mfx\"; } \n",c_var_name);
  fprintf(fp_xbc,"  if (dataset == NULL) { dataset = \"%s\"; }\n",s);
  fprintf(fp_xbc,"  if (mode == NULL) { mode = \"w\"; }\n");
  fprintf(fp_xbc,"  if (XbWMFX_WriteSet(filename,dataset,mode)) {\n");
  fprintf(fp_xbc,"    return(1);\n");
  fprintf(fp_xbc,"    }\n");
  {
    char li[1000];
    fp_wmfx=fopen("makemfx.wmfx","r");
    if (fp_wmfx==NULL){puts("ERR: can't read scratch file!");exit(1);}
    while(!feof(fp_wmfx)){
      if (fgets(li,1000,fp_wmfx)){
        fputs(li,fp_xbc);
        }
      }
    }
  
  fclose(fp_wmfx);
  unlink("makemfx.wmfx");
  
  fprintf(fp_xbc,"  XbWMFX_WriteEnd();\n");
  fprintf(fp_xbc,"  XbWMFX_CloseSet();\n");
  fprintf(fp_xbc,"  return(0);\n");
  fprintf(fp_xbc,"  }\n\n");
  
  /*}}}  */
  fprintf(fp_xbc,"int ReadMFXGroup_%s(char*filename, char*dataset){\n",c_var_name);
  /*{{{  */
  fprintf(fp_xbc,"  if (filename == NULL) { filename = \"%s.mfx\"; } \n",c_var_name);
  fprintf(fp_xbc,"  if (dataset == NULL) { dataset = \"%s\"; }\n",s);
  fprintf(fp_xbc,"  if (XbWMFX_ReadSet(filename,dataset)) {\n");
  fprintf(fp_xbc,"    puts(\"ERR on opening MFX file; I will now try to append\");\n");
  fprintf(fp_xbc,"    ropenerr:;\n");
  fprintf(fp_xbc,"    printf(\"a working MFX Group %%s to the end of file %%s...\\n\",dataset,filename);\n");
  fprintf(fp_xbc,"    if (!WriteMFXGroup_%s(filename,dataset,\"a\")){\n",c_var_name);
  fprintf(fp_xbc,"      puts(\"...done. Exiting with error code.\");\n");
  fprintf(fp_xbc,"      printf(\"The end of file %%s should now be readable. Please check its contents!\\n\",filename);\n");
  fprintf(fp_xbc,"      printf(\"If %%s did not exist until now, don't get crazy :)\\n\",filename);\n");
  fprintf(fp_xbc,"      return(1);\n");
  fprintf(fp_xbc,"      }\n");
  fprintf(fp_xbc,"    else {\n");
  fprintf(fp_xbc,"      puts(\"...did not work. Exiting with error code.\");\n");
  fprintf(fp_xbc,"      printf(\"I must now overwrite your file %%s, sorry. Please check its contents!\\n\",filename);\n");
  fprintf(fp_xbc,"      WriteMFXGroup_%s(filename,dataset,\"w\");\n",c_var_name);
  fprintf(fp_xbc,"      printf(\"If %%s did not exist until now, don't get crazy :)\\n\",filename);\n");
  fprintf(fp_xbc,"      return(1);\n");
  fprintf(fp_xbc,"      }\n");
  fprintf(fp_xbc,"    }\n");
  {
    char li[1000];
    fp_rmfx=fopen("makemfx.rmfx","r");
    if (fp_rmfx==NULL){puts("ERR: can't read scratch file!");exit(1);}
    while(!feof(fp_rmfx)){
      if (fgets(li,1000,fp_rmfx)>0){
        fputs(li,fp_xbc);
        }
      }
    }
  
  fprintf(fp_xbc,"  XbWMFX_CloseSet();\n");
  fprintf(fp_xbc,"  return(0);\n");
  fprintf(fp_xbc,"error:;\n");
  fprintf(fp_xbc,"  printf(\"Error while reading MFX Group %s\\n\");",c_var_name);
  fprintf(fp_xbc,"  XbWMFX_CloseSet();\n");
  fprintf(fp_xbc,"  puts(\"I will now try to append\");\n");
  fprintf(fp_xbc,"  goto ropenerr;\n");
  fprintf(fp_xbc,"  }\n\n\n");
  
  fclose(fp_rmfx);
  unlink("makemfx.rmfx");
  
  /*}}}  */
  fprintf(fp_xbc,"\n#undef thestruct\n");
 
  fprintf(fp_xbm,"\n%% XbW MFX Group %s\n",s);
  /*{{{  */
  sprintf(sstr,"%s",s); for(ii=0;ii<strlen(sstr);ii++){sstr[ii]=tolower(sstr[ii]);}
  fprintf(fp_xbm,"\n@mfxgroup/begin( %s (\"%s.mfx\") (\"xbwmfx.\") );\n",s,sstr);
  {
    char li[1000];
    fp_dmfx=fopen("makemfx.dmfx","r");
    if (fp_dmfx==NULL){puts("ERR: can't read scratch file!");exit(1);}
    while(!feof(fp_dmfx)){
      if(fgets(li,1000,fp_dmfx)){
        fputs(li,fp_xbm);
        }
      }
    }
  fclose(fp_dmfx);
  unlink("makemfx.dmfx");
  
  fprintf(fp_xbm,"\n@mfxgroup/end();\n\n");
  
  /*}}}  */
  fprintf(fp_trl,"\nMFXGroup( Read %s );\n",s);
 
  /* write window */
  /*{{{  */
  {
    char li[1000];
    wdwnr++;
    sprintf(wdwname,"WD%02d",wdwnr);
    wdwname[4]=0;
    fprintf(fp_wdw,"wdw( %s %d %d %d 40 StandardWDW ); %%Get a Window\n",
      wdwname,wdwnr,wdwnr+2,WDW_WIDTH);
    fprintf(fp_wdw,"@window/gimmicks( %s (\" '%s' Window %s (P) by XbW\") );  %% Get some buttons\n",wdwname,pgmname,wdwname);
  /*
   * fprintf(fp_wdw,"$WDW:=%s;  %% Set Window Name\n",wdwname);
   * fprintf(fp_wdw,"$MFX:=%s;   %% Set MFX Group Name   (MFX: via MetaFile eXchangeable data group)\n",c_var_name);
   */
  
    fprintf(fp_wdw,"ng( KEY (\"%s:27.0\")); c( K (\"IconAllWdw(); SelectWdw(MAIN);\")); eg(); /* ESC:Reset All */\n\n",
      wdwname);
  
    fprintf(fp_wdw,"\no( %s02 S T 9 3 30 1 Secure );   %% This Object starts the User Program\n",
      wdwname);
    fprintf(fp_wdw,"bg( %s02 . (\" Start Program %s\") );\n",
      wdwname,pgmname);
    fprintf(fp_wdw,"  tk( (\"\") (\"%s\") );             %% Program (TasK) name\n",pgmname);
    fprintf(fp_wdw,"  cn( wbX %s );                %% XbW: write MFX group before starting task\n",c_var_name);
    fprintf(fp_wdw,"  cn( raX %s );                %% XbW: read MFX group after end of task\n",c_var_name);
    fprintf(fp_wdw,"  eg();\n");
  
    fp_dwdw=fopen("makemfx.dwdw","r");
    if (fp_dwdw==NULL){puts("ERR: can't read scratch file!");exit(1);}
    while(!feof(fp_dwdw)){
      if(fgets(li,1000,fp_dwdw)){
        fputs(li,fp_wdw);
        }
      }
    }
  fclose(fp_dwdw);
  unlink("makemfx.dwdw");
  
  /*}}}  */
  mfx_entry=START_MFX_ENTRY;
  return(0);
  }
 
int main(int argc, char **argv){
  extern FILE *yyin;
 
  yyin=NULL;
  if (argc>0){     yyin = fopen(argv[1],"r"); }
  if (yyin==NULL){ yyin = stdin; }
 
/*  yydebug = 1; */
 
  fp_trl=fopen("makemfx.emfx","w"); if (fp_trl==NULL){puts("ERR: can't write scratch file!");exit(1);}
 
  yyparse();
 
  fclose(fp_trl);
  {
    char li[1000];
    fp_trl=fopen("makemfx.emfx","r");
    if (fp_trl==NULL){puts("ERR: can't read scratch file!");exit(1);}
    while(!feof(fp_trl)){
      if(fgets(li,1000,fp_trl)){
        fputs(li,fp_wdw);
        }
      }
    }
 
  unlink("makemfx.emfx");
 
  fprintf(fp_xbm,"End();\n\n");
  fprintf(fp_xbc,"\n#endif /* ALREADY_DEFINED_MFX_... */\n");
  fclose(fp_xbc);
  fclose(fp_xbm);
 
  fprintf(fp_wdw,"\n\n%%----------------------------------------------------\n");
  fprintf(fp_wdw,"wdw( MAIN 0 0 80 2 StandardWDW ); %%Get the MAIN Window\n");
  fprintf(fp_wdw,"\no( MAINXit M . 0 0 4 2 Red LGray LGray White 1); %%This object exits XbW\n");
  fprintf(fp_wdw,"bg(MAINXit . 1);lt(XbW 0 End End (\"=\"));cn(raK (\"@stop();\") );eg();\n");
  { int ii;
    for (ii=1;ii<=wdwnr;ii++){
      fprintf(fp_wdw,"\no( MAIN%02d M V %d 0 4 2 Gold LGray LGray Blue 1); %%This object selects Window WD%02d\n",
                  ii,ii*4,ii);
      fprintf(fp_wdw,"bg(MAIN%02d . (ptr)WDW:WD%02d.icn);lt((\"%02d\") 0 WD WD (\"=\"));cn(bW WD%02d MAIN);eg();\n",
                  ii,ii,ii,ii);
      };
    };
  fprintf(fp_wdw,"ng( KEY (\"MAIN:27.0\")); c( K (\"IconAllWdw(); SelectWdw(MAIN);\")); eg(); /* ESC:Reset All */\n\n");
  fprintf(fp_wdw,"SelectWdw( MAIN );\n");
 
  fprintf(fp_wdw,"End();\n\n");
  fclose(fp_wdw);
  fclose(fp_trl);
  unlink("makemfx.emfx");
 
  return(0);
  }
 
