
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*                                                                           */
/*                                                                           */
/*   Modul X3.C                                                              */
/*                                                                           */
/*                                                                           */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/* Header--------------------------------------------------------------------*/
 
#include "xbw.h"
#include "signal.h"
/*{{{F xbw.h*/
/*:::F xbw.h*/
/*}}}  */

/*  ---------------------Compiler-Modelle------------------------------------*/
                      /* ---............Nicht mglich  */
                      /* !!!............Noch zu machen */
                      /* ???............unklar         */
                      /* TC3............Turbo-C Version*/
                      /*     GNU........32-Bit Version */
                      /*         X11....X-Window       */


/*{{{  XbWFWd_GetList(     ***    Liste aller Windownamen lesen*/
int  XbWFWd_GetList(void){
  int ii;  for (ii=1;ii<=XbWDWd_MaxWdw;ii++){  XbWVWd_Name[ii]=NULL; };
  ii = 0;
  XbWVDb_ActGrp1 = XbWFDb_FindGrp("WDW",NULL);
  do {
    ii++;
    XbWVWd_Name[ii] = (char*)XbWFDb_VarInh(XbWVDb_ActGrp1,XbWDDb_Str,"WDW",0);
    XbWVWd_Grp[ii] = XbWVDb_ActGrp1;

    if (ii == XbWDWd_MaxWdw-3){
      XbWVWd_Name[ii]=NULL;
      };
    }
  while ((XbWVDb_ActGrp1 = (XbWDDb_DbIVar  *)XbWFDb_NextGrp(XbWVDb_ActGrp1,NULL)) != NULL);
  XbWVWd_MaxReg = ii;
  XbWVWd_FoundNo = ii;
  return(0);
  };
/*}}}  */
/*{{{  XbWFWd_GetPara(     ***    Parameter eines Windows laden*/
int  XbWFWd_GetPara(int nr, XbWDDb_DbIWdw  *TW){
  XbWDDb_DbIVar  *TV;

  if (XbWVWd_Name[nr] == NULL) {return(0);};

  TW->nm = XbWVWd_Name[nr];
  TV =     XbWVWd_Grp[nr];

  XbWFDb_ForWd(&TV,XbWDDb_DbISys);
  XbWFDb_ForWd(&TV,XbWDDb_DbISys);

  TW->tp = (int *)XbWFDb_GetInh(TV,XbWDDb_Int);
  XbWFDb_ForWd(&TV,XbWDDb_DbISys);
  TW->layer = (int *)&( ((XbWDDb_DbIInt *)TV)->inh);
  XbWFDb_ForWd(&TV,XbWDDb_DbISys);
  TW->nx = (int *)&( ((XbWDDb_DbIInt *)TV)->inh);
  XbWFDb_ForWd(&TV,XbWDDb_DbISys);
  TW->ny = (int *)&( ((XbWDDb_DbIInt *)TV)->inh);
  XbWFDb_ForWd(&TV,XbWDDb_DbISys);
  TW->sx = (int *)&( ((XbWDDb_DbIInt *)TV)->inh);
  XbWFDb_ForWd(&TV,XbWDDb_DbISys);
  TW->sy = (int *)&( ((XbWDDb_DbIInt *)TV)->inh);
  XbWFDb_ForWd(&TV,XbWDDb_DbISys);
  TW->wov = (int *)&( ((XbWDDb_DbIInt *)TV)->inh);
  XbWFDb_ForWd(&TV,XbWDDb_DbISys);
 
  if ((TV->tp & XbWDDb_Typ) == XbWDDb_Int) {
    TW->icn = (int *)&( ((XbWDDb_DbIInt *)TV)->inh);
    }
  else {
    TW->icn = (int *)XbWFDb_GetInh(TV,XbWDDb_Int);
    };
 
  XbWFDb_ForWd(&TV,XbWDDb_DbISys);
 
  if ((TV->tp & XbWDDb_Typ) == XbWDDb_Int) {
    TW->bkc = (int *)&( ((XbWDDb_DbIInt *)TV)->inh);
    }
  else {
    TW->bkc = (int *)XbWFDb_GetInh(TV,XbWDDb_Int);
    };
 
  XbWFDb_ForWd(&TV,XbWDDb_DbISys);
 
  if ((TV->tp & XbWDDb_Typ) == XbWDDb_Int) {
    TW->txc = (int *)&( ((XbWDDb_DbIInt *)TV)->inh);
    }
  else {
    TW->txc = (int *)XbWFDb_GetInh(TV,XbWDDb_Int);
    };
 
  XbWFDb_ForWd(&TV,XbWDDb_DbISys);
 
  if ((TV->tp & XbWDDb_Typ) == XbWDDb_Int) {
    TW->bfc = (int *)&( ((XbWDDb_DbIInt *)TV)->inh);
    }
  else {
    TW->bfc = (int *)XbWFDb_GetInh(TV,XbWDDb_Int);
    };
 
  XbWFDb_ForWd(&TV,XbWDDb_DbISys);
 
  if ((TV->tp & XbWDDb_Typ) == XbWDDb_Int) {
    TW->dfc = (int *)&( ((XbWDDb_DbIInt *)TV)->inh);
    }
  else {
    TW->dfc = (int *)XbWFDb_GetInh(TV,XbWDDb_Int);
    };
 
  XbWFDb_ForWd(&TV,XbWDDb_DbISys);
  TW->wfx = (int *)&( ((XbWDDb_DbIInt *)TV)->inh);
  XbWFDb_ForWd(&TV,XbWDDb_DbISys);
  TW->wfe = (int *)&( ((XbWDDb_DbIInt *)TV)->inh);
  XbWFDb_ForWd(&TV,XbWDDb_DbISys);
  TW->bd = (int *)&( ((XbWDDb_DbIInt *)TV)->inh);
  XbWFDb_ForWd(&TV,XbWDDb_DbISys);
  TW->obj = (XbWDDb_DbIPtr*)&( ((XbWDDb_DbINPtr *)TV)->inh);
  return(1);
  };
/*}}}  */
/*{{{  XbWFWd_OvrLap(      ***    Check ob sich zwei Wdws ueberlappen*/
int  XbWFWd_OvrLap(XbWDDb_DbIWdw *wtest, XbWDDb_DbIWdw *wb){
  if (wtest == NULL) {goto is_not_overlapped;};
  if (wb == NULL) {goto is_not_overlapped;};
  if (wtest->nm == NULL) {goto is_not_overlapped;};
  if (wb->nm == NULL) {goto is_not_overlapped;};
  if (XbWFTb_CmpStr((char*)wtest->nm,(char*)wb->nm) == 0){ goto is_not_overlapped;};
  if (((*wtest->icn) ) != 0) {goto is_not_overlapped;};
  if (*wtest->nx  + *wtest->sx <= *wb->nx){goto is_not_overlapped;};
  if (*wtest->nx >= *wb->nx  + *wb->sx){goto is_not_overlapped;};
  if (*wtest->ny  + *wtest->sy <= *wb->ny){goto is_not_overlapped;};
  if (*wtest->ny >= *wb->ny  + *wb->sy){goto is_not_overlapped;};
  (*wtest->wov)=1;
  if (!XbWVWd_AClos) {
    return(0);
    };
  return(1);
  is_not_overlapped:;
  return(0);
  };
/*}}}  */
/*{{{  XbWFWd_Hide(        ***    Ckeck ob ein Window ein anderes ganz verdeckt*/
int  XbWFWd_Hide(XbWDDb_DbIWdw *wtest, XbWDDb_DbIWdw *wb){
  if (((*wtest->icn) ) == 0) {
    if (*wtest->nx  >= *wb->nx){
      if (*wtest->ny >= *wb->ny){
        if (*wtest->nx  + *wtest->sx <= *wb->nx + *wb->sx){
          if (*wtest->ny + *wtest->sy <= *wb->ny  + *wb->sy){
            /* wtest wird vollstndig von wb berdeckt */

            *wtest->wov = 1;
            *wtest->icn = 1;  /* iconizen */
            return(1);
            };
          };
        };
      };
    };
  return(0);
  };
/*}}}  */
/*{{{  XbWFWd_ReDisp(      ***    Window Rahmen und Inhalt zeichnen*/
void  XbWFWd_ReDisp(void){
  XbWFWd_Draw(); XbWFWd_Rebuild();
  };
/*}}}  */
/*{{{  XbWFWd_Refresh(     ***    Window Rahmen zeichnen*/
void  XbWFWd_Refresh(void){
  int cstat = XbWVMs_CSet;
  XbWFGr_CurOFF();
  if (XbWVWd_W.nm != NULL) {
    if ( (*XbWVWd_W.nx < 0) ) { /*  Window liegt zu weit links       */
      *XbWVWd_W.nx = 0;
      };
    if ( (*XbWVWd_W.ny < 0) ) {     /* zu weit oben  */
      *XbWVWd_W.ny = 0;
      };
    if (((*XbWVWd_W.icn) ) == 0) {
      XbWFWd_Make(&XbWVWd_W);
      };                                    /* Zeichne normales Fenster */
    };
  if (cstat) { XbWFGr_CurON(); };
  };
/*}}}  */
/*{{{  XbWFWd_DrwASub(        ***    Unterroutine zu DrawAll*/
void  XbWFWd_DrwASub(void){
  XbWDDb_DbIWdw MPW;
  int count;
  MPW = XbWVWd_W;
  XbWFWd_GetList();
  XbWVWd_DrawNr = 0;
  for (count = 1;count <= XbWDWd_MaxWdw;count++) {
    if (XbWFWd_GetPara(count, &XbWVWd_W)) {
      if (((*XbWVWd_W.icn) ) == 0) {
        if (XbWFTb_CmpStr((char*)XbWVWd_W.nm,(char*)MPW.nm) != 0) {
          XbWFWd_OvrLap(&XbWVWd_W,&MPW);
          XbWFWd_Hide(&XbWVWd_W,&MPW);
          XbWVWd_LastDsp = XbWVWd_W;
          XbWFWd_Refresh(); XbWFWd_Rebuild();
          };
        };
      };
    };
  if (MPW.nm != NULL) {
    XbWVWd_W = MPW;
    *XbWVWd_W.wov = 0;
    }
  else {
    if (XbWVWd_LastDsp.nm != NULL) {
      XbWVWd_W = XbWVWd_LastDsp;
      *XbWVWd_W.wov = 0;
      };
    };
  };
/*}}}  */
/*{{{  XbWFWd_DrawAll(     ***    Alle Windows zeichnen*/
void  XbWFWd_DrawAll(void){
  XbWDDb_DbIWdw MPW;
  int cmrk,count;
  cmrk = XbWVMs_CSet;
  XbWFGr_CurOFF();
  MPW = XbWVWd_W;
  XbWFWd_DrwASub();
  if (MPW.nm != NULL) {
    XbWVWd_W = MPW;
    }
  else {
    if (XbWVWd_LastDsp.nm != NULL) {
      XbWVWd_W = XbWVWd_LastDsp;
      };
    };
  if (XbWVWd_W.icn != NULL){
    if (((*XbWVWd_W.icn) ) == 0) {
      for (count = 1;count <= XbWDWd_MaxWdw;count++) {
        if (XbWFWd_GetPara(count, &MPW)) {
          if (((*XbWVWd_W.icn) ) == 0) {
            if (XbWFTb_CmpStr((char*)XbWVWd_W.nm,(char*)MPW.nm) != 0) {
              XbWFWd_OvrLap(&MPW,&XbWVWd_W);
              XbWFWd_Hide(&MPW,&XbWVWd_W);
              };
            };
          };
        };
      };
    XbWFWd_ReDisp();
    };
  if (cmrk) { XbWFGr_CurON(); };
  };
/*}}}  */
/*{{{  XbWFWd_EraWdw(      ***    Ein Window loeschen*/
void  XbWFWd_EraWdw(void){
  if (((*XbWVWd_W.icn) ) == 0) {
    XbWFWd_Erase(&XbWVWd_W);
    };
  };
/*}}}  */
/*{{{  XbWFWd_Rebuild(     ***    Alle Objekte eines Windows zeichnen*/
void  XbWFWd_Rebuild(void){
  int cstat = XbWVMs_CSet;
  XbWFGr_CurOFF();
  if ( XbWVWd_W.nm != NULL) {
    if (((*XbWVWd_W.icn) ) == 0) {
      *XbWVWd_W.layer = XbWVWd_DrawNr;
      *XbWVWd_W.wov = 0;
      XbWVWd_DrawNr++;
      XbWVMf_P[0] = (void  *)0;
      XbWFOb_dpO(&XbWVWd_W,NULL);  /* Alle Objekte zeichnen */
      };
    };
  if (cstat) { XbWFGr_CurON(); };
  };
/*}}}  */
/*{{{  XbWFWd_Activate(    ***    Window anwaehlen*/
void  XbWFWd_Activate(char *nm, int savescreen){
  int count;
  XbWDDb_DbIWdw MPW;
  int cstat = XbWVMs_CSet;
  XbWFGr_CurOFF();
  XbWFWd_GetList();
  for (count = 1;count<= XbWDWd_MaxWdw;count++) {
    if (XbWFTb_CmpStr(nm,XbWVWd_Name[count])==0){
      if (XbWFWd_GetPara(count, &XbWVWd_W)) {
        if (cstat) { XbWFGr_CurON(); };
        return;
        }
      else {
        count = XbWDWd_MaxWdw+10;
        };
      };
    };
  XbWVWd_W=MPW;
  if (cstat) { XbWFGr_CurON(); };
  };
/*}}}  */
/*{{{  XbWFWd_Iconize(     ***    Window iconizen*/
void  XbWFWd_Iconize(void  *(*p)[]){
  char aname[20];
  int cstat = XbWVMs_CSet;
  XbWFGr_CurOFF();
  strcpy(aname,XbWVWd_W.nm);
 
  if ((int)(*p)[0] > 0) {
    XbWFWd_Activate((char*)(*p)[1],0);
    };
  XbWVWd_LastDsp.nm = NULL;
  XbWFWd_EraWdw();
  *XbWVWd_W.icn = 1;
 
  if ((int)(*p)[0] > 0) {
    if (strcmp(aname,XbWVWd_W.nm) != 0){
      XbWFWd_SwitchTo(aname,0);
      XbWFWd_DrawAll();
      XbWFWd_SwitchTo(aname,16);
      }
    else {
      XbWFWd_DrawAll();
      };
    }
  else {
    XbWFWd_DrawAll();
    };
  XbWVWd_W = XbWVWd_LastDsp;
 
  if (cstat) { XbWFGr_CurON(); };
  };
/*}}}  */
/*{{{  XbWFWd_IconAll(     ***    Alle Ede iconizen*/
void  XbWFWd_IconAll(void){
  int count;
  XbWDDb_DbIWdw MPW;
  int cstat = XbWVMs_CSet;
  XbWFGr_CurOFF();
  MPW = XbWVWd_W;
  XbWFWd_GetList();
  for (count = 1;count<= XbWDWd_MaxWdw;count++) {
    if (XbWFWd_GetPara(count, &XbWVWd_W)) {
      XbWVWd_LastDsp = XbWVWd_W;
      *XbWVWd_W.icn = 1;
      };
    };
  if (MPW.nm != NULL) {
    XbWVWd_W = MPW;
    }
  else {
    if (XbWVWd_LastDsp.nm != NULL) {
      XbWVWd_W = XbWVWd_LastDsp;
      };
    };
  XbWFWd_BackGr();
  XbWFWd_DrawAll();
  if (cstat) { XbWFGr_CurON(); };
  };
/*}}}  */
/*{{{  XbWFWd_SwitchTo(    ***    Window anwaehlen*/
void  XbWFWd_SwitchTo(char *nm, int savescreen){
  int count,mi;
  XbWDDb_DbIWdw MPW;
  int redraw = 0;
  int cstat = XbWVMs_CSet;
  XbWFGr_CurOFF();
  XbWFWd_GetList();
  for (count = 1;count<= XbWDWd_MaxWdw;count++) {
    if (XbWFTb_CmpStr(nm,XbWVWd_Name[count])==0){
      if (XbWFWd_GetPara(count, &XbWVWd_W)) {
        mi = count;
        if (XbWVWd_RedrawON){
          if ((*XbWVWd_W.wov)) {
            redraw = 1;
            };
          };
        if ( (*XbWVWd_W.tp != 2 ) &
           (((*XbWVWd_W.icn) ) == 1) ) {
          if (savescreen & 0x10) {
            redraw = 1;
            };
          };
        for (count = 1;count<= XbWDWd_MaxWdw;count++) {
          if (XbWFWd_GetPara(count, &MPW)) {
            if (XbWFWd_OvrLap(&MPW,&XbWVWd_W)){
              if ( (!(savescreen & 0x20)) & (XbWVWd_AClos)) {
                *MPW.icn = 1;
                };
              };
            XbWFWd_Hide(&MPW,&XbWVWd_W);
            }
          else {
            count = XbWDWd_MaxWdw + 10;
            };
          };
        XbWFWd_GetPara(mi,&XbWVWd_W);
        if ( (*XbWVWd_W.tp != 2 ) &
           (((*XbWVWd_W.icn) ) == 1) ) {
          *XbWVWd_W.icn = 0;
          };
        if (savescreen & 1){
          XbWFWd_SaveImage(&XbWVWd_W);
          };
        if (redraw) {
          XbWFWd_Draw();
          XbWFWd_Rebuild();
          };
        if (cstat) { XbWFGr_CurON(); };
        return;
        }
      else {
        count = XbWDWd_MaxWdw+10;
        };
      };
    };
  if (cstat) { XbWFGr_CurON(); };
  };
/*}}}  */
/*{{{  XbWFWd_Select(      ***    Ruft SwitchTo auf*/
int  XbWFWd_Select(void  *(*p)[]){
  if ((int)(*p)[0] > 0) {
    if ((int)(*p)[0] > 1) {
      XbWFWd_SwitchTo((char*)(*p)[1],(int)(*p)[2]);
      }
    else {
      XbWFWd_SwitchTo((char*)(*p)[1], 16 );
      };
    return(0);
    };
  return(1);
  };
/*}}}  */
/*{{{  XbWFWd_DrawP(       ***    Neuzeichnen*/
void  XbWFWd_DrawP(void){
  XbWFWd_Draw();
  XbWFWd_Rebuild();
  };
/*}}}  */
/*{{{  XbWFWd_Draw(        ***    Neuzeichnen (???)*/
void  XbWFWd_Draw(void){
  XbWFWd_Refresh();
  if (((*XbWVWd_W.icn) ) == 0) {
    XbWVWd_LastDsp = XbWVWd_W;
    };
  };
/*}}}  */
/*{{{  XbWFWd_Exists(      ***    Ob Window existiert*/
int  XbWFWd_Exists(char *refname){
  int count;
  XbWDDb_DbIWdw MPW;
  XbWFWd_GetList();
  for (count = 1;count <= XbWDWd_MaxWdw;count++) {
    if (XbWFWd_GetPara(count,&MPW) != 0) {
      if (XbWFTb_CmpStr((char*)MPW.nm,refname)==0){
        return(count);
        };
      };
    };
  return(-1);
  };
/*}}}  */
/*{{{  XbWFWd_SetPort(     ***    Videoport auf Window einstellen*/
void  XbWFWd_SetPort(void  *(*p)[]){
  if ( (int)(*p)[0] > 0) {
    XbWFWd_Select(p);
    };
  XbWFGr_MinPort(
    *XbWVWd_W.nx+1,
    *XbWVWd_W.ny+1,
    *XbWVWd_W.nx+*XbWVWd_W.sx-1,
    *XbWVWd_W.ny+*XbWVWd_W.sy);
  };
/*}}}  */
/*{{{  XbWFWd_NotInWdw(    ***    Check ob Maus ausserhalb*/
int  XbWFWd_NotInWdw(void){
  if ((XbWVWd_W.nm != NULL) & (XbWVMs_CX >= *XbWVWd_W.nx) &
      (XbWVMs_CY >= *XbWVWd_W.ny) &
      (XbWVMs_CX <= *XbWVWd_W.nx + *XbWVWd_W.sx) &
      (XbWVMs_CY <= *XbWVWd_W.ny + *XbWVWd_W.sy)) {
    return(0);
    }
  else {
    return(1);
    };
  };
/*}}}  */
/*{{{  XbWFWd_InInner(     ***    ...innerhalb*/
int  XbWFWd_InInner(void){
  if (((*XbWVWd_W.icn) ) == 0) {
    if ((XbWVWd_W.nm != NULL) &
        (XbWVMs_CX >= *XbWVWd_W.nx) &
        (XbWVMs_CY >= *XbWVWd_W.ny) &
        (XbWVMs_CX <= *XbWVWd_W.nx + *XbWVWd_W.sx ) &
        (XbWVMs_CY <= *XbWVWd_W.ny + *XbWVWd_W.sy )){
      return(1);
      };
    };
  return(0);
  };
/*}}}  */
/*{{{  XbWFWd_SlctOther(   ***    ...auf einem anderem Window*/
void  XbWFWd_SlctOther(void){
  int ccount,count;
  XbWDDb_DbIWdw MPW;
  int lt[XbWDWd_MaxWdw+2];
  int ln[XbWDWd_MaxWdw+2];
  int echtfnd = 0;
  MPW = XbWVWd_W;
  ccount = 1;
  XbWFWd_GetList();
  ccount = 1;
  if (XbWVWd_FoundNo < 1) {
    return;
    };
  if (!XbWVWd_AClos) {
    for (ccount = 1; ccount <= XbWVWd_FoundNo; ccount++){
      lt[ccount] = -1;
      };
    echtfnd = 0;
    for (ccount = 1; ccount <= XbWVWd_FoundNo; ccount++){
      if (XbWFWd_GetPara(ccount, &XbWVWd_W) != 0) {
        lt[echtfnd] = *XbWVWd_W.layer;
        ln[echtfnd] = ccount;
        echtfnd++;
        };
      };
    echtfnd--;
    if (echtfnd < 0) {return; };
    if (echtfnd > 0) {
      int tausch = 1;
      while (tausch) {
        tausch = 0;
        for (ccount = 0; ccount < echtfnd; ccount++){
          for (count = ccount+1; count <= echtfnd; count++){
            if (lt[count] > lt[ccount]) {
              { int a,b;
                a = lt[ccount];
                b = ln[ccount];
                lt[ccount] = lt[count];
                ln[ccount] = ln[count];
                lt[count] = a;
                ln[count] = b;
                tausch = 1;
                };
              };
            };
          };
        };
      };
    }
  else {
    echtfnd = XbWVWd_FoundNo;
    for (ccount = 0; ccount < echtfnd; ccount++) {
      ln[ccount] = ccount+1;
      };
    };
  ccount = 0;
  while (ccount <= echtfnd)  {
    if (XbWFWd_GetPara(ln[ccount], &XbWVWd_W) != 0) {
      if (((*XbWVWd_W.icn) ) == 0) {
        if ((XbWVMs_CX>= *XbWVWd_W.nx) &&(XbWVMs_CY>= *XbWVWd_W.ny) &&
            (XbWVMs_CX<= *XbWVWd_W.nx+ *XbWVWd_W.sx)&&
            (XbWVMs_CY<= *XbWVWd_W.ny + *XbWVWd_W.sy)) {
          int mrk;
          mrk = *XbWVWd_W.wov;
          for (count = 1;count< XbWDWd_MaxWdw;count++) {
            if (XbWFWd_GetPara(count, &MPW)) {
              if (XbWFWd_OvrLap(&MPW,&XbWVWd_W)){
                *MPW.icn = 1;
                };
              XbWFWd_Hide(&MPW,&XbWVWd_W);
              }
            else {
              count = XbWDWd_MaxWdw + 10;
              };
            };
          XbWFWd_GetPara(ln[ccount],&XbWVWd_W);
          *XbWVWd_W.icn = 0;
          if (mrk){
            if (XbWVWd_RedrawON){
              XbWFWd_Draw();
              XbWFWd_Rebuild();
              };
            };
          return;
      };};};
    ccount++;
    };
  XbWVWd_W = MPW;
  };
/*}}}  */
/*{{{  XbWFWd_LockON(      ***    Schutz vor falschen Verlassen EIN*/
void  XbWFWd_LockON(void){
  *XbWVWd_W.wfx = 1;
  XbWSMs_Warp(*XbWVWd_W.nx+(*XbWVWd_W.sx)/2,*XbWVWd_W.ny+(*XbWVWd_W.sy)/2);
  };
/*}}}  */
/*{{{  XbWFWd_LockEdit(    ***    Schutz EIN wenn Objekt angeklickt*/
void  XbWFWd_LockEdit(void){
  *XbWVWd_W.wfe = 1;
  XbWSMs_Warp(*XbWVWd_W.nx+(*XbWVWd_W.sx)/2,*XbWVWd_W.ny+(*XbWVWd_W.sy)/2);
  };
/*}}}  */
/*{{{  XbWFWd_LockOFF(     ***    Schutz AUS*/
void  XbWFWd_LockOFF(void){
  *XbWVWd_W.wfx = 0;
  *XbWVWd_W.wfe = 0;
  };
/*}}}  */
/*{{{  XbWFWd_ChkDisp(     ***    Check ob Hintergrund-Display von Wdws noetig*/
void  XbWFWd_ChkDisp(int sofort){
  XbWDDb_DbIWdw MPW;
  time_t ntime;
  char anam[20];
  if (XbWVWd_Time > 0) {
    ntime = XbWVSy_Time;
    if (ntime <= XbWVWd_Time+3) {
      if (!sofort) return;
      };
    XbWVWd_Time = 0;
    };
  strcpy(anam,(char*)XbWVWd_W.nm);
  XbWFWd_GetList();
  if (XbWVWd_ADspNr > XbWVWd_MaxReg) {
    XbWVWd_Time = XbWVSy_Time;
    XbWVWd_ADspNr = 0;
    };
  if (XbWFWd_GetPara(XbWVWd_ADspNr, &MPW) == 0) {
    }
  else {
    *XbWVWd_W.wov = 0;
    if (strcmp(anam,(char*)MPW.nm) != 0) {
      int draw_wdw_border = 0;
      draw_wdw_border = (*MPW.bd) & 0x10;
      switch ((*MPW.bd)&0x0F) {
        case 3:
                  XbWFGr_CurOFF();
                  if ((*MPW.icn == 1) | (*MPW.wov != 0)){
                    XbWFWd_SwitchTo((char*)MPW.nm,16);
                    }
                  else {
                    XbWFWd_SwitchTo((char*)MPW.nm,0);
                    if (draw_wdw_border) {
                      XbWFWd_Draw();
                      };
                    XbWFWd_Rebuild();
                    };
                  XbWFGr_CurON();
                  break;
        case 2: if (*MPW.icn == 0) {
                  XbWFGr_CurOFF();
                  if ((*MPW.icn == 1) | (*MPW.wov != 0)){
                    XbWFWd_SwitchTo((char*)MPW.nm,16);
                    }
                  else {
                    XbWFWd_SwitchTo((char*)MPW.nm,0);
                    if (draw_wdw_border) {
                      XbWFWd_Draw();
                      };
                    XbWFWd_Rebuild();
                    };
                  XbWFGr_CurON();
                  };
                break;
        case 1: if ((*MPW.icn == 0) & (*MPW.wov == 0)) {
                  XbWFGr_CurOFF();
                  XbWFWd_SwitchTo((char*)MPW.nm,0);
                  XbWFWd_Rebuild();
                  XbWFGr_CurON();
                  };
                break;
        };
      };
    };
  XbWVWd_ADspNr++;
  };
/*}}}  */
/*{{{  XbWFWd_ChkAct(      ***    Check auf Hintergrund-Aktion von Objekten*/
void  XbWFWd_ChkAct(int sofort){
  time_t ntime;
  char sstr[40];
  int ii;
  /*int suchnummer=0;*/
  XbWDDb_DbIVar  *sv_gp;
 
  ntime = XbWVSy_Time;
  if (ntime <= XbWVSy_AltChkActTime+2){
    if(!sofort)return;
    };
  XbWVSy_AltChkActTime = ntime;
 
  sv_gp = XbWFDb_FindGrp("SVR","ed_obj");
  if (sv_gp != NULL){
    char *obj_nam;
    ii=0;
    sprintf(sstr,"o%d",ii);
    while ((obj_nam = (char*)XbWFDb_VarInh(sv_gp,XbWDDb_Str,sstr,1)) != NULL){
      sv_gp = XbWFDb_FindGrp("OBJ",obj_nam);
      if (sv_gp != NULL){
        char *wdwname;
        wdwname = (char*)XbWFDb_VarInh(sv_gp,XbWDDb_Str,"W",1);
        XbWFWd_SwitchTo(wdwname,0);
        XbWFOb_EditAndDisp(obj_nam,1);
        };
      ii++;
      sprintf(sstr,"o%d",ii);
      };
    };
  };
/*}}}  */
/*{{{  XbWFWd_OManager(    ***    Hauptroutine bei PopUpWindow*/
void  XbWFWd_OManager(int popup, char *wname){
  unsigned char tastencode1,tastencode2;
  char teststr[160],*pptr;
  int warn_state = 0;
  XbWDDb_DbIVar  *grp_ptr;
  int strmode = 0;
  XbWDDb_DbIWdw MPW;
  XbWFGr_CurOFF();
  XbWSMs_Warp(10,10);
 
  if (popup){
    XbWFWd_SwitchTo(wname,1);
    XbWFWd_Draw();
    XbWFWd_Rebuild();
    *XbWVWd_W.wfx = 1;
    };
  XbWFGr_CurON();
  MPW = XbWVWd_W;
  XbWSMs_SetArrowCursor();
  while(XbWVWd_Activ){
    XbWPSy_SystemManagerHook(&XbWVWd_W);
#ifdef XbW_SYSDEF_X11_VERSION
    { XEvent event;
      long lastexpose=0,neuexpose;
      for ( ; ; ) {
        XbWVMs_LButt = 0;
        XbWVMs_RButt = 0;
        XbWVMs_MButt = 0;
        XbWVMs_Button = 0;
        XbWVSy_Time = XbWSSy_TimeSec();
        while(1){
          if (XCheckTypedWindowEvent(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.window,Expose,&event)) break;
          if (XCheckTypedWindowEvent(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.window,EnterNotify,&event)) break;
          if (XCheckTypedWindowEvent(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.window,MotionNotify,&event)) break;
          if (XCheckTypedWindowEvent(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.window,KeyPress,&event)) break;
          if (XCheckTypedWindowEvent(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.window,ButtonPress,&event)) break;
          XbWVSy_Time = XbWSSy_TimeSec();
          usleep(30000);
          if (! *XbWVWd_W.wfx ) {
            XbWFWd_ChkAct(0);
            };
          };
        XbWVSy_Time = XbWSSy_TimeSec();
        XbWVSy_AltChkActTime=XbWVSy_Time;
        switch(event.type){
          case Expose:
            if (lastexpose < (neuexpose=XbWSSy_TimeSec()) ){
              lastexpose=neuexpose;
              XbWFWd_BackGr();
              XbWFWd_DrawAll();
              };
            break;
          case EnterNotify:
          case MotionNotify:
            goto XbW_OManagerWeiter;
            break;
          case KeyPress:
            {
              KeySym keysym;
              int n;
              char string[257];
              XKeyEvent *keyevent;
              keyevent = (XKeyEvent *)&event;
              string[0]=0;
              n = XLookupString(keyevent, string, 256, &keysym, NULL);
              strncpy(XbWVSy_ConTxt.key,string,255);
              XbWVSy_ConTxt.key[255] = 0;
              XbWVSy_ConTxt.keysym = keysym;
              XbWVSy_ConTxt.is_a_key_waiting = 1;
              goto XbW_OManagerWeiter;
              };
          case ButtonPress:
            { int rootx,rooty,winx,winy,mask;
              Window root, child;
              if ( XQueryPointer(
                     XbWVSy_ConTxt.dpy,
                     XbWVSy_ConTxt.window,
                     &root, &child,
                     &rootx, &rooty,
                     &winx, &winy,
                     &mask
                     )
                   ){
                XbWVMs_Button = 0;
                XbWVMs_LButt = 0;
                XbWVMs_MButt = 0;
                XbWVMs_RButt = 0;
                if (mask & Button1Mask){
                  XbWVMs_LButt = 1;
                  XbWVMs_Button = 1;
                  };
                if (mask & Button2Mask){
                  XbWVMs_MButt = 1;
                  XbWVMs_Button = 1;
                  };
                if (mask & Button3Mask){
                  XbWVMs_RButt = 1;
                  XbWVMs_Button = 1;
                  };
                XbWVMs_XPos = winx;
                XbWVMs_YPos = winy;
                goto XbW_OManagerWeiter;
                };
              };
            break;

          };
        };
      };
    XbW_OManagerWeiter:;
#endif
 
    if (XbWVWd_W.wfx != NULL) {
      /*{{{  */
      if ( *XbWVWd_W.wfx ) {
        if (!XbWFTb_InBox(XbWVMs_XPos,XbWVMs_YPos,
            *XbWVWd_W.nx,*XbWVWd_W.ny,
            *XbWVWd_W.nx+*XbWVWd_W.sx,*XbWVWd_W.ny+*XbWVWd_W.sy)) {
          /* XbWSMs_SetStopCursor();*/
          if (warn_state != 1){
            XbWFTb_Warning("Please quit the active window explicitly!");
            warn_state = 1;
            };
          }
        else  {
          XbWSMs_SetArrowCursor();
          if (warn_state != 2){
            XbWFTb_Message("XbW - Multiwindow Dialogmanager.");
            warn_state = 2;
            };
          };
        }
      else {
        if (XbWVMs_PtrActualPtr != XbWVMs_PtrPtrArrow){
          XbWSMs_SetArrowCursor();
          };
        };
      
      if (popup) {
        if (! *XbWVWd_W.wfx ) {
          XbWFGr_CurOFF();
          XbWFWd_RestImage(&XbWVWd_W);
          if (MPW.nm != NULL){
            XbWFWd_SwitchTo((char*)MPW.nm,0);
            };
          XbWFGr_CurON();
          return;
          };
        };
      /*}}}  */
      }
 
    if (XbWVSy_ConTxt.is_a_key_waiting){
      while (!XbWSMs_IsAKey(1)){;};
      XbWSMs_GetKey(&tastencode2,&tastencode1);
 
      strmode = 0;
      if (XbWFWd_NotInWdw()==1)   {
        XbWFGr_CurOFF();
        XbWFWd_SlctOther();
        XbWVEd_nxt = Vor;
        };
      if ((!tastencode1)&(tastencode2 == 82)){
        if (XbWVEd_ins == 1) { XbWVEd_ins = 0;}  /* INSERT */
        else {XbWVEd_ins = 1;};
        XbWFEd_OutIns();
        };
 
      if ( ((tastencode1 >= 'a') & (tastencode1 <= 'z')) ||
           ((tastencode1 >= 'A') & (tastencode1 <= 'Z')) ||
           ((tastencode1 >= '0') & (tastencode1 <= '9')) ||
            (tastencode1 == '\\') | (tastencode1 == '@') ||
            (tastencode1 == '?') ||
            (tastencode1 == ' ')                          ) {
        XbWFGr_CurOFF();
        if (tastencode1 != ' ') {
          if (XbWVWd_CStr[0] == 0) {
            XbWVWd_CStr[1] = 0;
            };
          XbWVWd_CStr[0] = (char)tastencode1;
          XbWFEd_GetSStr("Command:",XbWVWd_CStr,98,1);
          }
        else {
          XbWVWd_CStr[0] = 0;
          XbWFEd_GetSStr("Command:",XbWVWd_CStr,98,1);
          };
        XbWVWd_CErr = 0;
        strcpy(XbWVWd_CStr,(char*)XbWFTb_PckTxt(XbWVWd_CStr));
        strmode = 1;
        sprintf(teststr,"Executing %s...",XbWVWd_CStr);
        XbWFTb_Message(teststr);
        XbWFMf_ReadMakro(XbWVWd_CStr);
        goto makro_beendet;
        }
      else {
        sprintf(teststr,"%s:%d.%d",(char*)XbWVWd_W.nm,tastencode1,tastencode2);
        };
      XbWFGr_CurOFF();
      if ((grp_ptr = XbWFDb_FindGrp("KEY",teststr)) != NULL) {
        if ((pptr = (char*)XbWFDb_VarInh(grp_ptr,XbWDDb_Str,"T",1)) != NULL) {
          XbWFMf_ReadMF(pptr);
          };
        if ((pptr = (char*)XbWFDb_VarInh(grp_ptr,XbWDDb_Str,"K",1)) != NULL) {
          XbWFMf_ReadMakro(pptr);
          };
        if ((pptr = (char*)XbWFDb_VarInh(grp_ptr,XbWDDb_Str,"O",1)) != NULL) {
          XbWFOb_EditAndDisp(pptr,1);
          };
        if ((pptr = (char*)XbWFDb_VarInh(grp_ptr,XbWDDb_Str,"W",1)) != NULL) {
          XbWFWd_SwitchTo(pptr,16);
          };
        }
      else {
        if (!strmode) {
          sprintf(teststr,"@XW:%d.%d",tastencode1,tastencode2);
          }
        else {
          sprintf(teststr,"@XW:%s",XbWVWd_CStr);
          };
        if ((grp_ptr = XbWFDb_FindGrp("KEY",teststr)) != NULL) {
          if ((pptr = (char*)XbWFDb_VarInh(grp_ptr,XbWDDb_Str,"T",1)) != NULL) {
            XbWFMf_ReadMF(pptr);
            };
          if ((pptr = (char*)XbWFDb_VarInh(grp_ptr,XbWDDb_Str,"K",1)) != NULL) {
            XbWFMf_ReadMakro(pptr);
            };
          if ((pptr = (char*)XbWFDb_VarInh(grp_ptr,XbWDDb_Str,"O",1)) != NULL) {
            XbWFOb_EditAndDisp(pptr,1);
            };
          if ((pptr = (char*)XbWFDb_VarInh(grp_ptr,XbWDDb_Str,"W",1)) != NULL) {
            XbWFWd_SwitchTo(pptr,16);
            };
          }
        else {
          if (tastencode1 == 0){
            switch (tastencode2){
              case 83:                       /* DEL */
                       XbWFGr_CurOFF();
                       if (((*XbWVWd_W.icn) ) == 0) {
                         XbWFOb_MovToPos(&XbWVWd_W,XbWVMs_CX,XbWVMs_CY);
                         XbWSMs_WButtUp(); XbWFGr_CurON();
                         };
              case 113:XbWSMs_DrReset(); break; /* Alt-F10 */

              default: XbWFTb_HBeep();
                       break;
              };
            }
          else {
            if (strmode) {
              sprintf(teststr,"!? %s ?! Sorry.",XbWVWd_CStr);
              XbWFTb_Message(teststr);
              XbWFTb_HBeep();
              XbWVWd_CErr = 1;
              };
            };
          };
        };
      };
    makro_beendet:;
    XbWVSy_Time = XbWSSy_TimeSec();
    if (! *XbWVWd_W.wfx ) {
      XbWFWd_ChkAct(0);
      XbWFWd_ChkDisp(0);
      };
    if (XbWVMs_Bewegt==1)   {
      XbWFGr_CurOFF();
      XbWVMs_CX = XbWVMs_XPos; XbWVMs_CY = XbWVMs_YPos;
      };
    XbWFGr_CurON();
    if (XbWVMs_Button==1)   {
      if (XbWVMs_LButt==1)   {
        XbWVMs_CX = XbWVMs_XPos; XbWVMs_CY = XbWVMs_YPos;
        if (((*XbWVWd_W.icn) ) == 0) {
          if (XbWFWd_InInner()==1){
            XbWFGr_CurOFF();
            XbWVEd_nxt = Vor;
            XbWFOb_EdObjMausPos(&XbWVWd_W,XbWVMs_CX,XbWVMs_CY);
            goto stp2;
            };
          };
        if (XbWFWd_NotInWdw()==1)   {
          if ((!popup)&&(!(*XbWVWd_W.wfx))) {
            XbWFGr_CurOFF();
            XbWFWd_SlctOther();
            XbWVEd_nxt = Vor;
            if (XbWFWd_InInner()==1){
              XbWFOb_EdObjMausPos(&XbWVWd_W,XbWVMs_CX,XbWVMs_CY);
              };
            goto stp2;
            }
          else {
            XbWFTb_HBeep();
            goto stp2;
            };
          };
        };
      if (XbWVMs_RButt==1)   {
        XbWVMs_CX = XbWVMs_XPos; XbWVMs_CY = XbWVMs_YPos;
        if ((!popup)&(!(*XbWVWd_W.wfx))) {
          XbWFGr_CurOFF();
          if (XbWFWd_NotInWdw()==1)   {
            XbWFWd_SlctOther();
            };
          XbWVEd_nxt = Vor;
          if (XbWFWd_InInner()==1){
            XbWFOb_GiveInfo(&XbWVWd_W,XbWVMs_CX,XbWVMs_CY,0);
            goto stp2;
            };
          };
        goto stp2;
        };
      if (XbWVMs_MButt==1)   {
        XbWVMs_CX = XbWVMs_XPos; XbWVMs_CY = XbWVMs_YPos;
        XbWFGr_CurOFF();
        if ((!popup)&(!(*XbWVWd_W.wfx))) {
          if (XbWFWd_NotInWdw()==1)   {
            XbWFWd_SlctOther();
            };
          XbWVEd_nxt = Vor;
          };
        if (XbWFWd_InInner()==1){
          XbWFOb_MovToPos(&XbWVWd_W,XbWVMs_CX,XbWVMs_CY);
          XbWSMs_WButtUp(); XbWFGr_CurON();
          };
        };
      stp2:;
      XbWFGr_CurON();
      };
    };
  };
/*}}}  */
/*{{{  XbWFWd_WManager(    ***    Hauptroutine zur Fensterverwaltung*/
void  XbWFWd_WManager(void){
  XbWFWd_OManager(0," ");
  };
/*}}}  */

/*{{{  XbWFWd_PopUp(       ***    (PopUpWindow)*/
void  XbWFWd_PopUp(void  *(*p)[]){
  if ((int)(*p)[0] > 0) {
    XbWFWd_OManager(1,(char*)(*p)[1]);
    };
  };
/*}}}  */
/*{{{  XbWFWd_SaveRestore( ****/
void  XbWFWd_SaveRestore(XbWDDb_DbIWdw  *WI, int read){
  FILE *fp;
  XbWDGr_VidFram *vf;
  int ii;
  char fname[80]; int vh;
  sprintf(fname,"\\xw\\scratch\\%s.buf",WI->nm);
  if (read) {
    fp = XbWSSy_fopen(fname,"rb");
    }
  else {
    fp = XbWSSy_fopen(fname,"wb");
    };
  if (fp != NULL){
    vf = (XbWDGr_VidFram*)XbWSSy_AlocMem(1,sizeof(XbWDGr_VidFram));
    if (vf != NULL){
      if (read){
        fread(vf,1,20,fp);
        vh = vf->dy;
        fseek(fp,0,SEEK_SET);
        }
      else {
        for (ii = 4;ii < 100; ii+=4){
          vh = ii;
          if ((long)XbWSGr_GtImSiz(*WI->nx-2,0,*WI->nx+ *WI->sx+4,vh+2) > 65000l){
            ii = 300; vh-=4;
            };
          };
        vf->dy = vh;
        };

      XbWFGr_MaxPort();
      for (ii=0;vh*(ii-1)< *WI->sy +2;ii++){
        if (!read){
          XbWSGr_GetImag(  *WI->nx-2,*WI->ny +vh*ii-2,
                     *WI->nx+*WI->sx+2,*WI->ny +vh*ii-2+vh,vf->buf);
          fwrite(vf,(sizeof(XbWDGr_VidFram)/1000)+1,1000,fp);
          }
        else {
          if (fread(vf,(sizeof(XbWDGr_VidFram)/1000)+1,1000,fp) == 1){
            XbWSGr_PutImag(*WI->nx-2,*WI->ny +vh*ii-2,vf->buf,COPY_PUT);
            };
          };
        };
      fclose(fp);
      XbWFGr_ResPort();
      XbWSSy_FreeMem(vf);
      };
    };
  };
/*}}}  */
/*{{{  XbWFWd_SaveImage(   ****/
void  XbWFWd_SaveImage(XbWDDb_DbIWdw  *WI){
  XbWFWd_SaveRestore(WI,0);
  };
/*}}}  */
/*{{{  XbWFWd_RestImage(   ****/
void  XbWFWd_RestImage(XbWDDb_DbIWdw  *WI){
  XbWFWd_SaveRestore(WI,1);
  };
/*}}}  */

/*{{{  XbWFEd_MaxPort(     ***    ViewPort-Routine fuer Texteditor*/
void  XbWFEd_MaxPort(void){
  if (XbWVEd_mvport) {
    XbWFGr_SetPort();
    }
  else {
    XbWFGr_MaxPort();
    };
  };
/*}}}  */
/*{{{  XbWFEd_MinPort(     ***    dito*/
void  XbWFEd_MinPort(void){
  if (XbWVEd_mvport) {
    XbWFGr_SetPort();
    }
  else {
    XbWFGr_PopPort();
    XbWFGr_ResPort();
    XbWFGr_PushPort();
    };
  };
/*}}}  */
/*{{{  XbWFEd_OutIns(      ***    Zustand der Insert-Lampe*/
void  XbWFEd_OutIns(void){
   XbWFGr_SetPort();
   if (XbWVEd_ins == 1)   {
     XbWSGr_TLBox(
       XbWSGr_GtPhysX()-135,XbWSGr_GtPhysY()-XbWDWd_BordH,XbWSGr_GtPhysX()-78,XbWSGr_GtPhysY()-1,
       "Insert",XbWVGr_Red,XbWVGr_White,XbWVGr_LRed);
     }
   else {
     XbWSGr_TLBox(
       XbWSGr_GtPhysX()-135,XbWSGr_GtPhysY()-XbWDWd_BordH,XbWSGr_GtPhysX()-78,XbWSGr_GtPhysY()-1,
       "Overwr.",XbWVGr_White,XbWVGr_Blue,XbWVGr_White);
     };
   XbWFEd_MaxPort();
   };
/*}}}  */
/*{{{  XbWFEd_TextXY(      ***    TextXY fuer Texteditor*/
void  XbWFEd_TextXY(int x,int y, int cur, char msg[255], unsigned char col){
 char hmsg[2] = " ";
 XbWFEd_MinPort();
 hmsg[0] =msg[cur];
 XbWSGr_TLBox(x,y-XbWFGr_THeight(),
   XbWVEd_xb,XbWVEd_yb,
   msg,XbWVGr_White,col,XbWVGr_LRed);
 if (XbWSSy_TimeSec() & 1) {
   XbWSGr_TLBox(x+1+cur*XbWFGr_TWidth("M"),y-XbWFGr_THeight(),
     x+2+(cur+1)*XbWFGr_TWidth("M"),XbWVEd_yb,
     hmsg,XbWVGr_Black,XbWVGr_White,XbWVGr_Black);
   }
 else {
   XbWSGr_TLBox(x+1+cur*XbWFGr_TWidth("M"),y-XbWFGr_THeight(),
     x+2+(cur+1)*XbWFGr_TWidth("M"),XbWVEd_yb,
     hmsg,XbWVGr_White,XbWVGr_Black,XbWVGr_White);
   };
 XbWFEd_MaxPort();
 };
/*}}}  */
/*{{{  XbWFEd_OutLine(     ***    Textzeile ausgeben*/
void  XbWFEd_OutLine(void){
    char buffer[255]; int textw;
    /*
    Den Zustand des Insert- Flags anzeigen (ob Einf"ugen oder "Uberschreiben
    des strings.
    */
    XbWFEd_OutIns();
    /*
    Den aktuell zu bearbeitenden string {\bf XbWVEd_zstr } nach der Breite des
    aktuellen Fensters ausrichten. Dazu wird XbWVEd_zstr solange verkleinert, bis er
    gerade in die Editierzeile pa"st. Hier macht sich die Proportional-
    darstellung der Texte sehr angenehm bemerkbar.
    Zun"achst wird der Teil des strings bis zur Cursorposition bestimmt.
    */
    XbWVEd_lcnt = 0;
    strncpy(buffer,&XbWVEd_zstr[XbWVEd_lcnt],XbWVEd_crpos-XbWVEd_lcnt);
    buffer[XbWVEd_crpos-XbWVEd_lcnt]=0;
    textw = (XbWFGr_TWidth("M"))*strlen(buffer);
    while ((XbWVEd_lcnt < XbWVEd_crpos) &
       (textw >  XbWVEd_xb-XbWVEd_xa-5)) {
      XbWVEd_lcnt ++;
      strncpy(buffer,&XbWVEd_zstr[XbWVEd_lcnt],XbWVEd_crpos-
        XbWVEd_lcnt);
      buffer[XbWVEd_crpos-XbWVEd_lcnt+1]=0;
      textw = (XbWFGr_TWidth("M"))*strlen(buffer);
      }

    /*
    Wenn sich etwas ge"andert hat, mu"s der string anders ausgegeben werden.
    Dazu ist das Feld zu l"oschen, das XbWVEd_zstr belegt.
    */
    XbWFEd_MinPort();
    if ((XbWVEd_lcnt != XbWVEd_vpos) & (XbWVEd_lcnt-1 > 0)) {};

    {  XbWSGr_TLBox(XbWVEd_xhp,XbWVEd_yhp+1,XbWVEd_xb,XbWVEd_yb,
        NULL,XbWVGr_White,0,XbWVGr_White);};
    XbWFEd_MaxPort();

    /*
    Jetzt erst {\bf XbWVEd_vpos } setzen, weil sonst obige Pr"ufung fehlschlagen
    w"urde.
    */
    XbWVEd_vpos = XbWVEd_lcnt;

    /*
    Jetzt den aktuellen Header ausgeben. Dies ist der fr"uhestm"ogliche
    Zeitpunkt, da sich sonst die diversen "Uberpr"ufungen "uberschneiden
    w"urden.
    */
    XbWFEd_MinPort();
    XbWSGr_TLBox(XbWVEd_xhp,XbWVEd_ya+1,0,0,XbWVEd_hdr,XbWVGr_White,XbWVGr_Red,XbWVGr_White);
    XbWFEd_MaxPort();

    /*
    Pr"ufe, ob nach dem Cursor noch Platz f"ur den Rest des strings ist.
    Wenn ja, so viel wie m"oglich darstellen.
    */
    XbWVEd_lcnt = XbWVEd_crpos;
    strncpy(buffer,&XbWVEd_zstr[XbWVEd_vpos],XbWVEd_lcnt-XbWVEd_vpos);
    buffer[XbWVEd_lcnt-XbWVEd_vpos]=0;
    textw = strlen(buffer)*(XbWFGr_TWidth("M"));
    while ((XbWVEd_lcnt < strlen(XbWVEd_zstr)) &
        (textw < (XbWVEd_xb-XbWVEd_xa-5))){
      XbWVEd_lcnt++;
      strncpy(buffer,&XbWVEd_zstr[XbWVEd_vpos],XbWVEd_lcnt-
        XbWVEd_vpos);
      buffer[XbWVEd_lcnt-XbWVEd_vpos]=0;
      textw = strlen(buffer)*(XbWFGr_TWidth("M"));
      };
    XbWVEd_npos = XbWVEd_lcnt;

    /*
    Ein paar generelle checks folgen.
    */
    if (XbWVEd_vpos == strlen(XbWVEd_zstr))   {
      XbWVEd_vpos = strlen(XbWVEd_zstr)-2;}
    if (XbWVEd_vpos < 0)   {XbWVEd_vpos = 0;};
    if (XbWVEd_npos > strlen(XbWVEd_zstr))   {
      XbWVEd_npos = strlen(XbWVEd_zstr);};

    /*
    Jetzt den auszugebenden Text aus dem string kopieren.
    */
    strncpy(XbWVEd_coptxt,&XbWVEd_zstr[XbWVEd_vpos],XbWVEd_npos-
      XbWVEd_vpos+1);
    XbWVEd_coptxt[XbWVEd_npos-XbWVEd_vpos+1]=0;

    XbWVEd_send = (XbWFGr_TWidth("M"))*strlen(buffer);
    XbWFEd_MinPort();
    XbWFEd_TextXY(XbWVEd_xa,XbWVEd_yb+1,XbWVEd_crpos,XbWVEd_coptxt,
      XbWVEd_scol);

    XbWFEd_MinPort();

    /*
    Die beiden den string seitlich begrenzenden Doppelbalken ausgeben.
    */
    if ((XbWVEd_npos != strlen(XbWVEd_zstr)) &
        (strlen(XbWVEd_zstr)!=0))   {
      XbWSGr_VLin(XbWVEd_xa+XbWVEd_send+1,XbWVEd_ya+2,
        XbWVEd_yb-2,XbWVGr_Red);
      XbWSGr_VLin(XbWVEd_xa+XbWVEd_send+2,XbWVEd_ya+2,
        XbWVEd_yb-2,XbWVGr_Red);
      XbWSGr_VLin(XbWVEd_xa+XbWVEd_send+3,XbWVEd_ya+2,
        XbWVEd_yb-2,XbWVGr_Red);
      };
    if (XbWVEd_vpos != 0)   {
      XbWSGr_VLin(XbWVEd_xa-4,XbWVEd_ya+2,
        XbWVEd_yb-2,XbWVGr_Red);
      XbWSGr_VLin(XbWVEd_xa-3,XbWVEd_ya+2,
        XbWVEd_yb-2,XbWVGr_Red);
      XbWSGr_VLin(XbWVEd_xa-2,XbWVEd_ya+2,
        XbWVEd_yb-2,XbWVGr_Red);
      };

    };
/*}}}  */
/*{{{  XbWFEd_OutStr(      ***    Textstring ausgeben, ruft OutLine*/
void  XbWFEd_OutStr(void){
   XbWFGr_CurOFF();
   XbWFEd_MinPort();
   XbWSGr_TLBox(XbWVEd_xhp,XbWVEd_yhp+1,XbWVEd_xb,XbWVEd_yb,
     XbWVEd_hdr,
     XbWVGr_White,XbWVEd_hcol,XbWVGr_White);
   XbWFEd_OutLine();
   XbWFEd_MaxPort();
   };
/*}}}  */
/*{{{  XbWFEd_GetStr(      ***    Unterprogramm fuer Editor*/
void  XbWFEd_GetStr(void){
   int ccc,len,cursormrk;
   cursormrk = XbWVMs_CSet;
   XbWFGr_CurOFF();
   XbWVEd_nxt = Vor;
   XbWVEd_zc = ' ';XbWVEd_vpos = 0;XbWVEd_npos = 0;
   XbWVEd_hdr[12] = '.';
   XbWVEd_hdr[13] = '.';
   XbWVEd_hdr[14] = 0;
   strcpy(XbWVEd_zstr,XbWVEd_sst);XbWVEd_crpos = XbWVEd_cpos;XbWFEd_OutStr();
   XbWSMs_WButtUp();
   while (XbWVEd_zc != 13) {
     time_t oldtime = XbWSSy_TimeSec();
     XbWVMs_LButt = 0;
     while (1) {
       if (XbWSMs_IsAKey(0)){
         XbWSMs_GetKey(&XbWVEd_zf,&XbWVEd_zc);
         break;
         };
       if (XbWSSy_TimeSec() != oldtime) {
         XbWFEd_OutStr();
         oldtime = XbWSSy_TimeSec();
         };
       if (XbWVMs_LButt){
         XbWVEd_zc = 13;
         break;
         };
       };
     printf("Keys: %d %d\n",XbWVEd_zf,XbWVEd_zc);
     switch (XbWVEd_zc) {
       case 255:break;
       case (13): {XbWVEd_nxt = Vor;break;};  /* RETURN : ende mit VOR */
       case (27): {XbWVEd_nxt = EndInput; /* ESC : ende mit ENDINPUT */
                   strcpy(XbWVEd_zstr,XbWVEd_sst);XbWVEd_zc = 13;break;};
 
       /* DELETE und BACKSPACE sind wegen Linux XFree86 vertauscht! */
 
       case (8):   /* DELETE */
                   for(ccc=XbWVEd_crpos;XbWVEd_zstr[ccc]!=0;ccc++){
                     XbWVEd_zstr[ccc] = XbWVEd_zstr[ccc+1];}
                   XbWFEd_OutStr();break;
       case 7:
       case (127):  {if (XbWVEd_crpos >= 0)   { /* BackSpace */
                   for(ccc=XbWVEd_crpos-1;XbWVEd_zstr[ccc]!=0;ccc++){
                   XbWVEd_zstr[ccc] = XbWVEd_zstr[ccc+1];}
                   if (XbWVEd_crpos > 0)   {XbWVEd_crpos--;};
                   XbWFEd_OutStr();};break;};
       case (0):  {
              switch (XbWVEd_zf) {
              case ('O'): {
                        XbWVEd_crpos = strlen(XbWVEd_zstr);
                        XbWFEd_OutStr();break;}; /* End */
              case ('G'): {XbWVEd_crpos = 0;
                        XbWFEd_OutStr();break;};  /* Pos1 */
              case ('R'): {if (XbWVEd_ins == 1) {
                          XbWVEd_ins = 0;}  /* INSERT */
                        else {XbWVEd_ins = 1;};
                        XbWFEd_OutIns();break;};
              case ('S'): {if (XbWVEd_crpos >= 0)   {
                          for (ccc=XbWVEd_crpos;XbWVEd_zstr[ccc]!=0;
                            ccc++){XbWVEd_zstr[ccc]=
                              XbWVEd_zstr[ccc+1];}; /* DELETE */
                          XbWFEd_OutStr();};break;};
              case (77): {if (XbWVEd_crpos < strlen(XbWVEd_zstr)){
                          XbWVEd_crpos++;
                          XbWFEd_OutLine();};break;}; /* RECHTS */
              case (75): {if (XbWVEd_crpos > 0)   {
                          /* CURSOR links */
                          XbWVEd_crpos--;XbWFEd_OutLine();};break;};
              case (80): {XbWVEd_zc = 13;XbWVEd_nxt = CursorDown;
                        break;}; /* Cursor DOWN */
              case (72): {XbWVEd_zc = 13;XbWVEd_nxt = CursorUp;
                        break;};   /* Cursor UP */
              case (81): {XbWVEd_zc = 13;XbWVEd_nxt = PageDown;
                        break;};  /* PAGE DOWN */
              case (73): {XbWVEd_zc = 13;XbWVEd_nxt = PageUp;
                        break;}; /* PAGE UP */
              };
              break;};
       default:{
         if (XbWVEd_zc >= 20 )   {
           if (XbWVEd_ins == 1)   {
             len = strlen(XbWVEd_zstr);
             for (ccc=len+1;ccc >=XbWVEd_crpos;ccc--) {
               XbWVEd_zstr[ccc] = XbWVEd_zstr[ccc-1];}
             XbWVEd_zstr[XbWVEd_crpos] = XbWVEd_zc;XbWVEd_crpos++;
             XbWFEd_OutStr();
             }
           else {if (XbWVEd_crpos >= strlen(XbWVEd_zstr))   {
               len = strlen(XbWVEd_zstr);XbWVEd_zstr[len] = XbWVEd_zc;
               XbWVEd_zstr[len+1] = 0;}
             else {
               XbWVEd_zstr[XbWVEd_crpos] = XbWVEd_zc;};
             XbWVEd_crpos++;XbWFEd_OutStr();
           };};
         break;
         };
       };
     };
   XbWFGr_CurOFF();
   };
/*}}}  */
/*{{{  XbWFEd_GetAStr(     ***    Unterprogramm; ruft GetStr*/
void  XbWFEd_GetAStr(void) {
  int cursormrk;
  cursormrk = XbWVMs_CSet;
  XbWVEd_cpos = 0;
  XbWVEd_mvport = 0;
  XbWFEd_GetStr();
  if (cursormrk == 1) {
    XbWFGr_CurON();
    };
  };
/*}}}  */
/*{{{  XbWFEd_GetSStr(     ***    String in Standard-Texteingabezeile einlesen*/
void  XbWFEd_GetSStr(char *chdr, char *string,int MaxLen, int CurPos){

/* ---------------- XbWFEd_GetSStr() ---------------------------------------
   Hier wird ein String auf dem Grafikbildschirm in der Standard-Text-
   Ausgabezeile eingelesen.
   ----------------------------------------------------------------------- */
  int len;
  /*
  Wir werden den Bildschirm direkt adressieren.
  */
  if (MaxLen == 0) {
    MaxLen = strlen(string)+1;
    };
  if (MaxLen >0) {
    XbWFGr_PushPort();
    XbWVEd_cpos = CurPos;
    XbWVEd_mvport = 1;
    XbWFGr_SetPort();

    XbWSGr_TLBox(0,XbWSGr_GtPhysY()-XbWDWd_BordH-2,XbWSGr_GtPhysX(),
            XbWSGr_GtPhysY(),NULL,XbWVGr_White,0,XbWVGr_White);

    XbWVEd_xhp = 2;
    XbWVEd_yhp = XbWSGr_GtPhysY()-XbWDWd_BordH;

    len = strlen(chdr);
    if (len > 33) { len = 33; };

    strncpy(XbWVEd_hdr,chdr,len);

    XbWVEd_hdr[len] = 0;XbWVEd_hcol = XbWVGr_Red;
    XbWVEd_xa = XbWVEd_xhp + XbWFGr_TWidth(XbWVEd_hdr)+10;
    XbWVEd_ya = XbWVEd_yhp;
    XbWVEd_xb = 500;
    XbWVEd_yb = XbWSGr_GtPhysY()-3;

    strcpy(XbWVEd_sst,string);XbWVEd_sst[255] = 0;XbWVEd_scol = XbWVGr_Blue;
    XbWFEd_GetStr();

    XbWVEd_zstr[MaxLen-1] = 0;
    strcat(XbWVEd_zstr,"                                           ");
    strncpy((char *)string,XbWVEd_zstr,MaxLen-1);
    string[MaxLen-1] = 0;
    XbWFGr_PopPort();
    XbWFGr_ResPort();
    };
  };
/*}}}  */
/*{{{  XbWFEd_GetOStr(     ***    String im Objekt einlesen (xa,ya,xb,yb...)*/
void  XbWFEd_GetOStr(XbWDDb_DbIWdw  *WI,char *string,int MaxLen,
    int XA, int YA, int XB, int YB,char *defaultmsg, int cpo){
  int cursormrk;
  cursormrk = XbWVMs_CSet;
  XbWVEd_cpos = cpo;
  XbWFGr_CurOFF();
  if (XbWVEd_cpos > strlen(string) ){
    XbWVEd_cpos = strlen(string);
    };
  XbWVEd_mvport = 0;
  if (MaxLen == 0) {MaxLen = strlen(string)+1;};
  if (MaxLen >0) {
    XbWFGr_PushPort();
    XbWFTb_Message(defaultmsg);
    XbWFGr_MinPort(
      *WI->nx+5,*WI->ny+*WI->sy+2,
      *WI->nx+*WI->sx+3,*WI->ny+*WI->sy-2);
    XbWFGr_PopPort();
    XbWFGr_ResPort();
    XbWFGr_PushPort();

    XbWVEd_xhp = XA;
    XbWVEd_yhp = YA;
    strcpy(XbWVEd_hdr,"");

    XbWVEd_xa = XA;
    XbWVEd_ya = YA;
    XbWVEd_xb = XB;
    XbWVEd_yb = YB;
    strcpy(XbWVEd_sst,string);
    XbWVEd_sst[255] = 0;
    XbWVEd_scol = XbWVGr_Blue;
    XbWVEd_mvport = 0;
    XbWFEd_GetStr();
    if (cursormrk == 1) {
      XbWFGr_CurON();
      };
    XbWVEd_zstr[MaxLen-1] = 0;
    strcat(XbWVEd_zstr,"                                           ");
    XbWVEd_zstr[MaxLen] = 0;
    strncpy((char *)string,XbWVEd_zstr,MaxLen-1);
    string[MaxLen] = 0;
    XbWFTb_Message(".");
    XbWFGr_PopPort(); XbWFGr_ResPort();
    };
  };
/*}}}  */

/*{{{  XbWFMx_RWGrp(       ***    Unterroutine zum MFX-Gruppe schreiben/lesen*/
int  XbWFMx_RWGrp(char *rgr_nm, char* rgr_rwm,
                         int rw_smode, int rw_snr, char *new_filnm){
  char *rw_filnam,*rw_mode;
  XbWDDb_DbINPtr  *rw_filitm;
  XbWDDb_DbINPtr  *rw_itm;
  char sstr[80];
  char rgr_name[60];

  rw_filitm = (XbWDDb_DbINPtr *)XbWFDb_GetDbI("MFX",rgr_nm,"fil");
  if (rw_filitm == NULL) {return(1);};

  rw_filnam = XbWFTb_PckTxt((char*)XbWFDb_GetStr((XbWDDb_DbIStr  *)rw_filitm));
  if (new_filnm != NULL) {
    rw_filnam = new_filnm;
    };
  if (rw_filnam == NULL) {return(1);};
  switch(rw_smode){
    case 0: strcpy(rgr_name,rgr_nm);
            break;
    case 1: if (strchr(rw_filnam,'.') != NULL) {
              char nsstr[40];
              sprintf(nsstr,".%d",rw_snr);
              strcpy(strchr(rw_filnam,'.'),nsstr);
              }
            else {
              sprintf(rw_filnam,"%s.%d",rgr_nm,rw_snr);
              };
            strcpy(rgr_name,rgr_nm);
            break;
    case 2: if (strchr(rw_filnam,'.') != NULL) {
              char nsstr[40];
              int b,a;
              b = rw_snr/10;
              if (b>9) {
                b=b - (b/100)*100;
                };
              a = rw_snr;
              if (a > 9) {
                a=a - (a/10)*10;
                };
              sprintf(nsstr,".%d%d%d",(rw_snr/100),b,a);
              strcpy(strchr(rw_filnam,'.'),nsstr);
              }
            else {
              int b,a;
              b = rw_snr/10;
              if (b>9) {
                b=b - (b/100)*100;
                };
              a = rw_snr;
              if (a > 9) {
                a=a - (a/10)*10;
                };
              sprintf(rw_filnam,"%s.%d%d%d",rgr_nm,(rw_snr/100),b,a);
              };
            strcpy(rgr_name,rgr_nm);
            break;
    };

  rw_mode = rgr_rwm;
  switch (rw_mode[0]) {
    case 'R': XbWFMx_RdSet(rw_filnam,rgr_name); break;
    case 'W': XbWFMx_WrSet(rw_filnam,rgr_name,0); break;
    case 'A': XbWFMx_WrSet(rw_filnam,rgr_name,1); break;
    default:return(1);
    };

  switch(rw_smode){
    case 0: sprintf(sstr,"%s MFX-Group %s...",rgr_rwm,rgr_name);
            break;
    case 2:
    case 1: sprintf(sstr,"%s MFX-Group %s set %d...",rgr_rwm,rgr_nm,rw_snr);
            break;
    };
  XbWFTb_Message(sstr);

  while(rw_filitm !=NULL) {
    XbWFDb_ForWd((XbWDDb_DbIVar  **)&rw_filitm,XbWDDb_DbISys);
    while (strncmp(rw_filitm->nm,"  ArraySize",strlen("  ArraySize"))==0){
      XbWFDb_ForWd((XbWDDb_DbIVar  **)&rw_filitm,XbWDDb_DbISys);
      };
 
    if (rw_filitm != NULL) {
      if (XbWVMf_prd){
        if ((((XbWDDb_DbIVar  *)rw_filitm)->tp & XbWDDb_Typ) == XbWDDb_GPtr){
          printf("XbW: XBCOM finds End Of MFX Group of file %s\n",rw_filnam);
          }
        else {
          if (rw_mode[0]=='R'){
            printf("XbW: XBCOM reads %s from %s\n",rw_filitm->nm,rw_filnam);
            }
          else {
            printf("XbW: XBCOM writes %s to %s\n",rw_filitm->nm,rw_filnam);
            };
          };
        };
 
      switch (((XbWDDb_DbIVar  *)rw_filitm)->tp & XbWDDb_Typ) {
        case XbWDDb_Int:
          if (rw_mode[0] == 'R'){
            XbWFMx_GetInt((int*)&((XbWDDb_DbIInt *)rw_filitm)->inh);
            }
          else {
            XbWFMx_PutInt(*(int*)&((XbWDDb_DbIInt *)rw_filitm)->inh,
              (char*)XbWFDb_GetNam((XbWDDb_DbIVar *)rw_filitm));
            };
          break;
        case XbWDDb_Dbl:
          if (rw_mode[0] == 'R'){
            XbWFMx_GetDbl((double*)& ((XbWDDb_DbIDbl*)rw_filitm)->inh);
            }
          else {
            XbWFMx_PutDbl(*(double*)& ((XbWDDb_DbIDbl*)rw_filitm)->inh,
              (char*)XbWFDb_GetNam((XbWDDb_DbIVar *)rw_filitm));
            };
          break;
        case XbWDDb_Str:
          if (rw_mode[0] == 'R'){
            XbWFMx_GetStr((char*)XbWFDb_GetStr((XbWDDb_DbIStr  *)rw_filitm));
            }
          else {
            XbWFMx_PutStr((char*)XbWFDb_GetStr((XbWDDb_DbIStr  *)rw_filitm),
              (char*)XbWFDb_GetNam((XbWDDb_DbIVar *)rw_filitm));
            };
          break;

        case XbWDDb_NPtr:
          if (rw_filitm->inh != 0) {
            rw_itm = (XbWDDb_DbINPtr  *)rw_filitm;
            while ((rw_itm->tp & XbWDDb_Typ)== XbWDDb_NPtr){
              if (rw_itm->inh == 0) { rw_itm = NULL;}
              else {
                rw_itm = (XbWDDb_DbINPtr  *)XbWFDb_CDbIToPtr(rw_itm->inh,XbWDDb_DbISys);
                };
              };
            if (rw_itm != NULL) {
              switch (rw_mode[0]) {
                case 'R':
                  switch(rw_itm->tp & XbWDDb_Typ) {
                    case XbWDDb_Int:
                      XbWFMx_GetInt((int*)&((XbWDDb_DbIInt *)rw_itm)->inh); break;
                    case XbWDDb_Dbl:
                      XbWFMx_GetDbl((double*)& ((XbWDDb_DbIDbl*)rw_itm)->inh); break;
                    case XbWDDb_Str:
                      XbWFMx_GetStr((char*)XbWFDb_GetStr((XbWDDb_DbIStr *)rw_itm)); break;
                    default:;
                    };
                case 'W':
                case 'A':
                  switch(rw_itm->tp & XbWDDb_Typ) {
                    case XbWDDb_Int:
                      XbWFMx_PutInt(*((int*)&((XbWDDb_DbIInt *)rw_itm)->inh),
                        (char*)XbWFDb_GetNam((XbWDDb_DbIVar *)rw_filitm)); break;
                    case XbWDDb_Dbl:
                      XbWFMx_PutDbl(*((double*)& ((XbWDDb_DbIDbl*)rw_itm)->inh),
                        (char*)XbWFDb_GetNam((XbWDDb_DbIVar *)rw_filitm)); break;
                    case XbWDDb_Str:
                      XbWFMx_PutStr((char*)XbWFDb_GetStr((XbWDDb_DbIStr *)rw_itm),
                        (char*)XbWFDb_GetNam((XbWDDb_DbIVar *)rw_filitm)); break;
                    default:;
                    };
                };
              };
            };
          break;
        case XbWDDb_GPtr: rw_filitm = NULL; break;
        default:      rw_filitm = NULL; break;
        };
      };
    };
  switch (rw_mode[0]) {
    case 'W': XbWFMx_EndSet(); break;
    case 'A': XbWFMx_EndSet(); break;
    };
  XbWFMx_Close();
  sprintf(sstr,"%s MFX-Group %s done!",rgr_rwm,rgr_name);
  XbWFTb_Message(sstr);
  return(0);
  };
/*}}}  */
/*{{{  XbWFMx_CrGrp(       ***    Headerdatei fuer MFX-Gruppe erstellen*/
int  XbWFMx_CrGrp(char *cgr_name){
  /*{{{  Variablen*/
  int max_brace=0;
  char rw_filnam[60];
  char *sstr,*iomfname;
  XbWDDb_DbINPtr  *rw_filitm;
  XbWDDb_DbINPtr  *rw_start;
  XbWDDb_DbIVar  *rw_itm;
  char *default_return = ",\n";
  char *start_return = "\n";
  char *akt_return;
  FILE *fp;
  
  /*}}}  */
  /*{{{  Datenstruktur fuer Gruppe erzeugen*/
  rw_filitm = (XbWDDb_DbINPtr *)XbWFDb_GetDbI("MFX",cgr_name,"C-Files");
  if (rw_filitm == NULL) {return(1);};
  
  sstr = (char*)XbWFDb_GetStr((XbWDDb_DbIStr  *)rw_filitm);
  if (sstr == NULL) {return(1);};
  
  sprintf(rw_filnam,"%s%s.xbh",sstr,cgr_name);
  
  if ((fp = XbWSSy_fopen(rw_filnam,"wt")) == NULL) {return(1);};
  
  rw_filitm = (XbWDDb_DbINPtr *)XbWFDb_GetDbI("MFX",cgr_name,"fil");
  if (rw_filitm == NULL) {return(1);};
  
  iomfname = (char*)XbWFDb_GetStr((XbWDDb_DbIStr  *)rw_filitm);
  if (iomfname == NULL) {
    fclose(fp);
    return(1);
    };
  
  fprintf(fp,"/* IO-Struct Descr for group %s created by XW */\n\n",cgr_name);
  
  fprintf(fp,"typedef struct {\n");
  
  rw_start = rw_filitm;
  
  akt_return = start_return;
  while(rw_filitm !=NULL) {
    int array_x=0, array_y=0;
    XbWFDb_ForWd((XbWDDb_DbIVar  **)&rw_filitm,XbWDDb_DbISys);
    if (strncmp(rw_filitm->nm,"  ArraySize",strlen("  ArraySize"))==0){
      /*{{{  */
      array_x = *(int*)&((XbWDDb_DbIInt *)rw_filitm)->inh;
      XbWFDb_ForWd((XbWDDb_DbIVar  **)&rw_filitm,XbWDDb_DbISys);
      if (strncmp(rw_filitm->nm,"  ArraySize",strlen("  ArraySize"))==0){
        array_y = *(int*)&((XbWDDb_DbIInt *)rw_filitm)->inh;
        XbWFDb_ForWd((XbWDDb_DbIVar  **)&rw_filitm,XbWDDb_DbISys);
        };
      };
      
      /*}}}  */
    if (rw_filitm != NULL) {
      switch (((XbWDDb_DbIVar  *)rw_filitm)->tp & XbWDDb_Typ) {
        case XbWDDb_Int:
          /*{{{  */
          if (array_x+array_y){
            char sstr[40];
            strcpy(sstr,(char*)XbWFDb_GetNam((XbWDDb_DbIVar *)rw_filitm));
            if (strchr(sstr,'[') != NULL){
              strcpy(strchr(sstr,'['),"\0");
              };
            fprintf(fp,akt_return);
            if ( (array_x!=0) & (array_y!=0)){
              fprintf(fp," int %s[%d][%d]", sstr, array_x,array_y);
              }
            else {
              if (!array_x){
                fprintf(fp," int %s[%d]", sstr, array_y);
                };
              if (!array_y){
                fprintf(fp," int %s[%d]", sstr, array_x);
                };
              };
            }
          else {
            fprintf(fp,akt_return);
            fprintf(fp," int %s",
              (char*)XbWFDb_GetNam((XbWDDb_DbIVar *)rw_filitm));
            };
          break;
          
          /*}}}  */
        case XbWDDb_Dbl:
          /*{{{  */
          if (array_x+array_y){
            char sstr[40];
            strcpy(sstr,(char*)XbWFDb_GetNam((XbWDDb_DbIVar *)rw_filitm));
            if (strchr(sstr,'[') != NULL){
              strcpy(strchr(sstr,'['),"\0");
              };
            fprintf(fp,akt_return);
            if ( (array_x!=0) & (array_y!=0)){
              fprintf(fp," double %s[%d][%d]", sstr, array_x,array_y);
              }
            else {
              if (!array_x){
                fprintf(fp," double %s[%d]", sstr, array_y);
                };
              if (!array_y){
                fprintf(fp," double %s[%d]", sstr, array_x);
                };
              };
            }
          else {
            fprintf(fp,akt_return);
            fprintf(fp," double %s",
              (char*)XbWFDb_GetNam((XbWDDb_DbIVar *)rw_filitm));
            };
          break;
          /*}}}  */
        case XbWDDb_Str:
          /*{{{  */
          if (array_x+array_y){
            char sstr[40];
            strcpy(sstr,(char*)XbWFDb_GetNam((XbWDDb_DbIVar *)rw_filitm));
            if (strchr(sstr,'[') != NULL){
              strcpy(strchr(sstr,'['),"\0");
              };
            fprintf(fp,akt_return);
            if ( (array_x!=0) & (array_y!=0)){
              fprintf(fp," char %s[%d][%d][205]", sstr, array_x,array_y);
              }
            else {
              if (!array_x){
                fprintf(fp," char %s[%d][205]", sstr, array_y);
                };
              if (!array_y){
                fprintf(fp," char %s[%d][205]", sstr, array_x);
                };
              };
            break;
            }
          else {
            fprintf(fp,akt_return);
            fprintf(fp," char %s[205]",
              (char*)XbWFDb_GetNam((XbWDDb_DbIVar *)rw_filitm));
            };
          break;
          /*}}}  */
        case XbWDDb_NPtr:
          /*{{{  */
          if (rw_filitm->inh != 0) {
            rw_itm = (XbWDDb_DbIVar *)XbWFDb_CDbIToPtr(rw_filitm->inh,XbWDDb_DbISys);
            if (rw_itm != NULL) {
              switch(rw_itm->tp & XbWDDb_Typ) {
                case XbWDDb_Int:
                  if (array_x+array_y){
                    char sstr[40];
                    strcpy(sstr,(char*)XbWFDb_GetNam((XbWDDb_DbIVar *)rw_filitm));
                    if (strchr(sstr,'[') != NULL){
                      strcpy(strchr(sstr,'['),"\0");
                      };
                    fprintf(fp,akt_return);
                    if ( (array_x!=0) & (array_y!=0)){
                      fprintf(fp," double %s[%d][%d]", sstr, array_x,array_y);
                      }
                    else {
                      if (!array_x){
                        fprintf(fp," double %s[%d]", sstr, array_y);
                        };
                      if (!array_y){
                        fprintf(fp," double %s[%d]", sstr, array_x);
                        };
                      };
                    }
                  else {
                    fprintf(fp,akt_return);
                    fprintf(fp," int %s",
                      (char*)XbWFDb_GetNam((XbWDDb_DbIVar *)rw_filitm)); break;
                    };
                case XbWDDb_Dbl:
                  if (array_x+array_y){
                    char sstr[40];
                    strcpy(sstr,(char*)XbWFDb_GetNam((XbWDDb_DbIVar *)rw_filitm));
                    if (strchr(sstr,'[') != NULL){
                      strcpy(strchr(sstr,'['),"\0");
                      };
                    fprintf(fp,akt_return);
                    if ( (array_x!=0) & (array_y!=0)){
                      fprintf(fp," int %s[%d][%d]", sstr, array_x,array_y);
                      }
                    else {
                      if (!array_x){
                        fprintf(fp," int %s[%d]", sstr, array_y);
                        };
                      if (!array_y){
                        fprintf(fp," int %s[%d]", sstr, array_x);
                        };
                      };
                    }
                  else {
                    fprintf(fp,akt_return);
                    fprintf(fp," double %s",
                      (char*)XbWFDb_GetNam((XbWDDb_DbIVar *)rw_filitm)); break;
                    };
                case XbWDDb_Str:
                  if (array_x+array_y){
                    char sstr[40];
                    strcpy(sstr,(char*)XbWFDb_GetNam((XbWDDb_DbIVar *)rw_filitm));
                    if (strchr(sstr,'[') != NULL){
                      strcpy(strchr(sstr,'['),"\0");
                      };
                    fprintf(fp,akt_return);
                    if ( (array_x!=0) & (array_y!=0)){
                      fprintf(fp," char %s[%d][%d][205]", sstr, array_x,array_y);
                      }
                    else {
                      if (!array_x){
                        fprintf(fp," char %s[%d][205]", sstr, array_y);
                        };
                      if (!array_y){
                        fprintf(fp," char %s[%d][205]", sstr, array_x);
                        };
                      };
                    break;
                    }
                  else {
                    fprintf(fp,akt_return);
                    fprintf(fp," char %s[205]",
                      (char*)XbWFDb_GetNam((XbWDDb_DbIVar *)rw_filitm)); break;
                    };
                default:;
                };
              };
            };
          break;
          /*}}}  */
        case XbWDDb_GPtr: rw_filitm = NULL; break;
        default:      rw_filitm = NULL; break;
        };
      if (array_x+array_y){
        int kk; int kmax;
        kmax = array_x*array_y;
        if (!array_x){ kmax = array_y; };
        if (!array_y){ kmax = array_x; };
        for (kk=1;kk<kmax;kk++){
          XbWFDb_ForWd((XbWDDb_DbIVar  **)&rw_filitm,XbWDDb_DbISys);
          };
        };
      };
    akt_return = ";\n";
    };
  fprintf(fp,";\n} DATA_%s;\n\n",cgr_name);
  fprintf(fp,"extern DATA_%s %s;\n\n",cgr_name,cgr_name);
  
  fclose(fp);
  /*}}}  */
  /*{{{  Read MFX Gruppe*/
  rw_filitm = (XbWDDb_DbINPtr *)XbWFDb_GetDbI("MFX",cgr_name,"C-Files");
  if (rw_filitm == NULL) {return(1);};
  sstr = (char*)XbWFDb_GetStr((XbWDDb_DbIStr  *)rw_filitm);
  if (sstr == NULL) {return(1);};
  sprintf(rw_filnam,"%s%s.xbc",sstr,cgr_name);
  if ((fp = XbWSSy_fopen(rw_filnam,"wt")) == NULL) {return(1);};
  rw_filitm = (XbWDDb_DbINPtr *)XbWFDb_GetDbI("MFX",cgr_name,"fil");
  if (rw_filitm == NULL) {return(1);};
  iomfname = (char*)XbWFDb_GetStr((XbWDDb_DbIStr  *)rw_filitm);
  if (iomfname == NULL) {
    fclose(fp);
    return(1);
    };
  
  fprintf(fp,"/* XbW-Headerfile for group %s created by XbW */\n\n",cgr_name);
  fprintf(fp,"int XbWReadMFX%s(DATA_%s *grp, char *filename, char *datensatz){\n",cgr_name, cgr_name);
  fprintf(fp,"  int err;\n");
  fprintf(fp,"  if (grp == NULL) { grp = &%s; };\n",cgr_name );
  { int kk;
    char sstr[100];
    strcpy(sstr,cgr_name);
    for (kk=0;kk<strlen(sstr);kk++){
      if ( (sstr[kk] >= 'A')&(sstr[kk] <= 'Z')){
        sstr[kk] |= 0x20;
        };
      };
    fprintf(fp,"  if (filename == NULL) { filename = \"%s.mfx\"; }; \n",sstr);
    };
  fprintf(fp,"  if (datensatz == NULL) { datensatz = \"%s\"; };\n",cgr_name);
  fprintf(fp,"  if ((err=XbWFMx_RdSet(filename,datensatz)) != XbWDMx_RDok) {\n");
  fprintf(fp,"    return(err);\n");
  fprintf(fp,"    };\n");
  rw_start = rw_filitm;
  while(rw_filitm !=NULL) {
    char var_nam[40], grp_nam[40];
    XbWFDb_ForWd((XbWDDb_DbIVar  **)&rw_filitm,XbWDDb_DbISys);
    while (strncmp(rw_filitm->nm,"  ArraySize",strlen("  ArraySize"))==0){
      XbWFDb_ForWd((XbWDDb_DbIVar  **)&rw_filitm,XbWDDb_DbISys);
      };
  
    if (rw_filitm != NULL) {
      strcpy(var_nam,(char*)XbWFDb_GetNam((XbWDDb_DbIVar *)rw_filitm));
      strcpy(grp_nam,cgr_name);
      switch (((XbWDDb_DbIVar  *)rw_filitm)->tp & XbWDDb_Typ) {
        case XbWDDb_Int:
          fprintf(fp,"  if (XbWFMx_GetInt((int*)&grp->%s)!=XbWDMx_RDok){ goto RDerror; };\n",
            var_nam); break;
        case XbWDDb_Dbl:
          fprintf(fp,"  if (XbWFMx_GetDbl((double*)&grp->%s)!=XbWDMx_RDok){ goto RDerror; };\n",
            var_nam); break;
        case XbWDDb_Str:
          fprintf(fp,"  if (XbWFMx_GetStr((char*)grp->%s)!=XbWDMx_RDok){ goto RDerror; };\n",
            var_nam); break;
        case XbWDDb_NPtr:
          if (rw_filitm->inh != 0) {
            rw_itm = (XbWDDb_DbIVar *)XbWFDb_CDbIToPtr(rw_filitm->inh,XbWDDb_DbISys);
            if (rw_itm != NULL) {
              switch(rw_itm->tp & XbWDDb_Typ) {
                case XbWDDb_Int:
                  fprintf(fp,"  if (XbWFMx_GetInt((int*)&grp->%s)!=XbWDMx_RDok){ goto RDerror; };\n",
                    var_nam); break;
                case XbWDDb_Dbl:
                  fprintf(fp,"  if (XbWFMx_GetDbl((double*)&grp->%s)!=XbWDMx_RDok){ goto RDerror; };\n",
                    var_nam); break;
                case XbWDDb_Str:
                  fprintf(fp,"  if (XbWFMx_GetStr((char*)grp->%s)!=XbWDMx_RDok){ goto RDerror; };\n",
                    var_nam); break;
                default:;
                };
              };
            };
          break;
        case XbWDDb_GPtr: rw_filitm = NULL; break;
        default:      rw_filitm = NULL; break;
        };
      };
    };
  fprintf(fp,"  XbWFMx_Close();\n");
  fprintf(fp,"  return(XbWDMx_RDok);\n");
  fprintf(fp,"RDerror:;\n");
  fprintf(fp,"  XbWFMx_Close();\n");
  fprintf(fp,"  return(err);\n  };\n\n");
  /*}}}  */
  /*{{{  Write MFX Gruppe*/
  rw_filitm = (XbWDDb_DbINPtr *)XbWFDb_GetDbI("MFX",cgr_name,"C-Files");
  if (rw_filitm == NULL) {return(1);};
  sstr = (char*)XbWFDb_GetStr((XbWDDb_DbIStr  *)rw_filitm);
  if (sstr == NULL) {return(1);};
  sprintf(rw_filnam,"%s%s.xbc",sstr,cgr_name);
  
  rw_filitm = (XbWDDb_DbINPtr *)XbWFDb_GetDbI("MFX",cgr_name,"fil");
  if (rw_filitm == NULL) {return(1);};
  iomfname = (char*)XbWFDb_GetStr((XbWDDb_DbIStr  *)rw_filitm);
  
  fprintf(fp,"/* XbW-Headerfile for group %s created by XbW */\n\n",cgr_name);
  fprintf(fp,"int XbWWriteMFX%s(DATA_%s *grp, char *filename, char *datensatz){\n",cgr_name, cgr_name);
  fprintf(fp,"  int err;\n");
  fprintf(fp,"  if (grp == NULL) { grp = &%s; };\n",cgr_name );
  fprintf(fp,"  if (filename == NULL) { filename = \"%s.mfx\"; }; \n",cgr_name);
  fprintf(fp,"  if (datensatz == NULL) { datensatz = \"%s\"; };\n",cgr_name);
  fprintf(fp,"  if ((err=XbWFMx_WrSet(filename,datensatz,0)) != XbWDMx_WRok) {\n");
  fprintf(fp,"    return(err);\n");
  fprintf(fp,"    };\n");
  rw_start = rw_filitm;
  while(rw_filitm !=NULL) {
    char var_nam[40], grp_nam[40];
    XbWFDb_ForWd((XbWDDb_DbIVar  **)&rw_filitm,XbWDDb_DbISys);
    while (strncmp(rw_filitm->nm,"  ArraySize",strlen("  ArraySize"))==0){
      XbWFDb_ForWd((XbWDDb_DbIVar  **)&rw_filitm,XbWDDb_DbISys);
      };
  
    if (rw_filitm != NULL) {
      strcpy(var_nam,(char*)XbWFDb_GetNam((XbWDDb_DbIVar *)rw_filitm));
      strcpy(grp_nam,cgr_name);
      switch (((XbWDDb_DbIVar  *)rw_filitm)->tp & XbWDDb_Typ) {
        case XbWDDb_Int:
          fprintf(fp,"  XbWFMx_PutInt((int)grp->%s,\"%s\");\n",
            var_nam,var_nam); break;
        case XbWDDb_Dbl:
          fprintf(fp,"  XbWFMx_PutDbl((double)grp->%s,\"%s\");\n",
            var_nam,var_nam); break;
        case XbWDDb_Str:
          fprintf(fp,"  XbWFMx_PutStr((char*)grp->%s,\"%s\");\n",
            var_nam,var_nam); break;
        case XbWDDb_NPtr:
          if (rw_filitm->inh != 0) {
            rw_itm = (XbWDDb_DbIVar *)XbWFDb_CDbIToPtr(rw_filitm->inh,XbWDDb_DbISys);
            if (rw_itm != NULL) {
              switch(rw_itm->tp & XbWDDb_Typ) {
                case XbWDDb_Int:
                  fprintf(fp,"  XbWFMx_PutInt((int)grp->%s,\"%s\");\n",
                    var_nam,var_nam); break;
                case XbWDDb_Dbl:
                  fprintf(fp,"  XbWFMx_PutDbl((double)grp->%s,\"%s\");\n",
                    var_nam,var_nam); break;
                case XbWDDb_Str:
                  fprintf(fp,"  XbWFMx_PutStr((char*)grp->%s,\"%s\");\n",
                    var_nam,var_nam); break;
                default:;
                };
              };
            };
          break;
        case XbWDDb_GPtr: rw_filitm = NULL; break;
        default:      rw_filitm = NULL; break;
        };
      };
    };
  fprintf(fp,"  XbWFMx_EndSet();\n");
  fprintf(fp,"  XbWFMx_Close();\n");
  fprintf(fp,"  return(XbWDMx_WRok);\n");
  fprintf(fp,"  XbWFMx_EndSet();\n");
  fprintf(fp,"  XbWFMx_Close();\n");
  fprintf(fp,"  return(err);\n  };\n\n");
  /*}}}  */
  /*{{{  Datenstruktur fuer Initialisierung der Gruppe*/
  fprintf(fp,"DATA_%s %s={\n",cgr_name,cgr_name);
  rw_filitm = rw_start;
  akt_return = start_return;
  {
    int array_x = 0;
    int array_y = 0;
    int start_brace=0;
    /*{{{  */
    max_brace = 0;
    while(rw_filitm !=NULL) {
      XbWFDb_ForWd((XbWDDb_DbIVar  **)&rw_filitm,XbWDDb_DbISys);
      if (rw_filitm != NULL) {
        if (strncmp(rw_filitm->nm,"  ArraySize",strlen("  ArraySize"))==0){
          /*{{{  */
          max_brace=0;
          start_brace=1;
          array_x = *(int*)&((XbWDDb_DbIInt *)rw_filitm)->inh;
          XbWFDb_ForWd((XbWDDb_DbIVar  **)&rw_filitm,XbWDDb_DbISys);
          if (strncmp(rw_filitm->nm,"  ArraySize",strlen("  ArraySize"))==0){
            array_y = *(int*)&((XbWDDb_DbIInt *)rw_filitm)->inh;
            XbWFDb_ForWd((XbWDDb_DbIVar  **)&rw_filitm,XbWDDb_DbISys);
            };
          if (!array_x){ max_brace=array_y;};
          if (!array_y){ max_brace=array_x;};
          fprintf(fp,akt_return);
          fprintf(fp,"{");
          
          };
          
          /*}}}  */
        switch (((XbWDDb_DbIVar  *)rw_filitm)->tp & XbWDDb_Typ) {
          case XbWDDb_Int:
            /*{{{  */
            if (!start_brace){ fprintf(fp,akt_return); };
            fprintf(fp," %d",
              (int)(XbWFDb_GetNum((XbWDDb_DbIVar *)rw_filitm,NULL,1)) ); break;
            /*}}}  */
          case XbWDDb_Dbl:
            /*{{{  */
            if (!start_brace){ fprintf(fp,akt_return); };
            fprintf(fp," %19.7f",
              (double)(XbWFDb_GetNum((XbWDDb_DbIVar *)rw_filitm,NULL,1)) ); break;
            /*}}}  */
          case XbWDDb_Str:
            /*{{{  */
            {
              char *ms;
              char sstr[200];
              int vtp,ii,ee;
              int SL;
              XbWFDb_GetInf((XbWDDb_DbIVar *)rw_filitm, 0, NULL, &vtp, &ms, &SL, 1);
            
              strcpy(sstr,ms);
            
              ee = 0;
              for (ii=0; ii<SL-2; ii++) {
                if (ee) {
                  sstr[ii] = ' ';
                  }
                else {
                  switch (sstr[ii]) {
                    case 10: sstr[ii] = ' '; ee = 1; break;
                    case 13: sstr[ii] = ' '; ee = 1; break;
                    case  0: sstr[ii] = ' '; ee = 1; break;
                    };
                  };
                };
              sstr[SL] = 0;
            
              if (!start_brace){ fprintf(fp,akt_return); };
              fprintf(fp," \"%s\"",sstr);
            
              };
            break;
            
            /*}}}  */
          case XbWDDb_NPtr:
            /*{{{  */
            if (rw_filitm->inh != 0) {
              rw_itm = (XbWDDb_DbIVar *)XbWFDb_CDbIToPtr(rw_filitm->inh,XbWDDb_DbISys);
              if (rw_itm != NULL) {
                switch(rw_itm->tp & XbWDDb_Typ) {
                  case XbWDDb_Int:
                    if (!start_brace){ fprintf(fp,akt_return); };
                    fprintf(fp," %d",
                      (int)(XbWFDb_GetNum((XbWDDb_DbIVar *)rw_filitm,NULL,1)) ); break;
                  case XbWDDb_Dbl:
                    if (!start_brace){ fprintf(fp,akt_return); };
                    fprintf(fp," %19.7f",
                      (double)(XbWFDb_GetNum((XbWDDb_DbIVar *)rw_filitm,NULL,1)) ); break;
                  case XbWDDb_Str:
                    {
                      char *ms;
                      char sstr[200];
                      int vtp,ii,ee;
                      int SL;
            
                      XbWFDb_GetInf((XbWDDb_DbIVar *)rw_itm, 0,
                        NULL, &vtp, &ms, &SL, 1);
            
                      strcpy(sstr,ms);
            
                      ee = 0;
                      for (ii=0; ii<SL; ii++) {
                        if (ee) {
                          sstr[ii] = ' ';
                          }
                        else {
                          switch (sstr[ii]) {
                            case 10: sstr[ii] = ' '; ee = 1; break;
                            case 13: sstr[ii] = ' '; ee = 1; break;
                            case  0: sstr[ii] = ' '; ee = 1; break;
                            };
                          };
                        };
                      sstr[SL] = 0;
            
                      if (!start_brace){ fprintf(fp,akt_return); };
                      fprintf(fp," \"%s\" ",sstr);
                      };
                    break;
                  default:;
                  };
                };
              };
            break;
            /*}}}  */
          case XbWDDb_GPtr: rw_filitm = NULL; break;
          default:      rw_filitm = NULL; break;
          };
        akt_return = default_return;
        if (max_brace){
          max_brace--;
          start_brace=0;
          if (!max_brace){
            fprintf(fp,"}");
            };
          };
        };
      };
    
    fprintf(fp,"\n};\n\n");
    /*}}}  */
    };
  /*}}}  */
  fclose(fp);

  return(0);
  };
/*}}}  */
/*{{{  XbWFMx_RWGroup(     ***    Hauptroutine, ruft CrGrp und RWGrp*/
int  XbWFMx_RWGroup(void  *(*p)[], int (*t)[]){
#define rgr_apar (int)((*p)[0])
   char rgr_name[20];
   char fil_name[200];
   char rgr_rwm[200];
 
if (rgr_apar == 2) {
    char *tstr;
    strcpy(rgr_name,XbWFTb_PckTxt((char*)((*p)[2])));
    strcpy(rgr_rwm,XbWFTb_PckTxt((char*)((*p)[1])));
    tstr = rgr_rwm;
    switch (tstr[0]) {
      case 'C':
      case 'c':
        return(XbWFMx_CrGrp(rgr_name));
      default:
        return(XbWFMx_RWGrp(rgr_name,rgr_rwm,0,0,NULL));
      };
    };
if (rgr_apar == 4) {
  int v1,v2;
  strcpy(rgr_name,XbWFTb_PckTxt((char*)((*p)[2])));
  strcpy(rgr_rwm,XbWFTb_PckTxt((char*)((*p)[1])));
  switch ((int)(*t)[3]){
    case XbWDMf_VLPar:
      {
        XbWDDb_DbIVar  *MV;
        MV = (XbWDDb_DbIVar  *)(*p)[3];
        if (MV == NULL)  {return(1); };
        v1 = XbWFDb_GetNum(MV,NULL,1);
        };
      break;
    case XbWDMf_VPPar:
    case XbWDMf_IntPar: v1 = (int)(*p)[3]; break;
    default:return(1);
    };
  switch ((int)(*t)[4]){
    case XbWDMf_VLPar:
      {
        XbWDDb_DbIVar  *MV;
        MV = (XbWDDb_DbIVar  *)(*p)[4];
        if (MV == NULL)  {return(1); };
        v2 = XbWFDb_GetNum(MV,NULL,1);
        };
      break;
    case XbWDMf_VPPar:
    case XbWDMf_IntPar: v2 = (int)(*p)[4]; break;
    default:return(1);
    };

  {
    char *tstr = rgr_rwm;
    switch (tstr[0]) {
      case 'C':
      case 'c':
        return(XbWFMx_CrGrp(rgr_name));
      default:
        return(XbWFMx_RWGrp(rgr_name,rgr_rwm,v1,v2,NULL));
      };
    };
  };
if (rgr_apar == 3) {
  strcpy(rgr_name,XbWFTb_PckTxt((char*)((*p)[2])));
  strcpy(fil_name,XbWFTb_PckTxt((char*)((*p)[3])));
  strcpy(rgr_rwm,XbWFTb_PckTxt((char*)((*p)[1])));
  return(XbWFMx_RWGrp(rgr_name,rgr_rwm,0,0,fil_name));
  };
return(1);
};






/*}}}  */

/*{{{  XbWFDb_CDbIToPtr(         ***    Macht aus einer Datenbank-Pos. einen Pointer*/
XbWDDb_DbIVar  *XbWFDb_CDbIToPtr(XbWDDb_DbIPtr bb,void  *AP){
  return ((XbWDDb_DbIVar  *) (
    (char *)(AP)+(long)bb ));
  };
/*}}}  */
/*{{{  XbWFDb_ForWd(       ***    Ein Datenbank-Element vorwaerts*/
void  XbWFDb_ForWd(XbWDDb_DbIVar  **AP,XbWDDb_DbIVar  *IP){
  char  *tt;
  tt = (char  *)(*AP);
  tt = tt + (long)XbWFDb_GetSiz(*AP);
  *AP = (XbWDDb_DbIVar  *)tt;
  while(((*AP)->tp & XbWDDb_Typ) == XbWDDb_FPtr) {
    (*AP) = ((XbWDDb_DbIVar  *) ( (char *)(IP)+(long)(((XbWDDb_DbINPtr  *)(*AP))->inh) ));
    };
  };
/*}}}  */
/*{{{  XbWFDb_Fore(        ***    Speziell; im Prinzip wie ForWd*/
void  XbWFDb_Fore(XbWDDb_DbIVar  **AP,XbWDDb_DbIVar  *IP){
  char  *tt;
  while(((*AP)->tp & XbWDDb_Typ) == XbWDDb_FPtr) {
    (*AP) = ((XbWDDb_DbIVar  *) ( (char *)(IP)+(long)(((XbWDDb_DbINPtr  *)(*AP))->inh) ));
    };
  tt = (char  *)(*AP);
  tt = tt + (long)XbWFDb_GetSiz(*AP);
  *AP = (XbWDDb_DbIVar  *)tt;
  };
/*}}}  */
/*{{{  XbWFDb_PrInt(       ***    Integer-Element debuggen*/
void  XbWFDb_PrInt(FILE *fp, char *name, long adresse, long groesse, int inhalt){
  if (name[0] == 0) {
    fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Integer-parameter for command \"%s\")\n",
      adresse,groesse,name,inhalt,
      XbWVMf_LCmd);
    return;
    };
  if (name[1] == 0) {
    switch (name[0]) {
      case 'C':
        fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Command\t\"%s\")\n",
        adresse,groesse,name,inhalt,
        XbWVMf_com[inhalt]);
        XbWVMf_LCmd = XbWVMf_com[inhalt];
        return;
      case 'c':
        fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Parameter count for command\t\"%s\")\n",
        adresse,groesse,name,inhalt,
        XbWVMf_LCmd);
        return;
      case 'X':
        fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Object X left top)\n",
        adresse,groesse,name,inhalt);
        return;
      case 'Y':
        fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Object Y left top)\n",
        adresse,groesse,name,inhalt);
        return;
      case 'x':
        fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Object X right bottom)\n",
        adresse,groesse,name,inhalt);
        return;
      case 'y':
        fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Object Y right bottom)\n",
        adresse,groesse,name,inhalt);
        return;
      case 'b':
        fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Object background color)\n",
        adresse,groesse,name,inhalt);
        return;
      case 'f':
        fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Object bright (frame-) color)\n",
        adresse,groesse,name,inhalt);
        return;
      case 'F':
        fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Object dark (frame-) color)\n",
        adresse,groesse,name,inhalt);
        return;
      case 't':
        fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Object text color)\n",
        adresse,groesse,name,inhalt);
        return;
      case 'd':
        fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Object display status)\n",
        adresse,groesse,name,inhalt);
        return;
      case 'e':
        fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Object edit status)\n",
        adresse,groesse,name,inhalt);
        return;
      case 'w':
        fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Object draw window after edit)\n",
        adresse,groesse,name,inhalt);
        return;
      case 'V':
        fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Object VAR-PARAMETER INTEGER)\n",
        adresse,groesse,name,inhalt);
        return;
      case 'v':
        fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Object default)\n",
        adresse,groesse,name,inhalt);
        return;
      case 'm':
        fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Object minimum)\n",
        adresse,groesse,name,inhalt);
        return;
      case 'M':
        fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Object maximum)\n",
        adresse,groesse,name,inhalt);
        return;
      default:
        fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Integer)\n",
        adresse,groesse,name,inhalt);
        return;
      };
    };
  if (strlen(name) == 2) {
    if (strcmp(name,"sx") == 0) {
      fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Window: X-size in pixels)\n",
        adresse,groesse,name,inhalt);
      return;
      };
    if (strcmp(name,"sy") == 0) {
      fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Window: Y-size in pixels)\n",
        adresse,groesse,name,inhalt);
      return;
      };
    if (strcmp(name,"nx") == 0) {
      fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Window: X-position corner left top in pixels)\n",
        adresse,groesse,name,inhalt);
      return;
      };
    if (strcmp(name,"ny") == 0) {
      fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Window: Y-position corner left top in pixels)\n",
        adresse,groesse,name,inhalt);
      return;
      };
    if (strcmp(name,"tp") == 0) {
      fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Window: type)\n",
        adresse,groesse,name,inhalt);
      return;
      };
    if (strcmp(name,"bd") == 0) {
      fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Window: bkgd-draw 0=never 1=if!wov 2=if!icn 3=alw. +16=drawframe)\n",
        adresse,groesse,name,inhalt);
      return;
      };
    };
  if (strlen(name) == 3) {
    if (strcmp(name,"chg") == 0) {
      fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Window: if window has been changed. SYSTEM USE ONLY.)\n",
        adresse,groesse,name,inhalt);
      return;
      };
    if (strcmp(name,"wov") == 0) {
      fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Window: if window has been overwritten. SYSTEM USE ONLY.)\n",
        adresse,groesse,name,inhalt);
      return;
      };
    if (strcmp(name,"icn") == 0) {
      fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Window: if window has been iconized)\n",
        adresse,groesse,name,inhalt);
      return;
      };
    if (strcmp(name,"bkc") == 0) {
      fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Window: background color)\n",
        adresse,groesse,name,inhalt);
      return;
      };
    if (strcmp(name,"bfc") == 0) {
      fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Window: bright frame color)\n",
        adresse,groesse,name,inhalt);
      return;
      };
    if (strcmp(name,"dfc") == 0) {
      fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Window: dark frame color)\n",
        adresse,groesse,name,inhalt);
      return;
      };
    if (strcmp(name,"txc") == 0) {
      fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Window: text color)\n",
        adresse,groesse,name,inhalt);
      return;
      };
    if (strcmp(name,"wfx") == 0) {
      fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Window: if =1, do not leave window: WAIT FOR EXIT)\n",
        adresse,groesse,name,inhalt);
      return;
      };
    if (strcmp(name,"wfe") == 0) {
      fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Window: if =1 and object edited: set wfx = 1; WAIT FOR EDIT)\n",
        adresse,groesse,name,inhalt);
      return;
      };
    };
  if (strcmp(name,"layer") == 0) {
    fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Window: actual position vertical on screen)\n",
      adresse,groesse,name,inhalt);
    return;
    };
  fprintf(fp,"%5ld\ti\t%2ldsz\t\"%s\"\t\t%5d\t(Integer)\n",
      adresse,groesse,name,inhalt);
  return;
  };
/*}}}  */
/*{{{  XbWFDb_PrDbl(       ***    Double-Element debuggen*/
void  XbWFDb_PrDbl(FILE *fp, char *name, long adresse, long groesse, XbWDDb_DbIVar  *TV){
  if (name[0] == 0) {
    fprintf(fp,"%5ld\td\t%2ldsz\t\"%s\"\t\t%17.7f\t(Double-parameter for command \"%s\")\n",
      adresse,groesse,name,
      ((XbWDDb_DbIDbl *)TV)->inh,
      XbWVMf_LCmd);
    return;
    };
  if (name[1] == 0) {
    switch(name[0]){
      case 'V':
        fprintf(fp,"%5ld\td\t%2ldsz\t\"%s\"\t\t%17.7f\t(Object VAR-PARAMETER DOUBLE)\n",
          adresse,groesse,name,
          ((XbWDDb_DbIDbl *)TV)->inh);
        return;
      case 'v':
        fprintf(fp,"%5ld\td\t%2ldsz\t\"%s\"\t\t%17.7f\t(Object default)\n",
          adresse,groesse,name,
          ((XbWDDb_DbIDbl *)TV)->inh);
        return;
      case 'm':
        fprintf(fp,"%5ld\td\t%2ldsz\t\"%s\"\t\t%17.7f\t(Object minimum)\n",
          adresse,groesse,name,
          ((XbWDDb_DbIDbl *)TV)->inh);
        return;
      case 'M':
        fprintf(fp,"%5ld\td\t%2ldsz\t\"%s\"\t\t%17.7f\t(Object maximum)\n",
          adresse,groesse,name,
          ((XbWDDb_DbIDbl *)TV)->inh);
        return;
      default:
        fprintf(fp,"%5ld\td\t%2ldsz\t\"%s\"\t\t%17.7f\t(Double)\n",
          adresse,groesse,name,
          ((XbWDDb_DbIDbl *)TV)->inh);
        return;
      };
    };
  if (strlen(name) == 3){
    if (strcmp(name,"sca") == 0){
      fprintf(fp,"%5ld\td\t%2ldsz\t\"%s\"\t\t%17.7f\t(Objekt floating point scale)\n",
        adresse,groesse,name,
        ((XbWDDb_DbIDbl *)TV)->inh);
      return;
      };
    };

  fprintf(fp,"%5ld\td\t%2ldsz\t\"%s\"\t\t%17.7f\t(Double)\n",
    adresse,groesse,name,
    ((XbWDDb_DbIDbl *)TV)->inh);
  };

/*}}}  */
/*{{{  XbWFDb_PrPtr(       ***    Pointer-Element debuggen*/
void  XbWFDb_PrPtr(FILE *fp, char *name, long adresse, long groesse, XbWDDb_DbIVar  *TV){
  if (name[0] == 0) {
    fprintf(fp,"%5ld\tpn\t%2ldsz\t\"%s\"\t\t==> %lu\t(Pointer-parameter for command \"%s\")\n",
      adresse,groesse,name,
      ((XbWDDb_DbINPtr *)TV)->inh,
      XbWVMf_LCmd);
    return;
    };
  if (name[1] == 0) {
    switch(name[0]){
      case 'V':
        fprintf(fp,"%5ld\tpn\t%2ldsz\t\"%s\"\t\t==> %lu\t(Object VAR-PARAMETER POINTER)\n",
          adresse,groesse,name,
          ((XbWDDb_DbINPtr *)TV)->inh);
        return;
      case 'W':
        fprintf(fp,"%5ld\tpn\t%2ldsz\t\"%s\"\t\t==> %lu\t(Pointer to window name of object)\n",
          adresse,groesse,name,
          ((XbWDDb_DbINPtr *)TV)->inh);
        return;
      default:
        fprintf(fp,"%5ld\tpn\t%2ldsz\t\"%s\"\t\t==> %lu\t(Pointer)\n",
          adresse,groesse,name,
          ((XbWDDb_DbINPtr *)TV)->inh);
        return;
      };
    };
  if (strlen(name) == 3){
    if (strcmp(name,"OBJ") == 0) {
      fprintf(fp,"%5ld\tpn\t%2ldsz\t\"%s\"\t\t==> %lu\t(Pointer to next object)\n",
          adresse,groesse,name,
          ((XbWDDb_DbINPtr *)TV)->inh);
      return;
      };
    if (strcmp(name,"obj") == 0) {
      fprintf(fp,"%5ld\tpn\t%2ldsz\t\"%s\"\t\t==> %lu\t(Window: pointer to first object)\n",
          adresse,groesse,name,
          ((XbWDDb_DbINPtr *)TV)->inh);
      return;
      };
    if (strcmp(name,"WDW") == 0) {
      fprintf(fp,"%5ld\tpn\t%2ldsz\t\"%s\"\t\t==> %lu\t(Pointer to next window)\n",
          adresse,groesse,name,
          ((XbWDDb_DbINPtr *)TV)->inh);
      return;
      };
    if (strcmp(name,"PRJ") == 0) {
      fprintf(fp,"%5ld\tpn\t%2ldsz\t\"%s\"\t\t==> %lu\t(Pointer to next project)\n",
          adresse,groesse,name,
          ((XbWDDb_DbINPtr *)TV)->inh);
      return;
      };
    if (strcmp(name,"MFX") == 0) {
      fprintf(fp,"%5ld\tpn\t%2ldsz\t\"%s\"\t\t==> %lu\t(Pointer to next MFX-group)\n",
          adresse,groesse,name,
          ((XbWDDb_DbINPtr *)TV)->inh);
      return;
      };
    if (strcmp(name,"KEY") == 0) {
      fprintf(fp,"%5ld\tpn\t%2ldsz\t\"%s\"\t\t==> %lu\t(Pointer to next keyboard-group)\n",
          adresse,groesse,name,
          ((XbWDDb_DbINPtr *)TV)->inh);
      return;
      };
    if (strcmp(name,"OBX") == 0) {
      fprintf(fp,"%5ld\tpn\t%2ldsz\t\"%s\"\t\t==> %lu\t(Pointer to next object generator variable group)\n",
          adresse,groesse,name,
          ((XbWDDb_DbINPtr *)TV)->inh);
      return;
      };
    if (strcmp(name,"SVR") == 0) {
      fprintf(fp,"%5ld\tpn\t%2ldsz\t\"%s\"\t\t==> %lu\t(Pointer to next system variable group)\n",
          adresse,groesse,name,
          ((XbWDDb_DbINPtr *)TV)->inh);
      return;
      };
    if (strcmp(name,"USR") == 0) {
      fprintf(fp,"%5ld\tpn\t%2ldsz\t\"%s\"\t\t==> %lu\t(Pointer to next user variable group)\n",
          adresse,groesse,name,
          ((XbWDDb_DbINPtr *)TV)->inh);
      return;
      };
    };
  fprintf(fp,"%5ld\tpn\t%2ldsz\t\"%s\"\t\t==> %lu\t(Pointer to VAR-Element)\n",
    adresse,groesse,name,
    ((XbWDDb_DbINPtr *)TV)->inh);
  };
/*}}}  */
/*{{{  XbWFDb_PrStr(       ***    String-Element debuggen*/
void  XbWFDb_PrStr(FILE *fp, char *name, long adresse, long groesse, XbWDDb_DbIVar  *TV){
  XbWDDb_DbIStr  *TS;

  TS = (XbWDDb_DbIStr *)TV;

  if (name[0] == 0) {
    fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t\t(String-Parameter for command \"%s\")\n",
      adresse,groesse,name,
      TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]),
      XbWVMf_LCmd);
    return;
    };
  if (name[1] == 0) {
    switch(name[0]){
      case 'M':
        fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Compiled Makro)\n",
          adresse,groesse,name,
          TS->len*2,"");
        return;
      case 'D':
        fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object display mode)\n",
          adresse,groesse,name,
          TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
        return;
      case 'E':
        fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object edit mode)\n",
          adresse,groesse,name,
          TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
        return;
      case 'V':
        fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object VAR-PARAMETER STRING)\n",
          adresse,groesse,name,
          TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
        return;
      case 'v':
        fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object default)\n",
          adresse,groesse,name,
          TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
        return;
      case 'i':
        fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object info text mode)\n",
          adresse,groesse,name,
          TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
        return;
      case 'T':
        fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object additional text)\n",
          adresse,groesse,name,
          TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
        return;
      case '1':
        fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(LIGHT-Object ON-text)\n",
          adresse,groesse,name,
          TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
        return;
      case '0':
        fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(LIGHT-Object OFF-text)\n",
          adresse,groesse,name,
          TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
        return;
      case 'W':
        fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object window name)\n",
          adresse,groesse,name,
          TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
        return;
      default:
        fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(String)\n",
          adresse,groesse,name,
          TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
        return;
      };
    };
  if (strlen(name) == 3){
    if (strcmp(name,"inf") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Window: file name for help text)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"OBJ") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object name)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"WDW") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Window name)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"PRJ") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Project name)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"SVR") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(System variable group name)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"OBX") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object generator variable group name)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"USR") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(User variable group name)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"MFX") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(MFX variable group name)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"KEY") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Keyboard variable group name)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"fmt") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object floating point format)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"eha") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object floating point unit)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"epO") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object to edit PREVIOUSLY)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"rbK") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object: makro to read before edit)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"ebO") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object: object to edit before edit)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"wbX") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object: mfx-file to write before edit)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"rbT") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object: meta-file to read before edit)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"rbC") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object: compiled makro to read before edit)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"raX") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object: mfx-file to read after edit)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"raT") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object: meta-file to read after edit)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"raK") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object: makro to read after edit)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"edO") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object: object to edit after edit)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"raC") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object: compiled makro to read after edit)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"dpO") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object: object to display after edit)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"rqX") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object: mfx-file to read after queue)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"rqT") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object: meta-file to read after queue)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"rqK") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object: makro to read after queue)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"eqO") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object: object to edit after queue)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"rqC") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object: compiled makro to read after queue)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    if (strcmp(name,"dqO") == 0) {
      fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(Object: object to display after queue)\n",
        adresse,groesse,name,
        TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
      return;
      };
    };
  fprintf(fp,"%5ld\ts\t%2ldsz\t\"%s\"\t\t(%d unsigned chars)\t\"%s\"\t(String)\n",
    adresse,groesse,name,
    TS->len*2,&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
  return;
  };
/*}}}  */

