 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*                                                                           */
/*                                                                           */
/*   Modul X4.C                                                              */
/*                                                                           */
/*                                                                           */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */



/* Header--------------------------------------------------------------------*/

#include "xbw.h"
#include "sys/mman.h"
#include "sys/stat.h"
#include "unistd.h"
#include "fcntl.h"

  #ifndef MAP_FILE
  #define MAP_FILE 0
  #endif

/* Abkrzungen---------------------------------------------------------------*/
                      /* ---............Nicht mglich  */
                      /* !!!............Noch zu machen */
                      /* ???............unklar         */
                      /* TC3............Turbo-C Version*/
                      /*     GNU........32-Bit Version */
                      /*         X11....X-Window       */
 
/*  ---------------------Compiler-Modelle-----------------------------*/
 

/*{{{  XbWFDb_DbgVar(      ***    Eine Datenbank-Variable debuggen*/
void  XbWFDb_DbgVar(XbWDDb_DbIVar  *TV,FILE *fp){
  char *name;
  long adresse;
  long groesse;
  int inhalt;
  int fclos=0;
  if (fp == NULL) {
    fp = XbWSSy_fopen("debug.mto","wt");
    if (fp == NULL) {XbWFTb_HBeep(); return;};
    fclos = 1;
    };
  name = (char*)XbWFDb_GetNam(TV);
  adresse = XbWDDb_C_PtrToDbI(TV,XbWDDb_DbISys);
  groesse = XbWFDb_GetSiz(TV);
  inhalt = ((XbWDDb_DbIInt *)TV)->inh;

  switch(TV->tp & XbWDDb_Typ){
    case XbWDDb_Int :
                  inhalt = ((XbWDDb_DbIInt *)TV)->inh;
                  XbWFDb_PrInt(fp,name,adresse,groesse,inhalt);  break;
    case XbWDDb_Dbl : XbWFDb_PrDbl(fp,name,adresse,groesse,TV);       break;
    case XbWDDb_NPtr: XbWFDb_PrPtr(fp,name,adresse,groesse,TV);      break;
    case XbWDDb_IPtr:
                 fprintf(fp,"%5ld\tpi\t%2ldsz\t\"%s\"\t\t==> %lu\n",
                   XbWDDb_C_PtrToDbI(TV,XbWDDb_DbISys),XbWFDb_GetSiz(TV),
                   (char*)XbWFDb_GetNam(TV),((XbWDDb_DbIIPtr *)TV)->inh);
                 break;
    case XbWDDb_GPtr:
                 fprintf(fp,"%5ld\tend of actual group\t%2ldsz\t\"%s\"\t\t==> %lu\t(Pointer to start of actual group)\n",
                   XbWDDb_C_PtrToDbI(TV,XbWDDb_DbISys),XbWFDb_GetSiz(TV),
                   (char*)XbWFDb_GetNam(TV),((XbWDDb_DbIGPtr *)TV)->inh);
                 break;
    case XbWDDb_FPtr:
                 fprintf(fp,"%5ld\tcontinuation pointer\t%2ldsz\t\"%s\"\t\t==> %lu\t(Pointer to continuation of actual group)\n",
                   XbWDDb_C_PtrToDbI(TV,XbWDDb_DbISys),XbWFDb_GetSiz(TV),
                   (char*)XbWFDb_GetNam(TV),((XbWDDb_DbIFPtr *)TV)->inh);
                 break;
    case XbWDDb_Str : XbWFDb_PrStr(fp,name,adresse,groesse,TV);      break;
    default:fprintf(fp," -  (???)\n"); break;
    };
  if (fclos) {fclose(fp); };
  };
/*}}}  */
 
/*{{{  XbWFDb_FindNptr(    ***    Unterroutinen zur Datenbank-Verwaltung*/
XbWDDb_DbIVar  *XbWFDb_FindNptr(XbWDDb_DbIVar  *start,char *name){
  char  *tt;
  if (start == NULL) {
    return(NULL);};
  while (start < (XbWDDb_DbIVar  *)XbWDDb_Dbk->T_ITM_END) {
    if ((start->tp & XbWDDb_Typ) == XbWDDb_NPtr){
      if (XbWFTb_CmpStr((char*)XbWFDb_GetNam(start),name) == 0) {
        return(start);
        };
      };
    tt = (char  *)start;
    tt = tt + (long)XbWFDb_GetSiz(start);
    start = (XbWDDb_DbIVar  *)tt;
    while(((start)->tp & XbWDDb_Typ) == XbWDDb_FPtr) {
      start = ((XbWDDb_DbIVar  *) (
        (char *)(XbWVDb_DbkStrt->T_ITM_SYS)+
        (long)(((XbWDDb_DbINPtr  *)(start))->inh)   ));
      };
    };
  return(NULL);
  };
/*}}}  */
/*{{{  XbWFDb_NextGrp(     ****/
XbWDDb_DbIVar  *XbWFDb_NextGrp(XbWDDb_DbIVar  *start,char *name){
  if (start == NULL) {
    return(NULL);
    };
  while (start != NULL) {
    if ((start->tp & XbWDDb_Typ) == XbWDDb_Str){
      if (name != NULL) {
        if (XbWFTb_CmpStr((char*)XbWFDb_GetStr((XbWDDb_DbIStr  *)start),name) == 0) {
          return(start);
          };
        };
      XbWFDb_ForWd(&start,XbWDDb_DbISys);
      if ((start->tp & XbWDDb_Typ) != XbWDDb_NPtr){ return(NULL); };
      if (((XbWDDb_DbINPtr  *)start)->inh == 0) {return(NULL);};
      start = XbWFDb_CDbIToPtr( ((XbWDDb_DbINPtr  *)start)->inh,XbWDDb_DbISys);
      if (name == NULL) {return(start);};
      };
    };
  return(NULL);
  };
/*}}}  */
/*{{{  XbWFDb_GetInh(      ****/
char  *XbWFDb_GetInh(XbWDDb_DbIVar  *start, int tp){
  if (start == NULL) {
    return(NULL);
    };
  while (start != NULL) {
    while ((start->tp & XbWDDb_Typ) == XbWDDb_NPtr){
      if (((XbWDDb_DbINPtr  *)start)->inh == 0) {return(NULL);};
      start = XbWFDb_CDbIToPtr( ((XbWDDb_DbINPtr  *)start)->inh,XbWDDb_DbISys);
      if (start == NULL) {return(NULL);};
      };
    switch(tp) {
      case XbWDDb_Dbl: if ((start->tp & XbWDDb_Typ) == XbWDDb_Dbl){
                     return((char  *)&((XbWDDb_DbIDbl *)start)->inh);
                     };
                   return(NULL);
      case XbWDDb_Int: if ((start->tp & XbWDDb_Typ) == XbWDDb_Int){
                     return((char  *)&((XbWDDb_DbIInt *)start)->inh);
                     };
                   return(NULL);
      case XbWDDb_Str: if ((start->tp & XbWDDb_Typ) == XbWDDb_Str){
                     return(XbWFDb_GetStr((XbWDDb_DbIStr  *)start));
                     };
                   return(NULL);
      };
    };
  return(NULL);
  };
/*}}}  */
/*{{{  XbWFDb_VarInh(      ****/
char  *XbWFDb_VarInh(XbWDDb_DbIVar  *start, int tp, char *name, int recursiv){
  XbWDDb_DbIVar  *TV;
  TV = start;
  if (TV == NULL) {
    return(NULL);
    };
  if (name == NULL) {
    goto TABvarINHende;
    };
  if (XbWFTb_CmpStr((char*)XbWFDb_GetNam(TV),name) == 0) {
    goto TABvarINHende;
    };
  while ((TV->tp & XbWDDb_Typ) != XbWDDb_GPtr) {
    if (tp == XbWDDb_FPtr) {
      XbWFDb_Fore(&TV,XbWDDb_DbISys);
      }
    else {
      XbWFDb_ForWd(&TV,XbWDDb_DbISys);
      };
    if (XbWFTb_CmpStr((char*)XbWFDb_GetNam(TV),name) == 0) {
      TABvarINHende:;
      if (recursiv) {
        while ((TV->tp & XbWDDb_Typ) == XbWDDb_NPtr){
          if (((XbWDDb_DbINPtr  *)TV)->inh == 0) {return(NULL);};
          TV = XbWFDb_CDbIToPtr( ((XbWDDb_DbINPtr  *)TV)->inh,XbWDDb_DbISys);
          if (TV == NULL) {return(NULL);};
          };
        };
      XbWVDb_ActGrp2 = (XbWDDb_DbIVar  *)TV;
      switch(tp) {
        case XbWDDb_Dbl: if ((TV->tp & XbWDDb_Typ) == XbWDDb_Dbl){
                       return((char  *)&((XbWDDb_DbIDbl *)TV)->inh);
                       };
                     return(NULL);
        case XbWDDb_Int: if ((TV->tp & XbWDDb_Typ) == XbWDDb_Int){
                       return((char  *)&((XbWDDb_DbIInt *)TV)->inh);
                       };
                     return(NULL);
        case XbWDDb_Str: if ((TV->tp & XbWDDb_Typ) == XbWDDb_Str){
                       return(XbWFDb_GetStr((XbWDDb_DbIStr  *)TV));
                       };
                     return(NULL);
        case XbWDDb_FPtr: if ((TV->tp & XbWDDb_Typ) == XbWDDb_FPtr){
                       return((char  *)&((XbWDDb_DbINPtr *)TV)->inh);
                       };
                     return(NULL);
        case XbWDDb_IPtr: if ((TV->tp & XbWDDb_Typ) == XbWDDb_IPtr){
                       return((char  *)&((XbWDDb_DbINPtr *)TV)->inh);
                       };
                     return(NULL);
        case XbWDDb_NPtr: if ((TV->tp & XbWDDb_Typ) == XbWDDb_NPtr){
                       return((char  *)&((XbWDDb_DbINPtr *)TV)->inh);
                       };
                     return(NULL);
        case 0:      return((char *)TV);
        };
      };
    };
  return(NULL);
  };
/*}}}  */
/*{{{  XbWFDb_GetNum(      ****/
double  XbWFDb_GetNum(XbWDDb_DbIVar  *start, char *name, int recursiv){
  XbWDDb_DbIVar  *TV;
  TV = start;
  XbWVDb_FndNum = 1;
  if (TV == NULL) {
    return(0.0);
    };
  if (name == NULL) {
    goto TABvarINHende;
    };
  if (XbWFTb_CmpStr((char*)XbWFDb_GetNam(TV),name) == 0) {
    goto TABvarINHende;
    };
  while ((TV->tp & XbWDDb_Typ) != XbWDDb_GPtr) {
    XbWFDb_ForWd(&TV,XbWDDb_DbISys);
    if (XbWFTb_CmpStr((char*)XbWFDb_GetNam(TV),name) == 0) {
      TABvarINHende:;
      XbWVDb_ActGrp1 = TV;
      if (recursiv) {
        while ((TV->tp & XbWDDb_Typ) == XbWDDb_NPtr){
          if (((XbWDDb_DbINPtr  *)TV)->inh == 0) {return(0.0);};
          TV = XbWFDb_CDbIToPtr( ((XbWDDb_DbINPtr  *)TV)->inh,XbWDDb_DbISys);
          if (TV == NULL) {return(0.0);};
          };
        };
      XbWVDb_AkDbkEl = TV;
      switch(TV->tp & XbWDDb_Typ) {
        case XbWDDb_Int:
        case XbWDDb_Dbl: if ((TV->tp & XbWDDb_Typ) == XbWDDb_Dbl){
                       XbWVDb_FndNum = 0;
                       return((double)((XbWDDb_DbIDbl  *)TV)->inh);
                       };
                     if ((TV->tp & XbWDDb_Typ) == XbWDDb_Int){
                       XbWVDb_FndNum = 0;
                       return((double)((XbWDDb_DbIInt  *)TV)->inh);
                       };
                     return(0.0);
        case XbWDDb_Str:
        case XbWDDb_FPtr:
        case XbWDDb_IPtr:
        case XbWDDb_NPtr:
                     return(0.0);
        };
      };
    };
  return(0.0);
  };
/*}}}  */
/*{{{  XbWFDb_PutNum(      ****/
char  *XbWFDb_PutNum(XbWDDb_DbIVar  *start, char *name, int recursiv, double zz){
  XbWDDb_DbIVar  *TV;
  TV = start;
  if (TV == NULL) {
    return(NULL);
    };
  if (name == NULL) {
    goto TABvarINHende;
    };
  if (XbWFTb_CmpStr((char*)XbWFDb_GetNam(TV),name) == 0) {
    goto TABvarINHende;
    };
  while ((TV->tp & XbWDDb_Typ) != XbWDDb_GPtr) {
    XbWFDb_ForWd(&TV,XbWDDb_DbISys);
    if (XbWFTb_CmpStr((char*)XbWFDb_GetNam(TV),name) == 0) {
      TABvarINHende:;
      XbWVDb_ActGrp1 = TV;
      if (recursiv) {
        while ((TV->tp & XbWDDb_Typ) == XbWDDb_NPtr){
          if (((XbWDDb_DbINPtr  *)TV)->inh == 0) {return(NULL);};
          TV = XbWFDb_CDbIToPtr(((XbWDDb_DbINPtr  *)TV)->inh,XbWDDb_DbISys);
          if (TV == NULL) {return(NULL);};
          };
        };
      XbWVDb_AkDbkEl = TV;
      switch(TV->tp & XbWDDb_Typ) {
        case XbWDDb_Int:
        case XbWDDb_Dbl: if ((TV->tp & XbWDDb_Typ) == XbWDDb_Dbl){
                        ((XbWDDb_DbIDbl  *)TV)->inh = zz;
                       return((char  *)&((XbWDDb_DbIDbl *)TV)->inh);
                       };
                     if ((TV->tp & XbWDDb_Typ) == XbWDDb_Int){
                       ((XbWDDb_DbIInt  *)TV)->inh = (int)zz;
                       return((char  *)&((XbWDDb_DbIInt *)TV)->inh);
                       };
                     return(NULL);
        case XbWDDb_Str:
        case XbWDDb_FPtr:
        case XbWDDb_IPtr:
        case XbWDDb_NPtr:
                     return(0);
        };
      };
    };
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_PutStr(      ****/
int  XbWFDb_PutStr(XbWDDb_DbIVar  *start, char *name, int recursiv, char *sstr){
  XbWDDb_DbIVar  *TV;
  TV = start;
  if (TV == NULL) {
    return(0);
    };
  if (XbWFTb_CmpStr((char*)XbWFDb_GetNam(TV),name) == 0) {
    goto TABvarINHende;
    };
  while ((TV->tp & XbWDDb_Typ) != XbWDDb_GPtr) {
    XbWFDb_ForWd(&TV,XbWDDb_DbISys);
    if (XbWFTb_CmpStr((char*)XbWFDb_GetNam(TV),name) == 0) {
      XbWVDb_ActGrp1 = TV;
      if (recursiv) {
        while ((TV->tp & XbWDDb_Typ) == XbWDDb_NPtr){
          if (((XbWDDb_DbINPtr  *)TV)->inh == 0) {return(0);};
          TV = XbWFDb_CDbIToPtr( ((XbWDDb_DbINPtr  *)TV)->inh,XbWDDb_DbISys);
          if (TV == NULL) {return(0);};
          };
        };
      TABvarINHende:;
      XbWVDb_AkDbkEl = TV;
      switch(TV->tp & XbWDDb_Typ) {
        case XbWDDb_Str: {
                       int len;
                       XbWDDb_DbIStr  *TS;
                       TS = (XbWDDb_DbIStr  *)TV;
                       len = strlen(sstr);
                       if (len < TS->len * 2) {
                         strcpy((char*)&(TS->nmi[(TS->tp & XbWDDb_NLen)]),sstr);
                         return(1);
                         };
                       XbWSPu_Alarm("Cannot set string because not enough space!");
                       };
                     return(0);
        };
      };
    };
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_GtEOT(       ****/
void  *XbWFDb_GtEOT(void){
  return(XbWDDb_Dbk->T_ITM_END);
  };
/*}}}  */
/*{{{  XbWFDb_Add(         ****/
void  *XbWFDb_Add(long size){
  XbWVDb_DbkStrt->T_ITM_END =
    (void *)((char *)(XbWVDb_DbkStrt->T_ITM_END)+(long)size);
  return(XbWDDb_Dbk->T_ITM_END);
  };
/*}}}  */
/*{{{  XbWFDb_GetSiz(      ****/
long  XbWFDb_GetSiz(XbWDDb_DbIVar  *TV){
  switch(TV->tp & XbWDDb_Typ){
    case XbWDDb_Int :return(sizeof(XbWDDb_DbIInt)+((TV->tp)&XbWDDb_NLen)-1);
    case XbWDDb_Dbl :return(sizeof(XbWDDb_DbIDbl)+((TV->tp)&XbWDDb_NLen)-1);
    case XbWDDb_IPtr:return(sizeof(XbWDDb_DbIIPtr)+((TV->tp)&XbWDDb_NLen)-1);
    case XbWDDb_NPtr:return(sizeof(XbWDDb_DbINPtr)+((TV->tp)&XbWDDb_NLen)-1);
    case XbWDDb_FPtr:return(sizeof(XbWDDb_DbIGPtr)+((TV->tp)&XbWDDb_NLen)-1);
    case XbWDDb_GPtr:return(sizeof(XbWDDb_DbIGPtr)+((TV->tp)&XbWDDb_NLen)-1);
    case XbWDDb_Str :return(sizeof(XbWDDb_DbIStr)+(((XbWDDb_DbIStr  *)TV)->len)*2+((((XbWDDb_DbIStr  *)TV)->tp)&XbWDDb_NLen)-1);
    default:return(0x2007FFEl);
    };
  };
/*}}}  */
/*{{{  XbWFDb_GetNam(      ****/
char  *XbWFDb_GetNam(XbWDDb_DbIVar  *TV){
  switch(TV->tp & XbWDDb_Typ){
    case XbWDDb_Int :  strncpy(XbWVDb_AktNam,((XbWDDb_DbIInt   *)TV)->nm,TV->tp & XbWDDb_NLen);
                   XbWVDb_AktNam[TV->tp & XbWDDb_NLen] = 0; break;
    case XbWDDb_Dbl :  strncpy(XbWVDb_AktNam,((XbWDDb_DbIDbl   *)TV)->nm,TV->tp & XbWDDb_NLen);
                   XbWVDb_AktNam[TV->tp & XbWDDb_NLen] = 0; break;
    case XbWDDb_NPtr:  strncpy(XbWVDb_AktNam,((XbWDDb_DbINPtr   *)TV)->nm,TV->tp & XbWDDb_NLen);
                   XbWVDb_AktNam[TV->tp & XbWDDb_NLen] = 0; break;
    case XbWDDb_IPtr:  strncpy(XbWVDb_AktNam,((XbWDDb_DbIIPtr   *)TV)->nm,TV->tp & XbWDDb_NLen);
                   XbWVDb_AktNam[TV->tp & XbWDDb_NLen] = 0; break;
    case XbWDDb_GPtr:  strncpy(XbWVDb_AktNam,((XbWDDb_DbIGPtr   *)TV)->nm,TV->tp & XbWDDb_NLen);
                   XbWVDb_AktNam[TV->tp & XbWDDb_NLen] = 0; break;
    case XbWDDb_FPtr:  strncpy(XbWVDb_AktNam,((XbWDDb_DbIFPtr   *)TV)->nm,TV->tp & XbWDDb_NLen);
                   XbWVDb_AktNam[TV->tp & XbWDDb_NLen] = 0; break;
    case XbWDDb_Str :  strncpy(XbWVDb_AktNam,((XbWDDb_DbIStr   *)TV)->nmi,TV->tp & XbWDDb_NLen);
                   XbWVDb_AktNam[TV->tp & XbWDDb_NLen] = 0; break;
    default:return("!!ERROR!!");
    };
  return((char *)&XbWVDb_AktNam);
  };
/*}}}  */
/*{{{  XbWFDb_CmpStr(      ****/
int  XbWFDb_CmpStr(XbWDDb_DbIVar  *TS,char *snam){
  if (TS == NULL){
    return(-1);
    };
  if ((((XbWDDb_DbIStr  *)TS)->tp & XbWDDb_Typ) != XbWDDb_Str) {
    char sstr[80];
    sprintf(sstr,"ERR: can't compare string conten((XbWDDb_DbIStr  *)TS) of %s !!",
      (char*)XbWFDb_GetNam((XbWDDb_DbIVar  *)((XbWDDb_DbIStr  *)TS)));
    XbWFTb_Error(sstr);
    return(-1);
    };
  return(XbWFTb_CmpStr((char*)XbWFDb_GetNam(TS),snam));
  };
/*}}}  */
/*{{{  XbWFDb_GetStr(      ****/
char  *XbWFDb_GetStr(XbWDDb_DbIStr  *TS){
  if ((TS->tp & XbWDDb_Typ) != XbWDDb_Str) {
    char sstr[80];
    sprintf(sstr,"ERR: can't get string contents of %s !!",
      (char*)XbWFDb_GetNam((XbWDDb_DbIVar  *)TS));
    XbWFTb_Error(sstr);
    return("ERROR");
    };
  return(&(TS->nmi[(TS->tp & XbWDDb_NLen)]));
  };
/*}}}  */
/*{{{  XbWFDb_AppCmd(      ****/
int  XbWFDb_AppCmd(void  *(*p)[]){
  XbWDDb_AppCStr  *pa;
  XbWDDb_DbINPtr  *TV;
  int nl;

  pa =  (XbWDDb_AppCStr  *)p; if ((int)(pa->anz) < 2) {return(XbWDMf_NoPara);};

  nl =  strlen((char*)(pa->nm));
  if (nl > 15) {nl = 15; };

  TV = (XbWDDb_DbINPtr  *)XbWFDb_GtEOT();                          /* Platz belegen */
  TV->tp  = XbWDDb_NPtr | nl;

  if (XbWFDb_Add(XbWFDb_GetSiz((XbWDDb_DbIVar  *)TV)) == NULL) {return(1);};

  strncpy(TV->nm,(char*)pa->nm,nl);
  if (pa->inh != NULL) {
    ((XbWDDb_DbINPtr  *)TV)->inh = (long)NULL;
    XbWFMf_CompileMF((char*)pa->inh);
    ((XbWDDb_DbINPtr  *)TV)->inh =  XbWDDb_C_PtrToDbI(XbWFDb_GtEOT(),XbWDDb_DbISys);
    TV->tp  = XbWDDb_FPtr | nl;
    }
  else {
    ((XbWDDb_DbINPtr  *)TV)->inh = (long)NULL;
    };
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_AppStr(      ****/
int  XbWFDb_AppStr(void  *(*p)[], int (*t)[]){
  XbWDDb_AppStr  *pa;
  XbWDDb_DbIStr  *TV;
  int ll,nl;
 
  if ( (int)(*p)[0] == -1){
    puts("\n");
    XbWFSy_bf_printf("Function: \"%s\" Add String VAR-Element)\n",(char*)(*p)[1]);
    puts  ("          3 Parameters");
    printf("Syntax:   %s( (\"VAR-Type\") <Length> (\"Content\") );",(char*)(*p)[1]);
    puts  ("\n");
    puts  ("Params:   VAR-Type is a string, max. 15 chars (\"Name\")");
    puts  ("          Length gives the string space in bytes");
    puts  ("          Content is a string with the content to put in");
    printf("Sample:   \"%s\"( myname 80 (\"Text with spaces\") );",(char*)(*p)[1]);
    return(0);
    };
 
  pa =  (XbWDDb_AppStr  *)p; if ((int)(pa->anz) < 3) {return(XbWDMf_NoPara);};
 
  nl =  strlen((char*)(pa->nm));
  if (nl > 15) {nl = 15; };

  if ((int)pa->len) {
    ll = (int)(pa->len)+2;
    }
  else {
    ll = strlen((char*)(pa->inh))+2;
    };
  ll = (ll/2)*2;  if (ll > 254*2) {return(XbWDMf_StrToL);};

  TV = (XbWDDb_DbIStr  *)XbWFDb_GtEOT();                          /* Platz belegen */
  TV->tp  = XbWDDb_Str | nl;

  TV->len = ll/2;


  if (XbWFDb_Add(XbWFDb_GetSiz((XbWDDb_DbIVar  *)TV)) == NULL) {return(1);};

  strncpy(TV->nmi,(char*)pa->nm,nl);
  if (pa->inh != NULL) {
    strncpy(&(TV->nmi[nl]),(char*)pa->inh,ll);
    TV->nmi[nl+ll-1] = 0;
    }
  else {
    TV->nmi[nl]=0;
    };
  return(0);
  };

/*}}}  */
/*{{{  XbWFDb_AppCSt(      ****/
int  XbWFDb_AppCSt(void  *(*p)[],int (*t)[]){
  XbWDDb_AppCStr  *pa;
  XbWDDb_DbIStr  *TV;
  int ll,nl;
 
  if ( (int)(*p)[0] == -1){
    puts("\n");
    XbWFSy_bf_printf("Function: \"%s\" Add Constant String VAR-Element)\n",(char*)(*p)[1]);
    puts  ("          2 Parameters");
    printf("Syntax:   %s( (\"VAR-Type\") (\"Content\") );",(char*)(*p)[1]);
    puts  ("\n");
    puts  ("Params:   VAR-Type is a string, max. 15 chars (\"Name\")");
    puts  ("          Content is a string with the content to put in");
    puts  ("          Length is determined by content length");
    printf("Sample:   \"%s\"( myname (\"Text with spaces\") );",(char*)(*p)[1]);
    return(0);
    };
 
 
  pa =  (XbWDDb_AppCStr  *)p; if ((int)(pa->anz) < 2) {return(XbWDMf_NoPara);};
  nl =  strlen((char*)(pa->nm));
  if (nl > 15) {nl = 15; };
  ll = strlen((char*)(pa->inh))+2;
  ll = (ll/2)*2;  if (ll > 254*2) {return(XbWDMf_StrToL);};
  TV = (XbWDDb_DbIStr  *)XbWFDb_GtEOT();                          /* Platz belegen */
  TV->tp  = XbWDDb_Str | nl; TV->len = ll/2;
  if (XbWFDb_Add(XbWFDb_GetSiz((XbWDDb_DbIVar  *)TV)) == NULL) {return(1);};
  strncpy(TV->nmi,(char*)pa->nm,nl);
  if (pa->inh != NULL) {
    strncpy(&(TV->nmi[nl]),(char*)pa->inh,ll);
    TV->nmi[nl+ll-1] = 0;
    }
  else {
    TV->nmi[nl]=0;
    };
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_AppInt(      ****/
int  XbWFDb_AppInt(void  *(*p)[],int (*t)[]){
  XbWDDb_AppInt  *pa;
  XbWDDb_DbIInt  *TV;
  int nl;
 
  if ( (int)(*p)[0] == -1){
    puts("\n");
    XbWFSy_bf_printf("Function: \"%s\" Add Integer VAR-Element)\n",(char*)(*p)[1]);
    puts  ("          2 Parameters");
    printf("Syntax:   %s( (\"VAR-Type\") <Content> );",(char*)(*p)[1]);
    puts  ("\n");
    puts  ("Params:   VAR-Type is a string, max. 15 chars (\"Name\")");
    puts  ("          Content is an integer number to put in");
    printf("Sample:   \"%s\"( myname 1234 );",(char*)(*p)[1]);
    return(0);
    };
 
 
  pa = (XbWDDb_AppInt  *)p;
  if ((int)(pa->anz) < 2) {return(XbWDMf_NoPara);};
  TV = (XbWDDb_DbIInt  *)XbWFDb_GtEOT();                          /* Platz belegen */
  nl =  strlen((char*)(pa->nm));
  if (nl > 15) {nl = 15; };
  TV->tp  = XbWDDb_Int | nl;
  if (XbWFDb_Add(XbWFDb_GetSiz((XbWDDb_DbIVar  *)TV)) == NULL) {return(1);};
  strncpy(TV->nm,(char*)pa->nm,nl);
  ((XbWDDb_DbIInt  *)TV)->inh = (int)(pa->inh);
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_AppDbl(      ****/
int  XbWFDb_AppDbl(void  *(*p)[]){
  XbWDDb_AppDBl  *pa;
  XbWDDb_DbIDbl  *TV;
  int nl;
 
  /* This is an obsolete Function */
 
  pa = (XbWDDb_AppDBl  *)p;
  if ((int)(pa->anz) < 2) {return(XbWDMf_NoPara);};
  TV = (XbWDDb_DbIDbl  *)XbWFDb_GtEOT();                          /* Platz belegen */
  nl =  strlen((char*)(pa->nm));
  if (nl > 15) {nl = 15; };
  TV->tp  = XbWDDb_Dbl | nl;
  if (XbWFDb_Add(XbWFDb_GetSiz((XbWDDb_DbIVar  *)TV)) == NULL) {return(1);};
  strncpy(TV->nm,(char*)pa->nm,nl);
  ((XbWDDb_DbIDbl  *)TV)->inh = (double)atof((char *)(pa->inh));
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_AppDblVal(      ****/
int  XbWFDb_AppDblVal(void  *(*p)[], double val){
  XbWDDb_AppDBl  *pa;
  XbWDDb_DbIDbl  *TV;
  int nl;
 
  if ( (int)(*p)[0] == -1){
    puts("\n");
    XbWFSy_bf_printf("Function: \"%s\" Add Double VAR-Element)\n",(char*)(*p)[1]);
    puts  ("          2 Parameters");
    printf("Syntax:   %s( (\"VAR-Type\") <Content> );",(char*)(*p)[1]);
    puts  ("\n");
    puts  ("Params:   VAR-Type is a string, max. 15 chars (\"Name\")");
    puts  ("          Content is a floating point number to put in");
    printf("Sample:   \"%s\"( myname 1.234 );",(char*)(*p)[1]);
    return(0);
    };
 
 
  pa = (XbWDDb_AppDBl  *)p;
  if ((int)(pa->anz) < 2) {return(XbWDMf_NoPara);};
  TV = (XbWDDb_DbIDbl  *)XbWFDb_GtEOT();                          /* Platz belegen */
  nl =  strlen((char*)(pa->nm));
  if (nl > 15) {nl = 15; };
  TV->tp  = XbWDDb_Dbl | nl;
  if (XbWFDb_Add(XbWFDb_GetSiz((XbWDDb_DbIVar  *)TV)) == NULL) {return(1);};
  strncpy(TV->nm,(char*)pa->nm,nl);
  ((XbWDDb_DbIDbl  *)TV)->inh = val;
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_AppNPtr(     ****/
int  XbWFDb_AppNPtr(void  *(*p)[],int (*t)[]){
  XbWDDb_AppNPtr  *pa;
  XbWDDb_DbINPtr  *TV;
  int nl;
 
  if ( (int)(*p)[0] == -1){
    puts("\n");
    XbWFSy_bf_printf("Function: \"%s\" Add Pointer VAR-Element)\n",(char*)(*p)[1]);
    puts  ("          2 Parameters");
    printf("Syntax:   %s( (\"VAR-Type\") Pointer );",(char*)(*p)[1]);
    puts  ("\n");
    puts  ("Params:   VAR-Type is a string, max. 15 chars (\"Name\")");
    puts  ("          Pointer gives Address to put in");
    printf("Sample:   \"%s\"( myname (ptr)OBJ:MyObject.MyVARElement );",(char*)(*p)[1]);
    return(0);
    };
 
 
  pa = (XbWDDb_AppNPtr  *)p;
  if ((int)(pa->anz) < 2) {return(XbWDMf_NoPara);};
  TV = (XbWDDb_DbINPtr  *)XbWFDb_GtEOT();                          /* Platz belegen */
  nl =  strlen((char*)(pa->nm));
  if (nl > 15) {nl = 15; };
  TV->tp  = XbWDDb_NPtr | nl;
  if (XbWFDb_Add(XbWFDb_GetSiz((XbWDDb_DbIVar  *)TV)) == NULL) {return(1);};
  strncpy(TV->nm,(char*)pa->nm,nl);
  if (pa->inh == NULL) {
    ((XbWDDb_DbINPtr  *)TV)->inh = 0;
    }
  else {
    ((XbWDDb_DbINPtr  *)TV)->inh =
     XbWDDb_C_PtrToDbI((char*)(pa->inh),XbWDDb_DbISys);
    };
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_AppIPtr(        ****/
int  XbWFDb_AppIPtr(void  *(*p)[]){
  XbWDDb_AppIPtr  *pa;
  XbWDDb_DbIIPtr  *TV;
  int nl;
  pa = (XbWDDb_AppIPtr  *)p;
  if ((int)(pa->anz) < 2) {return(XbWDMf_NoPara);};
  TV = (XbWDDb_DbIIPtr  *)XbWFDb_GtEOT();                          /* Platz belegen */
  nl =  strlen((char*)(pa->nm));
  if (nl > 15) {nl = 15; };
  TV->tp  = XbWDDb_NPtr | nl;
  if (XbWFDb_Add(XbWFDb_GetSiz((XbWDDb_DbIVar  *)TV)) == NULL) {return(1);};
  strncpy(TV->nm,(char*)pa->nm,nl);
  if (pa->inh == NULL) {
    ((XbWDDb_DbIIPtr  *)TV)->inh = 0;
    }
  else {
    ((XbWDDb_DbIIPtr  *)TV)->inh =
      XbWDDb_C_PtrToDbI((char*)(pa->inh),XbWDDb_DbISys);
    };
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_AppGPtr(     ****/
int  XbWFDb_AppGPtr(void  *(*p)[],int (*t)[]){
  XbWDDb_DbIGPtr  *TV;
  TV = (XbWDDb_DbIGPtr  *)XbWFDb_GtEOT();                          /* Platz belegen */
  if(p!=NULL){
    if ( (int)(*p)[0] == -1){
      puts("\n");
      XbWFSy_bf_printf("Function: \"%s\" Add End-Of-Group Pointer VAR-Element)\n",(char*)(*p)[1]);
      puts  ("          No Parameters");
      printf("Syntax:   %s();",(char*)(*p)[1]);
      puts  ("\n");
      return(0);
      };
    };
 
  TV->tp  = XbWDDb_GPtr;
  if (XbWFDb_Add(XbWFDb_GetSiz((XbWDDb_DbIVar  *)TV)) == NULL) {return(1);};
  ((XbWDDb_DbIGPtr  *)TV)->inh = XbWDDb_C_PtrToDbI((XbWDDb_DbIVar  *)XbWDDb_DbIGrp,XbWDDb_DbISys);
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_GtPrj(       ****/
XbWDDb_DbIVar  *XbWFDb_GtPrj(char *name){
  XbWDDb_DbIVar  *END;
  XbWDDb_DbIVar  *AP;
  XbWDDb_DbINPtr  *TNP;
  END = (XbWDDb_DbIVar  *)XbWFDb_GtEOT();
  AP = (XbWDDb_DbIVar  *)XbWDDb_DbISys;
  while (AP < END) {
    if ((AP->tp & XbWDDb_Typ) == XbWDDb_Str){
      if (XbWFTb_CmpStr((char*)XbWFDb_GetStr((XbWDDb_DbIStr  *)AP),name) == 0) {
        return(AP);
        };
      }
    else {
      return(NULL);
      };
    XbWFDb_ForWd(&AP,(XbWDDb_DbIVar  *)XbWDDb_DbISys);
    if ((AP->tp & XbWDDb_Typ) == XbWDDb_NPtr){
      if (XbWFTb_CmpStr((char*)XbWFDb_GetNam(AP),"PRJ") == 0) {
        TNP = (XbWDDb_DbINPtr  *)AP;
        if (TNP->inh == 0) {
          return(NULL);
          };
        AP = XbWFDb_CDbIToPtr( ((XbWDDb_DbINPtr  *)TNP)->inh,XbWDDb_DbISys);
        }
      else {
        return(NULL);
        };
      }
    else {
      return(NULL);
      };
    };
  return(NULL);
  };
/*}}}  */
/*{{{  XbWFDb_FindGPtr(    ****/
XbWDDb_DbIVar  *XbWFDb_FindGPtr(XbWDDb_DbIVar  *start, XbWDDb_DbIVar  *IP){
  XbWDDb_DbIVar  *END;
  XbWDDb_DbIVar  *AP;
  END = (XbWDDb_DbIVar  *)XbWDDb_Dbk->T_ITM_END;
  AP = start;
  while (AP < END) {
    if ((AP->tp & XbWDDb_Typ) == XbWDDb_GPtr){
      return(AP);
      };
    XbWFDb_ForWd(&AP,IP);
    };
  return(NULL);
  };
/*}}}  */
/*{{{  XbWFDb_FindGrp(     ****/
XbWDDb_DbIVar  *XbWFDb_FindGrp(char *liste, char *name){
  XbWDDb_DbINPtr  *TV;
  if (liste[0] == 'O'){
    if (strcmp(liste,"OBJ") == 0){
      char sname[6];
      if (name==NULL){
        sname[0]=0;
        }
      else {
        strncpy(sname,name,4);
        sname[4]=0;
        };
      if ((TV = (XbWDDb_DbINPtr  *)XbWFDb_FindNptr(XbWDDb_DbIPrj,"WDW"))==NULL){
        goto nochmal_finden;
        };
      do {
        if (TV->inh){
          TV = (XbWDDb_DbINPtr  *)XbWFDb_CDbIToPtr( ((XbWDDb_DbINPtr  *)TV)->inh,
            XbWDDb_DbISys);
          if (XbWFTb_CmpStr((char*)XbWFDb_GetStr((XbWDDb_DbIStr  *)TV),sname)==0) {
            /*return((XbWDDb_DbIVar  *)TV);*/
            while (strcmp((char*)XbWFDb_GetNam((XbWDDb_DbIVar  *)TV),"obj") != 0){
              XbWFDb_ForWd((XbWDDb_DbIVar  **)&TV,XbWDDb_DbISys);
              };
            if ( ((XbWDDb_DbINPtr  *)TV)->inh == 0){ goto nochmal_finden; };
            do {
              if (TV->inh){
                TV = (XbWDDb_DbINPtr  *)XbWFDb_CDbIToPtr( ((XbWDDb_DbINPtr  *)TV)->inh,
                  XbWDDb_DbISys);
                if (name == NULL) {
                  return((XbWDDb_DbIVar  *)TV);
                  };
                if (XbWFTb_CmpStr((char*)XbWFDb_GetStr((XbWDDb_DbIStr  *)TV),name)==0) {
                  return((XbWDDb_DbIVar  *)TV);
                  };
                }
              else {TV = NULL;};
              }
            while ((TV!=NULL)&((TV = (XbWDDb_DbINPtr  *)XbWFDb_FindNptr((XbWDDb_DbIVar  *)TV,liste))!= NULL));
            };
          }
        else {TV = NULL;};
        }
      while ((TV!=NULL)&((TV = (XbWDDb_DbINPtr  *)XbWFDb_FindNptr((XbWDDb_DbIVar  *)TV,"WDW"))!= NULL));
      };
    };

  nochmal_finden:
  if ((TV = (XbWDDb_DbINPtr  *)XbWFDb_FindNptr(XbWDDb_DbIPrj,liste))==NULL){
    return(NULL);
    };
  do {
    if (TV->inh){
      TV = (XbWDDb_DbINPtr  *)XbWFDb_CDbIToPtr( ((XbWDDb_DbINPtr  *)TV)->inh,
        XbWDDb_DbISys);
      if (name == NULL) {
        return((XbWDDb_DbIVar  *)TV);
        };
      if (XbWFTb_CmpStr((char*)XbWFDb_GetStr((XbWDDb_DbIStr  *)TV),name)==0) {
        return((XbWDDb_DbIVar  *)TV);
        };
      }
    else {TV = NULL;};
    }
  while ((TV!=NULL)&((TV = (XbWDDb_DbINPtr  *)XbWFDb_FindNptr((XbWDDb_DbIVar  *)TV,liste))!= NULL));
  return(NULL);
  };
/*}}}  */
/*{{{  XbWFDb_AppGrp(      ****/
int  XbWFDb_AppGrp(char *liste, char *name){
  XbWDDb_DbINPtr  *TL;
  XbWDDb_DbIPtr *TI;
  XbWDDb_DbIVar  *TV;
  if (XbWFTb_CmpStr(liste,"OBJ") == 0) {
    TI = (XbWDDb_DbIPtr*)XbWVWd_W.obj;
    if (*TI == (long)NULL) { return(1);  };
    if ((TV = XbWFDb_CDbIToPtr(*TI,XbWDDb_DbISys)) == NULL) { return(1);};
    if ((TL = (XbWDDb_DbINPtr *)XbWFDb_NextGrp(TV,name)) == NULL) { return(1);};
    }
  else {
    if ((TL = (XbWDDb_DbINPtr  *)XbWFDb_FindGrp(liste,name))==NULL){return(1);};
    };
  XbWDDb_DbIGrp = (XbWDDb_DbIStr  *)TL;
  if ((TL = (XbWDDb_DbINPtr  *)XbWFDb_FindGPtr((XbWDDb_DbIVar  *)TL,(XbWDDb_DbIVar  *)XbWDDb_DbISys))==NULL) {
    return(1);
    };
  TL->tp = (TL->tp & XbWDDb_NLen) | XbWDDb_FPtr;
  ((XbWDDb_DbINPtr  *)TL)->inh = XbWDDb_C_PtrToDbI((XbWDDb_DbIVar  *)XbWFDb_GtEOT(),XbWDDb_DbISys);
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_AppFPtr(     ****/
int  XbWFDb_AppFPtr(void  *(*p)[]){
  XbWDDb_AppFPtr  *pa;
  pa = (XbWDDb_AppFPtr  *)p;
  if ((int)(pa->anz) < 2) {return(XbWDMf_NoPara);};
  return(XbWFDb_AppGrp((char*)pa->lnm,(char*)pa->gnm));
  };
/*}}}  */
/*{{{  XbWFDb_MakeObj(      ****/
int  XbWFDb_MakeObj(void  *(*p)[], int (*t)[], int markmode){
  void  *vp[6];
  XbWDDb_DbIVar  *ac_gp;
  XbWDDb_DbIVar  *gv_gp;
  XbWDDb_DbIVar  *sc_gp;
  char *wv,*sstr; int ii,xa,ya,cx,cy;
  char *colortxt=NULL;
 
  if ((int)(*p)[0] < 12) {
    if ( ((int)(*p)[0] >= 8) & ((int)(*p)[0] <= 11)) {
      colortxt = (char*)(*p)[8];
      if (colortxt == NULL){
        return(1);
        };
      }
    else {
      return(1);
      };
    };
  if (markmode){
    XbWDTb_SetPara(1,"OBJ",NULL,NULL,NULL,NULL); XbWFDb_MarlGrp(&vp);
    }
  XbWDTb_SetPara(3,"OBJ",0,(*p)[1],NULL,NULL); XbWFDb_AppStr(&vp,NULL);
  XbWDTb_SetPara(2,"OBJ",NULL,NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
  gv_gp = XbWFDb_FindGrp("OBX","genvars");
  if (gv_gp == NULL) { return(1); };
 
  sstr = (char*)XbWFDb_VarInh(gv_gp,XbWDDb_Str,"WDWName",1);
  if (sstr == NULL) { return(1); };

  ac_gp = XbWFDb_FindGrp("WDW",sstr);

  wv   = (char*)XbWFDb_GetDbI("WDW",sstr,"WDW");

  if (wv == NULL) {
    if (wv == NULL) { return(1); };
    };

  XbWDTb_SetPara(2,"W",(void *)wv,NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);

  sc_gp = XbWFDb_FindGrp("SVR","colors");
  ac_gp = XbWFDb_FindGrp("OBJ",(char*)(*p)[1]);
  XbWVDb_AkDbkEl = ac_gp;

  cx = XbWFGr_TWidth("M");
  /*{{{  if ((*t)[4] == XbWDMf_VLPar){*/
  if ((*t)[4] == XbWDMf_VLPar){
    XbWDTb_SetPara(2,"X",(void  *)(*p)[4],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
    xa = (int)XbWFDb_GetNum(ac_gp,"X",1);
    }
  else {
    xa = cx*((int)(*p)[4])+3;
    XbWDTb_SetPara(2,"X",xa,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
    };
  /*}}}  */

  cy = XbWFGr_THeight();
  /*{{{  if ((*t)[5] == XbWDMf_VLPar){*/
  if ((*t)[5] == XbWDMf_VLPar){
    XbWDTb_SetPara(2,"Y",(void  *)(*p)[5],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
    ya = (int)XbWFDb_GetNum(ac_gp,"Y",1);
    }
  else {
    ya = cy*((int)(*p)[5]);
    XbWDTb_SetPara(2,"Y",ya,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
    };
  /*}}}  */
  /*{{{  if ((*t)[6] == XbWDMf_VLPar){*/
  if ((*t)[6] == XbWDMf_VLPar){
    XbWDTb_SetPara(2,"x",(void  *)(*p)[6],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
    }
  else {
    XbWDTb_SetPara(2,"x",(xa+cx*((int)(*p)[6])),NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
    };
  /*}}}  */
  /*{{{  if ((*t)[7] == XbWDMf_VLPar){*/
  if ((*t)[7] == XbWDMf_VLPar){
    XbWDTb_SetPara(2,"y",(void  *)(*p)[7],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
    }
  else {
    XbWDTb_SetPara(2,"y",(ya+cy*((int)(*p)[7])),NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
    };
  /*}}}  */
  if (colortxt == NULL){
    /*{{{  if ((*t)[8] == XbWDMf_VLPar){*/
    if ((*t)[8] == XbWDMf_VLPar){
      XbWDTb_SetPara(2,"b",(void  *)(*p)[8],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
      }
    else {
      ii = (int)XbWFDb_GetNum(sc_gp,(char*)(*p)[8],1);
      XbWDTb_SetPara(2,"b",ii,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
      };
    /*}}}  */
    /*{{{  if ((*t)[9] == XbWDMf_VLPar){*/
    if ((*t)[9] == XbWDMf_VLPar){
      XbWDTb_SetPara(2,"f",(void  *)(*p)[9],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
      }
    else {
      ii = (int)XbWFDb_GetNum(sc_gp,(char*)(*p)[9],1);
      XbWDTb_SetPara(2,"f",ii,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
      };
    /*}}}  */
    /*{{{  if ((*t)[10] == XbWDMf_VLPar){*/
    if ((*t)[10] == XbWDMf_VLPar){
      XbWDTb_SetPara(2,"F",(void  *)(*p)[10],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
      }
    else {
      ii = (int)XbWFDb_GetNum(sc_gp,(char*)(*p)[10],1);
      XbWDTb_SetPara(2,"F",ii,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
      };
    /*}}}  */
    /*{{{  if ((*t)[11] == XbWDMf_VLPar){*/
    if ((*t)[11] == XbWDMf_VLPar){
      XbWDTb_SetPara(2,"t",(void  *)(*p)[11],NULL,NULL,NULL);
      XbWFDb_AppNPtr(&vp,NULL);
      }
    else {
      ii = (int)XbWFDb_GetNum(sc_gp,(char*)(*p)[11],1);
      XbWDTb_SetPara(2,"t",ii,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
      };
    /*}}}  */
    /*{{{  if ((*t)[2] == XbWDMf_VLPar){*/
    if ((*t)[2] == XbWDMf_VLPar){
      XbWDTb_SetPara(2,"D",(void  *)(*p)[2],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
      }
    else {
      XbWDTb_SetPara(3,"D",0,(char*)(*p)[2],NULL,NULL); XbWFDb_AppStr(&vp,NULL);
      };
    /*}}}  */
    if ((int)(*p)[0] >= 13) {
      /*{{{  if ((*t)[13] == XbWDMf_VLPar){*/
      if ((*t)[13] == XbWDMf_VLPar){
        XbWDTb_SetPara(2,"d",(void  *)(*p)[13],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
        }
      else {
        XbWDTb_SetPara(2,"d",(void *)(*p)[13],NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
        };
      /*}}}  */
      }
    else {
      XbWDTb_SetPara(2,"d",1,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
      };
 
    if ((int)(*p)[0] >= 14) {
      /*{{{  if ((*t)[14] == XbWDMf_VLPar){*/
      if ((*t)[14] == XbWDMf_VLPar){
        XbWDTb_SetPara(2,"e",(void  *)(*p)[14],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
        }
      else {
        XbWDTb_SetPara(2,"e",(void *)(*p)[14],NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
        };
      /*}}}  */
      }
    else {
      XbWDTb_SetPara(2,"e",1,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
      };
 
    /*{{{  if ((*t)[12] == XbWDMf_VLPar){*/
    if ((*t)[12] == XbWDMf_VLPar){
      XbWDTb_SetPara(2,"w",(void  *)(*p)[12],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
      }
    else {
      XbWDTb_SetPara(2,"w",((int)(*p)[12]),NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
      };
    /*}}}  */
    /*{{{  if ((*t)[3] == XbWDMf_VLPar){*/
    if ((*t)[3] == XbWDMf_VLPar){
      XbWDTb_SetPara(2,"E",(void  *)(*p)[3],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
      }
    else {
      XbWDTb_SetPara(3,"E",0,(char*)(*p)[3],NULL,NULL); XbWFDb_AppStr(&vp,NULL);
      };
    /*}}}  */
 
    }
  else {
    void *dd;
    dd = (void*)XbWFDb_GetDbI("COL",colortxt,"Fill");
    if (dd==NULL){
      printf("ERROR: cannot find color type COL:%s.Fill !",colortxt);
      XbWDTb_SetPara(2,"b",8,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
      }
    else {
      XbWDTb_SetPara(2,"b",dd,NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
      };
 
    dd = (void*)XbWFDb_GetDbI("COL",colortxt,"Bright");
    if (dd==NULL){
      printf("ERROR: cannot find color type COL:%s.Bright !",colortxt);
      XbWDTb_SetPara(2,"f",15,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
      }
    else {
      XbWDTb_SetPara(2,"f",dd,NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
      };
 
    dd = (void*)XbWFDb_GetDbI("COL",colortxt,"Dark");
    if (dd==NULL){
      printf("ERROR: cannot find color type COL:%s.Dark !",colortxt);
      XbWDTb_SetPara(2,"F",15,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
      }
    else {
      XbWDTb_SetPara(2,"F",dd,NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
      };
 
    dd = (void*)XbWFDb_GetDbI("COL",colortxt,"Text");
    if (dd==NULL){
      printf("ERROR: cannot find color type COL:%s.Text !",colortxt);
      XbWDTb_SetPara(2,"t",15,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
      }
    else {
      XbWDTb_SetPara(2,"t",dd,NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
      };
 
    /*{{{  if ((*t)[2] == XbWDMf_VLPar){*/
    if ((*t)[2] == XbWDMf_VLPar){
      XbWDTb_SetPara(2,"D",(void  *)(*p)[2],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
      }
    else {
      XbWDTb_SetPara(3,"D",0,(char*)(*p)[2],NULL,NULL); XbWFDb_AppStr(&vp,NULL);
      };
    /*}}}  */
    if ((int)(*p)[0] >= 10) {
      /*{{{  if ((*t)[10] == XbWDMf_VLPar){*/
      if ((*t)[10] == XbWDMf_VLPar){
        XbWDTb_SetPara(2,"d",(void  *)(*p)[10],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
        }
      else {
        XbWDTb_SetPara(2,"d",(void *)(*p)[10],NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
        };
      /*}}}  */
      }
    else {
      XbWDTb_SetPara(2,"d",1,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
      };
 
    if ((int)(*p)[0] >= 11) {
      /*{{{  if ((*t)[11] == XbWDMf_VLPar){*/
      if ((*t)[11] == XbWDMf_VLPar){
        XbWDTb_SetPara(2,"e",(void  *)(*p)[11],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
        }
      else {
        XbWDTb_SetPara(2,"e",(void *)(*p)[11],NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
        };
      /*}}}  */
      }
    else {
      XbWDTb_SetPara(2,"e",1,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
      };
 
    if ((int)(*p)[0] > 8){
      /*{{{  if ((*t)[9] == XbWDMf_VLPar){*/
      if ((*t)[9] == XbWDMf_VLPar){
        XbWDTb_SetPara(2,"w",(void  *)(*p)[9],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
        }
      else {
        XbWDTb_SetPara(2,"w",((int)(*p)[9]),NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
        };
      /*}}}  */
      }
    else {
      XbWDTb_SetPara(2,"w",(void*)1,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
      };
    /*{{{  if ((*t)[3] == XbWDMf_VLPar){*/
    if ((*t)[3] == XbWDMf_VLPar){
      XbWDTb_SetPara(2,"E",(void  *)(*p)[3],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
      }
    else {
      XbWDTb_SetPara(3,"E",0,(char*)(*p)[3],NULL,NULL); XbWFDb_AppStr(&vp,NULL);
      };
    /*}}}  */
    };
  /*{{{  What's that??*/
  sstr = (char*)(*p)[2]; /* Display-Mode mit "@" ?? */
  if (sstr[0] == '@'){
    XbWDTb_SetPara(2,"@*",NULL,NULL,NULL,NULL);
    XbWFDb_AppNPtr(&vp,NULL);
    }
  else {
    sstr = (char*)(*p)[3]; /* Editier-Mode mit "@" ?? */
    if (sstr[0] == '@'){
      XbWDTb_SetPara(2,"@*",NULL,NULL,NULL,NULL);
      XbWFDb_AppNPtr(&vp,NULL);
      };
    };
  /*}}}  */
 
 
  XbWFDb_AppGPtr(NULL,NULL);
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_AppObj(      ****/
int  XbWFDb_AppObj(void  *(*p)[], int (*t)[]){
  return(XbWFDb_MakeObj(p,t,1));
  };
/*}}}  */
    #define DEBUG_NPTR(TT) \
    XbWFDb_PrPtr(stdout,((XbWDDb_DbINPtr*)TT)->nm,0,0,(XbWDDb_DbIVar*)TT);\
    puts("");
    #define DEBUG_STR(TT) \
    XbWFDb_PrStr(stdout,&(TT->nmi[(TT->tp & XbWDDb_NLen)]),0,0,(XbWDDb_DbIVar*)TT);\
    puts("");
 
/*{{{  XbWFDb_InsertObj(   ****/
int  XbWFDb_InsertObj(void  *(*p)[], int (*t)[]){
  char ObjName[100];
  char WdwName[100];
  XbWDDb_DbINPtr TheEnd;
  XbWDDb_DbINPtr Obj12Pointer;
  XbWDDb_DbIVar *Obj1ToObj2;
  XbWDDb_DbIVar *ObjNewToObj2;
  XbWDDb_DbIVar *gr_st;
  XbWDDb_DbIVar *WdwStart;
  XbWDDb_DbIVar *ObjWdwName;
 
  TheEnd.inh = XbWDDb_C_PtrToDbI((XbWDDb_DbIVar *)XbWFDb_GtEOT(),XbWDDb_DbISys);
  sprintf(ObjName,(*p)[1]);
  strncpy(WdwName,ObjName,4);
  WdwName[4]=0;
 
  if(!XbWFDb_MakeObj(p,t,0)){
    /* search 1st Object in Wdw for Pointer to the next.. */
    gr_st = XbWFDb_FindGrp("OBJ",WdwName);  /* Wdw IST RICHTIG !! */
    if (gr_st == NULL) {
      XbWFSy_bf_printf("\nERROR: Object %s not found!",WdwName);
      return(1);
      }
    XbWFDb_ForWd(&gr_st,XbWDDb_DbISys);
    Obj1ToObj2=gr_st;
 
    /* TT has the pointer to the 2nd object in window object list */
    Obj12Pointer.inh = ((XbWDDb_DbINPtr *)Obj1ToObj2)->inh;
 
    /* Relink Object Queue: the 2nd Object is now the NEW object */
    ((XbWDDb_DbINPtr*)Obj1ToObj2)->inh = TheEnd.inh;
 
    /* Relink Object Queue: append the complete queue to the 2nd Object */
    ObjNewToObj2= (XbWDDb_DbIVar *)XbWFDb_GetDbI("OBJ",ObjName,"OBJ");
    if (ObjNewToObj2 == NULL) {
      XbWFSy_bf_printf("\nERROR: OBJ:%s.OBJ String VAR Element not found!",
        ObjName);
      return(1);
      }
    XbWFDb_ForWd(&ObjNewToObj2,XbWDDb_DbISys);
    if (ObjNewToObj2 == NULL) {
      XbWFSy_bf_printf("\nERROR: OBJ:%s.OBJ Pointer VAR Element not found!",
        ObjName);
      return(1);
      }
    ((XbWDDb_DbINPtr *)ObjNewToObj2)->inh=Obj12Pointer.inh;
 
    /* Now let's relink the object to the new window ... */
    WdwStart = XbWFDb_FindGrp("WDW",WdwName);
    if (gr_st == NULL) {
      XbWFSy_bf_printf("\nERROR: Window %s not found!",WdwName);
      return(1);
      }
 
    ObjWdwName=(XbWDDb_DbIVar *)XbWFDb_GetDbI("OBJ",ObjName,"W");
    ((XbWDDb_DbINPtr *)ObjWdwName)->inh = XbWDDb_C_PtrToDbI(WdwStart,XbWDDb_DbISys);
 
    XbWFWd_SwitchTo(WdwName,16);
    return(0);
    }
  return(1);
  };
/*}}}  */
/*{{{  XbWFDb_AppWdw(      ****/
int  XbWFDb_AppWdw(void  *(*p)[], int (*t)[]){
  void  *vp[7];
  XbWDDb_DbIVar  *ac_gp;
  XbWDDb_DbIVar  *gv_gp;
  XbWDDb_DbIVar  *sc_gp;
  int ii,xa,ya,cx,cy;
  char *colortxt=NULL;
  int parameter = 0;
 
  #define GETHELPFILE 1
  #define GETICON     2
  #define GETCOLORS   4
  #define GETCOLORGRP 8
  #define GETCGRP     16
  /*    1 2 3  4  5     6    7    8   9   10  11 */
  /* name x y sx sy helpfile icon bkc bfc dfc txc */
  /* name x y sx sy colorgrp                      */
 
  switch ((int)(*p)[0]) {
    case 6: parameter=GETCGRP; break;
    case 7: parameter=GETHELPFILE|GETICON; break;
    case 8: parameter=GETHELPFILE|GETICON|GETCOLORGRP; break;
    case 11: parameter=GETHELPFILE|GETICON|GETCOLORS; break;
    default: return(1);
    };
 
  XbWDTb_SetPara(1,"WDW",NULL,NULL,NULL,NULL); XbWFDb_MarlGrp(&vp);
  XbWDTb_SetPara(3,"WDW",0,(*p)[1],NULL,NULL); XbWFDb_AppStr(&vp,NULL);
  XbWDTb_SetPara(2,"WDW",NULL,NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
 
  gv_gp = XbWFDb_FindGrp("OBX","genvars");
  if (gv_gp == NULL) { return(1); };
  ac_gp = XbWFDb_FindGrp("WDW",(char*)(*p)[1]);
  if (ac_gp == NULL) { return(1); };
 
  XbWDTb_SetPara(2,"tp",(void*)17,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
  XbWDTb_SetPara(2,"layer",(void*)0,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);

  XbWVDb_AkDbkEl = ac_gp;

  cx = XbWFGr_TWidth("M");
  if ((*t)[2] == XbWDMf_VLPar){
  /*{{{  */
    XbWDTb_SetPara(2,"nx",(void  *)(*p)[2],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
    xa = (int)XbWFDb_GetNum(ac_gp,"nx",1);
    }
  else {
    xa = cx*((int)(*p)[2])+3;
    XbWDTb_SetPara(2,"nx",xa,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
    };
  /*}}}  */
 
  cy = XbWFGr_THeight();
  if ((*t)[3] == XbWDMf_VLPar){
  /*{{{  */
    XbWDTb_SetPara(2,"ny",(void  *)(*p)[3],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
    ya = (int)XbWFDb_GetNum(ac_gp,"ny",1);
    }
  else {
    ya = cy*((int)(*p)[3]);
    XbWDTb_SetPara(2,"ny",ya,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
    };
  /*}}}  */
  if ((*t)[4] == XbWDMf_VLPar){
  /*{{{  */
    XbWDTb_SetPara(2,"sx",(void  *)(*p)[4],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
    }
  else {
    XbWDTb_SetPara(2,"sx",(cx*((int)(*p)[4])),NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
    };
  /*}}}  */
  if ((*t)[5] == XbWDMf_VLPar){
  /*{{{  */
    XbWDTb_SetPara(2,"sy",(void  *)(*p)[5],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
    }
  else {
    XbWDTb_SetPara(2,"sy",(cy*((int)(*p)[5])),NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
    };
  /*}}}  */
 
  XbWDTb_SetPara(2,"wov",(void*)0,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
 
  if (parameter & GETICON){
    /*{{{  */
    sc_gp = XbWFDb_FindGrp("ICN","WdwGroups");
    if (sc_gp == NULL) { return(1); };
    if ((*t)[7] == XbWDMf_VLPar){
      if ((*p)[7] == NULL){
        XbWDTb_SetPara(2,"icn",1,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
        };
      XbWDTb_SetPara(2,"icn",(void  *)(*p)[7],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
      }
    else {
      XbWDTb_SetPara(2,"icn",(void *)(*p)[7],NULL,NULL,NULL);
      XbWFDb_AppInt(&vp,NULL);
      };
    /*}}}  */
    }
  else {
    XbWDTb_SetPara(2,"icn",1,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
    };
 
  if (parameter & GETCOLORS){
    sc_gp = XbWFDb_FindGrp("SVR","colors");
    if (sc_gp == NULL) { return(1); };
    if ((*t)[8] == XbWDMf_VLPar){
    /*{{{  */
      XbWDTb_SetPara(2,"bkc",(void  *)(*p)[8],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
      }
    else {
      ii = (int)XbWFDb_GetNum(sc_gp,(char*)(*p)[8],1);
      XbWDTb_SetPara(2,"bkc",ii,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
      };
    /*}}}  */
    if ((*t)[11] == XbWDMf_VLPar){
    /*{{{  */
      XbWDTb_SetPara(2,"txc",(void  *)(*p)[11],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
      }
    else {
      ii = (int)XbWFDb_GetNum(sc_gp,(char*)(*p)[11],1);
      XbWDTb_SetPara(2,"txc",ii,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
      };
    /*}}}  */
    if ((*t)[9] == XbWDMf_VLPar){
    /*{{{  */
      XbWDTb_SetPara(2,"bfc",(void  *)(*p)[9],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
      }
    else {
      ii = (int)XbWFDb_GetNum(sc_gp,(char*)(*p)[9],1);
      XbWDTb_SetPara(2,"bfc",ii,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
      };
    /*}}}  */
    if ((*t)[10] == XbWDMf_VLPar){
    /*{{{  */
      XbWDTb_SetPara(2,"dfc",(void  *)(*p)[10],NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
      }
    else {
      ii = (int)XbWFDb_GetNum(sc_gp,(char*)(*p)[10],1);
      XbWDTb_SetPara(2,"dfc",ii,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
      };
    /*}}}  */
    }
  else {
    if (parameter & GETCOLORGRP){
      /*{{{  */
      void *dd;
      colortxt = (char*)(*p)[8];
      if (colortxt == NULL){
        return(1);
        };
      dd = (void*)XbWFDb_GetDbI("COL",colortxt,"Fill");
      /*{{{  */
      if (dd==NULL){
        printf("ERROR: cannot find color type COL:%s.Fill !",colortxt);
        XbWDTb_SetPara(2,"bkc",8,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
        }
      else {
        XbWDTb_SetPara(2,"bkc",dd,NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
        };
      /*}}}  */
      dd = (void*)XbWFDb_GetDbI("COL",colortxt,"Text");
      /*{{{  */
      if (dd==NULL){
        printf("ERROR: cannot find color type COL:%s.Text !",colortxt);
        XbWDTb_SetPara(2,"txc",15,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
        }
      else {
        XbWDTb_SetPara(2,"txc",dd,NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
        };
      
      /*}}}  */
      dd = (void*)XbWFDb_GetDbI("COL",colortxt,"Bright");
      /*{{{  */
      if (dd==NULL){
        printf("ERROR: cannot find color type COL:%s.Bright !",colortxt);
        XbWDTb_SetPara(2,"bfc",15,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
        }
      else {
        XbWDTb_SetPara(2,"bfc",dd,NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
        };
      
      /*}}}  */
      dd = (void*)XbWFDb_GetDbI("COL",colortxt,"Dark");
      /*{{{  */
      if (dd==NULL){
        printf("ERROR: cannot find color type COL:%s.Dark !",colortxt);
        XbWDTb_SetPara(2,"dfc",15,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
        }
      else {
        XbWDTb_SetPara(2,"dfc",dd,NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
        };
      
      /*}}}  */
      /*}}}  */
      }
    else {
      if (parameter & GETCGRP){
        /*{{{  */
        void *dd;
        colortxt = (char*)(*p)[6];
        if (colortxt == NULL){
          return(1);
          };
        dd = (void*)XbWFDb_GetDbI("COL",colortxt,"Fill");
        /*{{{  */
        if (dd==NULL){
          printf("ERROR: cannot find color type COL:%s.Fill !",colortxt);
          XbWDTb_SetPara(2,"bkc",8,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
          }
        else {
          XbWDTb_SetPara(2,"bkc",dd,NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
          };
        /*}}}  */
        dd = (void*)XbWFDb_GetDbI("COL",colortxt,"Text");
        /*{{{  */
        if (dd==NULL){
          printf("ERROR: cannot find color type COL:%s.Text !",colortxt);
          XbWDTb_SetPara(2,"txc",15,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
          }
        else {
          XbWDTb_SetPara(2,"txc",dd,NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
          };
        
        /*}}}  */
        dd = (void*)XbWFDb_GetDbI("COL",colortxt,"Bright");
        /*{{{  */
        if (dd==NULL){
          printf("ERROR: cannot find color type COL:%s.Bright !",colortxt);
          XbWDTb_SetPara(2,"bfc",15,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
          }
        else {
          XbWDTb_SetPara(2,"bfc",dd,NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
          };
        
        /*}}}  */
        dd = (void*)XbWFDb_GetDbI("COL",colortxt,"Dark");
        /*{{{  */
        if (dd==NULL){
          printf("ERROR: cannot find color type COL:%s.Dark !",colortxt);
          XbWDTb_SetPara(2,"dfc",15,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
          }
        else {
          XbWDTb_SetPara(2,"dfc",dd,NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
          };
        
        /*}}}  */
        /*}}}  */
        }
      else {
        XbWDTb_SetPara(2,"icn",1,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
        };
      };
    };
 
  XbWDTb_SetPara(2,"wfx",(void*)0,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
  XbWDTb_SetPara(2,"wfe",(void*)0,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
  XbWDTb_SetPara(2,"bd",(void*)0,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
  XbWDTb_SetPara(2,"obj",(void*)0,NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
 
  if (parameter & GETHELPFILE){
    if ((*p)[6]==NULL){
      XbWDTb_SetPara(3,"inf",0,"helpfile.inf",NULL,NULL); XbWFDb_AppStr(&vp,NULL);
      }
    else {
      XbWDTb_SetPara(3,"inf",0,(*p)[6],NULL,NULL); XbWFDb_AppStr(&vp,NULL);
      };
    }
  else {
    XbWDTb_SetPara(3,"inf",0,"helpfile.inf",NULL,NULL); XbWFDb_AppStr(&vp,NULL);
    };
  XbWFDb_AppGPtr(NULL,NULL);
 
  XbWDTb_SetPara(1,"OBJ",NULL,NULL,NULL,NULL); XbWFDb_MarlGrp(&vp);
  XbWDTb_SetPara(3,"OBJ",0,(*p)[1],NULL,NULL); XbWFDb_AppStr(&vp,NULL);
  XbWDTb_SetPara(2,"OBJ",NULL,NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);
  XbWDTb_SetPara(3,"W",0,(*p)[1],NULL,NULL); XbWFDb_AppStr(&vp,NULL);
  XbWDTb_SetPara(2,"X",(void*)0,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
  XbWDTb_SetPara(2,"Y",(void*)0,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
  XbWDTb_SetPara(2,"x",(void*)0,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
  XbWDTb_SetPara(2,"x",(void*)0,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
  XbWDTb_SetPara(2,"b",(void*)0,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
  XbWDTb_SetPara(2,"f",(void*)0,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
  XbWDTb_SetPara(2,"F",(void*)0,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
  XbWDTb_SetPara(2,"t",(void*)0,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
  XbWDTb_SetPara(3,"D",0,(void*)" ",NULL,NULL); XbWFDb_AppStr(&vp,NULL);
  XbWDTb_SetPara(2,"d",(void*)0,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
  XbWDTb_SetPara(2,"e",(void*)0,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
  XbWDTb_SetPara(2,"w",(void*)0,NULL,NULL,NULL); XbWFDb_AppInt(&vp,NULL);
  XbWDTb_SetPara(3,"E",0,(void*)" ",NULL,NULL); XbWFDb_AppStr(&vp,NULL);
  XbWFDb_AppGPtr(NULL,NULL);
 
  XbWDTb_SetPara(6,"OBJ",(*p)[1],"OBJ","WDW",(*p)[1]); vp[6]="obj";
  XbWFDb_LinkDbI(&vp);
 
  {
    char *sstr;
    gv_gp = XbWFDb_FindGrp("OBX","genvars");
    if (gv_gp == NULL) { return(1); };
    sstr = (char*)XbWFDb_VarInh(gv_gp,XbWDDb_Str,"WDWName",1);
    if (sstr == NULL) { return(1); };
    strcpy(sstr,(char*)(*p)[1]);
    };
 
  XbWDTb_SetPara(1,(*p)[1],NULL,NULL,NULL,NULL);
  XbWFWd_Select(&vp);
 
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_AppChn(      ****/
int  XbWFDb_AppChn(void  *(*p)[], int (*t)[]){
  int ll;
  void  *vp[6];
  char sstr[40];
  char *sptr;

  if ( (int)(*p)[0] < 2){ return(1);};

  sptr = (char*)(*p)[1];

  for (ll = 2; ll <= (int)(*p)[0] ; ll++){
    sprintf(sstr,"%s%d",sptr,ll-2);
    switch ( (*t)[ll] ) {
      case XbWDMf_VLPar:
         XbWDTb_SetPara(2,sstr,(void  *)(*p)[ll],NULL,NULL,NULL);
         XbWFDb_AppNPtr(&vp,NULL);
         break;
      case XbWDMf_StrPar:
         XbWDTb_SetPara(3,sstr,0,(void  *)(*p)[ll],NULL,NULL);
         XbWFDb_AppStr(&vp,NULL);
         break;
      case XbWDMf_IntPar:
         vp[0] = ((void *)2);
         vp[1] = (void*)(sstr);
         {
           int ii;
           ii = (int)((*p)[ll]);
           vp[2] = (void*)(ii);
           };
         vp[3] = (void*)NULL;
         vp[4] = (void*)NULL;
         vp[5] = (void*)NULL;
         /* XbWDTb_SetPara(2,sstr,(void  *)(*p)[ll],NULL,NULL,NULL); */
         XbWFDb_AppInt(&vp,NULL);
         break;
      case XbWDMf_DblPar:
         XbWDTb_SetPara(2,sstr,(void  *)(*p)[ll],NULL,NULL,NULL);
         XbWFDb_AppDbl(&vp);
         break;
      };
    };
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_CreateArray( ****/
int  XbWFDb_CreateArray(void  *(*p)[], int (*t)[]){
  int xx,yy, xmax=0, ymax=0;
  void  *vp[6];
  char sstr[40];
  char vname[40]="";
  /* 4 Parameter: Name; X,Y Size; Init-VAR Element */
 
  if ( (int)(*p)[0] < 4){ return(1);};
 
 
  switch( (int)(*t)[1] ) {
    case XbWDMf_StrPar:
      strcpy(vname,(char*)(XbWFTb_PckTxt((char*)(*p)[1])));
      break;
    case XbWDMf_VLPar:
      {
        XbWDDb_DbIVar  *QQ;
        char *vnmp;
        QQ = (XbWDDb_DbIVar  *)(*p)[1];
        if (QQ == NULL) { return(1); };
        vnmp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Str,NULL,1);
        if (vnmp != NULL) {
          strcpy(vname,(char*)XbWFTb_PckTxt(vnmp));
          };
        };
      break;
    };
  switch( (int)(*t)[2] ) {
    case XbWDMf_IntPar:
      ymax = (int)(*p)[2];
      break;
    case XbWDMf_VLPar:
      {
        XbWDDb_DbIVar  *QQ;
        QQ = (XbWDDb_DbIVar  *)(*p)[2];
        if (QQ == NULL) { return(1); };
        ymax = (int)XbWFDb_GetNum(QQ,NULL,1);
        };
      break;
    };
  switch( (int)(*t)[3] ) {
    case XbWDMf_IntPar:
      xmax = (int)(*p)[3];
      break;
    case XbWDMf_VLPar:
      {
        XbWDDb_DbIVar  *QQ;
        QQ = (XbWDDb_DbIVar  *)(*p)[3];
        if (QQ == NULL) { return(1); };
        ymax = (int)XbWFDb_GetNum(QQ,NULL,1);
        };
      break;
    };
 
  if ((xmax == 0) & (ymax == 0)){
    return(1);
    };
  if (strlen(vname) == 0){
    return(1);
    };
 
  sprintf(sstr,"  ArraySizeXX");
  vp[0] = ((void *)2);
  vp[1] = (void*)(sstr);
  vp[2] = (void*)(xmax);
  vp[3] = (void*)NULL;
  vp[4] = (void*)NULL;
  vp[5] = (void*)NULL;
  XbWFDb_AppInt(&vp,NULL);
  sprintf(sstr,"  ArraySizeYY");
  vp[0] = ((void *)2);
  vp[1] = (void*)(sstr);
  vp[2] = (void*)(ymax);
  vp[3] = (void*)NULL;
  vp[4] = (void*)NULL;
  vp[5] = (void*)NULL;
  XbWFDb_AppInt(&vp,NULL);
 
  for (yy = 0; ((yy < ymax)|(yy==0)) ; yy++){
    for (xx = 0; ((xx < xmax)|(xx==0)) ; xx++){
      sprintf(sstr,"%s[%d][%d]",vname,xx,yy);
      if (!ymax){ sprintf(sstr,"%s[%d]",vname,xx); };
      if (!xmax){ sprintf(sstr,"%s[%d]",vname,yy); };
      switch ( (*t)[4] ) {
        case XbWDMf_VLPar:
           XbWDTb_SetPara(2,sstr,(void  *)(*p)[4],NULL,NULL,NULL);
           XbWFDb_AppNPtr(&vp,NULL);
           break;
        case XbWDMf_StrPar:
           XbWDTb_SetPara(3,sstr,0,(void  *)(*p)[4],NULL,NULL);
           XbWFDb_AppStr(&vp,NULL);
           break;
        case XbWDMf_IntPar:
           vp[0] = ((void *)2);
           vp[1] = (void*)(sstr);
           {
             int ii;
             ii = (int)((*p)[4]);
             vp[2] = (void*)(ii);
             };
           vp[3] = (void*)NULL;
           vp[4] = (void*)NULL;
           vp[5] = (void*)NULL;
           /* XbWDTb_SetPara(2,sstr,(void  *)(*p)[4],NULL,NULL,NULL); */
           XbWFDb_AppInt(&vp,NULL);
           break;
        case XbWDMf_DblPar:
           XbWDTb_SetPara(2,sstr,(void  *)(*p)[4],NULL,NULL,NULL);
           XbWFDb_AppDbl(&vp);
           break;
        };
      };
    };
  return(0);
  };


/*}}}  */
/*{{{  XbWFDb_AppTsk(      ****/
int  XbWFDb_AppTsk(void  *(*p)[], int (*t)[]){
  void  *vp[6];
  if ((int)(*p)[0] < 2) {return(1);};

  if( (*t)[1] == XbWDMf_VLPar){
    XbWDTb_SetPara(2,"td",(void  *)(*p)[1],NULL,NULL,NULL);
    XbWFDb_AppNPtr(&vp,NULL);
    }
  else {
    XbWDTb_SetPara(3,"td",0,((char*)(*p)[1]),NULL,NULL);
    XbWFDb_AppStr(&vp,NULL);
    };
  if( (*t)[2] == XbWDMf_VLPar){
    XbWDTb_SetPara(2,"tn",(void  *)(*p)[2],NULL,NULL,NULL);
    XbWFDb_AppNPtr(&vp,NULL);
    }
  else {
    XbWDTb_SetPara(3,"tn",0,((char*)(*p)[2]),NULL,NULL);
    XbWFDb_AppStr(&vp,NULL);
    };
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_AppFloat(    ****/
int  XbWFDb_AppFloat(void  *(*p)[], int (*t)[]){
  void  *vp[6];
  if ((int)(*p)[0] < 3) {return(1);};

  if( (*t)[1] == XbWDMf_VLPar){
    XbWDTb_SetPara(2,"fmt",(void  *)(*p)[1],NULL,NULL,NULL);
    XbWFDb_AppNPtr(&vp,NULL);
    }
  else {
    XbWDTb_SetPara(3,"fmt",0,((char*)(*p)[1]),NULL,NULL);
    XbWFDb_AppStr(&vp,NULL);
    };
  if( (*t)[2] == XbWDMf_VLPar){
    XbWDTb_SetPara(2,"eha",(void  *)(*p)[2],NULL,NULL,NULL);
    XbWFDb_AppNPtr(&vp,NULL);
    }
  else {
    XbWDTb_SetPara(3,"eha",0,((char*)(*p)[2]),NULL,NULL);
    XbWFDb_AppStr(&vp,NULL);
    };
  switch( (*t)[3]){
    case XbWDMf_VLPar:
      XbWDTb_SetPara(2,"sca",(void  *)(*p)[3],NULL,NULL,NULL);
      XbWFDb_AppNPtr(&vp,NULL);
      break;
    case XbWDMf_StrPar:
    case XbWDMf_DblPar:
      XbWDTb_SetPara(3,"sca",((char*)(*p)[3]),NULL,NULL,NULL);
      XbWFDb_AppDbl(&vp);
      break;
    };
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_NewGrp(      ****/
int  XbWFDb_NewGrp(void  *(*p)[],int (*t)[]){
  void  *vp[6];
  if ((int)(*p)[0] < 2) {return(1);};

  XbWDTb_SetPara(1,(*p)[1],NULL,NULL,NULL,NULL); XbWFDb_MarlGrp(&vp);
  XbWDTb_SetPara(3,(*p)[1],0,(*p)[2],NULL,NULL); XbWFDb_AppStr(&vp,NULL);
  if (strcmp((char*)(*p)[1],"PRJ") == 0){
    sprintf(XbWVSy_PrjPath,"\\xw\\x\\app\\%s\\",(char*)(*p)[2]);
    };

  XbWDTb_SetPara(2,(*p)[1],NULL,NULL,NULL,NULL); XbWFDb_AppNPtr(&vp,NULL);


  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_AppLight(    ****/
int  XbWFDb_AppLight(void  *(*p)[], int (*t)[]){
  void  *vp[6];
  if ((int)(*p)[0] < 5) {return(1);};

  if( (*t)[1] == XbWDMf_VLPar){
    XbWDTb_SetPara(2,"T",(void  *)(*p)[1],NULL,NULL,NULL);
    XbWFDb_AppNPtr(&vp,NULL);
    }
  else {
    XbWDTb_SetPara(3,"T",0,((char*)(*p)[1]),NULL,NULL);
    XbWFDb_AppStr(&vp,NULL);
    };
  switch( (*t)[2]){
    case XbWDMf_VLPar:
      XbWDTb_SetPara(2,"v",(void  *)(*p)[2],NULL,NULL,NULL);
      XbWFDb_AppNPtr(&vp,NULL);
      break;
    case XbWDMf_StrPar:
    case XbWDMf_DblPar:
      XbWDTb_SetPara(2,"v",((char*)(*p)[2]),NULL,NULL,NULL);
      XbWFDb_AppDbl(&vp);
      break;
    case XbWDMf_IntPar:
      XbWDTb_SetPara(2,"v",((char*)(*p)[2]),NULL,NULL,NULL);
      XbWFDb_AppInt(&vp,NULL);
      break;
    };

  if( (*t)[3] == XbWDMf_VLPar){
    XbWDTb_SetPara(2,"1",(void  *)(*p)[3],NULL,NULL,NULL);
    XbWFDb_AppNPtr(&vp,NULL);
    }
  else {
    XbWDTb_SetPara(3,"1",0,((char*)(*p)[3]),NULL,NULL);
    XbWFDb_AppStr(&vp,NULL);
    };

  if( (*t)[4] == XbWDMf_VLPar){
    XbWDTb_SetPara(2,"0",(void  *)(*p)[4],NULL,NULL,NULL);
    XbWFDb_AppNPtr(&vp,NULL);
    }
  else {
    XbWDTb_SetPara(3,"0",0,((char*)(*p)[4]),NULL,NULL);
    XbWFDb_AppStr(&vp,NULL);
    };

  if( (*t)[5] == XbWDMf_VLPar){
    XbWDTb_SetPara(2,"A",(void  *)(*p)[5],NULL,NULL,NULL);
    XbWFDb_AppNPtr(&vp,NULL);
    }
  else {
    XbWDTb_SetPara(3,"A",0,((char*)(*p)[5]),NULL,NULL);
    XbWFDb_AppStr(&vp,NULL);
    };
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_AppBg(       ****/
int  XbWFDb_AppBg(void  *(*p)[], int (*t)[]){
  void  *vp[6];
  if ((int)(*p)[0] < 2) {return(1);};
  XbWDTb_SetPara(2,"OBJ",((char*)(*p)[1]),NULL,NULL,NULL); XbWFDb_AppFPtr(&vp);

  if( (*t)[2] == XbWDMf_VLPar){
    XbWDTb_SetPara(2,"i",(void  *)(*p)[2],NULL,NULL,NULL);
    XbWFDb_AppNPtr(&vp,NULL);
    }
  else {
    if (strlen((char*)(*p)[2]) > 0) {
      XbWDTb_SetPara(3,"i",0,((char*)(*p)[2]),NULL,NULL); XbWFDb_AppStr(&vp,NULL);
      };
    };

  if ((int)(*p)[0] >= 3) {
    switch( (*t)[3] ) {
      case XbWDMf_VLPar:
         XbWDTb_SetPara(2,"V",(void  *)(*p)[3],NULL,NULL,NULL);
         XbWFDb_AppNPtr(&vp,NULL);
         break;
      case XbWDMf_StrPar:
         XbWDTb_SetPara(3,"V",0,(void *)(*p)[3],NULL,NULL);
         XbWFDb_AppStr(&vp,NULL);
         break;
      case XbWDMf_IntPar:
         { int ii;
           ii = (int)((*p)[3]);
           XbWDTb_SetPara(2,"V",(void *)(ii),NULL,NULL,NULL);
           };
         XbWFDb_AppInt(&vp,NULL);
         break;
      case XbWDMf_DblPar:
         XbWDTb_SetPara(2,"V",(void *)(*p)[3],NULL,NULL,NULL);
         XbWFDb_AppDbl(&vp);
         break;
      };
    };
  return(0);
  };


/*}}}  */
/*{{{  XbWFDb_CPtrToStr(       ****/
char XbWFDb_CPtrToStrSStr[80];
char  *XbWFDb_CPtrToStr(XbWDDb_DbIVar  *TV, XbWDDb_DbIVar  *IP){
  XbWDDb_DbINPtr  *TL;
  char gname[16],lname[16],nname[16];
  if (TV == NULL) {
    return("NULL");
    };
  if ((TL = (XbWDDb_DbINPtr  *)XbWFDb_FindGPtr((XbWDDb_DbIVar  *)TV,IP)) == NULL){
    return("???");
    };
  if (TL->inh != 0) {
    TL = (XbWDDb_DbINPtr  *)XbWFDb_CDbIToPtr(((XbWDDb_DbINPtr  *)TL)->inh,IP);
    strcpy(nname,(char*)XbWFDb_GetNam((XbWDDb_DbIVar  *)TV));
    strcpy(lname,(char*)XbWFDb_GetNam((XbWDDb_DbIVar  *)TL));
    strcpy(gname,(char*)XbWFDb_GetStr((XbWDDb_DbIStr  *)TL));
    sprintf(XbWFDb_CPtrToStrSStr,"%s:%s.%s",lname,gname,nname);
    }
  else {
    strcpy(nname,(char*)XbWFDb_GetNam((XbWDDb_DbIVar  *)TV));
    strcpy(lname,(char*)XbWFDb_GetNam((XbWDDb_DbIVar  *)IP));
    strcpy(gname,(char*)XbWFDb_GetStr((XbWDDb_DbIStr  *)TV));
    };
  sprintf(XbWFDb_CPtrToStrSStr,"%s:%s.%s",lname,gname,nname);
  return(XbWFDb_CPtrToStrSStr);
  };
/*}}}  */
/*{{{  XbWFDb_StrToPtr(    ****/
XbWDDb_DbIVar  *XbWFDb_StrToPtr(char *name){
  XbWDDb_DbIVar  *TV;
  char gname[80],lname[80],nname[80];

  /*  Format : <LISTE>:<GRUPPE>.<Element> */

  if (name == NULL) {return(0);};
  if (strchr(name,':') == NULL) {return(0);};
  if (strchr(name,'.') == NULL) {return(0);};

  strcpy(lname,name); *((char*)(strchr(lname,':')))=0;
  strcpy(gname,strchr(name,':')+1); *((char*)(strchr(gname,'.')))=0;
  strcpy(nname,strchr(name,'.')+1);

  if ((TV = XbWFDb_FindGrp(lname,gname) ) != NULL) {
    TV = (XbWDDb_DbIVar *)XbWFDb_VarInh(TV,0,nname,0);
    };
  return(TV);
  };
/*}}}  */
/*{{{  XbWFDb_DbIToStr(    ****/
char  *XbWFDb_DbIToStr(XbWDDb_DbIPtr it, XbWDDb_DbIVar  *IP){
  return((char*)XbWFDb_CPtrToStr(XbWFDb_CDbIToPtr(it,IP),IP));
  };
/*}}}  */
/*{{{  XbWFDb_StrToDbI(    ****/
XbWDDb_DbIPtr  XbWFDb_StrToDbI(char *str, XbWDDb_DbIVar  *IP){
  return(XbWDDb_C_PtrToDbI(XbWFDb_StrToPtr(str),IP));
  };
/*}}}  */
/*{{{  XbWFDb_GetDbI(      ****/
char  *XbWFDb_GetDbI(char *lname, char *gname, char *nname){
  XbWDDb_DbIVar  *TV;
  if ((TV = XbWFDb_FindGrp(lname,gname) ) != NULL) {
    TV = (XbWDDb_DbIVar *)XbWFDb_VarInh(TV,0,nname,0);
    };
  return((char  *)TV);
  };
/*}}}  */
/*{{{  XbWFDb_GetInf(      ****/
int      XbWFDb_GetInf(XbWDDb_DbIVar  *start, int vnr,
                       char *vname, int *typ, char **inh, int *ale,
                       int recursiv){
  int ii = 0;
  XbWDDb_DbIVar  *TV;
  TV = start;
  if (TV == NULL) {
    return(0);
    };
  if (vnr  == 0) {
    goto TABvarINHende;
    };
  while ((TV->tp & XbWDDb_Typ) != XbWDDb_GPtr) {
    XbWFDb_ForWd(&TV,XbWDDb_DbISys);
    if (vnr == -1) {
      if (XbWFTb_CmpStr((char*)XbWFDb_GetNam(TV),vname) == 0) {
        ii = vnr;
        };
      };
    if (ii == vnr) {
      XbWVDb_AkDbkEl = TV;
      TABvarINHende:;
      if (recursiv) {
        while ((TV->tp & XbWDDb_Typ) == XbWDDb_NPtr){
          if (((XbWDDb_DbINPtr  *)TV)->inh == 0) {return(0);};
          TV = XbWFDb_CDbIToPtr( ((XbWDDb_DbINPtr  *)TV)->inh,XbWDDb_DbISys);
          if (TV == NULL) {return(0);};
          };
        };

      *typ = TV->tp & XbWDDb_Typ;
      if (vname != NULL) {
        strcpy(vname,(char*)XbWFDb_GetNam(TV));
        };
      *ale = 1;
      switch (*typ) {
        case XbWDDb_Str:  *ale = ((XbWDDb_DbIStr *)TV)->len * 2;
                      *inh = (char*)XbWFDb_GetStr((XbWDDb_DbIStr  *)TV); return(1);
        case XbWDDb_Int:  *inh = (char*)&(((XbWDDb_DbIInt  *)TV)->inh);  return(1);
        case XbWDDb_Dbl:  *inh = (char*)&(((XbWDDb_DbIDbl  *)TV)->inh);  return(1);
        case XbWDDb_NPtr: *inh = (char*)&(((XbWDDb_DbINPtr  *)TV)->inh); return(1);
        case XbWDDb_IPtr: *inh = (char*)&(((XbWDDb_DbIIPtr  *)TV)->inh); return(1);
        case XbWDDb_GPtr: *inh = (char*)&(((XbWDDb_DbIGPtr  *)TV)->inh); return(1);
        case XbWDDb_FPtr: *inh = (char*)&(((XbWDDb_DbIFPtr  *)TV)->inh); return(1);
        default    :  return(0);
        };
      };
    ii++;
    };
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_LinkDbI(     ****/
int  XbWFDb_LinkDbI(void  *(*p)[]){
  XbWDDb_DbIStr  *TSRC;
  XbWDDb_DbINPtr  *TTRG;
  XbWDDb_DbIPtr TVV;
  XbWDDb_DbIVar  *TV;
  XbWDDb_DbIVar  *TPP;
  int other_prj = 0;
  if ((int)(*p)[0] < 6) {return(1);};
  if ((int)(*p)[0] == 7) { other_prj = 1;};
  if ((TV = XbWFDb_FindGrp((char*)(*p)[4],(char*)(*p)[5]) ) == NULL) {
    return(1);
    };
  if ((TTRG = (XbWDDb_DbINPtr *)XbWFDb_VarInh(TV,0,(char*)(*p)[6],0)) == NULL) {
    return(1);
    };
  if ((TV = XbWFDb_FindGrp((char*)(*p)[1],(char*)(*p)[2]) ) == NULL) {
    return(1);
    };
  if ((TSRC = (XbWDDb_DbIStr *)XbWFDb_VarInh(TV,0,(char*)(*p)[3],0)) == NULL) {
    return(1);
    };
  if ((TTRG->tp & XbWDDb_Typ) == XbWDDb_NPtr) {
    TPP = XbWDDb_DbIPrj;
    if (other_prj){
      XbWFDb_SetPrj((char*)(*p)[7]);
      };
    TVV = XbWDDb_C_PtrToDbI(TSRC,XbWDDb_DbISys);
    XbWDDb_DbIPrj = TPP;
    ((XbWDDb_DbINPtr  *)TTRG)->inh = TVV;
    return(0);
    };
  return(1);
  };
/*}}}  */
/*{{{  XbWFDb_PrjName(     ****/
int  XbWFDb_PrjName(void  *(*p)[],int (*t)[]){
  char prjname[60];
 
  strcpy(prjname,"(default)");
  if ((int)(*p)[0] < 1 ) {return(XbWDMf_NoPara);};
  switch( (int)(*t)[1] ) {
    case XbWDMf_StrPar:
      strcpy(prjname,(char*)(XbWFTb_PckTxt((char*)(*p)[1])));
      break;
    case XbWDMf_VLPar:
      {
        XbWDDb_DbIVar  *QQ;
        char *fsp;
        QQ = (XbWDDb_DbIVar  *)(*p)[1];
        if (QQ == NULL) { return(1); };
        fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Str,NULL,1);
        if (fsp != NULL) {
          strcpy(prjname,(char*)XbWFTb_PckTxt(fsp));
          };
        };
      break;
    };
 
  strcpy(XbWVSy_PrjName,prjname);
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_MarkPrj(     ****/
int  XbWFDb_MarkPrj(void  *(*p)[],int (*t)[]){
  char prjname[60];
  XbWDDb_DbINPtr  *TL;
 
  strcpy(prjname,"(default)");
  if ((int)(*p)[0] < 1 ) {return(XbWDMf_NoPara);};
  switch( (int)(*t)[1] ) {
    case XbWDMf_StrPar:
      strcpy(prjname,(char*)(XbWFTb_PckTxt((char*)(*p)[1])));
      break;
    };
 
  strcpy(XbWVSy_PrjName,prjname);
  printf("Creating project \"%s\"\n",prjname);

  if ((XbWDDb_DbIVar  *)XbWFDb_GtEOT() != (XbWDDb_DbIVar *)XbWDDb_DbISys) {
    TL = (XbWDDb_DbINPtr  *)XbWDDb_DbIPrj;
    if ((TL = (XbWDDb_DbINPtr  *)XbWFDb_FindNptr((XbWDDb_DbIVar  *)TL,"PRJ")) == 0) {
      return(1);
      };
    while (TL->inh != 0) {
      TL = (XbWDDb_DbINPtr  *)XbWFDb_CDbIToPtr( ((XbWDDb_DbINPtr  *)TL)->inh,XbWDDb_DbISys);
      if ((TL = (XbWDDb_DbINPtr  *)XbWFDb_GtPrj((char*)XbWFDb_GetStr((XbWDDb_DbIStr  *)TL))) == 0) {
        return(1);};
      if ((TL = (XbWDDb_DbINPtr  *)XbWFDb_FindNptr((XbWDDb_DbIVar  *)TL,"PRJ")) == 0) {
        return(1);};
      };
    ((XbWDDb_DbINPtr  *)TL)->inh = XbWDDb_C_PtrToDbI((XbWDDb_DbIVar  *)XbWFDb_GtEOT(),XbWDDb_DbISys);
    };
  XbWDDb_DbIPrj = (XbWDDb_DbIVar  *)XbWFDb_GtEOT();
  XbWDDb_DbIGrp = (XbWDDb_DbIStr  *)XbWFDb_GtEOT();
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_SetPrj(     ****/
int  XbWFDb_SetPrj(char *prj_name){
  XbWDDb_DbINPtr  *TL;
  TL = (XbWDDb_DbINPtr  *)XbWDDb_DbISys;
  XbWDDb_DbIPrj = (XbWDDb_DbIVar  *)XbWDDb_DbISys;
  if (strcmp((char*)XbWFDb_GetStr((XbWDDb_DbIStr  *)TL),prj_name)==0){
    XbWFTb_ClrScr();
    XbWDDb_DbIPrj = (XbWDDb_DbIVar  *)TL;
    XbWFWd_DrawAll();
    return(0);
    };
  while (1) {
    if ((TL = (XbWDDb_DbINPtr  *)XbWFDb_FindNptr((XbWDDb_DbIVar  *)TL,"PRJ")) == 0) {return(1);};
    if ( ((XbWDDb_DbINPtr  *)TL)->inh == 0){
      return(1);
      };
    TL = (XbWDDb_DbINPtr  *)XbWFDb_CDbIToPtr( ((XbWDDb_DbINPtr  *)TL)->inh,XbWDDb_DbISys);
    XbWDDb_DbIPrj = (XbWDDb_DbIVar  *)TL;
    if (strcmp((char*)XbWFDb_GetStr((XbWDDb_DbIStr  *)TL),prj_name)==0){
      XbWDDb_DbIPrj = (XbWDDb_DbIVar  *)TL;
      return(0);
      };
    };
  };
/*}}}  */
/*{{{  XbWFDb_SetProject(     ****/
int  XbWFDb_SetProject(void  *(*p)[], int (*t)[]){
  char prj_name[40] = "";
  char wdw_name[40] = "";
  if ((int)(*p)[0] < 2 ) { return(1); };

  switch( (int)(*t)[1] ) {
    case XbWDMf_StrPar:
      strcpy(prj_name,(char*)(XbWFTb_PckTxt((char*)(*p)[1])));
      break;
    case XbWDMf_VLPar:
      {
        XbWDDb_DbIVar  *QQ;
        char *fsp;
        QQ = (XbWDDb_DbIVar  *)(*p)[1];
        if (QQ == NULL) { return(1); };
        fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Str,NULL,1);
        if (fsp != NULL) {
          strcpy(prj_name,(char*)XbWFTb_PckTxt(fsp));
          }
        else {
          return(2);
          };
        };
      break;
    };
  switch( (int)(*t)[2] ) {
    case XbWDMf_StrPar:
      strcpy(wdw_name,(char*)(XbWFTb_PckTxt((char*)(*p)[2])));
      break;
    case XbWDMf_VLPar:
      {
        XbWDDb_DbIVar  *QQ;
        char *fsp;
        QQ = (XbWDDb_DbIVar  *)(*p)[2];
        if (QQ == NULL) { return(1); };
        fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Str,NULL,1);
        if (fsp != NULL) {
          strcpy(wdw_name,(char*)XbWFTb_PckTxt(fsp));
          }
        else {
          return(2);
          };
        };
      break;
    };
  if (!XbWFDb_SetPrj(prj_name)){
    int count;
    XbWFTb_ClrScr();
    XbWFWd_GetList();
    for (count = 1;count <= XbWDWd_MaxWdw;count++) {
      if (XbWFWd_GetPara(count,&XbWVWd_W) != 0) {
        if (wdw_name != NULL){
          if (XbWFTb_CmpStr((char*)XbWVWd_W.nm,wdw_name)==0){
            XbWFWd_DrawAll();
            return(0);
            };
          };
        };
      };
    };
  return(1);
  };
/*}}}  */
/*{{{  XbWFDb_MarlGrp(     ****/
int  XbWFDb_MarlGrp(void  *(*p)[]){
  XbWDDb_DbINPtr  *TL;
  int mrk_key=0;
  int mrk_obj=0;
  char *lname;

  if ((int)(*p)[0] < 1) {return(1);};

  lname = (char*)(*p)[1];

  if (XbWFTb_CmpStr(lname,"PRJ") == 0) {
    XbWVDb_AktDKey = NULL;
    XbWVDb_AktDObj = NULL;

    XbWDDb_DbIGrp = (XbWDDb_DbIStr  *)XbWFDb_GtEOT();
    return(0);
    };

  if ((XbWDDb_DbIVar  *)XbWFDb_GtEOT() == (XbWDDb_DbIVar *)XbWDDb_DbISys) {
    XbWDDb_DbIGrp = (XbWDDb_DbIStr  *)XbWFDb_GtEOT();
    return(0);
    };

  if (XbWFTb_CmpStr(lname,"OBJ") == 0) {
    mrk_obj =1;
    if (XbWVDb_AktDObj != NULL) {
      TL = (XbWDDb_DbINPtr  *)XbWVDb_AktDObj;
      goto ITMmarkGRPweiter;
      };
    };
  if (XbWFTb_CmpStr(lname,"KEY") == 0) {
    mrk_key=1;
    if (XbWVDb_AktDKey != NULL) {
      TL = (XbWDDb_DbINPtr  *)XbWVDb_AktDKey;
      goto ITMmarkGRPweiter;
      };
    };

  TL = (XbWDDb_DbINPtr  *)XbWDDb_DbIPrj;
  if ((TL = (XbWDDb_DbINPtr  *)XbWFDb_FindNptr((XbWDDb_DbIVar  *)TL,lname)) == 0) {return(1);};

  ITMmarkGRPweiter:;
  while (TL->inh != 0) {
    TL = (XbWDDb_DbINPtr  *)XbWFDb_CDbIToPtr( ((XbWDDb_DbINPtr  *)TL)->inh,XbWDDb_DbISys);
    if ((TL = (XbWDDb_DbINPtr  *)XbWFDb_FindNptr((XbWDDb_DbIVar  *)TL,lname)) == 0) {return(1);};
    };
  if (mrk_key) {
    XbWVDb_AktDKey = (XbWDDb_DbIVar  *)TL;
    };
  if (mrk_obj) {
    XbWVDb_AktDObj = (XbWDDb_DbIVar  *)TL;
    };
  ((XbWDDb_DbINPtr  *)TL)->inh = XbWDDb_C_PtrToDbI((XbWDDb_DbIVar  *)XbWFDb_GtEOT(),XbWDDb_DbISys);
  XbWDDb_DbIGrp = (XbWDDb_DbIStr  *)XbWFDb_GtEOT();
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_OutLine(     ****/
void  XbWFDb_OutLine(FILE *fp) {
  fprintf(fp,    "----------------------------------------------------------------\n");
  };
/*}}}  */
/*{{{  XbWFDb_DbgSys(      ****/
int  XbWFDb_DbgSys(void  *(*p)[]){
  char *fname;
  FILE *fp;
  int cursormrk;
  void  *oldcursor;
  XbWDDb_DbIVar  *END;
  XbWDDb_DbIVar  *AP;
  XbWDDb_DbIStr  *TS;
  long oc,wc,ic,sc,pc,dc,mc,
  is,ss,ds,ps,as,ls,ins,dns,sns,pns,vc;

  oc = wc = ic = sc = pc = mc = dc =  0;
  is = ss = ds = ps = ls = ins = dns = sns = pns = vc = 0;
  if ((int)(*p)[0] < 1 ) {return(1);};
  fname = (char *)(*p)[1];
  XbWVDb_PrjSize = 0;


  if ((fp = XbWSSy_fopen(fname,"wt")) == NULL) {
    return(1);
    };

  cursormrk = XbWVMs_CSet;
  oldcursor = XbWSMs_SetClockCursor();
  XbWFGr_CurON();

  {
    char pstr[200];
    sprintf(pstr,"Dumping database to %s",fname);
    XbWFTb_Message(pstr);
    };

  fprintf(fp,"/* * * Xb Dialog Interface Script * * */\n");
  #ifdef TEST
    puts("Xb ...");
    #endif
  END = (XbWDDb_DbIVar  *)XbWFDb_GtEOT();
  AP = (XbWDDb_DbIVar  *)XbWDDb_DbISys;
  XbWVDb_PrjSize =0;
  XbWDDb_DbIPrj = (XbWDDb_DbIVar  *)XbWDDb_DbISys;
  while (AP < END) {
    XbWFDb_DbgVar(AP,fp);
    switch(AP->tp & XbWDDb_Typ){
      case XbWDDb_Int :
                   ic++;
                   as = XbWFDb_GetSiz(AP);
                   XbWVDb_PrjSize += as;
                   is += as;
                   ins += (AP->tp & XbWDDb_NLen);
                   vc++;
                   break;
      case XbWDDb_Dbl :
                   dc++;
                   as = XbWFDb_GetSiz(AP);
                   XbWVDb_PrjSize += as;
                   ds += as;
                   dns += (AP->tp & XbWDDb_NLen);
                   vc++;
                   break;
      case XbWDDb_NPtr:
                   pc++;
                   as = XbWFDb_GetSiz(AP);
                   XbWVDb_PrjSize += as;
                   ps += as;
                   pns += (AP->tp & XbWDDb_NLen);
                   vc++;
                   break;
      case XbWDDb_IPtr:
                   pc++;
                   as = XbWFDb_GetSiz(AP);
                   XbWVDb_PrjSize += as;
                   ps += as;
                   pns += (AP->tp & XbWDDb_NLen);
                   vc++;
                   break;
      case XbWDDb_GPtr:
                   pc++;
                   as = XbWFDb_GetSiz(AP);
                   XbWVDb_PrjSize += as;
                   ps += as;
                   fprintf(fp,"\n");
                   XbWFDb_OutLine(fp);
                   pns += (AP->tp & XbWDDb_NLen);
                   vc++;
                   break;
      case XbWDDb_FPtr:
                   pc++;
                   fprintf(fp,"\n");
                   XbWFDb_OutLine(fp);
                   as = XbWFDb_GetSiz(AP);
                   XbWVDb_PrjSize += as;
                   ps += as;
                   pns += (AP->tp & XbWDDb_NLen);
                   vc++;
                   break;
      case XbWDDb_Str :TS  = (XbWDDb_DbIStr  *)AP;
                   sc++;
                   if (XbWFTb_CmpStr((char*)XbWFDb_GetNam((XbWDDb_DbIVar  *)TS),"OBJ") == 0){
                     oc++;
                     };
                   if (XbWFTb_CmpStr((char*)XbWFDb_GetNam((XbWDDb_DbIVar  *)TS),"WDW") == 0){
                     wc++;
                     };
                   if (XbWFTb_CmpStr((char*)XbWFDb_GetNam((XbWDDb_DbIVar  *)TS),"MFX") == 0){
                     mc++;
                     };
                   ls += 2*TS->len;
                   as = XbWFDb_GetSiz(AP);
                   XbWVDb_PrjSize += as;
                   ss += as;
                   sns += (AP->tp & XbWDDb_NLen);
                   vc++;
                   break;
      };
    AP = XbWFDb_CDbIToPtr(XbWDDb_C_PtrToDbI(AP,XbWDDb_DbISys)+XbWFDb_GetSiz(AP),XbWDDb_DbISys);
    };

  fprintf(fp,"\n\n");
  XbWFDb_OutLine(fp);
  fprintf(fp,  "\nStatistics\n\n");
  fprintf(fp,"\n\nnumber of  windows   : %5ld\n",wc);
  fprintf(fp,    "number of  MFX-Groups: %5ld\n",mc);
  fprintf(fp,    "number of  objects   : %5ld\n",oc);
  fprintf(fp,    "number of  variables : %5ld\n",vc);
  XbWFDb_OutLine(fp);
  if (ic > 0) {
    fprintf(fp,    "           integers  : %5ld (%6ld Byte); %4.1f Byte/int\n",ic,is,(double)(((double)is)/ic));
    };
  if (sc > 0) {
    fprintf(fp,    "           strings   : %5ld (%6ld Byte); %4.1f Byte/str\n",sc,ss,(double)(((double)ss)/sc));
    };
  if (pc > 0) {
    fprintf(fp,    "           pointers  : %5ld (%6ld Byte); %4.1f Byte/ptr\n",pc,ps,(double)(((double)ps)/pc));
    };
  if (dc > 0) {
    fprintf(fp,    "           doubles   : %5ld (%6ld Byte); %4.1f Byte/dbl\n",dc,ds,(double)(((double)ds)/dc));
    };
  XbWFDb_OutLine(fp);
  fprintf(fp,    "netto size integers  :        %6ld Byte; %4.1f Byte/int\n",(long)ic*sizeof(int),(double)sizeof(int));
  if (sc > 0) {
    fprintf(fp,    "           strings   :        %6ld Byte; %4.1f Byte/str\n",ls,(double)(((double)ls)/sc));
    };
  fprintf(fp,    "           pointers  :        %6ld Byte; %4.1f Byte/ptr\n",(long)pc*sizeof(XbWDDb_DbIPtr),(double)sizeof(XbWDDb_DbIPtr));
  fprintf(fp,    "           doubles   :        %6ld Byte; %4.1f Byte/dbl\n",(long)dc*sizeof(double),(double)sizeof(double));
  XbWFDb_OutLine(fp);
  if (ic > 0){
    fprintf(fp,    "names size integers  :        %6ld Byte; %4.1f Byte/int\n",ins,(double)(((double)ins)/ic));
    };
  if (sc > 0) {
    fprintf(fp,    "           strings   :        %6ld Byte; %4.1f Byte/str\n",sns,(double)(((double)sns)/sc));
    };
  if (pc > 0) {
    fprintf(fp,    "           pointers  :        %6ld Byte; %4.1f Byte/ptr\n",pns,(double)(((double)pns)/pc));
    };
  if (dc > 0) {
    fprintf(fp,    "           doubles   :        %6ld Byte; %4.1f Byte/dbl\n",dns,(double)(((double)dns)/dc));
    };
  XbWFDb_OutLine(fp);
  if (ic > 0) {
    fprintf(fp,    "misc. size integers  :        %6ld Byte; %4.1f Byte/int\n",is-ins-(long)ic*sizeof(int),(double)(is-ins-(long)ic*sizeof(int))/ic);
    };
  if (sc > 0) {
    fprintf(fp,    "           strings   :        %6ld Byte; %4.1f Byte/str\n",ss-sns-ls,(double)(ss-sns-ls)/sc);
    };
  if (pc > 0) {
    fprintf(fp,    "           pointers  :        %6ld Byte; %4.1f Byte/ptr\n",ps-pns-(long)pc*sizeof(XbWDDb_DbIPtr),(double)(ps-pns-(long)pc*sizeof(XbWDDb_DbIPtr))/pc);
    };
  if (dc > 0) {
    fprintf(fp,    "           doubles   :        %6ld Byte; %4.1f Byte/dbl\n",ds-dns-(long)dc*sizeof(double),(double)(ds-dns-(long)dc*sizeof(double))/dc);
    };
  XbWFDb_OutLine(fp);
  {
    long akts;
    double perc;

    akts = (long)ic*sizeof(int)+ls+dc*sizeof(double);
    if (XbWVDb_PrjSize > 0) {
      perc = 100.0*akts/XbWVDb_PrjSize;
      }
    else {
      perc = 0;
      };
    fprintf(fp,"\n\nnetto data size      : %6ld Byte (%4.1f%%)\n",akts,perc);

    akts = (long)ic*sizeof(int)+ls+dc*sizeof(double)+pc*sizeof(XbWDDb_DbIPtr);
    perc = 100.0*akts/XbWVDb_PrjSize;
    fprintf(fp,"\n\nbrutto (incl pointer): %6ld Byte (%4.1f%%)\n",akts,perc);

    akts = XbWVDb_PrjSize-akts;
    perc = 100.0*akts/XbWVDb_PrjSize;
    fprintf(fp,"\n\noverhead             : %6ld Byte (%4.1f%%)\n",akts,perc);
    fprintf(fp,"\n\nproject size         : %6ld Byte.\n",XbWVDb_PrjSize);
    fprintf(fp,"\n\n----------------------------------------------------------------\n");
    };
  fclose(fp);
  XbWFTb_Message(".");
  if (!cursormrk) {
    XbWFGr_CurOFF();
    };
  XbWSMs_SetLastCursor(oldcursor);
  return(0);
  };

/*}}}  */
/*{{{  XbWFDb_WrTable(     ***    Datenbank binaer schreiben*/
int  XbWFDb_WrTable(void  *(*p)[],int (*t)[]){
  XbWDDb_Header th;
  char s_dir[60];
  void  *mrk;
  void  *oldcursor;
  char name[60];
  int write_complete=0;
  FILE *fp;
  if ((int)(*p)[0] < 1 ) {return(XbWDMf_NoPara);};
  if ((int)(*p)[0] >= 2 ) {
    switch( (int)(*t)[2] ) {
      case XbWDMf_StrPar:
        strcpy(s_dir,(char*)(XbWFTb_PckTxt((char*)(*p)[2])));
        break;
      case XbWDMf_VLPar:
        {
          XbWDDb_DbIVar  *QQ;
          char *fsp;
          QQ = (XbWDDb_DbIVar  *)(*p)[2];
          if (QQ == NULL) { return(1); };
          fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Str,NULL,1);
          if (fsp != NULL) {
            strcpy(s_dir,(char*)XbWFTb_PckTxt(fsp));
            };
          };
        break;
      };
    }
  else {
    strcpy(s_dir,"");
    };
  switch( (int)(*t)[1] ) {
    case XbWDMf_StrPar:
      strcpy(name,(char*)(XbWFTb_PckTxt((char*)(*p)[1])));
      break;
    case XbWDMf_VLPar:
      {
        XbWDDb_DbIVar  *QQ;
        char *fsp;
        QQ = (XbWDDb_DbIVar  *)(*p)[1];
        if (QQ == NULL) { return(1); };
        fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Str,NULL,1);
        if (fsp == NULL) { return(1); };
        strcpy(name,(char*)XbWFTb_PckTxt(fsp));
        };
      break;
    };
  if ((int)(*p)[0] >= 3 ) {
    switch( (int)(*t)[3] ) {
      case XbWDMf_IntPar:
        write_complete = (int)(*p)[3];
        break;
      case XbWDMf_VLPar:
        {
          XbWDDb_DbIVar  *QQ;
          QQ = (XbWDDb_DbIVar  *)(*p)[3];
          if (QQ == NULL) { return(1); };
          write_complete = (int)XbWFDb_GetNum(QQ,NULL,1);
          };
        break;
      };
    }
  if (name[0] == '*'){
    fp = XbWSSy_fopen("\\xw\\x\\sys\\RESUME.PRJ","wb");
    }
  else {
    strcat(s_dir,name);
    if (strchr(s_dir,'.') == NULL){
      strcat(s_dir,".PRJ");
      };
    fp = XbWSSy_fopen(s_dir,"wb");
    };
  if (fp != NULL) {
    strcpy(th.name,"XbWindows Project (c) 1992 HHM");
    strcpy(th.reserviert,"HHM                                                 ");

    th.tab_start = 0;

    th.akt_projekt = (long)XbWDDb_C_PtrToDbI(XbWDDb_DbIPrj,XbWVDb_DbkStrt);
    mrk = (void  *)XbWDDb_DbIPrj;
    XbWDDb_DbIPrj = (XbWDDb_DbIVar  *)XbWVDb_DbkStrt;

    th.akt_group = (long)XbWDDb_C_PtrToDbI(XbWDDb_DbIGrp,XbWVDb_DbkStrt);;
    th.akt_sys   = (long)XbWDDb_C_PtrToDbI(XbWDDb_DbISys,XbWVDb_DbkStrt);;
    th.akt_ende  = (long)XbWDDb_C_PtrToDbI(XbWFDb_GtEOT(),XbWVDb_DbkStrt);
    if (XbWVWd_W.nm != NULL){
      strcpy(th.akt_wdw,(char*)XbWVWd_W.nm);
      }
    else {
      strcpy(th.akt_wdw,"!!");
      };
    if (!write_complete){
      th.tab_size = (long)XbWDDb_C_PtrToDbI(XbWFDb_GtEOT(),XbWVDb_DbkStrt)+ 10000;
      }
    else {
      th.tab_size = XbWVDb_DbkStrt->ITM_MAX;
      };

    XbWFTb_Message("Writing Database...");

    oldcursor = XbWSMs_SetClockCursor();
    fwrite((void*)&th,sizeof(th),1,fp);
    fwrite((void*)XbWVDb_DbkStrt,(int)(th.tab_size*1.0/1024)+1,1024,fp);
    XbWSMs_SetLastCursor(oldcursor);
    XbWDDb_DbIPrj = (XbWDDb_DbIVar  *)mrk;
    fclose(fp);
    XbWFTb_Message(".");
    return(0);
    };
  return(1);
  };

/*}}}  */
/*{{{  XbWFDb_RdTable(     ***    Datenbank binaer lesen*/
int  XbWFDb_RdTable(void  *(*p)[], int (*t)[]){
  XbWDDb_Header th;
  char name[60];
  char s_dir[60];
  void  *oldcursor;
  FILE *fp;
  int draw_windows;
  int read_kbytes=0;
  if ((int)(*p)[0] < 1 ) {return(XbWDMf_NoPara);};
  if ((int)(*p)[0] >= 2 ) {
    switch( (int)(*t)[2] ) {
      case XbWDMf_StrPar:
        strcpy(s_dir,(char*)(XbWFTb_PckTxt((char*)(*p)[2])));
        break;
      case XbWDMf_VLPar:
        {
          XbWDDb_DbIVar  *QQ;
          char *fsp;
          QQ = (XbWDDb_DbIVar  *)(*p)[2];
          if (QQ == NULL) { return(1); };
          fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Str,NULL,1);
          if (fsp != NULL) {
            strcpy(s_dir,(char*)XbWFTb_PckTxt(fsp));
            };
          };
        break;
      default: return(1);
      };
    }
  else {
    strcpy(s_dir,"");
    };
  switch( (int)(*t)[1] ) {
    case XbWDMf_StrPar:
      strcpy(name,(char*)(XbWFTb_PckTxt((char*)(*p)[1])));
      break;
    case XbWDMf_VLPar:
      {
        XbWDDb_DbIVar  *QQ;
        char *fsp;
        QQ = (XbWDDb_DbIVar  *)(*p)[1];
        if (QQ == NULL) { return(1); };
        fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Str,NULL,1);
        if (fsp == NULL) { return(1); };
        strcpy(name,(char*)XbWFTb_PckTxt(fsp));
        };
      break;
    default: return(1);
    };

  draw_windows = 1;
  if ((int)(*p)[0] >= 3 ) {
    switch( (int)(*t)[3] ) {
      case XbWDMf_VLPar:
        {
          XbWDDb_DbIVar  *QQ;
          QQ = (XbWDDb_DbIVar  *)(*p)[3];
          if (QQ == NULL) { return(1); };
          draw_windows = XbWFDb_GetNum(QQ,NULL,1);
          };
        break;
      case XbWDMf_IntPar:
      case XbWDMf_VPPar:
        draw_windows = (int)(*p)[3];
        break;
      default: return(1);
      };
    };
  if ((int)(*p)[0] >= 4 ) {
    switch( (int)(*t)[4] ) {
      case XbWDMf_IntPar:
        read_kbytes = (int)(*p)[4];
        break;
      case XbWDMf_VLPar:
        {
          XbWDDb_DbIVar  *QQ;
          QQ = (XbWDDb_DbIVar  *)(*p)[4];
          if (QQ == NULL) { return(1); };
          read_kbytes = (int)XbWFDb_GetNum(QQ,NULL,1);
          };
        break;
      };
    }
  if (name[0] == '*'){
    fp = XbWSSy_fopen("/xw/x/sys/resume.prj","rb");
    }
  else {
    strcat(s_dir,name);
    if (strchr(s_dir,'.') == NULL) {
      strcat(s_dir,".PRJ");
      };
    fp = XbWSSy_fopen(s_dir,"rb");
    };
 
  if (XbWVDb_DbkStat == 1) {
    XbWFDb_CloseSys();
    };
  if (XbWVDb_DbkStat == 2) {
    struct stat statbuf;
    if (fstat(XbWVDb_DbkFile,&statbuf)<0){
      printf("could not fstat() active database file.\n");
      exit(1);
      };
    munmap((caddr_t)XbWVDb_DbkStrtMem,statbuf.st_size);
    close(XbWVDb_DbkFile);
    };
 
 
  if (fp != NULL) {
    fread((void*)&th,sizeof(th),1,fp);
    if (XbWVDb_DbkStat == 1) {
      XbWFDb_CloseSys();
      };
    XbWVDb_DbkStat = 1;

    if (!read_kbytes){
      XbWVDb_DbkStrt = (XbWDDb_Sys  *)(XbWSSy_AlocMem((th.tab_size/100)+20,100));
      }
    else {
      XbWVDb_DbkStrt = (XbWDDb_Sys  *)(XbWSSy_AlocMem(read_kbytes+2,1024));
      };
    if (XbWVDb_DbkStrt == NULL) {
      #ifdef TEST
        puts("HEAP ERROR!!");
      #else
        XbWSPu_Alarm("HEAP ERROR!");
        #endif
      puts("");
      exit(1);
      };
    XbWVDb_DbkStrt->ITM_MAX     = (XbWDDb_DbIPtr)(1.0*th.tab_size);
    XbWVDb_DbkStrt->T_ITM_END   = (void  *)XbWDDb_Dbk;
    XbWFDb_Add(sizeof(XbWDDb_Sys));
    XbWVDb_DbkStrt->T_ITM_PRJ = (XbWDDb_DbIVar  *)XbWFDb_GtEOT();
    XbWVDb_DbkStrt->T_ITM_SYS = (XbWDDb_DbIStr  *)XbWFDb_GtEOT();
    XbWVDb_DbkStrt->T_ITM_GRP = (XbWDDb_DbIStr  *)XbWFDb_GtEOT();
    XbWFTb_Message("Reading Database...");
    oldcursor = XbWSMs_SetClockCursor();
    fread((void *)XbWVDb_DbkStrt,(size_t)(1.0*th.tab_size/100)+1,100,fp);
    XbWSMs_SetLastCursor(oldcursor);
    fclose(fp);
    XbWVDb_DbkStrt->ITM_MAX = (long)th.tab_size;
    XbWVDb_DbkStrt->T_ITM_END = (XbWDDb_DbIVar *)((char *)XbWVDb_DbkStrt+(long)th.akt_ende);
    XbWVDb_DbkStrt->T_ITM_PRJ = (XbWDDb_DbIVar *)((char *)XbWVDb_DbkStrt+(long)th.akt_projekt);
    XbWVDb_DbkStrt->T_ITM_GRP = (XbWDDb_DbIStr *)((char *)XbWVDb_DbkStrt+(long)th.akt_group);
    XbWVDb_DbkStrt->T_ITM_SYS = (XbWDDb_DbIStr *)((char *)XbWVDb_DbkStrt+(long)th.akt_sys);
    XbWFTb_Message(".");
    if (draw_windows) {
      XbWFWd_BackGr();
      if (th.akt_wdw[0] != '!'){
        XbWFWd_SwitchTo(th.akt_wdw,0);
        };
      XbWFWd_DrawAll();
      };
    return(0);
    };
  return(1);
  };
/*}}}  */

/*{{{  XbWFDb_CloseSys(    ***    Datenbank loeschen*/
int  XbWFDb_CloseSys(void){
  if (XbWVDb_DbkStat == 1) {
    XbWVDb_DbkStat = 0;
    XbWSSy_FreeMem((void*)XbWVDb_DbkStrt);
    XbWVDb_DbkStrt = NULL;
    return(0);
    };
  #ifdef TEST
    puts("NO TABLE UN-ALLOCATED");
  #else
    XbWSPu_Alarm("NO TABLE UN-ALLOCATED");
    #endif
  return(1);
  };
/*}}}  */
/*{{{  XbWFDb_CreaSys(     ***    ALT!! (Speicher reservieren fuer Datenbank)*/
int  XbWFDb_CreaSys(void  *(*p)[]){
  XbWDDb_DbIPtr size;
  if ((int)(*p)[0] < 1 ) {return(XbWDMf_NoPara);};
  size = (1.0*((int)((*p)[1])));
  if (XbWVDb_DbkStat == 1) {
    XbWFDb_CloseSys();
    };
  if (XbWVDb_DbkStat == 2) {
    struct stat statbuf;
    if (fstat(XbWVDb_DbkFile,&statbuf)<0){
      printf("could not fstat() active database file.\n");
      exit(1);
      };
    munmap((caddr_t)XbWVDb_DbkStrtMem,statbuf.st_size);
    close(XbWVDb_DbkFile);
    };
 
  XbWVDb_DbkStat = 1;
  XbWVDb_AkDbkEl = NULL;
  XbWVDb_ActGrp1 = NULL;
  XbWVDb_AktDObj = NULL;
  XbWVDb_AktDKey = NULL;
  XbWVDb_DbkStrt = (XbWDDb_Sys  *)(XbWSSy_AlocMem(size,1024));
  if (XbWVDb_DbkStrt == NULL) {
    #ifdef TEST
      puts("HEAP ERROR!!");
    #else
      XbWSPu_Alarm("HEAP ERROR!");
      #endif
      puts("");
    exit(1);
    };
  XbWVDb_DbkStrt->ITM_MAX     = (XbWDDb_DbIPtr)(1.0*size*1024);
  XbWVDb_DbkStrt->T_ITM_END   = (void  *)XbWVDb_DbkStrt;
  XbWVDb_DbkStrt->T_ITM_END =
    (void *)((char *)(XbWVDb_DbkStrt->T_ITM_END)+(long)sizeof(XbWDDb_Sys));
  XbWVDb_DbkStrt->T_ITM_PRJ = (XbWDDb_DbIVar  *)XbWFDb_GtEOT();
  XbWVDb_DbkStrt->T_ITM_SYS = (XbWDDb_DbIStr  *)XbWFDb_GtEOT();
  XbWVDb_DbkStrt->T_ITM_GRP = (XbWDDb_DbIStr  *)XbWFDb_GtEOT();
  return(0);
  };
/*}}}  */
/*{{{  XbWFDb_OpenSys(     ***    NEU!! Datenbank schnell r/w oeffen*/
int  XbWFDb_OpenSys(void  *(*p)[], int (*t)[]){
  XbWDDb_DbIPtr size=0;
  char filename[100];
  XbWDDb_Header th;
  struct stat statbuf;
 
  if (XbWVDb_DbkStat == 1) {
    XbWFDb_CloseSys();
    };
 
  if ((int)(*p)[0] < 1 ) {return(XbWDMf_NoPara);};
    switch( (int)(*t)[1] ) {
    /*{{{  */
      case XbWDMf_StrPar:
        /*{{{  */
        strcpy(filename,(char*)(XbWFTb_PckTxt((char*)(*p)[1])));
        break;
        /*}}}  */
      case XbWDMf_VLPar:
        /*{{{  */
        {
          XbWDDb_DbIVar  *QQ;
          char *fsp;
          QQ = (XbWDDb_DbIVar  *)(*p)[1];
          if (QQ == NULL) { return(1); };
          fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Str,NULL,1);
          if (fsp != NULL) {
            strcpy(filename,(char*)XbWFTb_PckTxt(fsp));
            };
          };
        break;
        /*}}}  */
      };
    /*}}}  */
  if ((int)(*p)[0] > 1 ) {
    switch( (int)(*t)[2] ) {
    /*{{{  */
      case XbWDMf_IntPar:
        /*{{{  */
        size = (1.0*((int)((*p)[2])));
        break;
        /*}}}  */
      };
    /*}}}  */
    };
  XbWVDb_DbkStat = 2;
  XbWVDb_AkDbkEl = NULL;
  XbWVDb_ActGrp1 = NULL;
  XbWVDb_AktDObj = NULL;
  XbWVDb_AktDKey = NULL;
 
  XbWVDb_DbkFile = open(filename,O_RDWR);
  if (XbWVDb_DbkFile<0){
    printf("Could not open database %s!!\n",filename);
    exit(1);
    };
  if (fstat(XbWVDb_DbkFile,&statbuf)<0){
    printf("could not fstat() file %s\n",filename);
    exit(1);
    };
 
  read(XbWVDb_DbkFile,&th,sizeof(th));

  XbWVDb_DbkStrtMem = (XbWDDb_Sys  *)mmap(0,statbuf.st_size,
                                           PROT_READ|PROT_WRITE,
                                           MAP_FILE|MAP_PRIVATE,
                                           XbWVDb_DbkFile,
                                           0 /* offset in pagesize!*/
                                           );
  if ((int)XbWVDb_DbkStrtMem==-1){
    printf("Errno %d; Could not memmap() database %s!!\n",errno,filename);
    exit(1);
    };
 
  XbWVDb_DbkStrt =  (XbWDDb_Sys  *)((char*)XbWVDb_DbkStrtMem+sizeof(XbWDDb_Header));
 
  XbWVDb_DbkStrt->ITM_MAX = (long)th.tab_size;
  XbWVDb_DbkStrt->T_ITM_END = (XbWDDb_DbIVar *)((char *)XbWVDb_DbkStrt+(long)th.akt_ende);
  XbWVDb_DbkStrt->T_ITM_PRJ = (XbWDDb_DbIVar *)((char *)XbWVDb_DbkStrt+(long)th.akt_projekt);
  XbWVDb_DbkStrt->T_ITM_GRP = (XbWDDb_DbIStr *)((char *)XbWVDb_DbkStrt+(long)th.akt_group);
  XbWVDb_DbkStrt->T_ITM_SYS = (XbWDDb_DbIStr *)((char *)XbWVDb_DbkStrt+(long)th.akt_sys);
  XbWFTb_Message(".");
 
  XbWFWd_BackGr();
  if (th.akt_wdw[0] != '!'){
    XbWFWd_SwitchTo(th.akt_wdw,0);
    };
  XbWFWd_DrawAll();
 
  return(0);
  };
/*}}}  */
 
/*{{{  XbWFMf_ExecCom(     ***    Unterroutinen Metafile-Interpreter*/
void  XbWFMf_ExecCom(char *com){
  char sstr[100];
  int stat;
  stat = XbWFMf_GtComNo(com);
  if (stat >= 0){
    if (XbWFMf_ExComand(stat,0)) {
      sprintf(sstr,"Sorry: %s !OK (l.%d) %s",(char *)com,
        (int)XbWVMf_az,(char *)XbWVMf_af);
      XbWFTb_Error(sstr);
      };
    };
  return;
  };
/*}}}  */
/*{{{  XbWFMf_DebugON(     ****/
void  XbWFMf_DebugON(void){
  XbWVMf_prd = 1;
  };
/*}}}  */
/*{{{  XbWFMf_SetNames(    ****/
int  XbWFMf_SetNames(char *lzeile){
  int ii;
  /*  Format : <LISTE>:<GRUPPE>.<Element> */
  if (strchr(lzeile,':') == NULL) {return(1);};
  if (strchr(lzeile,'.') == NULL) {return(1);};
  strncpy(XbWVMf_ln,&lzeile[0],129);
  XbWVMf_ln[129]=0; *((char*)(strchr(XbWVMf_ln,':')))=0;
  strncpy(XbWVMf_gn,strchr(lzeile,':')+1,129); XbWVMf_gn[129]= 0;
  *((char*)(strchr(XbWVMf_gn,'.')))=0;
  strncpy(XbWVMf_nn,strchr(lzeile,'.')+1,129); XbWVMf_nn[129]= 0;
  for (ii=0;ii<129;ii++){
    switch(XbWVMf_nn[ii]) {
      case ';':
      case ',':
      case '|':
      case ' ':
      case '\t':
      case '}': XbWVMf_nn[ii]=0;ii=1000;break;
      };
    };
  return(0);
  };
/*}}}  */
/*{{{  XbWFMf_EndOfMta(    ****/
void  XbWFMf_EndOfMta(void){
  XbWVMf_eof = 1;};
/*}}}  */
/*{{{  XbWFMf_GotoLabl(    ****/
void  XbWFMf_GotoLabl(void *p[1]){
  strcpy(XbWVMf_jln,"!");
  strcat(XbWVMf_jln,(char *)p[0]);
  strcat(XbWVMf_jln,"!");
  XbWVMf_jtl = 1;
  };
/*}}}  */
/*{{{  XbWFMf_PtrStr(      ****/
void  XbWFMf_PtrStr(char *zeile,char*rohzeile, int *r_a, int *r_l, FILE *MetaFile){
  int r_akt,r_len;
  int ii=0;
  int mm=0;
  r_akt = *r_a;
  r_len = *r_l;
  while(!mm)
    {
    switch (rohzeile[r_akt])
      {
      case  0 : mm++; zeile[ii]=0; break;
      case '|': mm++; zeile[ii]=0; break;
      case ' ': mm++; zeile[ii]=0; break;
      case '\t': mm++; zeile[ii]=0; break;
      case '}': mm++; zeile[ii]=0; break;
      case ',': mm++; zeile[ii]=0; break;
      case '>': mm++; zeile[ii]=0; break;
      case '$':
          {
          int ll,kk;
          char *parstr;
          r_akt++;
          XbWDMf_GtLine;
          if (XbWVMf_eof){goto end_of_read;};
          ll = rohzeile[r_akt] - '0';
          r_akt++;
          XbWDMf_GtLine;
          if (XbWVMf_eof){goto end_of_read;};
          if (rohzeile[r_akt] >= '0')
            {
            if (rohzeile[r_akt] <= '9')
              {
              ll *= 10;
              ll += rohzeile[r_akt]-'0';
              r_akt ++;
              XbWDMf_GtLine;
              };
            };
          if (XbWVMf_aP != NULL){
            parstr = (char*)((*XbWVMf_aP)[ll]).XbWVMf_P;
            kk = 0;
            while (parstr[kk] != 0){
              zeile[ii] = parstr[kk]; ii++; kk++;
              };
            };
          };
          break;
      case '<':
          {
          char s_zz[80];
          XbWFMf_PtrStr(s_zz,rohzeile,&r_akt,&r_len,MetaFile);
          if (!XbWFMf_SetNames(s_zz))
            {
            char *parstr;
            int s_kk;
            XbWDDb_DbIVar  *ac_gp;
            if ((ac_gp = XbWFDb_FindGrp(XbWVMf_ln,XbWVMf_gn)) != NULL){
              parstr = (char*)XbWFDb_VarInh(ac_gp,XbWDDb_Str,XbWVMf_nn,1);
              if (parstr != NULL) {
                s_kk = 0;
                while (parstr[s_kk] != 0){
                  zeile[ii] = parstr[s_kk]; ii++; s_kk++;
                  };
                };
              };
            };
          };
          break;
      default :
        zeile[ii] = rohzeile[r_akt]; ii++;
        r_akt++; XbWDMf_GtLine; break;
      };
    };
  end_of_read:;
  zeile[ii] = 0;
  *r_a = r_akt;
  *r_l = r_len;
  };
/*}}}  */
/*{{{  XbWFMf_VPtr(        ****/
void  XbWFMf_VPtr(char *zeile,char*rohzeile, int *r_a, int *r_l, FILE *MetaFile, int *s_p){
  int r_akt,r_len,StarteProcedure;
  char r_p;
  r_akt = *r_a;
  r_len = *r_l;
  StarteProcedure = *s_p;
  r_akt++;
  XbWDMf_GtLine;
  if (XbWVMf_eof){goto end_of_read;};
  r_p = rohzeile[r_akt];
  r_akt++;
  XbWDMf_GtLine;
  if (XbWVMf_eof){goto end_of_read;};
  XbWFMf_PtrStr(zeile,rohzeile,&r_akt,&r_len,MetaFile);
  switch(r_p)
    {
    case 'p':
      {
      int dd;
      if (!XbWFMf_SetNames(zeile)) {
        XbWDDb_DbIVar  *ac_gp;
        ac_gp = XbWFDb_FindGrp(XbWVMf_ln,XbWVMf_gn);
        if (ac_gp != NULL) {
          dd = XbWFDb_GetNum(ac_gp,XbWVMf_nn,1);
          XbWVMf_P[XbWVMf_C] = (void  *)dd;
          XbWVMf_T[XbWVMf_C] = XbWDMf_VPPar;
          XbWVMf_C++;
          };
        XbWDMf_SekEOL;
        };
      };
      break;
    case 'i':
      {
      int dda=0; int *dd=&dda;
      if (!XbWFMf_SetNames(zeile))
        {
        XbWDDb_DbIVar  *ac_gp;
        ac_gp = XbWFDb_FindGrp(XbWVMf_ln,XbWVMf_gn);
        if (ac_gp != NULL) {
          ac_gp = (XbWDDb_DbIVar  *)XbWFDb_VarInh(ac_gp,0,XbWVMf_nn,1);
          switch( ac_gp->tp & XbWDDb_Typ) {
            case XbWDDb_Int:  dd = (int*)&((XbWDDb_DbIInt  *)ac_gp)->inh; break;
            case XbWDDb_Dbl:  dd = (int*)&((XbWDDb_DbIDbl  *)ac_gp)->inh; break;
            case XbWDDb_Str:  dd = (int*)&(((XbWDDb_DbIStr  *)ac_gp)->nmi[ac_gp->tp & XbWDDb_NLen]); break;
            case XbWDDb_NPtr:
            case XbWDDb_FPtr:
            case XbWDDb_IPtr:
            case XbWDDb_GPtr: dd = (int*)&((XbWDDb_DbINPtr  *)ac_gp)->inh; break;
            };
          };
        XbWVMf_P[XbWVMf_C] = (void  *)dd;
        XbWVMf_T[XbWVMf_C] = XbWDMf_VIPar;
        XbWVMf_C++;
        XbWDMf_SekEOL;
        };
      };
      break;
    case 'm':
      {
      char *dd;
      if (!XbWFMf_SetNames(zeile))
        {
        XbWDDb_DbIVar  *ac_gp;
        ac_gp = XbWFDb_FindGrp(XbWVMf_ln,XbWVMf_gn);
        if (ac_gp != NULL) {
          dd = (char *)XbWFDb_VarInh(ac_gp,XbWDDb_Str,XbWVMf_nn,1);
          if (dd != NULL) { XbWFMf_ReadMakro(dd); };
          };
        XbWDMf_SekEOL;
        };
      };
      break;
    case 'l':
      {
      int *dd;
      if (!XbWFMf_SetNames(zeile))
        {
        dd = (int*)XbWFDb_GetDbI(XbWVMf_ln,XbWVMf_gn,XbWVMf_nn);
        XbWVMf_P[XbWVMf_C] = (void  *)dd;
        XbWVMf_T[XbWVMf_C] = XbWDMf_VLPar;
        XbWVMf_C++;
        XbWDMf_SekEOL;
        };
      };
      break;
    };
  end_of_read:;
  *r_a = r_akt;
  *r_l = r_len;
  *s_p = StarteProcedure;
  };
/*}}}  */
/*{{{  XbWFMf_VPtrKl(      ****/
void  XbWFMf_VPtrKl(char *zeile,char*rohzeile, int *r_a, int *r_l, FILE *MetaFile, int *s_p){
  int r_akt,r_len,StarteProcedure;
  char r_p;
  r_akt = *r_a;
  r_len = *r_l;
  StarteProcedure = *s_p;
  r_akt++;
  XbWDMf_GtLine;
  if (XbWVMf_eof){goto end_of_read;};
  r_p = rohzeile[r_akt];
  r_akt++;
  XbWDMf_GtLine;
  { char dummy=0;
    while (dummy != ')' ){
      dummy = rohzeile[r_akt];
      r_akt++;
      XbWDMf_GtLine;
      };
    };
  if (XbWVMf_eof){goto end_of_read;};
  XbWFMf_PtrStr(zeile,rohzeile,&r_akt,&r_len,MetaFile);
 
  switch(r_p)
    {
    /*{{{  case 'i':   (int)*/
    case 'i':  /* (int) */
      {
      int dd;
      if (!XbWFMf_SetNames(zeile)) {
        XbWDDb_DbIVar  *ac_gp;
        ac_gp = XbWFDb_FindGrp(XbWVMf_ln,XbWVMf_gn);
        if (ac_gp != NULL) {
          dd = XbWFDb_GetNum(ac_gp,XbWVMf_nn,1);
          XbWVMf_P[XbWVMf_C] = (void  *)dd;
          XbWVMf_T[XbWVMf_C] = XbWDMf_VPPar;
          XbWVMf_C++;
          };
        XbWDMf_SekEOL;
        };
      };
      break;
    /*}}}  */
    /*{{{  case 'v':   (val)*/
    case 'v':  /* (val) */
      {
      int dda=0; int *dd=&dda;
      if (!XbWFMf_SetNames(zeile))
        {
        XbWDDb_DbIVar  *ac_gp;
        ac_gp = XbWFDb_FindGrp(XbWVMf_ln,XbWVMf_gn);
        if (ac_gp != NULL) {
          ac_gp = (XbWDDb_DbIVar  *)XbWFDb_VarInh(ac_gp,0,XbWVMf_nn,1);
          switch( ac_gp->tp & XbWDDb_Typ) {
            case XbWDDb_Int:  dd = (int*)&((XbWDDb_DbIInt  *)ac_gp)->inh; break;
            case XbWDDb_Dbl:  dd = (int*)&((XbWDDb_DbIDbl  *)ac_gp)->inh; break;
            case XbWDDb_Str:  dd = (int*)&(((XbWDDb_DbIStr  *)ac_gp)->nmi[ac_gp->tp & XbWDDb_NLen]); break;
            case XbWDDb_NPtr:
            case XbWDDb_FPtr:
            case XbWDDb_IPtr:
            case XbWDDb_GPtr: dd = (int*)&((XbWDDb_DbINPtr  *)ac_gp)->inh; break;
            };
          };
        XbWVMf_P[XbWVMf_C] = (void  *)dd;
        XbWVMf_T[XbWVMf_C] = XbWDMf_VIPar;
        XbWVMf_C++;
        XbWDMf_SekEOL;
        };
      };
      break;
    /*}}}  */
    /*{{{  case 's':   (str)  val = str !!!*/
    case 's':  /* (str) */
      {
      int dda=0; int *dd=&dda;
      if (!XbWFMf_SetNames(zeile))
        {
        XbWDDb_DbIVar  *ac_gp;
        ac_gp = XbWFDb_FindGrp(XbWVMf_ln,XbWVMf_gn);
        if (ac_gp != NULL) {
          ac_gp = (XbWDDb_DbIVar  *)XbWFDb_VarInh(ac_gp,0,XbWVMf_nn,1);
          switch( ac_gp->tp & XbWDDb_Typ) {
            case XbWDDb_Int:  dd = (int*)&((XbWDDb_DbIInt  *)ac_gp)->inh; break;
            case XbWDDb_Dbl:  dd = (int*)&((XbWDDb_DbIDbl  *)ac_gp)->inh; break;
            case XbWDDb_Str:  dd = (int*)&(((XbWDDb_DbIStr  *)ac_gp)->nmi[ac_gp->tp & XbWDDb_NLen]); break;
            case XbWDDb_NPtr:
            case XbWDDb_FPtr:
            case XbWDDb_IPtr:
            case XbWDDb_GPtr: dd = (int*)&((XbWDDb_DbINPtr  *)ac_gp)->inh; break;
            };
          };
        XbWVMf_P[XbWVMf_C] = (void  *)dd;
        XbWVMf_T[XbWVMf_C] = XbWDMf_VIPar;
        XbWVMf_C++;
        XbWDMf_SekEOL;
        };
      };
      break;
    /*}}}  */
    /*{{{  case 'm':   (mak)*/
    case 'm':     /* (mak) */
      {
      char *dd;
      if (!XbWFMf_SetNames(zeile))
        {
        XbWDDb_DbIVar  *ac_gp;
        ac_gp = XbWFDb_FindGrp(XbWVMf_ln,XbWVMf_gn);
        if (ac_gp != NULL) {
          dd = (char *)XbWFDb_VarInh(ac_gp,XbWDDb_Str,XbWVMf_nn,1);
          if (dd != NULL) { XbWFMf_ReadMakro(dd); };
          };
        XbWDMf_SekEOL;
        };
      };
      break;
    /*}}}  */
    /*{{{  case 'p':   (ptr)*/
    case 'p':    /* (ptr) */
      {
      int *dd;
      if (!XbWFMf_SetNames(zeile))
        {
        dd = (int*)XbWFDb_GetDbI(XbWVMf_ln,XbWVMf_gn,XbWVMf_nn);
        XbWVMf_P[XbWVMf_C] = (void  *)dd;
        XbWVMf_T[XbWVMf_C] = XbWDMf_VLPar;
        XbWVMf_C++;
        XbWDMf_SekEOL;
        };
      };
      break;
    
    /*}}}  */

    };
  end_of_read:;
  *r_a = r_akt;
  *r_l = r_len;
  *s_p = StarteProcedure;
  };
/*}}}  */
/*{{{  XbWFMf_RdCompMak(   ****/
void  XbWFMf_RdCompMak(XbWDDb_DbIVar  *start){
  int ii;
  XbWDDb_DbIVar  *TV;
  int Command = 0;
  char  *mfname = NULL;
  TV = (XbWDDb_DbIVar  *)start;
  XbWVMf_eof = 0;
  while(!XbWVMf_eof){
    XbWFDb_ForWd(&TV,XbWDDb_DbISys);
    switch(TV->tp & XbWDDb_Typ){
      case XbWDDb_Int:
        Command = ((XbWDDb_DbIInt  *)TV)->inh;
        if (XbWVMf_eof) { return; };
        mfname = NULL;
        break;
      case XbWDDb_Str:
        Command = 0;
        mfname = (char  *)XbWFDb_GetStr((XbWDDb_DbIStr  *)TV);
        break;
      };
    XbWFDb_ForWd(&TV,XbWDDb_DbISys);
    XbWVMf_C = 0;
    switch(TV->tp & XbWDDb_Typ){
      case XbWDDb_Int:
        XbWVMf_C = ((XbWDDb_DbIInt  *)TV)->inh;
        break;
      };
    XbWVMf_P[0] = (void  *)XbWVMf_C;
    for (ii=1;ii<=XbWVMf_C;ii++) {
      XbWFDb_ForWd(&TV,XbWDDb_DbISys);
      switch((TV->tp)&XbWDDb_Typ)
        {
        case XbWDDb_Str:
          XbWVMf_T[ii] = XbWDMf_StrPar;
          XbWVMf_P[ii] = (void  *)XbWFDb_GetStr((XbWDDb_DbIStr  *)TV);
          break;
        case XbWDDb_Dbl:
          XbWVMf_T[ii] = XbWDMf_DblPar;
          sprintf((char*)&XbWVMf_B[ii*XbWDMf_BfStrL],"%20.10f",
            XbWFDb_GetNum(TV,NULL,1));
          XbWVMf_P[ii] = (void *)&(XbWVMf_B[ii*XbWDMf_BfStrL]);
          break;
        case XbWDDb_Int:
          XbWVMf_T[ii] = XbWDMf_IntPar;
          { int dd;
          dd = XbWFDb_GetNum(TV,NULL,1);
          XbWVMf_P[ii] = (void  *)dd;
          }
          break;
        case XbWDDb_IPtr:
          XbWVMf_T[ii] = XbWDMf_VIPar;
          XbWVMf_P[ii] = XbWFDb_CDbIToPtr( ((XbWDDb_DbINPtr  *)TV)->inh,XbWDDb_DbISys);
          break;
        case XbWDDb_NPtr:
          XbWVMf_T[ii] = XbWDMf_VLPar;
          XbWVMf_P[ii] = XbWFDb_CDbIToPtr( ((XbWDDb_DbINPtr  *)TV)->inh,XbWDDb_DbISys);
          break;
        };
      };
    if (mfname == NULL) {
      if (XbWFMf_ExComand(Command,0) != 0) {
        XbWFTb_Error("Sorry: Compiled Makro not OK. ");
        };
      }
    else {
      XbWFMf_ReadMF((char*)mfname);
      };
    };
  };
/*}}}  */
/*{{{  XbWFMf_InterpretMF( ***    Haupt-Unterroutine fuer Interpreter*/
void  XbWFMf_InterpretMF(
    FILE *MetaFile, char *rohzeile, int compile_target){
  int StarteProcedure = 0;
  int minus_val;
  int r_len;
  int r_akt;
  int AutoMetaMode = 0;
  char ProcName[65];
  char zeile[50];
  #ifdef TEST
    XbWFTb_Message("start interpreter");
    #endif
  if (MetaFile == NULL){
    r_akt = 0; r_len = strlen(rohzeile)+1;
    }
  else {
    r_akt = 0; r_len = fread(rohzeile,1,256,MetaFile);
    };
  ProcName[0] = 0;
  XbWVMf_eof = 0;
  #ifdef TEST
    XbWFTb_Message("zeile lesen");
    #endif
  XbWVSy_DebugCommand = ProcName;
  XbWVSy_DebugLine = rohzeile;
  if (r_len > 0)
    while (!XbWVMf_eof){
      {
      nochmal_1:;
      XbWVSy_DebugLinePos = &rohzeile[r_akt];
      XbWDMf_GtLine;
      if (XbWVMf_eof){goto end_of_read;};
      switch(rohzeile[r_akt])
        {
        case ' ':  r_akt++; goto nochmal_1;
        case ',':  r_akt++; goto nochmal_1;
        case '|':  r_akt++; goto nochmal_1;
        case '\t': r_akt++; goto nochmal_1;
        case 10: r_akt++; goto nochmal_1;
        case 13: r_akt++; goto nochmal_1;
        };
      XbWDMf_GtLine;
      if (XbWVMf_eof){goto end_of_read;};
      switch(rohzeile[r_akt])
        {
/* ---------------- */
/*{{{  case 'm':*/
        case 'm':
          {
          int ll;
          if ( (rohzeile[r_akt+1] >= '0') &
               (rohzeile[r_akt+1] <= '9') ) {
            }
          else {
            goto read_string;
            };
 
          r_akt++;
          XbWDMf_GtLine;
          if (XbWVMf_eof){goto end_of_read;};
          ll = rohzeile[r_akt] - '0';
          r_akt++;
          XbWDMf_GtLine;
          if (XbWVMf_eof){goto end_of_read;};
          if (rohzeile[r_akt] >= '0')
            {
            if (rohzeile[r_akt] <= '9')
              {
              ll *= 10;
              ll += rohzeile[r_akt]-'0';
              r_akt ++;
              XbWDMf_GtLine;
              };
            };
          XbWDMf_SekEOL;
          if (XbWVMf_aP != NULL){
            XbWFMf_ReadMakro((char*)((*XbWVMf_aP)[ll]).XbWVMf_P);
            }
          else {
            XbWFTb_Error("Bad or missing metafile parameters!");
            };
          };
          break;
/*}}}  */
 
/* ---------------- */
/*{{{  case '\\':*/
        case '\\':
          {
          if (XbWVMf_dmf) {
            char strz[100];
            sprintf(strz,"Line: ");
            strncat(strz,rohzeile,80);
            XbWFTb_Message(strz);
            XbWSMs_WaitKey();
            };
          r_akt++;
          XbWDMf_GtLine;
          #ifdef TEST
            XbWFTb_Message("Kommando lesen");
            #endif
          if (XbWVMf_eof){goto end_of_read;};
          StarteProcedure = 0;
          XbWVMf_C = 1;
          XbWDMf_CpyCom(ProcName);
          XbWDMf_SekEOL;
          AutoMetaMode = 0;
          if (XbWVMf_eof){
            if (strcmp(ProcName,"End") == 0){
              goto end_of_read;
              };
            };
          };
          #ifdef TEST
            XbWFTb_Message("Kommando eingelesen");
            #endif
          break;
/*}}}  */
 
/* ---------------- */
/*{{{  case ':':          Kommando mit neuen Parametern wiederholen*/
        case ':':       /* Kommando mit neuen Parametern wiederholen */
          if (XbWVMf_dmf) {
            char strz[100];
            sprintf(strz,"Line: ");
            strncat(strz,rohzeile,80);
            XbWFTb_Message(strz);
            XbWSMs_WaitKey();
            };
          StarteProcedure = 0;
          XbWVMf_C = 1;
          XbWDMf_SekEOL;
          /* Autometamode unverndert !! */
          break;
/*}}}  */
 
/* ---------------- */
/*{{{  case '-':*/
        case '-':
          r_akt++; XbWDMf_GtLine;
          if (XbWVMf_eof){goto end_of_read;};
          minus_val= -1;
          goto int_lesen;
/*}}}  */
 
/*{{{  case 'i':*/
        case 'i':
        case '+':
          if ( (rohzeile[r_akt+1] >= '0') &
               (rohzeile[r_akt+1] <= '9') ) {
            }
          else {
            goto read_string;
            };
          r_akt++; XbWDMf_GtLine;
          if (XbWVMf_eof){goto end_of_read;};
          minus_val = 1;
          goto int_lesen;
/*}}}  */
 
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
/*{{{  case '9':*/
        case '9':
 
          minus_val = 1;
          int_lesen:;
          {
          long ll;
          int mm=0;
          ll = 0;
          while(!mm)
            {
            switch (rohzeile[r_akt])
              {
              case 10 : mm++; break;
              case 13 : mm++; break;
              case  0 : mm++; break;
              case '}': mm++; break;
              case '|': mm++; break;
              case ' ': mm++; break;
              case '\t': mm++; break;
              case ',': mm++; break;
              case '-': ll *= -1;
              case '+':
              case '0':
              case '1':
              case '2':
              case '3':
              case '4':
              case '5':
              case '6':
              case '7':
              case '8':
              case '9':
                ll *= 10;
                ll += rohzeile[r_akt] - '0';
                r_akt++; XbWDMf_GtLine; break;
              default: {
                char sstr[80];
                sprintf(sstr,"Is no integer: %s ",(char*)&rohzeile[r_akt]);
                XbWSPu_Alarm(sstr); mm++; break;
                };
              };
            };
          XbWDMf_SekEOL;
          XbWVMf_P[XbWVMf_C] = (void  *)((int)(ll * minus_val));
          XbWVMf_T[XbWVMf_C] = XbWDMf_IntPar;
          XbWVMf_C +=1;
          };
          break;
/*}}}  */

/* ---------------- */
/*{{{  case '\"':*/
        case '\"':
          {
          char *cp;
          int ii=0;
          int mm=0;
          #ifdef TEST
            XbWFTb_Message("Stringpara");
            #endif
          r_akt++;
          XbWDMf_GtLine;
          if (XbWVMf_eof){goto end_of_read;};
          cp = (char*)&XbWVMf_B[XbWVMf_C*XbWDMf_BfStrL];
          while(!mm)  {
            switch (rohzeile[r_akt])
              {
              case 10 : mm++; cp[ii]=0;break;
              case 13 : mm++; cp[ii]=0;break;
              case  0 : mm++; cp[ii]=0;break;
              case '"': mm++; cp[ii]=0; break;
              case '\'': cp[ii] = '"'; ii++; r_akt++; XbWDMf_GtLine; break;
              case '$': /* Insert parameter as string */
                /*{{{  */
                {
                  int ll;
                  int ccc;
                  char *insert_string="(xbw:???)";
                  r_akt++;
                  XbWDMf_GtLine;
                  if (XbWVMf_eof){goto end_of_read;};
                  ll = rohzeile[r_akt] - '0';
                  r_akt++;
                  XbWDMf_GtLine;
                  if (XbWVMf_eof){goto end_of_read;};
                  if (rohzeile[r_akt] >= '0')
                    {
                    if (rohzeile[r_akt] <= '9')
                      {
                      ll *= 10;
                      ll += rohzeile[r_akt]-'0';
                      r_akt ++;
                      XbWDMf_GtLine;
                      if (XbWVMf_eof){goto end_of_read;};
                      };
                    };
                  if (XbWVMf_aP != NULL) {
                    switch ((*XbWVMf_aP)[ll].XbWVMf_T){
                      case XbWDMf_StrPar:
                        insert_string = (void  *)((*XbWVMf_aP)[ll]).XbWVMf_P;
                        break;
                      case XbWDMf_IntPar:
                        sprintf(insert_string,"%d",(int)((*XbWVMf_aP)[ll]).XbWVMf_P);
                        break;
                      case XbWDMf_DblPar:
                        sprintf(insert_string,"%s",(char *)((*XbWVMf_aP)[ll]).XbWVMf_P);
                        break;
                      case XbWDMf_VLPar:
                        {
                          XbWDDb_DbIVar  * TV;
                          TV = (XbWDDb_DbIVar  *)((*XbWVMf_aP)[ll]).XbWVMf_P;
                          insert_string = XbWFDb_GetNam(TV);
                          };
                        break;
                      };
                    }
                  else {
                    XbWFTb_Error("Not enough metafile parameters");
                    };
                
                  ccc = 0;
                  while(insert_string[ccc] != 0){
                    cp[ii] = insert_string[ccc]; ii++;
                    ccc++;
                    };
                  };
                /*}}}  */
                break;
 
              default :
                cp[ii] = rohzeile[r_akt]; ii++;
                r_akt++; XbWDMf_GtLine; break;
              };
            };
          XbWVMf_P[XbWVMf_C] = (char  *)&XbWVMf_B[XbWVMf_C*XbWDMf_BfStrL];
          XbWVMf_T[XbWVMf_C] = XbWDMf_StrPar;
          XbWVMf_C++;
          XbWDMf_SekEOL;
          #ifdef TEST
            XbWFTb_Message("Stringpara fertig");
            #endif
          };
          break;
/*}}}  */

/* ---------------- */
/*{{{  case '{':*/
        case '{':
          {
          char *cp;
          int ii=0;
          int mm=0;
          r_akt++;
          XbWDMf_GtLine;
          if (XbWVMf_eof){goto end_of_read;};
          cp = (char*)&XbWVMf_B[XbWVMf_C*XbWDMf_BfStrL];
          while(!mm) {
            switch (rohzeile[r_akt]) {
              case  0 : mm++; cp[ii]=0; break;
              case '}': mm++; cp[ii]=0; break;
              default :
                cp[ii] = rohzeile[r_akt]; ii++;
                r_akt++; XbWDMf_GtLine; break;
              };
            };
          XbWVMf_P[XbWVMf_C] = (char  *)&XbWVMf_B[XbWVMf_C*XbWDMf_BfStrL];
          XbWVMf_T[XbWVMf_C] = XbWDMf_DblPar;
          XbWVMf_C++;
          XbWDMf_SekEOL;
          };
          break;
/*}}}  */

/* ---------------- */
        case '%':
/* ---------------- */
        case '/':
/* ---------------- */
/*{{{  case '!':*/
        case '!':
          XbWDMf_IgnLin;
          break;
/*}}}  */

/* ---------------- */
/*{{{  case '}':*/
        case '}':
          XbWDMf_SekEOL;
          break;
/*}}}  */

/* ---------------- */
/*{{{  case '(':*/
        case '(':
          XbWFMf_VPtrKl(zeile,rohzeile,&r_akt,&r_len,MetaFile,&StarteProcedure);
          break;
/*}}}  */

/* ---------------- */
/*{{{  case 'v':*/
        case 'v':
          if ( (rohzeile[r_akt+1] != 'l') &
               (rohzeile[r_akt+1] != 'i') &
               (rohzeile[r_akt+1] != 'm') &
               (rohzeile[r_akt+1] != 'p') ) {
            goto read_string;
            };
          XbWFMf_VPtr(zeile,rohzeile,&r_akt,&r_len,MetaFile,&StarteProcedure);
          break;
/*}}}  */

/* ---------------- */
/*{{{  case 'N':*/
        case 'N':
          if ( (rohzeile[r_akt+1] != 'U') &
               (rohzeile[r_akt+2] != 'L') &
               (rohzeile[r_akt+3] != 'L') ) {
            goto read_string;
            };
          XbWVMf_P[XbWVMf_C] = NULL;
          XbWVMf_T[XbWVMf_C] = XbWDMf_NULPar;
          XbWVMf_C++;
          XbWDMf_SekEOL;
          break;
/*}}}  */

/* ---------------- */
/*{{{  case '@':*/
        case '@':
          {
          if (XbWVMf_dmf) {
            char strz[100];
            sprintf(strz,"Line: ");
            strncat(strz,rohzeile,80);
            XbWFTb_Message(strz);
            XbWSMs_WaitKey();
            };
          XbWDMf_CpyCom(ProcName);
          XbWDMf_SekEOL;
          XbWVMf_C = 1;
          AutoMetaMode = 1;
          };
          break;
/*}}}  */

/* ---------------- */
/*{{{  case '$':*/
        case '$':
          {
          int ll;
          r_akt++;
          XbWDMf_GtLine;
          if (XbWVMf_eof){goto end_of_read;};
          ll = rohzeile[r_akt] - '0';
          r_akt++;
          XbWDMf_GtLine;
          if (XbWVMf_eof){goto end_of_read;};
          if (rohzeile[r_akt] >= '0')
            {
            if (rohzeile[r_akt] <= '9')
              {
              ll *= 10;
              ll += rohzeile[r_akt]-'0';
              r_akt ++;
              XbWDMf_GtLine;
              if (XbWVMf_eof){goto end_of_read;};
              };
            };
          XbWDMf_SekEOL;
          if (XbWVMf_aP != NULL) {
            XbWVMf_P[XbWVMf_C] = (void  *)((*XbWVMf_aP)[ll]).XbWVMf_P;
            XbWVMf_T[XbWVMf_C] = (*XbWVMf_aP)[ll].XbWVMf_T;
            }
          else {
            XbWFTb_Error("Not enough metafile parameters");
            };
          XbWVMf_C ++;
          };
          break;
/*}}}  */

/* ---------------- */
/*{{{  case 0:*/
        case 0:
          XbWVMf_eof = 1;
          goto end_of_read;
/*}}}  */

/* ---------------- */
/*{{{  default:*/
        default:
          read_string:;
          if ( ( (rohzeile[r_akt]>='A')&(rohzeile[r_akt]<='Z') ) |
               ( (rohzeile[r_akt]>='a')&(rohzeile[r_akt]<='z') ) |
                 (rohzeile[r_akt]=='=')                          |
                 (rohzeile[r_akt]=='.')                           ){
             char *cp;
             int ii=0;
             int mm=0;
             #ifdef TEST
               XbWFTb_Message("Stringpara");
               #endif
             XbWDMf_GtLine;
             if (XbWVMf_eof){goto end_of_read;};
             cp = (char*)&XbWVMf_B[XbWVMf_C*XbWDMf_BfStrL];
             while(!mm)  {
               switch (rohzeile[r_akt])
                 {
                 case 10 : mm++; cp[ii]=0;break;
                 case 13 : mm++; cp[ii]=0;break;
                 case  0 : mm++; cp[ii]=0;break;
                 case '"': mm++; cp[ii]=0; break;
                 case ' ': mm++; cp[ii]=0; break;
                 case '\'': cp[ii] = '"'; ii++; r_akt++; XbWDMf_GtLine; break;
                 case '$': /* Insert parameter as string */
                   /*{{{  */
                   {
                     int ll;
                     int ccc;
                     char *insert_string="(xbw:???)";
                     r_akt++;
                     XbWDMf_GtLine;
                     if (XbWVMf_eof){goto end_of_read;};
                     ll = rohzeile[r_akt] - '0';
                     r_akt++;
                     XbWDMf_GtLine;
                     if (XbWVMf_eof){goto end_of_read;};
                     if (rohzeile[r_akt] >= '0')
                       {
                       if (rohzeile[r_akt] <= '9')
                         {
                         ll *= 10;
                         ll += rohzeile[r_akt]-'0';
                         r_akt ++;
                         XbWDMf_GtLine;
                         if (XbWVMf_eof){goto end_of_read;};
                         };
                       };
                     if (XbWVMf_aP != NULL) {
                       switch ((*XbWVMf_aP)[ll].XbWVMf_T){
                         case XbWDMf_StrPar:
                           insert_string = (void  *)((*XbWVMf_aP)[ll]).XbWVMf_P;
                           break;
                         case XbWDMf_IntPar:
                           sprintf(insert_string,"%d",(int)((*XbWVMf_aP)[ll]).XbWVMf_P);
                           break;
                         case XbWDMf_DblPar:
                           sprintf(insert_string,"%s",(char *)((*XbWVMf_aP)[ll]).XbWVMf_P);
                           break;
                         case XbWDMf_VLPar:
                           {
                             XbWDDb_DbIVar  * TV;
                             TV = (XbWDDb_DbIVar  *)((*XbWVMf_aP)[ll]).XbWVMf_P;
                             insert_string = XbWFDb_GetNam(TV);
                             };
                           break;
                         };
                       }
                     else {
                       XbWFTb_Error("Not enough metafile parameters");
                       };
                   
                     ccc = 0;
                     while(insert_string[ccc] != 0){
                       cp[ii] = insert_string[ccc]; ii++;
                       ccc++;
                       };
                     };
                   /*}}}  */
                   break;
 
                 default :
                   cp[ii] = rohzeile[r_akt]; ii++;
                   r_akt++; XbWDMf_GtLine; break;
                 };
               };
             XbWVMf_P[XbWVMf_C] = (char  *)&XbWVMf_B[XbWVMf_C*XbWDMf_BfStrL];
             XbWVMf_T[XbWVMf_C] = XbWDMf_StrPar;
             XbWVMf_C++;
             XbWDMf_SekEOL;
             #ifdef TEST
               XbWFTb_Message("Stringpara fertig");
               #endif
             }
          else {
            XbWSPu_Alarm((char*)&(rohzeile[r_akt]));
            XbWVMf_eof = 1;
            goto end_of_read;
            };
          break;
 
        };
/*}}}  */

      if (XbWVMf_C > XbWDMf_MaxPar - 3)
        {
        XbWSPu_Alarm("Too many parameters in command...");
        return;
        };
      if (StarteProcedure == 1)
        {
        int ii;
        XbWDMf_AktPar ( *mrkpara)[];
        char fname[80];

        #ifdef TEST
          XbWFTb_Message("Starte Procedure...");
          #endif

        XbWVMf_CErr = 0;
        XbWVMf_P[XbWVMf_C] = NULL;
        XbWVMf_P[0] = (void  *)(XbWVMf_C-1);
        XbWVMf_T[0] = XbWDMf_AnzPar;
        if (!AutoMetaMode) {
          if (compile_target == 0) {
            int stat;
            stat = XbWFMf_GtComNo(ProcName);
            if (stat >= 0){
              if ((XbWVMf_Cerr = XbWFMf_ExComand(stat,0))!= 0)
                {
                sprintf(fname,"Sorry: %s !OK %s",ProcName,
                  XbWVMf_af);
                XbWFTb_Error(fname);
                };
              };
            }
          else {
            void  *pp[4];
 
            if (!AutoMetaMode) {
              pp[0] = (void  *)2;
              pp[1] = (void  *)"C";
              pp[2] = (void  *)XbWFMf_GtComNo(ProcName);
              XbWFDb_AppInt(&pp,NULL);
              pp[0] = (void  *)2;
              pp[1] = (void  *)"c";
              pp[2] = (void  *)(XbWVMf_C-1);
              XbWFDb_AppInt(&pp,NULL);
              }
            else {
              pp[0] = (void  *)2;
              pp[1] = (void  *)"M";
              pp[2] = (void  *)(ProcName);
              XbWFDb_AppStr(&pp,NULL);
              pp[0] = (void  *)2;
              pp[1] = (void  *)"c";
              pp[2] = (void  *)(XbWVMf_C);
              XbWFDb_AppInt(&pp,NULL);
              };

            for (ii=0;ii<XbWVMf_C;ii++) {
              switch(XbWVMf_T[ii]) {
                case XbWDMf_StrPar:
                  pp[0] = (void  *)2;
                  pp[1] = (void  *)"";
                  pp[2] = (void *)&(XbWVMf_B[ii*XbWDMf_BfStrL]);
                  XbWFDb_AppCSt(&pp,NULL);
                  break;
                case XbWDMf_DblPar:
                  pp[0] = (void  *)2;
                  pp[1] = (void  *)"";
                  pp[2] = (void *)&(XbWVMf_B[ii*XbWDMf_BfStrL]);
                  XbWFDb_AppDbl(&pp);
                  break;
                case XbWDMf_IntPar:
                case XbWDMf_VPPar:
                  pp[0] = (void  *)2;
                  pp[1] = (void  *)"";
                  pp[2] = (void *)XbWVMf_P[ii];
                  XbWFDb_AppInt(&pp,NULL);
                  break;
                case XbWDMf_VLPar:
                  pp[0] = (void  *)2;
                  pp[1] = (void  *)"";
                  pp[2] = (void *)XbWVMf_P[ii];
                  XbWFDb_AppNPtr(&pp,NULL);
                  break;
                case XbWDMf_VIPar:
                  pp[0] = (void  *)2;
                  pp[1] = (void  *)"";
                  pp[2] = (void *)XbWVMf_P[ii];
                  XbWFDb_AppIPtr(&pp);
                  break;
                };
              };
            };
          }
        else
          {
          #ifdef TEST
            XbWFTb_Message("Execute Metafile...");
            #endif
          mrkpara = XbWVMf_aP;
          /*{{{  */
          if (XbWVMf_C > 1)
            /*{{{  */
            {
            XbWVMf_aP = (XbWDMf_AktPar ( *)[])XbWSSy_AlocMem(XbWVMf_C,sizeof(XbWDMf_AktPar));
            if (XbWVMf_aP != NULL)
              {
              for (ii=0;ii<XbWVMf_C;ii++)
                {
                if (XbWVMf_P[ii] == (char *)&(XbWVMf_B[ii*XbWDMf_BfStrL]))
                  {
                  strcpy(((*XbWVMf_aP)[ii]).Str,(char*)&(XbWVMf_B[ii*XbWDMf_BfStrL]));
                  ((*XbWVMf_aP)[ii]).XbWVMf_T = XbWVMf_T[ii];
                  ((*XbWVMf_aP)[ii]).XbWVMf_P = &(((*XbWVMf_aP)[ii]).Str);
                  }
                else
                  {
                  ((*XbWVMf_aP)[ii]).XbWVMf_P = XbWVMf_P[ii];
                  ((*XbWVMf_aP)[ii]).XbWVMf_T = XbWVMf_T[ii];
                  };
                };
              if (compile_target) {
                XbWFMf_CompileMF(ProcName);
                }
              else {
                XbWFMf_ReadMF(ProcName);
                };
              #ifdef TEST
                XbWFTb_Message("Execute Metafile mit Params fertig");
                #endif
              };
            /*}}}  */
            }
          else {
            XbWVMf_aP = NULL;
            if (compile_target) {
              XbWFMf_CompileMF(ProcName);
              }
            else {
              XbWFMf_ReadMF(ProcName);
              };
              #ifdef TEST
                XbWFTb_Message("Execute Metafile ohne Params fertig");
                #endif
            };
          if (XbWVMf_aP != NULL) {
            XbWSSy_FreeMem((void far*)XbWVMf_aP);
            };
          XbWVMf_aP = mrkpara;
          /*}}}  */
          };

        #ifdef TEST
          XbWFTb_Message("eof??");
          #endif
        if (XbWVMf_eof){
          if (strcmp(ProcName,"End") == 0) {
            goto end_of_read;
            };
          };
        #ifdef TEST
          XbWFTb_Message("error??");
          #endif
        if (XbWVMf_CErr != 0)
          {
          goto end_of_read;
          };
        StarteProcedure = 0;
        };
      if (XbWVMf_jtl == 1)
        {
        char lb[80];
        int ee=1;
        while(ee){
          r_akt++;
          XbWDMf_GtLine;
          if (XbWVMf_eof){goto end_of_read;};
          if (rohzeile[r_akt] == '!')
            {
            XbWDMf_CpyLab(lb);
            if (strstr(lb,XbWVMf_jln) == NULL)
              {
              ee=0;
              };
            };
          };
        XbWDMf_SekEOL;
        XbWVMf_jtl = 0;
        };

      if (r_len >0) {XbWVMf_eof = 0;};
      end_of_read:;
      };
    };
  };
/*}}}  */
/*{{{  XbWFMf_ReadMF(      ***    Metafile interpretieren*/
void  Old_Mf_ReadMF(char *filename){
  char *mrk;
  char filbuf[260];
  char thefilename[80];
  int successful = 0;
  FILE *MetaFile;
  void  *oldcursor;
 
  mrk = XbWVMf_af;
  oldcursor = XbWSMs_SetClockCursor();
  XbWVMf_mlv++;
 
  if (filename == NULL) { goto ende_ReadMF; };
 
  if (strstr(filename,".") == NULL){
    if (filename[0] == '@'){
      if (filename[1]=='('){
        sprintf(thefilename,"%s.mta",(char*)&filename[7]);
        }
      else {
        sprintf(thefilename,"%s.mta",(char*)&filename[1]);
        };
      }
    else {
      sprintf(thefilename,"%s.mta",filename);
      };
    }
  else {
    if (filename[0] == '@'){
      if (filename[1]=='('){
        sprintf(thefilename,"%s",(char*)&filename[7]);
        }
      else {
        sprintf(thefilename,"%s",(char*)&filename[1]);
        };
      }
    else {
      sprintf(thefilename,"%s",filename);
      };
    };
  MetaFile = XbWSSy_fopen(thefilename,"rb");
  if (MetaFile != NULL){ goto ReadTheFile; };
  strcpy(thefilename,filename);
 
  if (MetaFile==NULL){
    switch (filename[0]){
      case 0:   goto ende_ReadMF;
      case 'N': if (strncmp(filename,"NULL",4) == 0) {  goto ende_ReadMF; };
      default:
         sprintf(thefilename,"\\xw\\x\\%s.mta",(char*)&(filename[1]));
         MetaFile = XbWSSy_fopen(thefilename,"rb");
         if (MetaFile != NULL){ goto ReadTheFile; };
         strcpy(thefilename,filename);
         break;
      };
    };
 
  MetaFile = XbWSSy_fopen(thefilename,"rb");
  if (MetaFile == NULL) {
    switch (filename[0]){
      case '@':
        switch(filename[1]){
          case '(': break;
          default:  sprintf(thefilename,"\\xw\\x\\%s",(char*)&(filename[1]));
                    break;
          };
        break;
      default:  strcpy(thefilename,filename); break;
      };
    };
 
  if (strchr(thefilename,'.') == NULL) {
    strcat(thefilename,".mta");
    };
 
  MetaFile = XbWSSy_fopen(thefilename,"rb");
 
  if (MetaFile == NULL) {
    switch (filename[0]){
      case '@':
        sprintf(thefilename,"%s%s",XbWVSy_PrjPath,(char*)&(filename[1]));
        if (strchr(thefilename,'.') == NULL) {
          strcat(thefilename,".mta");
          };
        MetaFile = XbWSSy_fopen(thefilename,"rb");
        if (MetaFile == NULL) {
          switch (filename[0]){
            case '@':
              sprintf(thefilename,"%s%s",XbWVSy_AppPath,(char*)&(filename[1]));
              if (strchr(thefilename,'.') == NULL) {
                strcat(thefilename,".mta");
                };
              MetaFile = XbWSSy_fopen(thefilename,"rb");
              if (MetaFile == NULL) {
                goto ende_ReadMF;
                };
              break;
            default:
              goto ende_ReadMF;
            };
          };
        break;
      default:  goto ende_ReadMF;
      };
    };
 
  mrk = XbWVMf_af;
  XbWVMf_af = thefilename;
 
  #ifdef TEST
    XbWFTb_Message("Interpreter...");
    #endif
ReadTheFile:;
  XbWFMf_InterpretMF(MetaFile,filbuf,0);
  successful=1;
  XbWVMf_af= mrk;
  fclose(MetaFile);
  XbWVMf_mlv--;
  ende_ReadMF:
  XbWSMs_SetLastCursor(oldcursor);
  if (!successful){
    printf("\nERROR: Could not find metafile %s\n",filename);
    };
  };
/*}}}  */
/*{{{  XbWFMf_CompileMF(   ***    Metafile compilieren*/
void  XbWFMf_CompileMF(char *filename){
  char *mrk;
  char filbuf[260];
  char thefilename[80];
  FILE *MetaFile;

  void  *oldcursor;

  oldcursor = XbWSMs_SetClockCursor();
  XbWVMf_mlv++;

  if (filename == NULL) {                  goto ende_CompileMF; };
  switch (filename[0]){
    case 0:   goto ende_CompileMF;
    case 'N': if (strncmp(filename,"NULL",4) == 0) {   goto ende_CompileMF; }; break;
    case '@': sprintf(thefilename,"\\xw\\x\\%s",(char*)&(filename[1]));
              if (strchr(thefilename,';') != NULL) {
                strcpy(strchr(thefilename,';'),"\0");
                };
              break;
    default:  strcpy(thefilename,filename); break;
    };

  if (strchr(thefilename,'.') == NULL) {
    strcat(thefilename,".mta");
    };

  MetaFile = XbWSSy_fopen(thefilename,"rb");

  if (MetaFile == NULL) {
    goto ende_CompileMF;
    };

  mrk = XbWVMf_af;
  XbWVMf_af = thefilename;

  XbWFMf_InterpretMF(MetaFile,filbuf,1);
  XbWVMf_af= mrk;
  fclose(MetaFile);
  XbWVMf_mlv--;

  ende_CompileMF:
  XbWSMs_SetLastCursor(oldcursor);
  };
/*}}}  */
/*{{{  XbWFMf_ReadMakro(   ***    Makro interpretieren*/
void  XbWFMf_ReadMakro(char *makro){
  char *mrk;
  void  *oldcursor;
  oldcursor = XbWSMs_SetClockCursor();
  mrk = XbWVMf_af;
  XbWVMf_af = makro;
/*  XbWFMf_InterpretMF(NULL,makro,0); */
  XbWFMf_ParseMakro(makro);
  XbWVMf_af= mrk;
  XbWSMs_SetLastCursor(oldcursor);
  };
/*}}}  */

/*{{{  XbWFMx_DbgON(       ***    Debugging fuer MFX-Gruppen*/
void  XbWFMx_DbgON(void){
  XbWVIf_Debug = 1;
  };
/*}}}  */

/*{{{  XbWFSy_SysStop(     ***    XbW-System stoppen*/
void  XbWFSy_SysStop(void){
  if (XbWVDb_DbkStat == 2) {
    struct stat statbuf;
    if (fstat(XbWVDb_DbkFile,&statbuf)<0){
      printf("could not fstat() active database file.\n");
      exit(1);
      };
    munmap((caddr_t)XbWVDb_DbkStrtMem,statbuf.st_size);
    close(XbWVDb_DbkFile);
    };
 
  XbWVWd_Activ=0;
  XbWSGr_Close();
  puts("");
  exit(0);
  };
/*}}}  */

/*{{{  XbWFTb_StrExpand(   ***    Wie C: sprintf(..)*/
int  XbWFTb_StrExpand(void  *(*p)[]){
  char sstr[200];
  if ((int)((*p)[0]) < 2) {
    return(1);
    };
  switch( (int)((*p)[0])) {
    case  3: sprintf(sstr,(char*)(*p)[2], (char*)(*p)[3]); break;
    case  4: sprintf(sstr,(char*) (*p)[2], (char*) (*p)[3],
                (char*)(*p)[4]); break;
    case  5: sprintf(sstr,(char*) (*p)[2], (char*) (*p)[3],
                (char*)(*p)[4], (char*)(*p)[5]); break;
    case  6: sprintf(sstr,(char*) (*p)[2], (char*) (*p)[3],
                (char*)(*p)[4], (char*)(*p)[5], (char*)(*p)[6]); break;
    case  7: sprintf(sstr,(char*) (*p)[2], (char*) (*p)[3],
                (char*)(*p)[4], (char*)(*p)[5],
                (char*)(*p)[6], (char*)(*p)[7]); break;
    default:return(1);
    };
  strcpy( (char*)(*p)[1],(char*)XbWFTb_PckTxt(sstr));
  return(0);
  };
/*}}}  */
/*{{{  XbWFTb_NumVal(      ***    Wie C: a=b*/
int  XbWFTb_NumVal(void  *(*p)[], int (*t)[]){
  #define SIV_a  ((int )(*p)[0])  /* Anz. Argumente             */
  #define SIV_z  ((void *)(*p)[1])  /* Ziel-Pointer (auf Integer) */
  #define SIV_o  ((char *)(*p)[2])  /* Operation (character)      */
  #define SIV_q  ((void *)(*p)[3])  /* Quelle (Integer)           */
  #define SIV_mi ((int )(*p)[4])  /* Minimum (Integer)          */
  #define SIV_ma ((int )(*p)[5])  /* Maximum (Integer)          */

  char *oper;
  XbWDDb_DbIVar  *QQ; XbWDDb_DbIVar  *ZZ; XbWDDb_DbIVar  *MV;
  double qv,zv,mv=0;
 
  if (SIV_a < 3) {return(1);};
  if (SIV_z == NULL) {return(1);};

  if ((int)(*t)[1] != XbWDMf_VLPar) { return(1); };

  ZZ = (XbWDDb_DbIVar  *)SIV_z;
  zv = XbWFDb_GetNum(ZZ,NULL,1);

  switch ((int)(*t)[3]) {
    case XbWDMf_IntPar:
      qv = (double) (int)(*p)[3];
      break;

    case XbWDMf_DblPar:
      qv = atof((char*)(*p)[3]);
      break;

    case XbWDMf_VLPar:
      if (SIV_q == NULL) {return(1);};
      QQ = (XbWDDb_DbIVar  *)SIV_q;
      qv = XbWFDb_GetNum(QQ,NULL,1);
      break;
    default:
      return(1);
    };


  oper = SIV_o;
  switch (oper[0]) {
    case '=':  XbWFDb_PutNum(ZZ,NULL,1,qv);    break;
    case '+':  XbWFDb_PutNum(ZZ,NULL,1,zv+qv); break;
    case '-':  XbWFDb_PutNum(ZZ,NULL,1,zv-qv); break;
    case '*':  XbWFDb_PutNum(ZZ,NULL,1,zv*qv); break;
    case '/':  if (qv != 0) {
                 XbWFDb_PutNum(ZZ,NULL,1,zv/qv);
                 }
               else {
                 XbWFDb_PutNum(ZZ,NULL,1,9.9E99);
                 };
               break;
    case '&':  XbWFDb_PutNum(ZZ,NULL,1,(double)((int)zv & ((int)qv)));    break;
    case '|':  XbWFDb_PutNum(ZZ,NULL,1,(double)((int)zv & ((int)qv)));    break;
    default :  return(1);
    };

  if (SIV_a >= 4) {
    zv = XbWFDb_GetNum(ZZ,NULL,1);
    switch ((int)(*t)[4]) {
      case XbWDMf_IntPar:
        mv = (double) (int)(*p)[4];
        break;

      case XbWDMf_DblPar:
        mv = atof((char*)(*p)[4]);
        break;

      case XbWDMf_VLPar:
        MV = (XbWDDb_DbIVar  *)SIV_mi;
        if (MV == NULL) { return(1); };
        mv = XbWFDb_GetNum(MV,NULL,1);
        break;
      };

    if ( zv < mv) { XbWFDb_PutNum(ZZ,NULL,1,mv); };
    };
  if (SIV_a >= 5) {
    zv = XbWFDb_GetNum(ZZ,NULL,1);
    switch ((int)(*t)[5]) {
      case XbWDMf_IntPar:
        mv = (double) (int)(*p)[5];
        break;

      case XbWDMf_DblPar:
        mv = atof((char*)(*p)[5]);
        break;

      case XbWDMf_VLPar:
        MV = (XbWDDb_DbIVar  *)SIV_ma;
        if (MV == NULL) { return(1); };
        mv = XbWFDb_GetNum(MV,NULL,1);
        break;
      };
    if ( zv > mv) { XbWFDb_PutNum(ZZ,NULL,1,mv); };
    };
  return(0);
  };
/*}}}  */
