%{
/*{{{  */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "xbw.h"
#include "xbwtype.h"
/*{{{F xbw.h*/
/*:::F xbw.h*/
/*}}}  */

/*{{{F xbwtype.h*/
/*:::F xbwtype.h*/
/*}}}  */

#define XbWFSy_bf1_printf(a) XbWFSy_bf_printf("%s",a)

int yyerror(char*s);

char scratch[scratchmax][200];
int scratchno=0;
int IFTHEN_val = 1;

int errcnt=0;

void *(fpar)[100];
double (fpard)[100];
int (fpart)[100];
int fpar_count=0;
char func_lastname[100]="!!Uninitialized!!";

#define MAX_mac_lvl 100
#define MAX_fpar     100

void *(macpar)[MAX_mac_lvl][MAX_fpar];
int (macpar_type)[MAX_mac_lvl][MAX_fpar];
int macparlvl=1;
int macpar_count=0;

void fpar_add(
                 int type,
                 char *txt,
                 double dval,
                 int ival,
                 XbWDDb_DbIVar *ptr);
double fpar_call(char *name);
int macpar_call(char *name);
 
/*}}}  */
 
%}
%union { XbWDDb_DbIVar *ptr; char *strp; double val; symrec *tptr; };

%token <val>   ENDFILE
%token <val>   IF
%token <val>   THEN
%type  <strp>  strexp
%token <strp>  NULLPTR
%token <strp>  NPTR
%token <strp>  SPTR
%token <strp>  IPTR
%token <strp>  DPTR
%token <strp>  STR
%token <val>   NUM
%token <tptr>  STRVAR NUMVAR
%type  <val>   funcresult
%type  <val>   numexp
%type  <ptr>   sptrexp
%type  <ptr>   nptrexp
%type  <ptr>   iptrexp
%left  LOPRE
%right '?'
%right '='
%left  '>' '<'
%left  '!'
%left  '-' '+'
%left  '*' '/'
%left  ','
%left  ')'
%right  '('
%left  ']'
%right  '['
%right  '.'
%right  ':'
%left   ';'
%right  '@'
%left  NEG
%left  HIPRE
 
%%
 
 
input:     /* empty */
         | input statement
         ;
statement:
           ';'
         | iptrexp '+' '=' numexp '[' numexp ']' ';' %prec HIPRE {
           /*{{{  */
           {
           XbWDDb_DbIVar  *TT=$1;
           if ((TT = (XbWDDb_DbIVar*)XbWFDb_VarInh(TT,0,NULL,0)) == NULL) {
             XbWFSy_bf1_printf("\nERROR: Integer VAR Element not found!");
             errcnt=errcnt+1;
             }
           else {
             switch (TT->tp & XbWDDb_Typ){
               case XbWDDb_Int: {
                                  XbWDDb_DbIInt  *TTRG = (XbWDDb_DbIInt *)TT;
                                  TTRG->inh+= $4;
                                  if (TTRG->inh > $6){
                                    TTRG->inh = $6;
                                    };
                                  };
                                break;
               case XbWDDb_Dbl: {
                                  XbWDDb_DbIDbl  *TTRG = (XbWDDb_DbIDbl *)TT;
                                  TTRG->inh+= $4;
                                  if (TTRG->inh > $6){
                                    TTRG->inh = $6;
                                    };
                                  };
                                break;
               default:
                                XbWFSy_bf1_printf("\nERROR: Target is no (int/dbl) VAR Element!");
                                errcnt=errcnt+1;
               };
             };
           };
           /*}}}  */
           }
         | iptrexp '-' '=' numexp '[' numexp ']' ';' %prec HIPRE {
           /*{{{  */
           {
           XbWDDb_DbIVar  *TT=$1;
           if ((TT = (XbWDDb_DbIVar*)XbWFDb_VarInh(TT,0,NULL,0)) == NULL) {
             XbWFSy_bf1_printf("\nERROR: Integer VAR Element not found!");
             errcnt=errcnt+1;
             }
           else {
             switch (TT->tp & XbWDDb_Typ){
               case XbWDDb_Int: {
                                  XbWDDb_DbIInt  *TTRG = (XbWDDb_DbIInt *)TT;
                                  TTRG->inh -= $4;
                                  if (TTRG->inh < $6){
                                    TTRG->inh = $6;
                                    };
                                  };
                                break;
               case XbWDDb_Dbl: {
                                  XbWDDb_DbIDbl  *TTRG = (XbWDDb_DbIDbl *)TT;
                                  TTRG->inh -= $4;
                                  if (TTRG->inh < $6){
                                    TTRG->inh = $6;
                                    };
                                  };
                                break;
               default:
                                XbWFSy_bf1_printf("\nERROR: Target is no (int/dbl) VAR Element!");
                                errcnt=errcnt+1;
               };
             };
           };
           /*}}}  */
           }
         | ENDFILE                    { fpar_call("End");                  }
         | NUMVAR ':' '=' numexp ';'  { $1->value.var = $4;                }
         | NUMVAR '+' '=' numexp ';'  { $1->value.var += $4;               }
         | STRVAR ':' '=' strexp ';'  { strcpy($1->value.strp,$4);         }
         | STRVAR '+' '=' numexp ';'  {
           char sstr[100];
           sprintf(sstr,"%d",(int)$4);
           strcat($1->value.strp,sstr);
           }
         | funcresult ';'             { ; }
         | STR '('  ')' ';' %prec HIPRE  { fpar_call($1); }
         | ':' funcpar ')' ';'        { fpar_call(func_lastname); }
         | '?' funcresult ';' %prec HIPRE {
           printf("\nResult= %17.7f",$2);
           }
         | '?' numexp ';'             { printf("\nNUM =%15.9f",$2);}
         | '?' strexp ';'             { printf("\nSTR =%s",$2);}
 
         | IF '(' numexp ')'          { IFTHEN_val = (int)$3;              }
 
         | '@' STR '(' funcpar ')' ';' %prec HIPRE { macpar_call($2); }
         | '@' STR '(' ')' ';'   %prec HIPRE      { macpar_call($2); }
 
         | nptrexp ':' '=' nptrexp ';' {
           /*{{{  */
           {
           XbWDDb_DbIVar  *TT=$1;
           if ((TT = (XbWDDb_DbIVar*)XbWFDb_VarInh(TT,0,NULL,0)) == NULL) {
             XbWFSy_bf1_printf("\nERROR: Pointer VAR Element not found!");
             errcnt=errcnt+1;
             }
           else {
             if ( (TT->tp & XbWDDb_Typ) == XbWDDb_NPtr){
               XbWDDb_DbINPtr  *TTRG = (XbWDDb_DbINPtr *)TT;
               TTRG->inh = XbWDDb_C_PtrToDbI((char*)$4,XbWDDb_DbISys);
               }
             else {
               XbWFSy_bf1_printf("\nERROR: Target is no (ptr) VAR Element!");
               errcnt=errcnt+1;
               };
             };
           };
           /*}}}  */
           }
         | sptrexp ':' '=' '(' sptrexp ')' ';' %prec HIPRE {
           /*{{{  */
           {
             XbWDDb_DbIStr  *TT = (XbWDDb_DbIStr *)$1;
             XbWDDb_DbIStr  *TS = (XbWDDb_DbIStr *)$5;
             if ((TT = (XbWDDb_DbIStr*)XbWFDb_VarInh((XbWDDb_DbIVar*)TT,0,NULL,0)) == NULL) {
               XbWFSy_bf1_printf("\nERROR: String VAR Element not found!");
               errcnt=errcnt+1;
               }
             else {
               if ( (TT->tp & XbWDDb_Typ) == XbWDDb_Str){
                 if ((TS = (XbWDDb_DbIStr*)XbWFDb_VarInh((XbWDDb_DbIVar*)TS,0,NULL,0)) == NULL) {
                   XbWFSy_bf1_printf("\nERROR: String VAR Element not found!");
                   errcnt=errcnt+1;
                   }
                 else {
                   char *pps, *ppt;
                   pps = (char *)&(TS->nmi[(TS->tp & XbWDDb_NLen)]);
                   ppt = (char *)&(TT->nmi[(TT->tp & XbWDDb_NLen)]);
                   strncpy(ppt,pps,TT->len);
                   }
                 }
               else {
                 XbWFSy_bf1_printf("\nERROR: target of pointer is no string!");
                 errcnt++;
                 };
               };
             };
           /*}}}  */
           }
         | sptrexp ':' '=' strexp ';' {
           /*{{{  */
           {
           XbWDDb_DbIStr  *TS=(XbWDDb_DbIStr *)$1;
           if ( (TS->tp & XbWDDb_Typ) == XbWDDb_Str){
             int len;
             len = strlen($4);
             if (len < TS->len * 2) {
               strcpy((char*)&(TS->nmi[(TS->tp & XbWDDb_NLen)]),$4);
               }
             else {
               XbWFSy_bf1_printf("\nERROR: Cannot set string because not enough space!");
               errcnt=errcnt+1;
               };
             }
           else {
             XbWFSy_bf1_printf("\nERROR: Target is no (str) VAR Element!");
             errcnt=errcnt+1;
             };
           };
           /*}}}  */
           }
         | iptrexp ':' '=' numexp ';' {
           /*{{{  */
           {
           XbWDDb_DbIVar  *TT=$1;
           if ((TT = (XbWDDb_DbIVar*)XbWFDb_VarInh(TT,0,NULL,0)) == NULL) {
             XbWFSy_bf1_printf("\nERROR: Integer VAR Element not found!");
             errcnt=errcnt+1;
             }
           else {
             switch (TT->tp & XbWDDb_Typ){
               case XbWDDb_Int: {
                                  XbWDDb_DbIInt  *TTRG = (XbWDDb_DbIInt *)TT;
                                  TTRG->inh = $4;
                                  };
                                break;
               case XbWDDb_Dbl: {
                                  XbWDDb_DbIDbl  *TTRG = (XbWDDb_DbIDbl *)TT;
                                  TTRG->inh = $4;
                                  };
                                break;
               default:
                                XbWFSy_bf1_printf("\nERROR: Target is no (int/dbl) VAR Element!");
                                errcnt=errcnt+1;
               };
             };
           };
           /*}}}  */
           }
         | iptrexp '+' '=' numexp ';' {
           /*{{{  */
           {
           XbWDDb_DbIVar  *TT=$1;
           if ((TT = (XbWDDb_DbIVar*)XbWFDb_VarInh(TT,0,NULL,0)) == NULL) {
             XbWFSy_bf1_printf("\nERROR: Integer VAR Element not found!");
             errcnt=errcnt+1;
             }
           else {
             switch (TT->tp & XbWDDb_Typ){
               case XbWDDb_Int: {
                                  XbWDDb_DbIInt  *TTRG = (XbWDDb_DbIInt *)TT;
                                  TTRG->inh+= $4;
                                  };
                                break;
               case XbWDDb_Dbl: {
                                  XbWDDb_DbIDbl  *TTRG = (XbWDDb_DbIDbl *)TT;
                                  TTRG->inh+= $4;
                                  };
                                break;
               default:
                                XbWFSy_bf1_printf("\nERROR: Target is no (int/dbl) VAR Element!");
                                errcnt=errcnt+1;
               };
             };
           };
           /*}}}  */
           }
         | iptrexp '-' '=' numexp ';' {
           /*{{{  */
           {
           XbWDDb_DbIVar  *TT=$1;
           if ((TT = (XbWDDb_DbIVar*)XbWFDb_VarInh(TT,0,NULL,0)) == NULL) {
             XbWFSy_bf1_printf("\nERROR: Integer VAR Element not found!");
             errcnt=errcnt+1;
             }
           else {
             switch (TT->tp & XbWDDb_Typ){
               case XbWDDb_Int: {
                                  XbWDDb_DbIInt  *TTRG = (XbWDDb_DbIInt *)TT;
                                  TTRG->inh -= $4;
                                  };
                                break;
               case XbWDDb_Dbl: {
                                  XbWDDb_DbIDbl  *TTRG = (XbWDDb_DbIDbl *)TT;
                                  TTRG->inh -= $4;
                                  };
                                break;
               default:
                                XbWFSy_bf1_printf("\nERROR: Target is no (int/dbl) VAR Element!");
                                errcnt=errcnt+1;
               };
             };
           };
           /*}}}  */
           }
         |  error ';' { yyerrok; }
;
funcresult: STR '(' funcpar ')' %prec HIPRE   { $$=fpar_call($1); }
funcpar:
         funcpar strexp  %prec LOPRE { fpar_add(1,$2,0,0,NULL);      }
         | funcpar numexp  %prec LOPRE { fpar_add(2,0,$2,0,NULL);      }
         | funcpar nptrexp %prec LOPRE { fpar_add(10,0,0,0,$2);        }
         | strexp  %prec LOPRE { fpar_add(1,$1,0,0,NULL);      }
         | numexp  %prec LOPRE { fpar_add(2,0,$1,0,NULL);      }
         | nptrexp %prec LOPRE { fpar_add(10,0,0,0,$1);        }
;
nptrexp:   NPTR ':' strexp '.' strexp {
           $$ = (XbWDDb_DbIVar *)XbWFDb_GetDbI($1,$3,$5);
           }
         | NULLPTR {
           /*{{{  */
           (XbWDDb_DbIPtr *)$$ = (XbWDDb_DbIVar *)NULL;
           /*}}}  */
           }
;
sptrexp:   SPTR ':' strexp '.' strexp %prec HIPRE {
           $$ = (XbWDDb_DbIVar *)XbWFDb_GetDbI($1,$3,$5);
           }
;
iptrexp:   IPTR ':' strexp '.' strexp %prec HIPRE {
           $$ = (XbWDDb_DbIVar *)XbWFDb_GetDbI($1,$3,$5);
           }
         | DPTR ':' strexp '.' strexp %prec HIPRE {
           $$ = (XbWDDb_DbIVar *)XbWFDb_GetDbI($1,$3,$5);
           }
;
strexp:    strexp '[' NUM ']' {
           char sstr[1000];
           sprintf(sstr,"%s[%d]",$1,(int)$3);
           $$=sstr;
           }
         | STR %prec LOPRE {
           $$=$1;
           }
         | STRVAR {
           $$ = $1->value.strp;
           }
         | strexp ',' strexp %prec HIPRE {
           /*{{{  */
           strcpy((char*)&scratch[scratchno][0],$1);
           strcat((char*)&scratch[scratchno][0],$3);
           $$=(char*)&scratch[scratchno][0];
           scratchno++;
           if (scratchno>=scratchmax){
             scratchno=0;
             };
           /*}}}  */
           }
         | strexp ',' numexp %prec HIPRE {
           /*{{{  */
           strcpy((char*)&scratch[scratchno][0],$1);
           { char sstr[100];
             sprintf(sstr,"%d",(int)$3);
             strcat((char*)&scratch[scratchno][0],sstr);
             }
           $$=(char*)&scratch[scratchno][0];
           scratchno++;
           if (scratchno>=scratchmax){
             scratchno=0;
             };
           /*}}}  */
           }
         | '(' sptrexp ')' %prec LOPRE {
            /*{{{  */
            {
              XbWDDb_DbIStr  *TT = (XbWDDb_DbIStr *)$2;
              if ((TT = (XbWDDb_DbIStr*)XbWFDb_VarInh((XbWDDb_DbIVar*)TT,0,NULL,0)) == NULL) {
                XbWFSy_bf1_printf("\nERROR: String VAR Element not found!");
                errcnt=errcnt+1;
                }
              else {
                if ( (TT->tp & XbWDDb_Typ) == XbWDDb_Str){
                  $$ = (char *)&(TT->nmi[(TT->tp & XbWDDb_NLen)]);
                  }
                else {
                  XbWFSy_bf1_printf("\nERROR: target of pointer is no string!");
                  errcnt++;
                  };
                };
              };
            /*}}}  */
            }
       /*   | '[' strexp ']' %prec LOPRE {
        *   $$=$2;
        *   }
        */
;
numexp:    NUM                        { $$ = $1;                           }
         | '(' NUMVAR ')'             { $$ = $2->value.var;                }
         | '(' numexp ')'             { $$ = $2;                           }
         | '-' numexp  %prec      NEG { $$ = -$2;                          }
         | numexp '=' '=' numexp      { $$ = ($1 == $4);                   }
         | numexp '!' '=' numexp      { $$ = ($1 != $4);                   }
         | numexp '>' '=' numexp      { $$ = ($1 >= $4);                   }
         | numexp '>' numexp          { $$ = ($1 >  $3);                   }
         | numexp '<' '=' numexp      { $$ = ($1 <= $4);                   }
         | numexp '<' '>' numexp      { $$ = ($1 != $4);                   }
         | numexp '<' numexp          { $$ = ($1 <  $3);                   }
         | numexp '+' numexp          { $$ = $1+$3;                        }
         | numexp '-' numexp          { $$ = $1-$3;                        }
         | numexp '/' numexp          { $$ = $1/$3;                        }
         | numexp '*' numexp          { $$ = $1*$3;                        }
 
         | strexp '>' '=' strexp      { $$ = (strcmp($1,$4) >= 0);         }
         | strexp '>' strexp          { $$ = (strcmp($1,$3) >  0);         }
         | strexp '<' '=' strexp      { $$ = (strcmp($1,$4) <= 0);         }
         | strexp '<' strexp          { $$ = (strcmp($1,$3) <  0);         }
         | strexp '=' '=' strexp      { $$ = (strcmp($1,$4) == 0);         }
         | strexp '!' '=' strexp      { $$ = (strcmp($1,$4) != 0);         }
         | funcresult      %prec LOPRE  { $$ = $1 ; };
         | iptrexp                    {
           /*{{{  */
           {
           XbWDDb_DbIVar  *TT= $1;
           if ((TT = (XbWDDb_DbIVar*)XbWFDb_VarInh(TT,0,NULL,0)) == NULL) {
             XbWFSy_bf1_printf("\nERROR: Integer VAR Element not found!");
             errcnt=errcnt+1;
             }
           else {
             switch (TT->tp & XbWDDb_Typ){
               case XbWDDb_Int: {
                                  XbWDDb_DbIInt  *TTRG = (XbWDDb_DbIInt *)TT;
                                  $$ = (double)TTRG->inh;
                                  };
                                break;
               case XbWDDb_Dbl: {
                                  XbWDDb_DbIDbl  *TTRG = (XbWDDb_DbIDbl *)TT;
                                  $$ = TTRG->inh;
                                  };
                                break;
               default:
                                XbWFSy_bf1_printf("\nERROR: Source of ptr is no numeric VAR Element!");
                                errcnt=errcnt+1;
               };
             };
           };
           /*}}}  */
           }
;
%%

symrec *sym_table = (symrec *)0;
 
symrec *putsym(char *sym_name, int sym_type){
  /*{{{  */
  symrec *ptr;
  ptr=(symrec*)malloc(sizeof(symrec));
  ptr->malloc_used=0;
  ptr->name=(char*)malloc(strlen(sym_name)+1);
  strcpy(ptr->name,sym_name);
  ptr->type=sym_type;
  ptr->value.strp = 0;
  ptr->value.var = 0;
  ptr->value.ivar = 0;
  ptr->next=(struct symrec *)sym_table;
  sym_table=ptr;
  return ptr;
  };
  /*}}}  */
symrec *getsym(char *sym_name){
  /*{{{  */
  symrec *ptr;
  for (ptr=sym_table;ptr!= (symrec *)0; ptr=(symrec *)ptr->next){
    if (strcmp(ptr->name,sym_name)==0){
      return(ptr);
      };
    };
  
  return(NULL);
  };
  /*}}}  */
 
int put_lval_end_command(void){
  /*{{{  */
  return(ENDFILE);
  };
  
  /*}}}  */
int put_lval_double(double dd){
  /*{{{  */
  yylval.val = dd;
  return(NUM);
  };
  
  /*}}}  */
int put_lval_string(char *str){
  /*{{{  */
  strcpy((char*)&scratch[scratchno][0],str);
  yylval.strp=(char*)&scratch[scratchno][0];
  scratchno++;
  if (scratchno>=scratchmax){
    scratchno=0;
    };
  return(STR);
  };
  
  /*}}}  */
int put_lval_numvar(char *varname){
   /*{{{  */
   symrec *s = getsym(varname);
   if (s==0){
     s=putsym(varname,NUMVAR);
     s->malloc_used=0;
     };
   yylval.tptr = s;
   return(s->type);
   };
   
   /*}}}  */
int put_lval_nullptr(void){
   /*{{{  */
   return(NULLPTR);
   };
   
   /*}}}  */
int put_lval_strvar(char *varname){
  /*{{{  */
  symrec *s = getsym(varname);
  if (s==0){
    s=putsym(varname,STRVAR);
    s->malloc_used=1;
    s->value.strp = (char*)malloc(200);
    };
  yylval.tptr = s;
  return(s->type);
  };
  
  /*}}}  */
int put_lval_pointer(char type, char *str){
  /*{{{  */
  strcpy((char*)&scratch[scratchno][0],str);
  yylval.strp=(char*)&scratch[scratchno][0];
  scratchno++;
  if (scratchno>=scratchmax){
    scratchno=0;
    };
  switch(type){
    case 'p': /*ptr*/  return(NPTR);
    case 's': /*str*/  return(SPTR);
    case 'i': /*int*/  return(IPTR);
    case 'd': /*dbl*/  return(DPTR);
    default: XbWFSy_bf1_printf("\nERROR: illegal pointer type");
             return(STR);
             break;
    };
  };
  
  /*}}}  */
int put_lval_num_macropar(int no){
   /*{{{  */
   yylval.val = (double)((int)macpar[macparlvl-1][no]);
   return(NUM);
   };
   
   /*}}}  */
int put_lval_str_macropar(int no){
   /*{{{  */
   yylval.strp = (char *)macpar[macparlvl-1][no];
   return(STR);
   };
   
   /*}}}  */
int put_lval_var(char *varname){
  /*{{{  */
  symrec *s = getsym(varname);
  if (s==0){
    s=putsym(varname,NUMVAR);
    s->malloc_used=0;
    };
  yylval.tptr = s;
  return(s->type);
  return(0);
  };
  
  /*}}}  */
int put_lval_isvar(char *varname){
  /*{{{  */
  symrec *s = getsym(varname);
  if (s==0){
    return(0);
    };
  printf("found symbol <%s>\n",varname);
  return(1);
  };
  
  /*}}}  */
int put_lval_if(void){
  /*{{{  */
  return(IF);
  };
  
  /*}}}  */
int put_lval_then(void){
  /*{{{  */
  return(THEN);
  };
  
  /*}}}  */
int yyerror(char*s){
  XbWFSy_bf_printf("\nERROR in statement after %s:\n",func_lastname);
  printf(s);
  errcnt++;
  return(0);
  };
 
char *fltoa(double dd){
  static char sstr[100];
  sprintf(sstr,"%d",(int)dd);
  return(sstr);
  };
 
void fpar_add(
  /*{{{  */
                   int type,
                   char *txt,
                   double dval,
                   int ival,
                   XbWDDb_DbIVar *ptr){
  fpar_count++;
  switch (type){
    case 1: fpar[fpar_count]= (void*)txt;
            fpart[fpar_count]= XbWDMf_StrPar;
            break;
    case 2: fpar[fpar_count]= (void*)((int)dval);
            fpard[fpar_count]= dval;
            fpart[fpar_count]= XbWDMf_IntPar;
            break;
    case 3: fpar[fpar_count]= (void*)((int)ival);
            fpard[fpar_count]= ival;
            fpart[fpar_count]= XbWDMf_IntPar;
            break;
    case 10: fpar[fpar_count]= (void*)(ptr);
            fpart[fpar_count]= XbWDMf_VLPar;
            break;
    case 11:{
              /*{{{  */
              XbWDDb_DbIVar  *ac_gp = ptr;
              char *dd;
              if ((ac_gp = (XbWDDb_DbIVar*)XbWFDb_VarInh(ac_gp,0,NULL,1)) == NULL) {
                XbWFSy_bf1_printf("\nERROR: cannot get pointer parameter!");
                errcnt = errcnt+1;
                return;
                };
              switch( ac_gp->tp & XbWDDb_Typ) {
                case XbWDDb_Str:  dd = (char*)&(((XbWDDb_DbIStr  *)ac_gp)->nmi[ac_gp->tp & XbWDDb_NLen]); break;
                default:
                  XbWFSy_bf1_printf("\nERROR: cannot get pointer parameter!");
                  errcnt = errcnt+1;
                  return;
                };
              fpar[fpar_count]= (void*)(dd);
              fpart[fpar_count]= XbWDMf_VIPar;
              printf("\npar. %d ((str)*) = %d",fpar_count,(int)ptr);
              };
              /*}}}  */
    case 12:{
              /*{{{  */
              XbWDDb_DbIVar  *ac_gp = ptr;
              int dd;
              if ((ac_gp = (XbWDDb_DbIVar*)XbWFDb_VarInh(ac_gp,0,NULL,1)) == NULL) {
                XbWFSy_bf1_printf("\nERROR: cannot get pointer parameter!");
                errcnt = errcnt+1;
                return;
                };
              switch( ac_gp->tp & XbWDDb_Typ) {
                case XbWDDb_Int:  dd = ((XbWDDb_DbIInt  *)ac_gp)->inh; break;
                default:
                  XbWFSy_bf1_printf("\nERROR: cannot get pointer parameter!");
                  errcnt = errcnt+1;
                  return;
                };
              fpar[fpar_count]= (void*)(dd);
              fpart[fpar_count]= XbWDMf_VPPar;
              printf("\npar. %d ((int)*) = %d",fpar_count,(int)ptr);
              };
              /*}}}  */
            break;
    case 13: fpar[fpar_count]= (void*)(ptr);
            fpart[fpar_count]= XbWDMf_VIPar;
            break;
    };
  };
  /*}}}  */
double fpar_call(char *name){
  /*{{{  */
  double result=0;
  fpar[0]=(void*)fpar_count;
  fpart[0]=XbWDMf_AnzPar;
  if (name[1]==0){
    switch(name[0]){
      case 'h':
        printf("\n");
        XbWFSy_bf_printf("%s","XbW Commands:");
        printf("\n");
        fpar[0]=(void*)-1;
        fpar[1]=(void*)"s";     XbWFDb_AppStr(&fpar,&fpart);
        fpar[1]=(void*)"i";     XbWFDb_AppInt(&fpar,&fpart);
        fpar[1]=(void*)"c";     XbWFDb_AppCSt(&fpar,&fpart);
        fpar[1]=(void*)"d";     XbWFDb_AppDblVal(&fpar,0);
        printf("\n");
        printf("\n");
        printf("\n");
        break;
  
      case 's': result = XbWFDb_AppStr(&fpar,&fpart); break;
      case 'i': result = XbWFDb_AppInt(&fpar,&fpart); break;
      case 'c': result = XbWFDb_AppCSt(&fpar,&fpart); break;
      case 'o': result = XbWFDb_AppObj(&fpar,&fpart); break;
      case 'd': result = XbWFDb_AppDblVal(&fpar,fpard[2]); break;
      case 'x': result = XbWFMf_StrtHookCmd(&fpar,&fpart); break;
      default: goto errleave;
      };
    goto leave;
    }
  else {
    if (strcmp(name,"bg")==0){
      if (fpart[3] == XbWDMf_IntPar){
        /*{{{  */
        if ( (double)((int)fpar[3]) == (double)fpard[3]){
          result = XbWFDb_AppBg(&fpar,&fpart);
          }
        else {
          char sstr[100];
          sprintf(sstr,"%40.20f",fpard[3]);
          fpart[3]= XbWDMf_DblPar;
          fpar[3]=&sstr;
          result = XbWFDb_AppBg(&fpar,&fpart);
          };
        /*}}}  */
        }
      else {
        result = XbWFDb_AppBg(&fpar,&fpart);
        };
      goto leave; };
    if (strcmp(name,"cn")==0){ result = XbWFDb_AppChn(&fpar,&fpart); goto leave; };
    if (strcmp(name,"eg")==0){ result = XbWFDb_AppGPtr(&fpar,&fpart); goto leave; };
    if (strcmp(name,"pn")==0){ result = XbWFDb_AppNPtr(&fpar,&fpart); goto leave; };
    if (strcmp(name,"tk")==0){ result = XbWFDb_AppTsk(&fpar,&fpart); goto leave; };
    if (strcmp(name,"ff")==0){ result = XbWFDb_AppFloat(&fpar,&fpart); goto leave; };
    if (strcmp(name,"lt")==0){ result = XbWFDb_AppLight(&fpar,&fpart); goto leave; };
    if (strcmp(name,"ng")==0){ result = XbWFDb_NewGrp(&fpar,&fpart); goto leave; };
    if (strcmp(name,"wdw")==0){ result = XbWFDb_AppWdw(&fpar,&fpart); goto leave; };
    if (strcmp(name,"End")==0){
      end_include();
      yyclearin;
      macparlvl--;
      if (macparlvl < 1){
        macparlvl = 1;
        };
      goto leave;
      };
  
    if (strcmp(name,"sin")==0){         result = sin(fpard[1]); goto leave; };
    if (strcmp(name,"cos")==0){         result = cos(fpard[1]); goto leave; };
    if (strcmp(name,"atan")==0){        result = atan(fpard[1]); goto leave; };
    if (strcmp(name,"log")==0){         result = log(fpard[1]); goto leave; };
    if (strcmp(name,"exp")==0){         result = exp(fpard[1]); goto leave; };
    if (strcmp(name,"sqrt")==0){        result = sqrt(fpard[1]); goto leave; };
  
    if (strcmp(name,"Array")==0){       result = XbWFDb_CreateArray(&fpar,&fpart); goto leave; };
  
    if (strcmp(name,"DrawAllWdw")==0){           XbWFWd_DrawAll(); goto leave; };
    if (strcmp(name,"IconAllWdw")==0){           XbWFWd_IconAll(); goto leave; };
    if (strcmp(name,"IconizeWdw")==0){           XbWFWd_Iconize(&fpar); goto leave; };
    if (strcmp(name,"SelectWdw")==0){   result = XbWFWd_Select(&fpar); goto leave; };
    if (strcmp(name,"DrawWdw")==0){              XbWFWd_DrawP(); goto leave; };
  
    if (strcmp(name,"NewProject")==0){  result = XbWFDb_MarkPrj(&fpar,&fpart); goto leave; };
    if (strcmp(name,"NewGroup")==0){    result = XbWFDb_MarlGrp(&fpar); goto leave; };
  
    if (strcmp(name,"Malloc")==0){      result = XbWFDb_CreaSys(&fpar); goto leave; };
    if (strcmp(name,"Exit")==0){                 XbWFSy_SysStop(); goto leave; };
  
    if (strcmp(name,"DumpFile")==0){    result = XbWFDb_DbgSys(&fpar); goto leave; };
    if (strcmp(name,"WriteFile")==0){   result = XbWFDb_WrTable(&fpar,&fpart); goto leave; };
    if (strcmp(name,"ReadFile")==0){    result = XbWFDb_RdTable(&fpar,&fpart); goto leave; };
    if (strcmp(name,"EditFile")==0){    result = XbWFDb_OpenSys(&fpar,&fpart); goto leave; };
  
    if (strcmp(name,"Message")==0){              XbWFTb_PutMessage(&fpar); goto leave; };
    if (strcmp(name,"Alarm")==0){                XbWFTb_PutAlarm(&fpar); goto leave; };
    if (strcmp(name,"Error")==0){                XbWFTb_PutError(&fpar); goto leave; };
    if (strcmp(name,"WaitForButton")==0){        XbWSMs_WButtUpDn(); goto leave; };
    if (strcmp(name,"AnswPReq")==0){    result = XbWFTb_AnswerPopUpReq(&fpar); goto leave; };
    if (strcmp(name,"PopUpBox")==0){             XbWFTb_PopUpBox(&fpar); goto leave; };
    if (strcmp(name,"PopUpMSG")==0){    result = XbWSPu_Msg(&fpar,&fpart); goto leave; };
    if (strcmp(name,"PopUpDIR")==0){    result = XbWSPu_Dir(&fpar,&fpart); goto leave; };
    if (strcmp(name,"PopEditDir")==0){  result = XbWSPu_DirEd(&fpar,&fpart); goto leave; };
  
    if (strcmp(name,"LockWdw")==0){              XbWFWd_LockON(); goto leave; };
    if (strcmp(name,"LockWdwOnClick")==0){       XbWFWd_LockEdit(); goto leave; };
    if (strcmp(name,"UnLockWdw")==0){            XbWFWd_LockOFF(); goto leave; };
  
    if (strcmp(name,"MFXGroup")==0){    result = XbWFMx_RWGroup(&fpar,&fpart); goto leave; };
  
    if (strcmp(name,"EditObj")==0){     result = XbWFOb_EditOnly(&fpar); goto leave; };
    if (strcmp(name,"DispObj")==0){     result = XbWFOb_DispOnly(&fpar); goto leave; };
  
    if (strcmp(name,"ResizeWdw")==0){            XbWSWd_Resize(&fpar); goto leave; };
    if (strcmp(name,"MoveWdw")==0){              XbWSWd_Move(); goto leave; };
    if (strcmp(name,"ClrScr")==0){               XbWFTb_ClrScr(); goto leave; };
    if (strcmp(name,"MoveObjToWdw")==0){result = XbWFOb_MovToWdw(&fpar,&fpart); goto leave; };
    if (strcmp(name,"MouseWarp")==0){   result = XbWFTb_MouseWarp(&fpar,&fpart); goto leave; };
    if (strcmp(name,"XFlush")==0){               XbWFSY_DoXFlush(); goto leave; };
    if (strcmp(name,"RootWindow")==0){  result = XbWSSy_RootWindow(&fpar,&fpart); goto leave; };
    if (strcmp(name,"LoadFont")==0){    result = XbWFDb_LoadFont(&fpar,&fpart); goto leave; };
  
    if (strcmp(name,"PrjName")==0){     result = XbWFDb_PrjName(&fpar,&fpart); goto leave; };
    if (strcmp(name,"PackString")==0){  result = XbWFTb_PackStr(&fpar,&fpart); goto leave; };
    if (strcmp(name,"FFileNames")==0){  result = XbWSOS_FilDir(&fpar); goto leave; };
    if (strcmp(name,"GetWGrp")==0){     result = XbWFDb_StorGrpn(&fpar,&fpart); goto leave; };
    if (strcmp(name,"DebugMfxON")==0){           XbWFMx_DbgON(); goto leave; };
    if (strcmp(name,"DebugMtaON")==0){           XbWFTb_DbgMta(); goto leave; };
    if (strcmp(name,"AutoCloseON")==0){          XbWFTb_AClosON(); goto leave; };
    if (strcmp(name,"AutoCloseOFF")==0){         XbWFTb_AClosOFF(); goto leave; };
    if (strcmp(name,"RedrawON")==0){             XbWFTb_RedrawON(); goto leave; };
    if (strcmp(name,"RedrawOFF")==0){            XbWFTb_RedrawOFF(); goto leave; };
  
    if (strcmp(name,"Unlink")==0){      result = XbWFTb_Unlink(&fpar); goto leave; };
    if (strcmp(name,"Task")==0){        result = XbWSOS_SpwnStd(&fpar,&fpart); goto leave; };
    if (strcmp(name,"ChDir")==0){       result = XbWFSy_ChDir(&fpar,&fpart); goto leave; };
    if (strcmp(name,"LoadObjIcon")==0){ result = XbWSSy_ObjLoadIcon(&fpar,&fpart); goto leave; };
  
    if (strcmp(name,"SelectPrj")==0){  result = XbWFDb_SetProject(&fpar,&fpart); goto leave; };
    if (strcmp(name,"InsertObj")==0){
      result = XbWFDb_InsertObj(&fpar,&fpart); goto leave;
      };
    };
  errleave:;
  XbWFSy_bf_printf("\nERROR: function %s not recognized.",name); errcnt=errcnt+1;
  fpar_count=0;
  return(0);
  leave:;
  strcpy(func_lastname,name);
  fpar_count=0;
  return(result);
  };
  /*}}}  */
int macpar_call(char *name){
  /*{{{  */
  int ii;
  int result=0;
  fpar[0]=(void*)fpar_count;
  fpart[0]=XbWDMf_AnzPar;
  
  for (ii=0;ii<=fpar_count;ii++){
    macpar[macparlvl][ii]=fpar[ii];
    macpar_type[macparlvl][ii]=fpart[ii];
    };
  
  macparlvl++;
  if (macparlvl >= MAX_mac_lvl){
    macparlvl= MAX_mac_lvl;
    };
  
  if (begin_include(name)==0){
    XbWFSy_bf_printf("\nERROR: macro file %s not found;",name);
    };
  yyclearin;
  
  fpar_count=0;
  strcpy(func_lastname,name);
  return(result);
  };
  /*}}}  */

 
void  XbWFMf_ReadMF(char *filename){
  /*{{{  */
  
  extern FILE *yyin;
  
  #ifdef YYDEBUG
  yydebug=0;
  #endif
  errcnt=0;
  if (filename == NULL) {
    yyin = stdin;
    }
  else {
    int ii;
    char sstr[200];
    for (ii=0;ii<strlen(filename);ii++){
      if (filename[ii]=='\\'){ filename[ii]='/'; };
      };
    if (filename[0]=='@'){
      strcpy(filename,(char *)&filename[1]);
      };
    yyin = fopen(filename, "r" );
    if (yyin==NULL){
      sprintf(sstr,"%s.mta",filename);
      yyin = fopen( sstr, "r" );
      if (yyin==NULL){
        sprintf(sstr,"/xw/x/%s.mta",filename);
        yyin = fopen( sstr, "r" );
        if (yyin==NULL){
          sprintf(sstr,"%s.xwx",filename);
          yyin = fopen( sstr, "r" );
          if (yyin==NULL){
            XbWFSy_bf_printf("\nERROR: cannot open file %s !",filename);
            return;
            };
          };
        };
      };
    };
  
  yyparse();
  if (yyin != stdin){
    fclose(yyin);
    };
  if (errcnt){ printf("\nOOPS! There were %d parser errors!",errcnt); }
  else {        XbWFSy_bf1_printf("\nFile syntax okay."); };
  };
  /*}}}  */

int XbWFMf_ParseMakro(char *macro){
  /*{{{  */
  
  #ifdef YYDEBUG
  yydebug=1;
  #endif
  
  errcnt=0;
  
  begin_macro(macro);
  yyparse();
  
  if (errcnt){ printf("\nOOPS! There were %d parser errors!",errcnt); }
  else {        XbWFSy_bf1_printf("\nMacro syntax okay."); };
  
  return(0);
  };
  /*}}}  */
 
void  XbWFMf_StartMF(char *filename){
  /*{{{  */
  
  char buffer[10000];
  
  extern FILE *yyin;
  
  #ifdef YYDEBUG
  yydebug=0;
  #endif
  
  if (filename == NULL) {
    XbWFSy_bf1_printf("\nERROR: could not open file (null)!");
    return;
    }
  else {
    int ii;
    char sstr[200];
    for (ii=0;ii<strlen(filename);ii++){
      if (filename[ii]=='\\'){ filename[ii]='/'; };
      };
    if (filename[0]=='@'){
      strcpy(filename,(char *)&filename[1]);
      };
    yyin = fopen(filename, "r" );
    if (yyin==NULL){
      sprintf(sstr,"%s.mta",filename);
      yyin = fopen( sstr, "r" );
      if (yyin==NULL){
        sprintf(sstr,"/xw/x/%s.mta",filename);
        yyin = fopen( sstr, "r" );
        if (yyin==NULL){
          XbWFSy_bf_printf("\nERROR: cannot open file %s !",filename);
          return;
          };
        };
      };
    };
  
  fread(buffer,1,9999,yyin);
  
  if (strstr(buffer,"Malloc") != NULL){
    fseek(yyin,0,SEEK_SET);
    fread(buffer,1,((char*)strstr(buffer,"Malloc")-1-(char*)buffer),yyin);
    begin_macro(buffer);
    yyparse();
    }
  else {
    XbWFSy_bf1_printf("\nERROR: Malloc(<mem>); needed at start of first file!");
    };
  fclose(yyin);
  };
  /*}}}  */
 
