dnl -*- m4 -*-

AC_DEFUN(AM_PATH_GDKMAGICK,
[
	dnl Test for GdkMagick libraries

	AC_PATH_PROG(GDKMAGICK_CONFIG, gdkmagick-config, not_found)

	if test "$GDKMAGICK_CONFIG" = "not_found"
	then
	  $3
	else
	  GDKMAGICK_LIBS=`$GDKMAGICK_CONFIG --libs | tr '\012' ' '`
	  GDKMAGICK_CFLAGS=`$GDKMAGICK_CONFIG --cflags`
	fi

	AC_CHECK_LIB(gdkmagick, gdk_magick_init,, $3, $GDKMAGICK_LIBS)

	CPPFLAGS="$GDKMAGICK_CFLAGS $CPPFLAGS"
	LDFLAGS="$GDKMAGICK_LIBS $LDFLAGS"

	AC_CHECK_HEADERS(gdk_magick.h,, $3)
	AC_TRY_RUN([
		#include <stdio.h>
		#include <magick/api.h>
		#include <gdk/gdk.h>
		#include <gdk_magick.h>

		int main ()
		{
			if (gdk_magick_check_version ("$1"))
			{
				return 0;
			}
			else
			{
				return 1;
			}
		}
	], $2, $3, AC_MSG_ERROR(Cross-compiling is not yet supported.))
])


