/*
 *  This file is part of the GdkMagick library.
 *  Copyright (C) 1999 Arthur Jerijian
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as
 *  published by the Free Software Foundation; either version 2 of the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; see the file COPYING.LIB.  If not,
 *  write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#ifndef __GDK_MAGICK_H__
#define __GDK_MAGICK_H__

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <magick/api.h>
#include <magick/version.h>
#include <gdk/gdk.h>
#include <gdk/gdkrgb.h>

/* __BEGIN_DECLS should be used at the beginning of your declarations,
   so that C++ compilers don't mangle their names.  Use __END_DECLS at
   the end of C declarations. */
#undef __BEGIN_DECLS
#undef __END_DECLS
#ifdef __cplusplus
# define __BEGIN_DECLS extern "C" {
# define __END_DECLS }
#else
# define __BEGIN_DECLS /* empty */
# define __END_DECLS /* empty */
#endif

/* __P is a macro used to wrap function prototypes, so that compilers
   that don't understand ANSI C prototypes still work, and ANSI C
   compilers can issue warnings about type mismatches. */
#undef __P
#if defined (__STDC__) || defined (_AIX) \
    || (defined (__mips) && defined (_SYSTYPE_SVR4)) \
    || defined(WIN32) || defined(__cplusplus)
# define __P(protos) protos
#else
# define __P(protos) ()
#endif

__BEGIN_DECLS

/*********************************************************************
 *
 * MACROS AND CONSTANTS
 */

/**
   Determine if the GdkMagick library is built against
   ImageMagick 5.0 or greater.

   This macro is defined if GdkMagick is built against
   ImageMagick 5.0 or greater. If GdkMagick is built to use
   ImageMagick 4.2.8 or 4.2.9, this macro is not defined.
**/

#ifdef GDK_MAGICK_IS_MAGICK5
#undef GDK_MAGICK_IS_MAGICK5
#endif /* GDK_MAGICK_IS_MAGICK5 */
#ifdef MAGICK5
#define GDK_MAGICK_IS_MAGICK5 1
#endif /* MAGICK5 */

/*********************************************************************
 *
 * DATA TYPES
 */

typedef struct _GdkMagickColorList
{
    GdkColor color;
    struct _GdkMagickColorList *next;
} GdkMagickColorList;

/*********************************************************************
 *
 * FUNCTIONS
 */

/* Library initialization */

gboolean gdk_magick_init __P ((gint *argc, gchar **argv []));
GdkVisual *gdk_magick_get_visual __P ((void));
GdkColormap *gdk_magick_get_colormap __P ((void));
void gdk_magick_set_dither __P ((gboolean dither));

/* Core image rendering routines */

gboolean gdk_magick_render_to_gdk
__P ((
    GdkDrawable *gdk_drawable,
    GdkGC *gdk_gc,
    Image *image
));
gboolean gdk_magick_render_from_gdk
__P ((
    Image *image,
    GdkImage *gdk_image
));
gboolean gdk_magick_render_from_gdk_monochrome
__P ((
    Image *image,
    GdkImage *gdk_image
));
gboolean gdk_magick_render_to_gdkimage_truecolor
__P ((
    GdkImage *gdk_image,
    Image *image
));

/* Conversion between Image and GdkDrawable */

Image *gdk_magick_from_gdkdrawable __P ((GdkDrawable *gdk_drawable));

/* Conversion between Image and GdkPixmap */

GdkPixmap *gdk_magick_to_gdkpixmap __P ((Image *image));
Image *gdk_magick_from_gdkpixmap __P ((GdkPixmap *gdk_pixmap));

/* Conversion between Image and GdkBitmap */

GdkBitmap *gdk_magick_to_gdkbitmap __P ((Image *image));
Image *gdk_magick_from_gdkbitmap __P ((GdkBitmap *gdk_bitmap));

/* Conversion between Image and GdkImage */

GdkImage *gdk_magick_to_gdkimage __P ((Image *image));
Image *gdk_magick_from_gdkimage __P ((GdkImage *gdk_image));

/* Utility functions */

void gdk_magick_error __P ((gchar *message));
void gdk_magick_warning __P ((gchar *message));
void gdk_magick_assert __P ((gchar *message));

/* Version management functions */

guint32 gdk_magick_get_version __P ((void));
gboolean gdk_magick_check_version __P ((guchar *version_string));
guint32 gdk_magick_string_to_version __P ((guchar *version_string));

__END_DECLS

#endif /* __GDK_MAGICK_H__ */
