/*
 *  This file is part of the GdkMagick library.
 *  Copyright (C) 1999 Arthur Jerijian
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as
 *  published by the Free Software Foundation; either version 2 of the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; see the file COPYING.LIB.  If not,
 *  write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#ifndef __GDK_MAGICK_STRINGS_H__
#define __GDK_MAGICK_STRINGS_H__

/* __BEGIN_DECLS should be used at the beginning of your declarations,
   so that C++ compilers don't mangle their names.  Use __END_DECLS at
   the end of C declarations. */
#undef __BEGIN_DECLS
#undef __END_DECLS
#ifdef __cplusplus
# define __BEGIN_DECLS extern "C" {
# define __END_DECLS }
#else
# define __BEGIN_DECLS /* empty */
# define __END_DECLS /* empty */
#endif

/* __P is a macro used to wrap function prototypes, so that compilers
   that don't understand ANSI C prototypes still work, and ANSI C
   compilers can issue warnings about type mismatches. */
#undef __P
#if defined (__STDC__) || defined (_AIX) \
    || (defined (__mips) && defined (_SYSTYPE_SVR4)) \
    || defined(WIN32) || defined(__cplusplus)
# define __P(protos) protos
#else
# define __P(protos) ()
#endif

__BEGIN_DECLS

/*********************************************************************
 *
 * WARNING MESSAGES
 *
 */

#define GDK_MAGICK_WARNING_INITIALIZED \
    "GdkMagick is already initialized."

/*********************************************************************
 *
 * ERROR MESSAGES
 *
 */

#define GDK_MAGICK_ERROR_MAGICK4 \
    "FATAL -- ImageMagick version is less than 5.0!\n" \
    "Support for ImageMagick 4.2.x is not available in this compiled library."
#define GDK_MAGICK_ERROR_MAGICK5 \
    "FATAL -- ImageMagick version is 5.0 or greater!\n" \
    "Support for ImageMagick 5.0 is not available in this compiled library."
#define GDK_MAGICK_ERROR_VISUAL "Unable to retrieve the GdkRGB visual!"
#define GDK_MAGICK_ERROR_COLORMAP "Unable to retrieve the GdkRGB colormap!"
#define GDK_MAGICK_ERROR_RGB "Unable to transform image to RGB colorspace!"
#define GDK_MAGICK_ERROR_RGBDATA \
    "Unable to allocate memory for RGB buffer data!"
#define GDK_MAGICK_ERROR_BITMAP "Unable to create bitmap!"
#define GDK_MAGICK_ERROR_PIXMAP "Unable to create pixmap!"
#define GDK_MAGICK_ERROR_GDK_IMAGE "Unable to create GDK image!"
#define GDK_MAGICK_ERROR_MAGICK_IMAGE "Unable to create ImageMagick image!"
#define GDK_MAGICK_ERROR_MAGICK_PIXELS \
    "Unable to create pixel data for the ImageMagick image!"
#define GDK_MAGICK_ERROR_GC "Unable to create GC!"

__END_DECLS

#endif /* __GDK_MAGICK_STRINGS_H__ */

