/*
 *  This file is part of the GdkMagick library.
 *  Copyright (C) 1999 Arthur Jerijian
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as
 *  published by the Free Software Foundation; either version 2 of the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; see the file COPYING.LIB.  If not,
 *  write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

/*
 *  gdkmagick_private.c: Functions internal to GdkMagick
 */

#include "config.h"
#include <gdk_magick.h>
#include <gdk_magick_private.h>
#include <gdk_magick_strings.h>

/*********************************************************************/
/* *
   {\bf PRIVATE FUNCTION -- DO NOT USE IN YOUR APPLICATION.}
   
   Print a message to stderr indicating that a GdkMagick function is
   not yet implemented.
  
   @param func function name
   @return None.
 **/

void gdk_magick_stub (gchar *func)
{
    fprintf (stderr, "*** GdkMagick error: %s not implemented.\n", func);
}

/*********************************************************************/
/* *
   {\bf PRIVATE FUNCTION -- DO NOT USE IN YOUR APPLICATION.}

   Create an ImageMagick image structure suitable for GdkMagick
   operations.
     
   @param width image width
   @param height image height
   @return None.
 **/

Image *gdk_magick_new_image (gint width, gint height)
{
    Image *magick_image;
    PixelPacket *pixels;
    gint i;
    
    magick_image = AllocateImage (NULL);
    if (magick_image == NULL)
    {
        gdk_magick_error (GDK_MAGICK_ERROR_MAGICK_IMAGE);
        return NULL;
    }
    
    magick_image -> columns = width;
    magick_image -> rows = height;
    magick_image -> _qlass = DirectClass;
    magick_image -> matte = 0;
    magick_image -> colorspace = RGBColorspace;
    magick_image -> interlace = NoInterlace;
    GDK_MAGICK_SET_IF_NOT_MAGICK5 (magick_image -> packets, width * height);
    
    /* Allocate memory for pixels. */

    if (magick_image -> pixels != NULL)
    {
        FreeMemory (magick_image -> pixels);
    }
    pixels = (PixelPacket *) AllocateMemory
    (
        sizeof (PixelPacket) * width * height
    );    
    if (pixels == NULL)
    {
        gdk_magick_error (GDK_MAGICK_ERROR_MAGICK_PIXELS); 
        if (magick_image != NULL) DestroyImage (magick_image);
        return NULL;
    }

    for (i = 0; i < width * height; i++)
    {
        GDK_MAGICK_SET_PIXEL (pixels [i], 0, 0, 0, 0, 0, 0);
    }
    
    magick_image -> pixels = pixels;

    return magick_image;
}
