/*
 *  This file is part of the GdkMagick library.
 *  Copyright (C) 1999 Arthur Jerijian
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as
 *  published by the Free Software Foundation; either version 2 of the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; see the file COPYING.LIB.  If not,
 *  write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

/*
 *  gdkmagick_util.c: Utility functions
 */

#include "config.h"
#include <gdk_magick.h>
#include <gdk_magick_private.h>
#include <gdk_magick_strings.h>

/*********************************************************************/
/**
   Print a GdkMagick error message to stderr.
  
   @param message message text
   @return None.
 **/

void gdk_magick_error (gchar *message)
{
    fprintf (stderr, "*** GdkMagick ERROR: %s\n", message);
}

/*********************************************************************/
/**
   Print a GdkMagick warning message to stderr.
  
   @param message message text
   @return None.
 **/

void gdk_magick_warning (gchar *message)
{
    fprintf (stderr, "*** GdkMagick WARNING: %s\n", message);
}

/*********************************************************************/
/**
   Print a GdkMagick assertion message to stderr.
  
   @param message message text
   @return None.
 **/

void gdk_magick_assert (gchar *message)
{
    fprintf (stderr, "*** GdkMagick ASSERT: %s\n", message);
}

