/*
 * ?.c: .....
 */

#include "config.h"
#include <gdk_magick.h>
#include <gdk_magick_private.h>
#include <gtk/gtk.h>
#include "gdk_magick_test.h"

static GString *disk_filename = NULL;

gint disk_dialog_delete_event
(
    GtkWidget *widget,
    GdkEvent *event,
    gpointer data
)
{
    gtk_widget_destroy (widget);
    return FALSE;
}

void disk_init ()
{
    disk_filename = g_string_new (NULL);
}

void disk_cleanup ()
{
    g_string_free (disk_filename, TRUE);
}

void disk_load_image_dialog (GtkWidget *widget, gpointer *func)
{
    Image *image;
    GtkWidget *disk_dialog;
    DiskData *disk_data;
    
    disk_dialog = gtk_file_selection_new ("Load image from disk file");
    gtk_window_set_modal (GTK_WINDOW (disk_dialog), TRUE);

    disk_data = g_malloc (sizeof (DiskData));
    disk_data -> file_sel = disk_dialog;
    disk_data -> func = func;
    
    gtk_signal_connect
    (
        GTK_OBJECT (GTK_FILE_SELECTION (disk_dialog) -> ok_button),
        "clicked",
        (GtkSignalFunc) disk_load_image,
        disk_data
    );
    gtk_signal_connect_object
    (
        GTK_OBJECT (GTK_FILE_SELECTION (disk_dialog) -> ok_button),
        "clicked",
        (GtkSignalFunc) disk_dialog_delete_event,
        GTK_OBJECT (disk_dialog)
    );
    gtk_signal_connect
    (
        GTK_OBJECT (GTK_FILE_SELECTION (disk_dialog) -> cancel_button),
        "clicked",
        (GtkSignalFunc) disk_cancel,
        disk_data
    );
    gtk_signal_connect_object
    (
        GTK_OBJECT (GTK_FILE_SELECTION (disk_dialog) -> cancel_button),
        "clicked",
        (GtkSignalFunc) disk_dialog_delete_event,
        GTK_OBJECT (disk_dialog)
    );

    if (disk_filename != NULL)
    {
        gtk_file_selection_set_filename
        (
            GTK_FILE_SELECTION (disk_dialog),
            disk_filename -> str
        );
    }
    gtk_widget_show (disk_dialog);
}

void disk_load_image (GtkWidget *widget, DiskData *disk_data)
{
    gchar *disk_filename_text;
    
    disk_filename_text = gtk_file_selection_get_filename
    (
        GTK_FILE_SELECTION (disk_data -> file_sel)
    );

    g_print ("File name chosen is %s\n", disk_filename_text);

    g_string_assign (disk_filename, disk_filename_text);
    g_free (disk_data);
}

void disk_cancel (GtkWidget *widget, DiskData *disk_data)
{
    g_free (disk_data);
}

