#ifndef __GDK_MAGICK_TEST_H__
#define __GDK_MAGICK_TEST_H__

/**********************************************************************
 *
 * CONSTANTS
 */

#ifndef TRUE
#define TRUE 1
#endif /* TRUE */

#ifndef FALSE
#define FALSE 0
#endif /* FALSE */

#define MAX_FILENAME 1024
#define MAX_LINE 1024
#define MAX_FILETYPE 1024

#define DEFAULT_DITHER TRUE

/**********************************************************************
 *
 * DATA TYPES
 */

/**********************************************************************
 *
 * FUNCTION DECLARATIONS
 */

void temp_func ();

/* sysinfo.c */
GtkWidget *sysinfo_create_page (GtkWidget *window);

/* pixmap.c */
GtkWidget *pixmap_create_page (GtkWidget *window);
void pixmap_button_func (GtkWidget *widget, gchar *button_text);
gint pixmap_load_delete_event
(
    GtkWidget *widget,
    GdkEvent *event,
    gpointer data
);
void pixmap_load_dialog (GtkWidget *widget, gpointer *func);
void pixmap_load (GtkWidget *widget, GtkWidget *disk_dialog);

/* bitmap.c */
GtkWidget *bitmap_create_page (GtkWidget *window);
void bitmap_button_func (GtkWidget *widget, gchar *button_text);

/* image.c */
GtkWidget *image_create_page (GtkWidget *window);
void image_button_func (GtkWidget *widget, gchar *button_text);
gint image_load_delete_event
(
    GtkWidget *widget,
    GdkEvent *event,
    gpointer data
);
void image_load_dialog (GtkWidget *widget, gpointer *func);
void image_load (GtkWidget *widget, GtkWidget *disk_dialog);

/* tomagick.c */
GtkWidget *tomagick_create_page ();

/* window.c */
void test_window_delete_event
(
    GtkWidget *widget,
    GdkEvent *event,
    gpointer data
);
void create_test_window ();
void dither_func (GtkWidget *widget, gpointer data);

/* widgproc.c */
void add_button
(
    GtkWidget *box,
    GtkObject *object,
    GtkSignalFunc button_func,
    const gchar *button_text
);
void add_fill_button
(
    GtkWidget *box,
    GtkObject *object,
    GtkSignalFunc button_func,
    const gchar *button_text
);
void add_checkbox
(
    GtkWidget *box,
    GtkObject *object,
    GtkSignalFunc checkbox_func,
    gint active,
    const gchar *checkbox_text
);
GSList *add_radio
(
    GtkWidget *box,
    GtkObject *object,
    GSList *group,
    GtkSignalFunc radio_func,
    gint active,
    const gchar *radio_text
);
void add_menu_item
(
    GtkWidget *menu,
    GtkSignalFunc menu_item_func,
    const gchar *item_text,
    gpointer data
);
void add_separator (GtkWidget *box);
void add_label (GtkWidget *box, const gchar *label_text);
void add_fill_label (GtkWidget *box, const gchar *label_text);

/* util.c */
void error_dialog (gchar *error_msg);
void debug_print (gchar *debug_msg);

/* genimage.c */
Image *generate_image (guint bpp);
Image *generate_rectangle
(
    guint width,
    guint height,
    guint bg_r,
    guint bg_g,
    guint bg_b
);
Image *generate_rectangle_bpp (guint bpp, guint bg_r, guint bg_g, guint bg_b);

/* main.c */
void print_usage (char *command);
int main (int argc, char *argv[], char *envp []);

#endif /* __GDK_MAGICK_TEST_H__ */
