#include "config.h"
#include <gdk_magick.h>
#include <gdk_magick_private.h>
#include <gtk/gtk.h>
#include "gdk_magick_test.h"

Image *generate_image (guint bpp)
{
    Image *image;
    PixelPacket *pixels;
    guint width_block, height_block, width, height;
    guint x_block, y_block, x, y;
    guint rprec, gprec, bprec;
    guint rmax, gmax, bmax;
    guint rshift, gshift, bshift;
    guint ri, gi, bi;
    guint r, g, b;
    guint i;
    guint index;

    /* Calculate the color parameters and image geometry. */

    /* rprec, gprec, bprec: Number of bits per RGB component */
    rprec = (bpp + 2) / 3;
    gprec = (bpp + 1) / 3;
    bprec = bpp / 3;

    /*
     * rmax, gmax, bmax: Maximum value of each RGB component. The
     * max value also doubles as a bitwise modulo mask.
     */
    rmax = (1 << rprec) - 1;
    gmax = (1 << gprec) - 1;
    bmax = (1 << bprec) - 1;

    /* rshift, gshift, bshift: RGB component shift values */
    rshift = 0;
    gshift = rprec;
    bshift = rprec + gprec;

    /* width_block, height_block: Block dimensions */
    width_block = 1 << (bpp / 2);
    height_block = 1 << (bpp / 2);
    if (((bpp / 2) * 2) != bpp)
    {
        width_block <<= 1;
    }

    /* width, height: Pixel dimensions */
    width = 16 * width_block;
    height = 16 * height_block;

    /* Initialize the image data structures. */
    
    image = gdk_magick_new_image (width, height);
    if (image == NULL)
    {
        /* TODO: Error case */
        return NULL;
    }
    pixels = image -> pixels;
    
    /*
     * Calculate the color values for each pixel and draw the pixels into
     * the image. Unique colors are drawn in 16x16 square blocks.
     */
    
    index = 0;
    for (y_block = 0; y_block < height_block; y_block++)
    {
        for (y = 0; y < 16; y++)
        {
            for (x_block = 0; x_block < width_block; x_block++)
            {
                i = y_block * width_block + x_block;

                for (x = 0; x < 16; x++)
                {
                    /* Compute the pixel color component values. */
                    
                    ri = (i >> rshift) & rmax;
                    gi = (i >> gshift) & gmax;
                    bi = (i >> bshift) & bmax;

                    /*
                     * Bring the color component values to the range
                     * [0, 255]
                     */
                    
                    if (rprec > 0) r = (ri * 255) / rmax; else r = 0;
                    if (gprec > 0) g = (gi * 255) / gmax; else g = 0;
                    if (bprec > 0) b = (bi * 255) / bmax; else b = 0;

                    /* Write the pixel to the image. */

                    GDK_MAGICK_SET_PIXEL (pixels [index], r, g, b, 0, 0, 0);
                    
                    index++;
                }
            }
        }
    }

    image -> pixels = pixels;

    return image;
}

Image *generate_rectangle
(
    guint width,
    guint height,
    guint bg_r,
    guint bg_g,
    guint bg_b
)
{
    Image *image;
    PixelPacket *pixels;
    guint32 r, g, b;
    guint index;

    /* Initialize the image data structures. */
    
    image = gdk_magick_new_image (width, height);
    if (image == NULL)
    {
        /* TODO: Error case */
        return NULL;
    }
    pixels = image -> pixels;

    if (image -> depth == 16)
    {
        r = GDK_MAGICK_HIGH_QUANTUM (bg_r);
        g = GDK_MAGICK_HIGH_QUANTUM (bg_g);
        b = GDK_MAGICK_HIGH_QUANTUM (bg_b);
    }
    else
    {
        r = bg_r;
        g = bg_g;
        b = bg_b;
    }
    
    /* Fill the image with a solid block of color. */
    
    for (index = 0; index < width * height; index++)
    {
        GDK_MAGICK_SET_PIXEL (pixels [index], r, g, b, 0, 0, 0);
    }
    
    return image;
}

Image *generate_rectangle_bpp (guint bpp, guint bg_r, guint bg_g, guint bg_b)
{
    guint width, height;

    width = 1 << (bpp / 2);
    height = 1 << (bpp / 2);
    if (((bpp / 2) * 2) != bpp)
    {
        width <<= 1;
    }
    width *= 16;
    height *= 16;

    return generate_rectangle (width, height, bg_r, bg_g, bg_b);
}

