/*
 * main.c: Main program entry point
 */

#include "config.h"
#include <gdk_magick.h>
#include <gdk_magick_private.h>
#include <gtk/gtk.h>
#include "gdk_magick_test.h"

/*********************************************************************
 *
 * print_usage: Echo brief command-line usage information to stderr
 * and exit the program with error code 1.
 *
 * Parameters:
 *   command - name of command as entered on the command line
 *
 * Return value:
 *   None.
 */

void print_usage (char *command)
{
    fprintf (stderr, "Usage: %s\n", command);
    exit (1);
}

/*********************************************************************
 *
 * MAIN FUNCTION
 */

int main (int argc, char *argv[], char *envp [])
{
    /* Process command-line arguments. */

    if (argc > 1)
    {
        print_usage (argv [0]);
    }

    /* Call all toolkit initialization routines. */

    gtk_init (&argc, &argv);
    gdk_magick_init (&argc, &argv);
    gdk_magick_set_dither (DEFAULT_DITHER);
    gtk_widget_push_visual (gdk_magick_get_visual ());
    gtk_widget_push_colormap (gdk_magick_get_colormap ());
    
    create_test_window ();

    /* Main GTK event loop */
    
    gtk_main ();
    
    return 0;
}
