/*
 * ?.c: .....
 */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <gdk_magick.h>
#include <gdk_magick_private.h>
#include <gtk/gtk.h>
#include "gdk_magick_test.h"
#include "preview.xpm"

GdkPixmap *test_pixmap;
GdkBitmap *test_pixmap_mask;
GtkWidget *test_pixmap_widget;

GtkWidget *pixmap_create_page (GtkWidget *window)
{
    GtkWidget *page_box, *hbox;
    GtkStyle *style;
    
    /* Create the pixmap notebook page. */
    
    page_box = gtk_vbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (page_box), 5);

    add_label (page_box, "Click on one of the following buttons:");
    
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);

    add_fill_button (hbox, NULL,
                     GTK_SIGNAL_FUNC (pixmap_button_func), "0 bpp");
    add_fill_button (hbox, NULL,
                     GTK_SIGNAL_FUNC (pixmap_button_func), "1 bpp");
    add_fill_button (hbox, NULL,
                     GTK_SIGNAL_FUNC (pixmap_button_func), "2 bpp");
    add_fill_button (hbox, NULL,
                     GTK_SIGNAL_FUNC (pixmap_button_func), "3 bpp");
    add_fill_button (hbox, NULL,
                     GTK_SIGNAL_FUNC (pixmap_button_func), "4 bpp");
    add_fill_button (hbox, NULL,
                     GTK_SIGNAL_FUNC (pixmap_button_func), "5 bpp");
    add_fill_button (hbox, NULL,
                     GTK_SIGNAL_FUNC (pixmap_button_func), "6 bpp");
    add_fill_button (hbox, NULL,
                     GTK_SIGNAL_FUNC (pixmap_button_func), "7 bpp");
    add_fill_button (hbox, NULL,
                     GTK_SIGNAL_FUNC (pixmap_button_func), "8 bpp");
    add_fill_button (hbox, NULL,
                     GTK_SIGNAL_FUNC (pixmap_button_func), "9 bpp");

    gtk_box_pack_start (GTK_BOX (page_box), hbox, FALSE, FALSE, 0);
    gtk_widget_show (hbox);

    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);

    add_fill_button
    (
        hbox,
        NULL,
        GTK_SIGNAL_FUNC (pixmap_load_dialog),
        "Load image from disk file..."
    );

    gtk_box_pack_start (GTK_BOX (page_box), hbox, FALSE, FALSE, 0);
    gtk_widget_show (hbox);

    add_separator (page_box);
    
    style = gtk_widget_get_style (window);
    test_pixmap = gdk_pixmap_colormap_create_from_xpm_d
    (
        NULL,
        gdk_magick_get_colormap (),
        &test_pixmap_mask,
        &style -> bg [GTK_STATE_NORMAL],
        (gchar **) preview_xpm
    );
    test_pixmap_widget = gtk_pixmap_new (test_pixmap, test_pixmap_mask);
    if (test_pixmap_widget == NULL)
    {
        error_dialog ("Unable to create test pixmap widget!");
        /* TODO: Cleanup here and return control to main routine... */
    }
    
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);

    gtk_box_pack_start
    (
        GTK_BOX (hbox),
        test_pixmap_widget,
        TRUE,
        FALSE,
        0
    );
    gtk_widget_show (test_pixmap_widget);
    
    gtk_box_pack_start (GTK_BOX (page_box), hbox, FALSE, FALSE, 0);
    gtk_widget_show (hbox);

    gtk_widget_set_usize (page_box, 0, 0);
    gtk_widget_show (page_box);

    return page_box;
}

void pixmap_button_func (GtkWidget *widget, gchar *button_text)
{
    GString *bpp_string;
    gint bpp;
    Image *image;

    bpp_string = g_string_new (button_text);
    g_string_truncate (bpp_string, 1);
    bpp = atoi (bpp_string -> str);

    /* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */

    if (test_pixmap != NULL) gdk_pixmap_unref (test_pixmap);
    if (test_pixmap_mask != NULL) gdk_bitmap_unref (test_pixmap_mask);
    
    image = generate_image (bpp);

    test_pixmap = gdk_magick_to_gdkpixmap (image);
    test_pixmap_mask = NULL;

    if (test_pixmap != NULL) gdk_pixmap_ref (test_pixmap);
    if (test_pixmap_mask != NULL) gdk_bitmap_ref (test_pixmap_mask);

    gtk_pixmap_set
    (
        GTK_PIXMAP (test_pixmap_widget),
        test_pixmap,
        test_pixmap_mask
    );
    gtk_widget_show (test_pixmap_widget);
    gdk_flush ();    

    /* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
    
    if (image != NULL) DestroyImage (image);
    g_string_free (bpp_string, TRUE);
}

gint pixmap_load_delete_event
(
    GtkWidget *widget,
    GdkEvent *event,
    gpointer data
)
{
    gtk_widget_destroy (widget);
    return FALSE;
}

void pixmap_load_dialog (GtkWidget *widget, gpointer *func)
{
    GtkWidget *disk_dialog;
     
    disk_dialog = gtk_file_selection_new ("Load image from disk file");
    gtk_window_set_modal (GTK_WINDOW (disk_dialog), TRUE);

    gtk_signal_connect
    (
        GTK_OBJECT (GTK_FILE_SELECTION (disk_dialog) -> ok_button),
        "clicked",
        (GtkSignalFunc) pixmap_load,
        disk_dialog
    );
    gtk_signal_connect_object
    (
        GTK_OBJECT (GTK_FILE_SELECTION (disk_dialog) -> ok_button),
        "clicked",
        (GtkSignalFunc) pixmap_load_delete_event,
        GTK_OBJECT (disk_dialog)
    );
    gtk_signal_connect_object
    (
        GTK_OBJECT (GTK_FILE_SELECTION (disk_dialog) -> cancel_button),
        "clicked",
        (GtkSignalFunc) pixmap_load_delete_event,
        GTK_OBJECT (disk_dialog)
    );

    gtk_widget_show (disk_dialog);
}

void pixmap_load (GtkWidget *widget, GtkWidget *disk_dialog)
{
    gchar *filename;
    Image *image;
    ImageInfo *image_info;
    
    filename = gtk_file_selection_get_filename
    (
        GTK_FILE_SELECTION (disk_dialog)
    );

    /* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */

    image_info = CloneImageInfo (NULL);
    strcpy (image_info -> filename, filename);
    image = ReadImage (image_info);
    if (image == NULL)
    {
        /*
         * TODO: Not an error case, but we need to inform the user.
         * Perhaps a message dialog?
         */
        return;
    }
    
    if (test_pixmap != NULL) gdk_pixmap_unref (test_pixmap);
    if (test_pixmap_mask != NULL) gdk_bitmap_unref (test_pixmap_mask);

    test_pixmap = gdk_magick_to_gdkpixmap (image);
    test_pixmap_mask = NULL;

    if (test_pixmap != NULL) gdk_pixmap_ref (test_pixmap);
    if (test_pixmap_mask != NULL) gdk_bitmap_ref (test_pixmap_mask);

    gtk_pixmap_set
    (
        GTK_PIXMAP (test_pixmap_widget),
        test_pixmap,
        test_pixmap_mask
    );
    gtk_widget_show (test_pixmap_widget);
    gdk_flush ();    

    /* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
    
    if (image != NULL) DestroyImage (image);
    if (image_info != NULL) DestroyImageInfo (image_info);
}
