/*
 * ?.c: .....
 */

#include "config.h"
#include <gdk_magick.h>
#include <gdk_magick_private.h>
#include <magick/version.h>
#include <gtk/gtk.h>
#include "gdk_magick_test.h"
#include "GdkMagick.xpm"
#ifdef HAVE_SYS_UTSNAME_H
#include <sys/utsname.h>
#endif /* HAVE_SYS_UTSNAME_H */

GtkWidget *sysinfo_create_page (GtkWidget *window)
{
    GtkWidget *page_box, *hbox;
    GtkStyle *style;
    GdkPixmap *gdkmagick_pixmap;
    GdkBitmap *gdkmagick_pixmap_mask;
    GtkWidget *gdkmagick_pixmap_widget;
    GdkVisual *gdkmagick_visual;
    GdkColormap *gdkmagick_colormap;
    GString *info_string;

#ifdef HAVE_SYS_UTSNAME_H
    struct utsname system_info;
#endif /* HAVE_SYS_UTSNAME_H */

    /* Create the system info notebook page. */
    
    page_box = gtk_vbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (page_box), 5);

    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);

    style = gtk_widget_get_style (window);
    gdkmagick_pixmap = gdk_pixmap_colormap_create_from_xpm_d
    (
        NULL,
        gdk_magick_get_colormap (),
        &gdkmagick_pixmap_mask,
        &style -> bg [GTK_STATE_NORMAL],
        (gchar **) gdkmagick_xpm
    );
    gdkmagick_pixmap_widget = gtk_pixmap_new
    (
        gdkmagick_pixmap,
        gdkmagick_pixmap_mask
    );
    if (gdkmagick_pixmap_widget == NULL)
    {
        error_dialog ("Unable to create GdkMagick banner pixmap widget!");
        /* TODO: Cleanup here and return control to main routine... */
    }
    gtk_box_pack_start
    (
        GTK_BOX (hbox),
        gdkmagick_pixmap_widget,
        TRUE,
        FALSE,
        0
    );
    gtk_widget_show (gdkmagick_pixmap_widget);

    gtk_box_pack_start (GTK_BOX (page_box), hbox, FALSE, FALSE, 0);
    gtk_widget_show (hbox);

    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);

    add_fill_label (hbox, "Welcome to the GdkMagick test program!");
    
    gtk_box_pack_start (GTK_BOX (page_box), hbox, FALSE, FALSE, 0);
    gtk_widget_show (hbox);

    add_separator (page_box);

    gdkmagick_visual = gdk_magick_get_visual ();
    gdkmagick_colormap = gdk_magick_get_colormap ();
    
    info_string = g_string_new (NULL);

    g_string_assign (info_string, "Operating system: ");

#ifdef HAVE_SYS_UTSNAME_H
    uname (&system_info);
    g_string_sprintfa
    (
        info_string,
        "%s %s",
        system_info.sysname,
        system_info.release
    );
#else
    g_string_append (info_string, "Unknown");
#endif /* HAVE_SYS_UTSNAME_H */
    
    add_label (page_box, info_string -> str);
    
    g_string_assign (info_string, "Display visual type: ");
    switch (gdkmagick_visual -> type)
    {
        case GDK_VISUAL_STATIC_GRAY:
            g_string_append (info_string, "GDK_VISUAL_STATIC_GRAY");
            break;
        case GDK_VISUAL_GRAYSCALE:
            g_string_append (info_string, "GDK_VISUAL_GRAYSCALE");
            break;
        case GDK_VISUAL_STATIC_COLOR:
            g_string_append (info_string, "GDK_VISUAL_STATIC_COLOR");
            break;
        case GDK_VISUAL_PSEUDO_COLOR:
            g_string_append (info_string, "GDK_VISUAL_PSEUDO_COLOR");
            break;
        case GDK_VISUAL_TRUE_COLOR:
            g_string_append (info_string, "GDK_VISUAL_TRUE_COLOR");
            break;
        case GDK_VISUAL_DIRECT_COLOR:
            g_string_append (info_string, "GDK_VISUAL_DIRECT_COLOR");
            break;
        default:
            g_string_append (info_string, "*** WARNING: Unknown visual type!");
            break;
    }
    add_label (page_box, info_string -> str);

    g_string_sprintf
    (
        info_string,
        "Display visual depth: %d",
        gdkmagick_visual -> depth
    );
    add_label (page_box, info_string -> str);

    g_string_sprintf
    (
        info_string,
        "Display visual bits per RGB: %d",
        gdkmagick_visual -> bits_per_rgb
    );
    add_label (page_box, info_string -> str);
    
    g_string_assign (info_string, "Number of colors in colormap: ");
    switch (gdkmagick_visual -> type)
    {
        case GDK_VISUAL_PSEUDO_COLOR:
        case GDK_VISUAL_STATIC_COLOR:
        case GDK_VISUAL_GRAYSCALE:
        case GDK_VISUAL_STATIC_GRAY:
            g_string_sprintfa
            (
                info_string,
                "%d",
                gdkmagick_visual -> colormap_size
            );
            break;
        default:
            g_string_append (info_string, "N/A");
    }
    add_label (page_box, info_string -> str);

    g_string_sprintf
    (
        info_string,
        "GdkMagick version: 0x%08x",
        gdk_magick_get_version ()
    );
    add_label (page_box, info_string -> str);
    
    g_string_sprintf
    (
        info_string,
        "ImageMagick version: 0x%04x",
        MagickLibVersion
    );
    add_label (page_box, info_string -> str);
        
    gtk_widget_set_usize (page_box, 0, 0);
    gtk_widget_show (page_box);

    g_string_free (info_string, TRUE);
    
    return page_box;
}
