/*
 * window.c: .....
 */

#include "config.h"
#include <gdk_magick.h>
#include <gdk_magick_private.h>
#include <gtk/gtk.h>
#include "gdk_magick_test.h"

void test_window_delete_event
(
    GtkWidget *widget,
    GdkEvent *event,
    gpointer data
)
{
    gtk_main_quit ();
}

void create_test_window ()
{
    GtkWidget *window;
    GtkWidget *label;
    GtkWidget *notebook;
    GtkWidget *page_box, *main_box, *button_box;

    /* Create the main test window. */
    
    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);    
    gtk_window_set_title (GTK_WINDOW (window), "GdkMagick test program");
    gtk_container_set_border_width (GTK_CONTAINER (window), 5);

    gtk_signal_connect
    (
        GTK_OBJECT (window),
        "delete_event",
        GTK_SIGNAL_FUNC (test_window_delete_event),
        NULL
    );

    main_box = gtk_vbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (main_box), 5);

    /* Create a notebook which will contain all the tabs. */
    
    notebook = gtk_notebook_new ();
    gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
    gtk_box_pack_start
    (
        GTK_BOX (main_box),
        notebook,
        TRUE,
        TRUE,
        0
    );
    gtk_widget_show (notebook);

    /* Create all the tabs. */
    
    label = gtk_label_new ("System Information");
    page_box = sysinfo_create_page (window);
    gtk_notebook_append_page (GTK_NOTEBOOK (notebook), page_box, label);
    label = gtk_label_new ("Pixmaps");
    page_box = pixmap_create_page (window);
    gtk_notebook_append_page (GTK_NOTEBOOK (notebook), page_box, label);
    label = gtk_label_new ("Bitmaps");
    page_box = bitmap_create_page (window);
    gtk_notebook_append_page (GTK_NOTEBOOK (notebook), page_box, label);
    label = gtk_label_new ("Images");
    page_box = image_create_page (window);
    gtk_notebook_append_page (GTK_NOTEBOOK (notebook), page_box, label);
    label = gtk_label_new ("GDK to Magick");
    page_box = tomagick_create_page ();
    gtk_notebook_append_page (GTK_NOTEBOOK (notebook), page_box, label);

    button_box = gtk_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (button_box), 5);

    add_checkbox
    (
        button_box,
        NULL,
        GTK_SIGNAL_FUNC (dither_func),
        DEFAULT_DITHER,
        "Dither rendered images"
    );

    gtk_box_pack_start (GTK_BOX (main_box), button_box, FALSE, FALSE, 0);
    gtk_widget_show (button_box);

    add_separator (main_box);

    button_box = gtk_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (button_box), 5);
    
    add_fill_button
    (
        button_box,
        GTK_OBJECT (window),
        GTK_SIGNAL_FUNC (test_window_delete_event),
        "Quit"
    );

    gtk_box_pack_start (GTK_BOX (main_box), button_box, FALSE, FALSE, 0);
    gtk_widget_show (button_box);
    
    gtk_container_add (GTK_CONTAINER (window), main_box);
    gtk_widget_show (main_box);
    
    /* Show the test window. */

    gtk_widget_show (window);
}

void dither_func (GtkWidget *widget, gpointer data)
{
    if (GTK_TOGGLE_BUTTON (widget) -> active)
    {
        gdk_magick_set_dither (TRUE);
    }
    else
    {
        gdk_magick_set_dither (FALSE);
    }
    return;
}

