/******************************************************************************
 JTEHTMLScanner.cc

	Helper class to lex HTML for JTextEditor.  By not inheriting from
	JHTMLScanner, JTextEditor objects avoid bloat because they do not
	permanently store the contents of yyFlexLexer.

	BASE CLASS = JHTMLScanner

	Copyright  1998 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <JTEHTMLScanner.h>
#include <JTextEditor.h>
#include <jAssert.h>

/******************************************************************************
 Constructor (protected)

	This is protected so only JTextEditor can construct us.

 ******************************************************************************/

JTEHTMLScanner::JTEHTMLScanner
	(
	JTextEditor* te
	)
	:
	JHTMLScanner(),
	itsTE(te)
{
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JTEHTMLScanner::~JTEHTMLScanner()
{
}

/******************************************************************************
 Handle something (virtual protected)

 ******************************************************************************/

JBoolean
JTEHTMLScanner::HandleHTMLWord
	(
	const JCharacter*	word,
	const JIndexRange&	range
	)
{
	itsTE->HandleHTMLWord(word, range);
	return kTrue;
}

JBoolean
JTEHTMLScanner::HandleHTMLWhitespace
	(
	const JCharacter*	space,
	const JIndexRange&	range
	)
{
	itsTE->HandleHTMLWhitespace(space, range);
	return kTrue;
}

JBoolean
JTEHTMLScanner::HandleHTMLTag
	(
	const JString&					name,
	const JStringPtrMap<JString>&	attr,
	const JIndexRange&				range
	)
{
	itsTE->HandleHTMLTag(name, attr, range);
	return kTrue;
}

JBoolean
JTEHTMLScanner::HandleHTMLComment
	(
	const JIndexRange& range
	)
{
	itsTE->HandleHTMLComment(range);
	return kTrue;
}

JBoolean
JTEHTMLScanner::HandleHTMLError
	(
	const HTMLError		err,
	const JCharacter*	errStr,
	const JIndexRange&	range
	)
{
	itsTE->HandleHTMLError(err, errStr, range);
	return kTrue;
}
