/******************************************************************************
 JXPGDirectorBase.cc

	BASE CLASS = JXWindowDirector

	Copyright  1997 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <JXPGDirectorBase.h>
#include <JXWindow.h>
#include <JXStaticText.h>
#include <JXButton.h>
#include <jGlobals.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

JXPGDirectorBase::JXPGDirectorBase
	(
	JXDirector* supervisor
	)
	:
	JXWindowDirector(supervisor)
{
	itsExpectsCloseFlag = kFalse;
	itsCancelButton     = NULL;
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JXPGDirectorBase::~JXPGDirectorBase()
{
}

/******************************************************************************
 ProcessFinished

	Call this to close the director.

 ******************************************************************************/

void
JXPGDirectorBase::ProcessFinished()
{
	itsExpectsCloseFlag = kTrue;
	const JBoolean ok = Close();
	assert( ok );
}

/******************************************************************************
 Close (virtual)

	Pass unexpected close messages to our JXProgressDisplay as cancel messages.

 ******************************************************************************/

JBoolean
JXPGDirectorBase::Close()
{
	if (itsExpectsCloseFlag)
		{
		return JXWindowDirector::Close();
		}
	else if (itsCancelButton != NULL)
		{
		itsCancelButton->Push();
		return kFalse;
		}
	else
		{
		(JGetUserNotification())->ReportError(
			"You cannot quit while this process is running.");
		return kFalse;
		}
}

/******************************************************************************
 Init (protected)

 ******************************************************************************/

void
JXPGDirectorBase::Init
	(
	JXWindow*			window,
	JXStaticText*		text,
	const JCharacter*	message,
	const JBoolean		allowCancel,
	JXButton*			cancelButton
	)
{
	window->SetTitle("Progress");

	// instantaneous redraw

	window->UsePixmapAsBackground(kTrue);
	window->KeepBufferPixmap(kTrue);

	// adjust window size to fit text

	text->SetText(message);

	const JRect apG = text->GetApertureGlobal();

	JSize dw          = 0;
	const JSize prefw = text->TEGetMinPreferredGUIWidth();
	const JSize apw   = apG.width();
	if (prefw > apw)
		{
		dw = prefw - apw;
		}

	JSize dh        = 0;
	const JSize bdh = text->GetBoundsHeight();
	const JSize aph = apG.height();
	if (bdh > aph)
		{
		dh = bdh - aph;
		}

	window->AdjustSize(dw, dh);
	window->LockCurrentSize();
	window->PlaceAsDialogWindow();

	// show cancel button, if allowed

	if (allowCancel)
		{
		itsCancelButton = cancelButton;
		}
	else
		{
		cancelButton->Hide();
		}
}
