/******************************************************************************
 JXStyleMenuTable.h

	Interface for the JXStyleMenuTable class

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXStyleMenuTable
#define _H_JXStyleMenuTable

#include <JXTextMenuTable.h>

class JXStyleMenu;

class JXStyleMenuTable : public JXTextMenuTable
{
public:

	static JXStyleMenuTable*	Create(JXStyleMenu* menu, JXTextMenuData* data, JXContainer* enclosure,
										 const HSizingOption hSizing, const VSizingOption vSizing,
										 const JCoordinate x, const JCoordinate y,
										 const JCoordinate w, const JCoordinate h);

	virtual ~JXStyleMenuTable();

protected:

	JXStyleMenuTable(JXStyleMenu* menu, JXTextMenuData* data, JXContainer* enclosure,
					 const HSizingOption hSizing, const VSizingOption vSizing,
					 const JCoordinate x, const JCoordinate y,
					 const JCoordinate w, const JCoordinate h);

	virtual void	TableDrawCell(JPainter& p, const JPoint& cell, const JRect& rect);

private:

	JXStyleMenu*	itsStyleMenu;	// it owns us

private:

	// not allowed

	JXStyleMenuTable(const JXStyleMenuTable& source);
	const JXStyleMenuTable& operator=(const JXStyleMenuTable& source);
};

#endif
