/******************************************************************************
 JXTEStyleMenu.h

	Interface for the JXTEStyleMenu class

	Copyright  1996-97 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXTEStyleMenu
#define _H_JXTEStyleMenu

#include <JXStyleMenu.h>

class JXTextEditor;

class JXTEStyleMenu : public JXStyleMenu
{
public:

	static JXTEStyleMenu*	Create(JXTextEditor* te, const JXMenu::Style menuStyle,
								  JXContainer* enclosure,
								  const HSizingOption hSizing, const VSizingOption vSizing,
								  const JCoordinate x, const JCoordinate y,
								  const JCoordinate w, const JCoordinate h);

	static JXTEStyleMenu*	Create(JXTextEditor* te, const JXMenu::Style menuStyle,
								  JXMenu* owner, const JIndex itemIndex, JXContainer* enclosure);

	virtual ~JXTEStyleMenu();

protected:

	JXTEStyleMenu(JXTextEditor* te, const JXMenu::Style menuStyle,
				  JXContainer* enclosure,
				  const HSizingOption hSizing, const VSizingOption vSizing,
				  const JCoordinate x, const JCoordinate y,
				  const JCoordinate w, const JCoordinate h);

	JXTEStyleMenu(JXTextEditor* te, const JXMenu::Style menuStyle,
				  JXMenu* owner, const JIndex itemIndex, JXContainer* enclosure);

	virtual JFontStyle	GetFontStyleForMenuUpdate() const;
	virtual void		HandleMenuItem(const JIndex menuItem);

private:

	JXTextEditor*	itsTE;		// we don't own this

private:

	// not allowed

	JXTEStyleMenu(const JXTEStyleMenu& source);
	const JXTEStyleMenu& operator=(const JXTEStyleMenu& source);
};

#endif
