/******************************************************************************
 testjxGlobals.cc

	Access to testjx global objects and factories.

	Written by John Lindal.

 ******************************************************************************/

#include "testjxGlobals.h"
#include "testjxHelpText.h"
#include <jAssert.h>

static TestApp*			theApplication = NULL;		// owns itself
static TestMDIServer*	theMDIServer   = NULL;		// owned by JX, can be NULL

/******************************************************************************
 TestjxCreateGlobals

	server can be NULL

 ******************************************************************************/

void
TestjxCreateGlobals
	(
	TestApp*		app,
	TestMDIServer*	server
	)
{
	theApplication = app;
	theMDIServer   = server;

	JXInitHelp(NULL, kHelpSectionCount,
			   kHelpSectionName, kHelpSectionTitle, kHelpSectionText,
			   JXMenu::kWindowsStyle);
}

/******************************************************************************
 TestjxDeleteGlobals

 ******************************************************************************/

void
TestjxDeleteGlobals()
{
	theApplication = NULL;
	theMDIServer   = NULL;
}

/******************************************************************************
 TestjxGetApplication

 ******************************************************************************/

TestApp*
TestjxGetApplication()
{
	assert( theApplication != NULL );
	return theApplication;
}

/******************************************************************************
 TestjxGetMDIServer

 ******************************************************************************/

JBoolean
TestjxGetMDIServer
	(
	TestMDIServer** server
	)
{
	*server = theMDIServer;
	return JBoolean( theMDIServer != NULL );
}
