/* $Id: M2ComboBox.h,v 1.1.1.1 2001/04/09 13:32:44 glgay Exp $ */
/*
 Copyright (C) 1996       Peter Williams
 Copyright (C) 1997, 1999 Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#if !defined(xarm_m2combobox_h)
#define xarm_m2combobox_h

#include <Xm/ComboBox.h>

class ComboBoxClass : public ManagerClass {
 protected:
   ComboBoxClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return xmComboBoxWidgetClass; }
   virtual _XtString className()      { return (_XtString) "XmComboBox"; }

 public:
   /* callbacks */
   void selectionCallback(XtCallbackProc fp, XtPointer data = NULL)
                                             { XARM_SET_CALLBACK(XmNselectionCallback); }

   /* resources */
   void arrowSize(Dimension val)             { XARM_SET_VALUE(XmNarrowSize); }
   Dimension arrowSize() const               { XARM_GET_VALUE(Dimension, XmNarrowSize); }
   void arrowSpacing(Dimension val)          { XARM_SET_VALUE(XmNarrowSpacing); }
   Dimension arrowSpacing() const            { XARM_GET_VALUE(Dimension, XmNarrowSpacing); }
   void highlightThickness(Dimension val)    { XARM_SET_VALUE(XmNhighlightThickness); }
   Dimension highlightThickness() const      { XARM_GET_VALUE(Dimension, XmNhighlightThickness); }
   void fontList(const XmFontList val)       { XARM_SET_VALUE(XmNfontList); }
   XmFontList fontList() const               { XARM_GET_VALUE(XmFontList, XmNfontList); }
   void matchBehavior(unsigned char val)     { XARM_SET_VALUE(XmNmatchBehavior); }
   unsigned char matchBehavior() const       { XARM_GET_VALUE(unsigned char, XmNmatchBehavior); }
   void renderTable(const XmRenderTable val) { XARM_SET_VALUE(XmNrenderTable); }
   XmRenderTable renderTable() const         { XARM_GET_VALUE(XmRenderTable, XmNrenderTable); }
   /* read-only resource after construction */
   unsigned char comboBoxType() const        { XARM_GET_VALUE(unsigned char, XmNcomboBoxType); }
   void marginHeight(Dimension val)          { XARM_SET_VALUE(XmNmarginHeight); }
   Dimension marginHeight() const            { XARM_GET_VALUE(Dimension, XmNmarginHeight); }
   void marginWidth(Dimension val)           { XARM_SET_VALUE(XmNmarginWidth); }
   Dimension marginWidth() const             { XARM_GET_VALUE(Dimension, XmNmarginWidth); }
   void selectedItem(const char *str)        { XARM_SET_STRING(XmNselectedItem); }
   char *selectedItem() const                { XARM_GET_STRING_NF(XmNselectedItem); }
   void selectedPosition(int val)            { XARM_SET_VALUE(XmNselectedPosition); }
   int selectedPosition() const              { XARM_GET_VALUE(int, XmNselectedPosition); }

   /* convenience routines */
   /* The add and clear functions were added as    */
   /* convenience routines here by popular demand. */
   Widget list() const; /* return list widget */
   void update(); /* update combobox internal structs */
   void add(const char *); /* Add an item to the list */
   void clear();     /* Clear the list */
   
   /* extra functionality */
   /* 
    * listObject()
    * This routine returns the list wrapper object for the list widget. 
    * Warning: if you modify anything in this object don't forget to 
    * call the update function.
    */
   ListClass *listObject() const; 
   
};

typedef XarmFuncWidget<ComboBoxClass, XmCreateComboBox,         true> ComboBox;
typedef XarmFuncWidget<ComboBoxClass, XmCreateDropDownList,     true> DropDownList;
typedef XarmFuncWidget<ComboBoxClass, XmCreateDropDownComboBox, true> DropDownComboBox;

#endif
