/* $Id: Tab.h,v 1.1.1.1 2001/04/09 13:33:22 glgay Exp $ */
/*
 Copyright (C) 1996 Peter Williams
 Copyright (C) 1999 Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_tab_h)
#define xarm_tab_h

/*
 * Warning:  These classes diverge from the Motif 1.2 standard GUI and
 * use widgets written by the author.
 */

/* ======================================================================= */
/* Include(s): */
#include <Xmext/Tab.h>
#include <Xarm/Label.h>

class TabClass : public LabelClass {
 protected:
   TabClass() {} /* only a derived class can make this */

   virtual WidgetClass classPointer() { return xmTabWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmTab"; }
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   /* callbacks */
   void activateCallback(XtCallbackProc fp, XtPointer data = NULL) { XARM_SET_CALLBACK(XmNactivateCallback); }
   void armCallback(XtCallbackProc fp, XtPointer data = NULL)      { XARM_SET_CALLBACK(XmNarmCallback); }
   void disarmCallback(XtCallbackProc fp, XtPointer data = NULL)   { XARM_SET_CALLBACK(XmNdisarmCallback); }

   /* resources */
   void armColor(Pixel val)        { XARM_SET_VALUE(XmNarmColor); }
   Pixel armColor() const          { XARM_GET_VALUE(Pixel, XmNarmColor); }
   void armPixmap(Pixmap val)      { XARM_SET_VALUE(XmNarmPixmap); }
   Pixmap armPixmap() const        { XARM_GET_VALUE(Pixmap, XmNarmPixmap); }
   void cornerSize(int val)        { XARM_SET_VALUE(XmNcornerSize); }
   int cornerSize() const          { XARM_GET_VALUE(int, XmNcornerSize); }
   void cornerStyle(int val)       { XARM_SET_VALUE(XmNcornerStyle); }
   int cornerStyle() const         { XARM_GET_VALUE(int, XmNcornerStyle); }
   void fillOnArm(Boolean val)     { XARM_SET_VALUE(XmNfillOnArm); }
   Boolean fillOnArm() const       { XARM_GET_VALUE(Boolean, XmNfillOnArm); }
   void showAsActive(Boolean val)  { XARM_SET_VALUE(XmNshowAsActive); }
   Boolean showAsActive() const    { XARM_GET_VALUE(Boolean, XmNshowAsActive); }

   /* extra functionality */
   void autoSpace(int size = 100);
   void armColor(const char *val)  { XARM_SET_TYPED(XmNarmColor); }
};

////////////////////////////////////////////
//                                        //
// Tab is not a template because it has   //
// non-standard constructors!             //
//                                        //
////////////////////////////////////////////
   
class Tab : public TabClass {
 public:
   Tab(Widget w_parent, 
                char *str, 
                _XtString name = NULL);

   Tab(Widget w_parent, 
              ArgList arglist = NULL, 
              Cardinal cnt = 0,
              _XtString name = NULL);

   Tab(_XtString name, Widget w_parent);
   Tab(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
