/*
 Copyright (C) 1998, 1999 Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#if !defined(xarm_xarmmatrix_h)
#define xarm_xarmmatrix_h

#include <Xarm/Xarm.h>
#include <Xarm/Manager.h>

#ifdef XARM_HAS_XBAE

#include <Xbae/Matrix.h>

typedef Pixel          **PixelTable;
typedef String         **CellTable;
typedef Boolean         *BooleanArray;
typedef Boolean        **BooleanTable;
typedef String          *StringArray;
typedef unsigned char    GridType;
typedef unsigned char  **HighlightTable;
typedef XtTranslations   TranslationTable;

class MatrixClass : public ManagerClass {

 protected:

    MatrixClass() {}

    virtual WidgetClass classPointer() { return xbaeMatrixWidgetClass; }
    virtual _XtString   className()    { return (_XtString) "XbaeMatrix"; }

 public:

    /* Callbacks */
    void defaultActionCallback(XtCallbackProc fp, XtPointer data = NULL)
          { XARM_SET_CALLBACK(XmNdefaultActionCallback); }
    void drawCellCallback(XtCallbackProc fp, XtPointer data = NULL)
          { XARM_SET_CALLBACK(XmNdrawCellCallback); }
    void enterCellCallback(XtCallbackProc fp, XtPointer data = NULL)
          { XARM_SET_CALLBACK(XmNenterCellCallback); }
    void labelActivateCallback(XtCallbackProc fp, XtPointer data = NULL)
          { XARM_SET_CALLBACK(XmNlabelActivateCallback); }
    void leaveCellCallback(XtCallbackProc fp, XtPointer data = NULL)
          { XARM_SET_CALLBACK(XmNleaveCellCallback); }
    void modifyVerifyCallback(XtCallbackProc fp, XtPointer data = NULL)
          { XARM_SET_CALLBACK(XmNmodifyVerifyCallback); }
    void processDragCallback(XtCallbackProc fp, XtPointer data = NULL)
          { XARM_SET_CALLBACK(XmNprocessDragCallback); }
    void resizeCallback(XtCallbackProc fp, XtPointer data = NULL)
          { XARM_SET_CALLBACK(XmNresizeCallback); }
    void resizeColumnCallback(XtCallbackProc fp, XtPointer data = NULL)
          { XARM_SET_CALLBACK(XmNresizeColumnCallback); }
    void selectCellCallback(XtCallbackProc fp, XtPointer data = NULL)
          { XARM_SET_CALLBACK(XmNselectCellCallback); }
    void traverseCellCallback(XtCallbackProc fp, XtPointer data = NULL)
          { XARM_SET_CALLBACK(XmNtraverseCellCallback); }
    void writeCellCallback(XtCallbackProc fp, XtPointer data = NULL)
          { XARM_SET_CALLBACK(XmNwriteCellCallback); }
#ifdef XARM_XBAE_HAS_VCC
    void valueChangedCallback(XtCallbackProc fp, XtPointer data = NULL)
          { XARM_SET_CALLBACK(XmNvalueChangedCallback); }
#endif

    /* Resources */
    void             allowColumnResize(Boolean val)         { XARM_SET_VALUE(XmNallowColumnResize); }
    Boolean          allowColumnResize() const              { XARM_GET_VALUE(Boolean, XmNallowColumnResize); }
    void             altRowCount(int val)                   { XARM_SET_VALUE(XmNaltRowCount); }
    int              altRowCount() const                    { XARM_GET_VALUE(int, XmNaltRowCount); }
    void             boldLabels(Boolean val)                { XARM_SET_VALUE(XmNboldLabels); }
    Boolean          boldLabels() const                     { XARM_GET_VALUE(Boolean, XmNboldLabels); }
    void             buttonLabels(Boolean val)              { XARM_SET_VALUE(XmNbuttonLabels); }
    Boolean          buttonLabels() const                   { XARM_GET_VALUE(Boolean, XmNbuttonLabels); }
    void             buttonLabelBackground(Pixel val)       { XARM_SET_VALUE(XmNbuttonLabelBackground); }
    Pixel            buttonLabelBackground() const          { XARM_GET_VALUE(Pixel, XmNbuttonLabelBackground); }
    void             cellBackgrounds(PixelTable val)        { XARM_SET_VALUE(XmNcellBackgrounds); }
    PixelTable       cellBackgrounds() const                { XARM_GET_VALUE(PixelTable, XmNcellBackgrounds); }
    void             cellHighlightThickness(Dimension val)  { XARM_SET_VALUE(XmNcellHighlightThickness); }
    Dimension        cellHighlightThickness() const         { XARM_GET_VALUE(Dimension, XmNcellHighlightThickness); }
    void             cellMarginHeight(Dimension val)        { XARM_SET_VALUE(XmNcellMarginHeight); }
    Dimension        cellMarginHeight() const               { XARM_GET_VALUE(Dimension, XmNcellMarginHeight); }
    void             cellMarginWidth(Dimension val)         { XARM_SET_VALUE(XmNcellMarginWidth); }
    Dimension        cellMarginWidth() const                { XARM_GET_VALUE(Dimension, XmNcellMarginWidth); }
    void             cellShadowThickness(Dimension val)     { XARM_SET_VALUE(XmNcellShadowThickness); }
    Dimension        cellShadowThickness() const            { XARM_GET_VALUE(Dimension, XmNcellShadowThickness); }
    void             cellShadowType(unsigned char val)      { XARM_SET_VALUE(XmNcellShadowType); }
    unsigned char    cellShadowType() const                 { XARM_GET_VALUE(unsigned char, XmNcellShadowType); }
    void             cellShadowTypes(unsigned char **val)   { XARM_SET_VALUE(XmNcellShadowTypes); }
    unsigned char  **cellShadowTypes() const                { XARM_GET_VALUE(unsigned char **, XmNcellShadowTypes); }
    void             cellUserData(XtPointer **val)          { XARM_SET_VALUE(XmNcellUserData); }
    XtPointer      **cellUserData() const                   { XARM_GET_VALUE(XtPointer **, XmNcellUserData); }
    Widget           clipWindow() const                     { XARM_GET_VALUE(Widget, XmNclipWindow); }
    void             cells(CellTable val)                   { XARM_SET_VALUE(XmNcells); }
    CellTable        cells() const                          { XARM_GET_VALUE(CellTable, XmNcells); }
    void             colors(PixelTable val)                 { XARM_SET_VALUE(XmNcolors); }
    PixelTable       colors() const                         { XARM_GET_VALUE(PixelTable, XmNcolors); }
    void             columnAlignments(AlignmentArray val)   { XARM_SET_VALUE(XmNcolumnAlignments); }
    AlignmentArray   columnAlignments() const               { XARM_GET_VALUE(AlignmentArray, XmNcolumnAlignments); }
    void             columnButtonLabels(BooleanArray val)   { XARM_SET_VALUE(XmNcolumnButtonLabels); }
    BooleanArray     columnButtonLabels() const             { XARM_GET_VALUE(BooleanArray, XmNcolumnButtonLabels); }
    void             columnLabelAlignments(AlignmentArray val) { XARM_SET_VALUE(XmNcolumnLabelAlignments); }
    AlignmentArray   columnLabelAlignments() const       { XARM_GET_VALUE(AlignmentArray, XmNcolumnLabelAlignments); }
    void             columnLabelColor(Pixel val)            { XARM_SET_VALUE(XmNcolumnLabelColor); }
    Pixel            columnLabelColor() const               { XARM_GET_VALUE(Pixel, XmNcolumnLabelColor); }
    void             columnLabels(StringArray val)          { XARM_SET_VALUE(XmNcolumnLabels); }
    StringArray      columnLabels() const                   { XARM_GET_VALUE(StringArray, XmNcolumnLabels); }
    void             columnMaxLengths(MaxLengthArray val)   { XARM_SET_VALUE(XmNcolumnMaxLengths); }
    MaxLengthArray   columnMaxLengths() const               { XARM_GET_VALUE(MaxLengthArray, XmNcolumnMaxLengths); }
    void             columnShadowTypes(unsigned char *val)  { XARM_SET_VALUE(XmNcolumnShadowTypes); }
    unsigned char   *columnShadowTypes() const              { XARM_GET_VALUE(unsigned char *, XmNcolumnShadowTypes); }
    void             columnUserData(XtPointer *val)         { XARM_SET_VALUE(XmNcolumnUserData); }
    XtPointer       *columnUserData() const                 { XARM_GET_VALUE(XtPointer *, XmNcolumnUserData); }
    void             columnWidths(WidthArray val)           { XARM_SET_VALUE(XmNcolumnWidths); }
    WidthArray       columnWidths() const                   { XARM_GET_VALUE(WidthArray, XmNcolumnWidths); }
    void             columns(int val)                       { XARM_SET_VALUE(XmNcolumns); }
    int              columns() const                        { XARM_GET_VALUE(int, XmNcolumns); }
    void             doubleClickInterval(int val)           { XARM_SET_VALUE(XmNdoubleClickInterval); }
    int              doubleClickInterval() const            { XARM_GET_VALUE(int, XmNdoubleClickInterval); }
    void             evenRowBackground(Pixel val)           { XARM_SET_VALUE(XmNevenRowBackground); }
    Pixel            evenRowBackground() const              { XARM_GET_VALUE(Pixel, XmNevenRowBackground); }
    void             fill(Boolean val)                      { XARM_SET_VALUE(XmNfill); }
    Boolean          fill() const                           { XARM_GET_VALUE(Boolean, XmNfill); }
    void             fixedColumns(Dimension val)            { XARM_SET_VALUE(XmNfixedColumns); }
    Dimension        fixedColumns() const                   { XARM_GET_VALUE(Dimension, XmNfixedColumns); }
    void             fixedRows(Dimension val)               { XARM_SET_VALUE(XmNfixedRows); }
    Dimension        fixedRows() const                      { XARM_GET_VALUE(Dimension, XmNfixedRows); }
    void             fontList(const XmFontList val)         { XARM_SET_VALUE(XmNfontList); }
    XmFontList       fontList() const                       { XARM_GET_VALUE(XmFontList, XmNfontList); }
    void             gridLineColor(Pixel val)               { XARM_SET_VALUE(XmNgridLineColor); }
    Pixel            gridLineColor() const                  { XARM_GET_VALUE(Pixel, XmNgridLineColor); }
    void             gridType(GridType val)                 { XARM_SET_VALUE(XmNgridType); }
    GridType         gridType() const                       { XARM_GET_VALUE(GridType, XmNgridType); }
    void             highlightedCells(HighlightTable val)   { XARM_SET_VALUE(XmNhighlightedCells); }
    HighlightTable   highlightedCells() const               { XARM_GET_VALUE(HighlightTable, XmNhighlightedCells); }
    Widget           horizontalScrollBar() const            { XARM_GET_VALUE(Widget, XmNhorizontalScrollBar); }
    void             horizontalScrollBarDisplayPolicy(unsigned char val)
                                  { XARM_SET_VALUE(XmNhorizontalScrollBarDisplayPolicy); }
    unsigned char    horizontalScrollBarDisplayPolicy() const
                                  { XARM_GET_VALUE(unsigned char, XmNhorizontalScrollBarDisplayPolicy); }
    void             labelFont(const XmFontList val)        { XARM_SET_VALUE(XmNlabelFont); }
    XmFontList       labelFont() const                      { XARM_GET_VALUE(XmFontList, XmNlabelFont); }
    void             leftColumn(int val)                    { XARM_SET_VALUE(XmNleftColumn); }
    int              leftColumn() const                     { XARM_GET_VALUE(int, XmNleftColumn); }
    void             oddRowBackground(Pixel val)            { XARM_SET_VALUE(XmNoddRowBackground); }
    Pixel            oddRowBackground() const               { XARM_GET_VALUE(Pixel, XmNoddRowBackground); }
    void             reverseSelect(Boolean val)             { XARM_SET_VALUE(XmNreverseSelect); }
    Boolean          reverseSelect() const                  { XARM_GET_VALUE(Boolean, XmNreverseSelect); }
    void             rowButtonLabels(BooleanArray val)      { XARM_SET_VALUE(XmNrowButtonLabels); }
    BooleanArray     rowButtonLabels() const                { XARM_GET_VALUE(BooleanArray, XmNrowButtonLabels); }
    void             rowLabelAlignment(Alignment val)       { XARM_SET_VALUE(XmNrowLabelAlignment); }
    Alignment        rowLabelAlignment() const              { XARM_GET_VALUE(Alignment, XmNrowLabelAlignment); }
    void             rowLabelColor(Pixel val)               { XARM_SET_VALUE(XmNrowLabelColor); }
    Pixel            rowLabelColor() const                  { XARM_GET_VALUE(Pixel, XmNrowLabelColor); }
    void             rowLabelWidth(short val)               { XARM_SET_VALUE(XmNrowLabelWidth); }
    short            rowLabelWidth() const                  { XARM_GET_VALUE(short, XmNrowLabelWidth); }
    void             rowLabels(StringArray val)             { XARM_SET_VALUE(XmNrowLabels); }
    StringArray      rowLabels() const                      { XARM_GET_VALUE(StringArray, XmNrowLabels); }
    void             rowShadowTypes(unsigned char *val)     { XARM_SET_VALUE(XmNrowShadowTypes); }
    unsigned char   *rowShadowTypes() const                 { XARM_GET_VALUE(unsigned char *, XmNrowShadowTypes); }
    void             rowUserData(XtPointer *val)            { XARM_SET_VALUE(XmNrowUserData); }
    XtPointer       *rowUserData() const                    { XARM_GET_VALUE(XtPointer *, XmNrowUserData); }
    void             rows(int val)                          { XARM_SET_VALUE(XmNrows); }
    int              rows() const                           { XARM_GET_VALUE(int, XmNrows); }
    void             scrollBarPlacement(unsigned char val)  { XARM_SET_VALUE(XmNscrollBarPlacement); }
    unsigned char    scrollBarPlacement() const             { XARM_GET_VALUE(unsigned char, XmNscrollBarPlacement); }
    void             selectScrollVisible(Boolean val)       { XARM_SET_VALUE(XmNselectScrollVisible); }
    Boolean          selectScrollVisible() const            { XARM_GET_VALUE(Boolean, XmNselectScrollVisible); }
    void             selectedBackground(Pixel val)          { XARM_SET_VALUE(XmNselectedBackground); }
    Pixel            selectedBackground() const             { XARM_GET_VALUE(Pixel, XmNselectedBackground); }
    void             selectedCells(BooleanTable val)        { XARM_SET_VALUE(XmNselectedCells); }
    BooleanTable     selectedCells() const                  { XARM_GET_VALUE(BooleanTable, XmNselectedCells); }
    void             selectedForeground(Pixel val)          { XARM_SET_VALUE(XmNselectedForeground); }
    Pixel            selectedForeground() const             { XARM_GET_VALUE(Pixel, XmNselectedForeground); }
    void             shadowType(unsigned char val)          { XARM_SET_VALUE(XmNshadowType); }
    unsigned char    shadowType() const                     { XARM_GET_VALUE(unsigned char, XmNshadowType); }
    void             showArrows(Boolean val)                { XARM_SET_VALUE(XmNshowArrows); }
    Boolean          showArrows() const                     { XARM_GET_VALUE(Boolean, XmNshowArrows); }
    void             space(Dimension val)                   { XARM_SET_VALUE(XmNspace); }
    Dimension        space() const                          { XARM_GET_VALUE(Dimension, XmNspace); }
    void             textBackground(Pixel val)              { XARM_SET_VALUE(XmNtextBackground); }
    Pixel            textBackground() const                 { XARM_GET_VALUE(Pixel, XmNtextBackground); }
    Widget           textField() const                      { XARM_GET_VALUE(Widget, XmNtextField); }
    void             textShadowThickness(Dimension val)     { XARM_SET_VALUE(XmNtextShadowThickness); }
    Dimension        textShadowThickness() const            { XARM_GET_VALUE(Dimension, XmNtextShadowThickness); }
    void             textTranslations(TranslationTable val) { XARM_SET_VALUE(XmNtextTranslations); }
    TranslationTable textTranslations() const               { XARM_GET_VALUE(TranslationTable, XmNtextTranslations); }
    void             topRow(int val)                        { XARM_SET_VALUE(XmNtopRow); }
    int              topRow() const                         { XARM_GET_VALUE(int, XmNtopRow); }
    void             trailingFixedColumns(Dimension val)    { XARM_SET_VALUE(XmNtrailingFixedColumns); }
    Dimension        trailingFixedColumns() const           { XARM_GET_VALUE(Dimension, XmNtrailingFixedColumns); }
    void             trailingFixedRows(Dimension val)       { XARM_SET_VALUE(XmNtrailingFixedRows); }
    Dimension        trailingFixedRows() const              { XARM_GET_VALUE(Dimension, XmNtrailingFixedRows); }
    void             traverseFixedCells(Boolean val)        { XARM_SET_VALUE(XmNtraverseFixedCells); }
    Boolean          traverseFixedCells() const             { XARM_GET_VALUE(Boolean, XmNtraverseFixedCells); }
    Widget           verticalScrollBar() const              { XARM_GET_VALUE(Widget, XmNverticalScrollBar); }
    void             verticalScrollBarDisplayPolicy(unsigned char val)
                                  { XARM_SET_VALUE(XmNverticalScrollBarDisplayPolicy); }
    unsigned char    verticalScrollBarDisplayPolicy() const
                                  { XARM_GET_VALUE(unsigned char, XmNverticalScrollBarDisplayPolicy); }
    void             visibleColumns(Dimension val)          { XARM_SET_VALUE(XmNvisibleColumns); }
    Dimension        visibleColumns() const                 { XARM_GET_VALUE(Dimension, XmNvisibleColumns); }
    void             visibleRows(Dimension val)             { XARM_SET_VALUE(XmNvisibleRows); }
    Dimension        visibleRows() const                    { XARM_GET_VALUE(Dimension, XmNvisibleRows); }

#ifdef XARM_XBAE_HAS_CC
    void             calcCursorPosition(Boolean val)        { XARM_SET_VALUE(XmNcalcCursorPosition); }
    Boolean          calcCursorPosition() const             { XARM_GET_VALUE(Boolean, XmNcalcCursorPosition); }
#endif

#ifdef XARM_XBAE_HAS_TAB
    void             trailingAttachedBottom(Boolean val)    { XARM_SET_VALUE(XmNtrailingAttachedBottom); }
    Boolean          trailingAttachedBottom() const         { XARM_GET_VALUE(Boolean, XmNtrailingAttachedBottom); }
#endif

    /* Convenience functions */
    /* NOTE:  Some of the arguments have been re-arranged from the actual */
    /*        Xbae calls to allow for easy default values */
    void addColumns(int position,
		    int num_columns,
		    String *columns                 = NULL,
		    String *labels                  = NULL,
		    short *widths                   = NULL,
		    int *max_lengths                = NULL,
		    unsigned char *alignments       = NULL,
		    unsigned char *label_alignments = NULL,
		    Pixel *colors                   = NULL) {
          XbaeMatrixAddColumns(widget(), position, columns, labels, widths, max_lengths,
			       alignments, label_alignments, colors, num_columns);
    }

    void addRows(int position,
		 int num_rows,
		 String *rows   = NULL,
		 String *labels = NULL,
		 Pixel *colors  = NULL) {
          XbaeMatrixAddRows(widget(), position, rows, labels, colors, num_rows);
    }

    void cancelEdit(Boolean unmap = False) { XbaeMatrixCancelEdit(widget(), unmap); }

    void commitEdit(Boolean unmap = True)  { XbaeMatrixCommitEdit(widget(), unmap); }

    void deleteColumns(int position, int num_columns) {
          XbaeMatrixDeleteColumns(widget(), position, num_columns);
    }

    void deleteRows(int position, int num_rows) {
          XbaeMatrixDeleteRows(widget(), position, num_rows);
    }

    void deselectAll() { XbaeMatrixDeselectAll(widget()); }

    void deselectCell(int row, int column) { XbaeMatrixDeselectCell(widget(), row, column); }

    void deselectColumn(int column) { XbaeMatrixDeselectColumn(widget(), column); }

    void deselectRow(int row) { XbaeMatrixDeselectRow(widget(), row); }

    void disableRedisplay() { XbaeMatrixDisableRedisplay(widget()); }

    void editCell(int row, int column) { XbaeMatrixEditCell(widget(), row, column); }

    void enableRedisplay(Boolean redisplay = True) { XbaeMatrixEnableRedisplay(widget(), redisplay); }

    Boolean eventToXY(XEvent *ev, int *x, int *y) { return XbaeMatrixEventToXY(widget(), ev, x, y); }

    void firstSelectedCell(int *row, int *column) { XbaeMatrixFirstSelectedCell(widget(), row, column); }

    int firstSelectedColumn() const { return XbaeMatrixFirstSelectedColumn(widget()); }

    int firstSelectedRow() const { return XbaeMatrixFirstSelectedRow(widget()); }

    String getCell(int row, int column) const { return XbaeMatrixGetCell(widget(), row, column); }

    XtPointer getCellUserData(int row, int column) const {
        return XbaeMatrixGetCellUserData(widget(), row, column);
    }

#ifdef XARM_XBAE_HAS_GCW
    int getColumnWidth(int column) const { return XbaeMatrixGetColumnWidth(widget(), column); }
#endif

    String getColumnLabel(int column) const { return XbaeMatrixGetColumnLabel(widget(), column); }

    XtPointer getColumnUserData(int column) const { return XbaeMatrixGetColumnUserData(widget(), column); }

    void getCurrentCell(int *x, int *y) const { XbaeMatrixGetCurrentCell(widget(), x, y); }

    int getEventRowColumn(XEvent *ev, int *row, int *column) {
        return XbaeMatrixGetEventRowColumn(widget(), ev, row, column);
    }

    int getNumSelected() const { return XbaeMatrixGetNumSelected(widget()); }

#ifdef XARM_XBAE_HAS_GRH
    int getRowHeight(int row) const { return XbaeMatrixGetRowHeight(widget(), row); }
#endif

    String getRowLabel(int row) const { return XbaeMatrixGetRowLabel(widget(), row); }

    XtPointer getRowUserData(int row) const { return XbaeMatrixGetRowUserData(widget(), row); }

    void hghlightCell(int row, int column) { XbaeMatrixHighlightCell(widget(), row, column); }

    void highlightColumn(int column) { XbaeMatrixHighlightColumn(widget(), column); }

    void highlightRow(int row) { XbaeMatrixHighlightRow(widget(), row); }

    Boolean isCellSelected(int row, int column) const { return XbaeMatrixIsCellSelected(widget(), row, column); }

    Boolean isCellVisible(int row, int column) const { return XbaeMatrixIsCellVisible(widget(), row, column); }

    Boolean isColumnSelected(int column) const { return XbaeMatrixIsColumnSelected(widget(), column); }

    Boolean isColumnVisible(int column) const { return XbaeMatrixIsColumnVisible(widget(), column); }

    Boolean isRowSelected(int row) const { return XbaeMatrixIsRowSelected(widget(), row); }

    Boolean isRowVisible(int row) const { return XbaeMatrixIsRowVisible(widget(), row); }

    void makeCellVisible(int row, int column) { XbaeMatrixMakeCellVisible(widget(), row, column); }

    int numRows() const { return XbaeMatrixNumRows(widget()); }

    int numColumns() const { return XbaeMatrixNumColumns(widget()); }

    void refresh() { XbaeMatrixRefresh(widget()); }

    void refreshCell(int row, int column) { XbaeMatrixRefreshCell(widget(), row, column); }

#ifdef XARM_XBAE_HAS_RFC
    void refreshColumn(int column) const { XbaeMatrixRefreshColumn(widget(), column); }
#endif

#ifdef XARM_XBAE_HAS_RFR
    void refreshRow(int row) const { XbaeMatrixRefreshRow(widget(), row); }
#endif

    int rowColToXY(int row, int col, int *x, int *y) const { return XbaeMatrixRowColToXY(widget(), row, col, x, y); }

    void selectAll() { XbaeMatrixSelectAll(widget()); }

    void selectCell(int row, int col) { XbaeMatrixSelectCell(widget(), row, col); }

    void selectColumn(int col) { XbaeMatrixSelectColumn(widget(), col); }

    void selectRow(int row) { XbaeMatrixSelectRow(widget(), row); }

    void setCell(int row, int col, String val) { XbaeMatrixSetCell(widget(), row, col, val); }

    void setCellBackground(int row, int col, Pixel color) {
        XbaeMatrixSetCellBackground(widget(), row, col, color);
    }

    void setCellColor(int row, int col, Pixel color) { XbaeMatrixSetCellColor(widget(), row, col, color); }

    void setCellUserData(int row, int col, XtPointer data) {
        XbaeMatrixSetCellUserData(widget(), row, col, data);
    }

#ifdef XARM_XBAE_HAS_SCW
    void setCellWidget(int row, int column, Widget w) { XbaeMatrixSetCellWidget(widget(), row, column, w); }
    void setCellWidget(int row, int column, WObjectClass *w) { XbaeMatrixSetCellWidget(widget(), row, column, w->widget()); }
#endif

    void setColumnBackgrounds(int pos, Pixel *colors, int num_colors) {
        XbaeMatrixSetColumnBackgrounds(widget(), pos, colors, num_colors);
    }

    void setColumnColors(int pos, Pixel *colors, int num_colors) {
        XbaeMatrixSetColumnColors(widget(), pos, colors, num_colors);
    }

    void setColumnLabel(int col, String val) { XbaeMatrixSetColumnLabel(widget(), col, val); }

    void setColumnUserData(int col, XtPointer data) { XbaeMatrixSetColumnUserData(widget(), col, data); }

#ifdef XARM_XBAE_HAS_SCOLW
    void setColumnWidth(int column, int width) { XbaeMatrixSetColumnWidth(widget(), column, width); }
#endif

    void setRowBackgrounds(int pos, Pixel *colors, int num_colors) {
        XbaeMatrixSetRowBackgrounds(widget(), pos, colors, num_colors);
    }

    void setRowColors(int pos, Pixel *colors, int num_colors) {
        XbaeMatrixSetRowColors(widget(), pos, colors, num_colors);
    }

#ifdef XARM_XBAE_HAS_SRH
    void setRowHeight(int row, int height) { XbaeMatrixSetRowHeight(widget(), row, height); }
#endif

    void setRowLabel(int row, String val) { XbaeMatrixSetRowLabel(widget(), row, val); }

    void setRowUserData(int row, XtPointer data) { XbaeMatrixSetRowUserData(widget(), row, data); }

    void unhighlightAll() { XbaeMatrixUnhighlightAll(widget()); }

    void unhighlightCell(int row, int col) { XbaeMatrixUnhighlightCell(widget(), row, col); }

    void unhighlightColumn(int col) { XbaeMatrixUnhighlightColumn(widget(), col); }

    void unhighlightRow(int row) { XbaeMatrixUnhighlightRow(widget(), row); }

    void visibleCells(int *top_row, int *bottom_row, int *left_column, int *right_column) {
        XbaeMatrixVisibleCells(widget(), top_row, bottom_row, left_column, right_column);
    }

    // Name collision!!!!!

    int getVisibleColumns() const { return XbaeMatrixVisibleColumns(widget()); }

    int getVisibleRows() const { return XbaeMatrixVisibleRows(widget()); }

#ifdef XARM_XBAE_HAS_VERSION
    int getVersionNum() const { return XbaeGetVersionNum(); }
    const char *getVersionText() const { return XbaeGetVersionTxt(); }
#endif

    // Extra functionality
    bool sort(int column, int direction = 0);  // 0 = ascending, 1 = descending
};

typedef XarmRawWidget<MatrixClass, true> Matrix;

#endif // XARM_HAS_XBAE

#endif // xarm_xarmmatrix_h
