// $Id: MakeGen.cpp,v 1.3 1997/11/03 00:04:34 jharris Exp $

#include "AssDialog.h"
#include "MakeGen.h"
#include "Project.h"
#include <qpushbt.h>
#include <qfiledlg.h>
#include <qgrpbox.h>


/*
 * For now, qtarch isn't able to generated AssPages by itself. I've
 * designed the pages with qtarch and collected the generated data
 * files here. 
 */

#define Inherited Pages

Page1Data::Page1Data
(
	AssDialog* parent,
  Project *prj,
	const char* name
)
	:
	Inherited( parent, prj, name )
{
	QLabel* tmpQLabel;
	tmpQLabel = new QLabel( this, "Label_1" );
	tmpQLabel->setGeometry( 10, 10, 380, 70 );
	tmpQLabel->setText( "Makefile generation is a multistep action. This dialog will guide you through it step by step." );
	tmpQLabel->setAlignment( 1057 );

	tmpQLabel = new QLabel( this, "Label_2" );
	tmpQLabel->setGeometry( 10, 80, 380, 60 );
	tmpQLabel->setText( "At first all included Object will get generated. Perhaps you're asked to enter some filenames (e.g. Dialogs need a confirmation about the filenames).  " );
	tmpQLabel->setAlignment( 1057 );

	resize( 400, 150 );
}


Page1Data::~Page1Data()
{
}

void Page1Data::InitPage( bool dir )
{
  // We simply show a message, so don't do anything
  dir = dir;
}

void Page1Data::ExitPage( bool dir )
{
  // Since we're the first pages, we could ignore direction completly
  dir = dir;

  // Generate only if we weren't entered via Back
  if( direction )
    itsProject->GenerateAllObjects();
}

Page2Data::Page2Data
(
	AssDialog* parent,
  Project *prj,
	const char* name
)
	:
	Inherited( parent, prj, name )
{
	QLabel* tmpQLabel;
	tmpQLabel = new QLabel( this, "Label_3" );
	tmpQLabel->setGeometry( 10, 10, 380, 70 );
	tmpQLabel->setText( "Please enter a path and filename for the Makefile. Qt Architect will overwrite an existing file  " );
	tmpQLabel->setAlignment( 1057 );

	tmpQLabel = new QLabel( this, "Label_4" );
	tmpQLabel->setGeometry( 10, 80, 80, 30 );
	tmpQLabel->setText( "Makefile:" );
	tmpQLabel->setAlignment( 33 );

	itsMakefileName = new QLineEdit( this, "LineEdit_1" );
	itsMakefileName->setGeometry( 90, 80, 190, 30 );
	itsMakefileName->setText( "" );

	QPushButton* tmpQPushButton;
	tmpQPushButton = new QPushButton( this, "PushButton_1" );
	tmpQPushButton->setGeometry( 290, 80, 100, 30 );
	connect( tmpQPushButton, SIGNAL(pressed()), SLOT(BrowseFiles()) );
	tmpQPushButton->setText( "Browse..." );

	resize( 400, 150 );

  itsFile = "";
}


Page2Data::~Page2Data()
{
}

void Page2Data::BrowseFiles()
{
  QString str = QFileDialog::getOpenFileName();
  
  if( ! str.isEmpty() )
    itsMakefileName->setText( str );
}

void Page2Data::InitPage( bool dir )
{
  if( dir )
  {
    if( itsFile == "" )
    {
      QString makeFileName = "Makefile." + itsProject->GetName(); 
      itsMakefileName->setText( makeFileName );
    } else
      itsMakefileName->setText( itsFile );
  } 
}

void Page2Data::ExitPage( bool dir )
{
  if( dir )
  {
    itsFile = itsMakefileName->text();
    itsProject->SetMakeFileName( itsFile );
  }
}

Page3Data::Page3Data
(
	AssDialog* parent,
  Project *prj,
	const char* name
)
	:
	Inherited( parent, prj, name )
{
	QLabel* tmpQLabel;
	tmpQLabel = new QLabel( this, "Label_3" );
	tmpQLabel->setGeometry( 10, 10, 380, 70 );
	tmpQLabel->setText( "Now we need the template Makefile. There's a default template provided with Qt Architect, but you might have copy and adapt it to fit your specific needs." );
	tmpQLabel->setAlignment( 1057 );

	tmpQLabel = new QLabel( this, "Label_4" );
	tmpQLabel->setGeometry( 10, 80, 80, 30 );
	tmpQLabel->setText( "Template:" );
	tmpQLabel->setAlignment( 33 );

	itsTemplateName = new QLineEdit( this, "LineEdit_1" );
	itsTemplateName->setGeometry( 90, 80, 190, 30 );
	itsTemplateName->setText( "" );

	QPushButton* tmpQPushButton;
	tmpQPushButton = new QPushButton( this, "PushButton_1" );
	tmpQPushButton->setGeometry( 290, 80, 100, 30 );
	connect( tmpQPushButton, SIGNAL(pressed()), SLOT(BrowseFiles()) );
	tmpQPushButton->setText( "Browse..." );

	resize( 400, 150 );

  itsFile = "";
}


Page3Data::~Page3Data()
{
}

void Page3Data::BrowseFiles()
{
  QString str = QFileDialog::getOpenFileName();
  
  if( ! str.isEmpty() )
    itsTemplateName->setText( str );
}

void Page3Data::InitPage( bool dir )
{
  if( dir )
  {
    itsTemplateName->setText( itsFile );
  }
      
}

void Page3Data::ExitPage( bool dir )
{
  if( dir )
  {
    itsFile = itsTemplateName->text();
    itsProject->SetMakeFileTemplateName( itsFile );
  }
}

Page4Data::Page4Data
(
	AssDialog* parent,
  Project *prj,
	const char* name
)
	:
	Inherited( parent, prj, name )
{
	QLabel* tmpQLabel;
	tmpQLabel = new QLabel( this, "Label_3" );
	tmpQLabel->setGeometry( 10, 10, 380, 70 );
	tmpQLabel->setText( "OK. All information collected. Now generation will start. An Editor with the generated Makefile will allow you to make changes before finally save the file." );
	tmpQLabel->setAlignment( 1057 );

	resize( 400, 150 );
}


Page4Data::~Page4Data()
{
}

const char *Page4Data::GetNextLabel()
{
  return "Finish";
}

void Page4Data::InitPage( bool dir )
{
  // Last page, nothing to initialize
  dir = dir;
}

void Page4Data::ExitPage( bool dir )
{
  // Last page, ignore direction
  dir = dir;
  itsProject->GenerateMakeFile();
}


MakeGen::MakeGen( Project *prj )
{
  AddPage( new Page1Data( this, prj ) );
  AddPage( new Page2Data( this, prj ) );
  AddPage( new Page3Data( this, prj ) );
  AddPage( new Page4Data( this, prj ) );
}

