/* Pixmap is a subclass from DlgObject. It's the interface from the
 * Pixmap editor modelled by PixmapWnd and the rest of dlgedit
 * It simply contains the interface from DlgObject and one PixmapWnd.
 */
#ifndef _Pixmap_included
#define _Pixmap_included

#include <qapp.h>
#include <qdir.h>
#include <qtstream.h>
#include <qfile.h>
#include <qfiledlg.h>
#include <qkeycode.h>
#include <qpopmenu.h>
#include <qmsgbox.h>
#include <qpixmap.h>

#include "DlgObject.h"

class PixmapWnd;

class Pixmap : public DlgObject
{
  Q_OBJECT

public: // ctor, dtor
  Pixmap( ProjectWnd &, const QString & );

  ~Pixmap();

public: // methods
  virtual QString GetType();
  virtual DlgObjectType GetObjType();
  // Retrieves Object Type

  virtual void GetGeneratedFiles( QString &, QString &, QString & );
  // Get back the generated Sources, Headers and Headers which contains
  // Metastructure and need to be compiled with moc
  // Is needed for Makefilegeneration.

    virtual void SetName( const QString &, bool = TRUE );
    // Set name

public slots:
  virtual bool Load();
  // Load from disk

  virtual bool Save();
  // Save to disk

  virtual bool Generate( bool = TRUE );
  // Generate c++ files (the object must be shown/loaded or not)

  virtual void Hide();
  // Hide from screen

  virtual void Show();
  // Show (again)

  virtual void Raise();
  // Raise Window

  virtual void CPAvailable( bool );
  // Somehow c&p data was made available

  void PixmapChanged();
  // Pixmap changed

signals:
  void Changed( DlgObject * );
  // DlgObject has changed, to be connected to DialogList

  void Closed( DlgObject * );
  // DlgObject was closed

  void Saved( DlgObject * );
  // Emitted after being saved

  void CPDataSet( DlgObject * );
  // Emitted after the c&p buffer was set by this object

private: // Attributes
  PixmapWnd *itsPixmapWnd;     

  QString itsPixmapName;
  QString itsPixmapFormat;
  // Filename and fileformat of the pixmap

  QString itsSource;
  QString itsHeader;
  // Generated files

  QString itsVarName;
  QString itsVarLengthName;
  // Variable names for generation

private slots:
  void RestorePixmap( QString &, QString & );

};
  
inline QString Pixmap::GetType()
{
  return "Pixmap";
}

inline DlgObjectType Pixmap::GetObjType()
{
  return DlgObject_Pixmap;
}

#endif
