#include <qframe.h>
#include <qstring.h>

#include "FramePage.h"

#include "widget/DlgWidget.h"

#define Inherited FramePageData

FramePage::FramePage
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    QFrame* frame = (QFrame*)widget->GetWidget();

    connect( itsShapes, SIGNAL(activated(int)), 
	     SLOT(ShapeChanged(int)) );
    connect( itsShadows, SIGNAL(activated(int)),
	     SLOT(ShadowChanged(int)) );
    
    itsShapes->setCurrentItem( frame->frameShape() );
    itsShadows->setCurrentItem( frame->frameShadow() >> 4 );
    itsAllowLines->setChecked( frame->lineShapesOk() );

    QString str;
    
    str.setNum( frame->lineWidth() );
    itsLineWidth->setText( str );
    str.setNum( frame->midLineWidth() );
    itsMidLineWidth->setText( str );
}


FramePage::~FramePage()
{
}


void FramePage::Apply( DlgWidget*	widget )
{
    QFrame* frame = (QFrame*)widget->GetWidget();
    
    frame->setFrameStyle( itsShapes->currentItem() | 
			  (itsShadows->currentItem() << 4) );
    
    // TODO: set linesOk field in DlgFrame object

    QString str = itsLineWidth->text();
    frame->setLineWidth( str.toInt() );
    str = itsMidLineWidth->text();
    frame->setMidLineWidth( str.toInt() );
}


void FramePage::ShapeChanged( int index )
{
    if( index == 0 )
    {
	itsShadows->setCurrentItem( 0 );
    }
    // only NoFrame can have None for shadow
    else if( itsShadows->currentItem() == 0 )
    {
	itsShadows->setCurrentItem( 1 );
    }
}


void FramePage::ShadowChanged( int index )
{
    if( (itsShapes->currentItem() == 0) && (index != 0) )
    {
	itsShadows->setCurrentItem( 0 );
    }
    else if( (itsShapes->currentItem() != 0) && (index == 0) )
    {
	itsShadows->setCurrentItem( 1 );
    }
}
