/**********************************************************************

	--- Dlgedit generated file ---

	File: SliderPage.cpp
	Last generated: Sun Apr 6 19:49:07 1997

 *********************************************************************/

#include <qslider.h>
#include <qstring.h>

#include "SliderPage.h"

#include "widget/DlgWidget.h"

#define Inherited SliderPageData

SliderPage::SliderPage
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    const QSlider* slider = (const QSlider*)widget->GetWidget();
    
    switch( slider->orientation() )
    {
	case QSlider::Horizontal:
	{
	    isHoriz->setChecked( TRUE );
	    break;
	}
	case QSlider::Vertical:
	{
	    isVert->setChecked( TRUE );
	    break;
	}
    }

    switch( ((QSlider*)slider)->tickmarks() )
    {
	case QSlider::NoMarks:
	{
	    isTickNone->setChecked( TRUE );
	    break;
	}
	case QSlider::Above:
	    // case QSlider::Left:
	{
	    isTickAboveLeft->setChecked( TRUE );
	    break;
	}
	case QSlider::Below:
	    //case QSlider::Right:
	{
	    isTickBelowRight->setChecked( TRUE );
	    break;
	}
	case QSlider::Both:
	{
	    isTickBoth->setChecked( TRUE );
	}
    }
    
    QString str;
    itsMinValue->setText( str.setNum( slider->minValue() ) );
    itsMaxValue->setText( str.setNum( slider->maxValue() ) );
    itsLineStep->setText( str.setNum( slider->lineStep() ) );
    itsPageStep->setText( str.setNum( slider->pageStep() ) );
    itsInitialValue->setText( str.setNum( slider->value() ) );
    itsTickInterval->setText( str.setNum( slider->tickInterval() ) );
    
    isTracking->setChecked( slider->tracking() );
}


SliderPage::~SliderPage()
{
}


void SliderPage::Apply( DlgWidget*	widget )
{
    QSlider* slide = (QSlider*)widget->GetWidget();
    
    QSlider::Orientation orient = QSlider::Vertical;
    
    if( isHoriz->isChecked() )
    {
	orient = QSlider::Horizontal;
    }
    
    slide->setOrientation( orient );

    QSlider::TickSetting tick = QSlider::NoMarks;
    
    if( isTickAboveLeft->isChecked() )
    {
	tick = QSlider::Above;
	// left is same enum value
    }
    else if( isTickBelowRight->isChecked() )
    {
	tick = QSlider::Below;
	// right is same enum value
    }
    else if( isTickBoth->isChecked() )
    {
	tick = QSlider::Both;
    }
    
    slide->setTickmarks( tick );
    
    QString str = itsMinValue->text();
    int min = str.toInt();
    str = itsMaxValue->text();
    int max = str.toInt();
    
    slide->setRange( min, max );
    
    str = itsLineStep->text();
    int line = str.toInt();
    str = itsPageStep->text();
    int page = str.toInt();
    
    slide->setSteps( line, page );
    
    str = itsInitialValue->text();
    slide->setValue( str.toInt() );

    str = itsTickInterval->text();
    slide->setTickInterval( str.toInt() );
    
    slide->setTracking( isTracking->isChecked() );
}
