#include "widget/DlgLabel.h"
#include "widget/DlgFrame.h"

#include "prop/FramePage.h"
#include "prop/LabelPage.h"

#define Inherited DlgWidget

int DlgLabel::itsNextWidgetNum = 1;

DlgLabel::DlgLabel
(
    QWidget*		parent,
    const char*	name
 )
    :
    Inherited( DlgWidget::DW_Label, parent )
{
    itsWidget = new Label( parent, CreateName( "Label", name, 
					       itsNextWidgetNum ));
    
    itsWidget->setMinimumSize( 10, 10 );
    itsWidget->setText( "Label:" );
}

DlgLabel::~DlgLabel()
{
}


void DlgLabel::GetPropertyPages
(
    QWidget*		parent,
    QList<QWidget>&	pages,
    QStrList&		labels
)
{
    pages.append( new FramePage( this, parent, "Frame" ) );
    pages.append( new LabelPage( this, parent, "Label" ) );

    labels.append( "Frame" );
    labels.append( "Label" );
}


void DlgLabel::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nLabel {";
  
    DlgLabel::SaveQt( stream, (const QLabel *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgLabel::SaveQt
(
   QTextStream &stream,
   const QLabel *widget
)
{
    if( widget->text() )
	stream << "\n\t\tText {" << widget->text() << "}";

    QString aStr;

    if( widget->alignment() != (AlignLeft | AlignVCenter | ExpandTabs) )
    {
	aStr.setNum( widget->alignment() );
	stream << "\n\t\tAlignment {" << aStr << "}";
    }

    stream << "\n\t\tAutoResize {";
    SaveBool( stream, widget->autoResize() );
    stream << "}";
    
    stream << "\n\t\tMargin {" << widget->margin() << "}";

    DlgFrame::SaveQt( stream, widget );
}

bool DlgLabel::RestoreKeyValue( QString &key, QString &value )
{
  bool retVal = TRUE;

  if( key == "Name" )
  {
      // Update the widget number so that no duplicate names are created
      UpdateNextWidgetNumber( value, itsNextWidgetNum );
  }

  if( ! DlgLabel::RestoreQt( key, value, (QLabel *) itsWidget ) )
  {  
    // At last DlgWidget catch the rest
    retVal = DlgWidget::RestoreKeyValue( key, value );
  }

  return retVal;
}

bool DlgLabel::RestoreQt
(
   const QString &key,
   const QString &value,
   QLabel *widget
)
{
    // Compare to known keys
    if( key == "Text" )
    {
	widget->setText( value );
    } 
    else if( key == "Alignment" )
    {
	widget->setAlignment( value.toInt() );
    }
    else if( key == "AutoResize" )
    {
	widget->setAutoResize( (value == "TRUE") );
    }
    else if( key == "Margin" )
    {
	widget->setMargin( value.toInt() );
    }
    else
    {
	// Key unknown
	return DlgFrame::RestoreQt( key, value, widget );
    }
    return TRUE;
}  


void DlgLabel::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgFrame::GenSrc( dlgWidget, stream, varName, zOrdering );

    const QLabel* widget = (const QLabel*)dlgWidget.GetWidget();

    if( widget->text() )
    {
	stream << varName << "setText( \"" << widget->text() << "\" );\n";
    }
    
    stream << varName << "setAlignment( " << widget->alignment() << " );\n";

    stream << varName << "setMargin( " << widget->margin() << " );\n";
}



