#include "widget/DlgProgressBar.h"
#include "widget/DlgFrame.h"

#include "prop/FramePage.h"
#include "prop/ProgressBarPage.h"

#define Inherited DlgWidget

int DlgProgressBar::itsNextWidgetNum = 1;

DlgProgressBar::DlgProgressBar
(
    QWidget*		parent,
    const char*	name
 )
    :
    Inherited( DlgWidget::DW_ProgressBar, parent )
{
    itsWidget = new ProgressBar( parent, CreateName( "ProgressBar", name, 
						     itsNextWidgetNum ));
    
    itsWidget->setMinimumSize( 10, 10 );
}

DlgProgressBar::~DlgProgressBar()
{
}


void DlgProgressBar::GetPropertyPages
(
    QWidget*		parent,
    QList<QWidget>&	pages,
    QStrList&		labels
)
{
    pages.append( new FramePage( this, parent, "Frame" ) );
    pages.append( new ProgressBarPage( this, parent, "ProgressBar" ) );

    labels.append( "Frame" );
    labels.append( "ProgressBar" );
}


void DlgProgressBar::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nProgressBar {";
  
    DlgProgressBar::SaveQt( stream, (const QProgressBar *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgProgressBar::SaveQt
(
   QTextStream &stream,
   const QProgressBar *widget
)
{
    stream << "\n\t\tTotalSteps {" << widget->totalSteps() << "}";
    stream << "\n\t\tProgress {" << widget->progress() << "}";

    DlgFrame::SaveQt( stream, widget );
}

bool DlgProgressBar::RestoreKeyValue( QString &key, QString &value )
{
  bool retVal = TRUE;

  if( key == "Name" )
  {
      // Update the widget number so that no duplicate names are created
      UpdateNextWidgetNumber( value, itsNextWidgetNum );
  }

  if( ! DlgProgressBar::RestoreQt( key, value, (QProgressBar *) itsWidget ) )
  {  
    // At last DlgWidget catch the rest
    retVal = DlgWidget::RestoreKeyValue( key, value );
  }

  return retVal;
}

bool DlgProgressBar::RestoreQt
(
   const QString &key,
   const QString &value,
   QProgressBar *widget
)
{
    bool rc = TRUE;

    // Compare to known keys
    if( key == "TotalSteps" )
    {
	widget->setTotalSteps( value.toInt() );
    }
    else if( key == "Progress" )
    {
	widget->setProgress( value.toInt() );
    }
    else
    {
	// Key unknown
	rc = DlgFrame::RestoreQt( key, value, widget );
    }

    return rc;
}  


void DlgProgressBar::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgFrame::GenSrc( dlgWidget, stream, varName, zOrdering );

    const QProgressBar* widget = (const QProgressBar*)dlgWidget.GetWidget();

    stream << varName << "setProgress( " << widget->progress() << " );\n";
}


void DlgProgressBar::GenerateCtor
(
    QTextStream&	stream,
    const QString&	varName
)
{
    QString name;
    const char* cp = GetWidget()->name();
    if( cp )
    {
	name = "\"";
	name += cp;
	name += "\"";
    }
    else
    {
	name = "NULL";
    }

    const QProgressBar* progbar = (const QProgressBar*)GetWidget();

    stream << '\t' << varName << " = new " << GetWidgetClass() << "( " <<
	progbar->totalSteps() << ", this, " <<name << " );\n";
}

