/*
 *
 * Gadget Editor -- a multiple purpose graphical editor
 * Copyright (C) 1999 by Mark-Andr Hopf
 *
 */

#include <toad/toad.hh>
#include <toad/gadgeteditor.hh>

class TMainWindow:
	public TFrame
{
		typedef TFrame super;
	public:
		TMainWindow(TWindow *parent, const string &title);
};

class TPaintArea:
	public TWindow
{
		typedef TWindow super;
	public:
		TPaintArea(TWindow *parent, 
							 const string &title,
							 TGadgetEditor *geditor);
		void mouseEvent(TOADBase::TMouseEvent&);
		void paint();
		
	protected:
		TGadgetEditor *geditor;
};

int ToadMain()
{
  return TWindow(NULL, "Gadget Editor").Run();
}

// TMainWindow
//---------------------------------------------------------------------------
TMainWindow::TMainWindow(TWindow *parent, const string &title):
	super(parent, title)
{
	static TGRectangle grect;

	geditor = new TGadgetEditor();
	TPaintArea *pa = new TPaintArea(this, "paintarea", geditor);
	
	TRadioState *state = new TRadioState();
	TWindow *prev = NULL;
	TFatRadioButton *rb;
	for(unsigned i=0; i<2; i++) {
		switch(i) {
			case 0:
				rb = new TFatRadioButton(this, "Select", state, i);
				rb->sigActivate.Add(geditor, &TGadgetEditor::SetMode, TGadgetEditor::MODE_SELECT);
				rb->SetToolTip("Markieren, Verschieben, Lschen, usw.");
				rb->SetDown(true);
				break;
			case 1:
				rb = new TFatRadioButton(this, "Rect", state, i);
				rb->sigActivate.Add(gedit, &TGadgetEditor::SetCreate, &grect);
				rb->SetToolTip("Ein neues Objekt erzeugen");
				break;
			case 2:
				rb = new TFatRadioButton(this, "Connect", state, i);
				rb->SetToolTip("Zwei Objekte miteinander verbinden");
				break;
		}
		rb->SetSize(80,TSIZE_PREVIOUS);
		Attach(rb, TOP, prev);
		Attach(rb, LEFT);
	}
	
	Attach(pa, LEFT, rb);
	Attach(pa, TOP|RIGHT|BOTTOM);
}

// TPaintArea
//---------------------------------------------------------------------------
TPaintArea::TPaintArea(TWindow *parent, const string &title):
	super(parent, title)
{
	geditor = new TGadgetEditor();
}

void TPaintArea::mouseEvent(TOADBase::TMouseEvent &event)
{
	geditor->mouseEvent(event);
}

void TPaintArea::paint()
{
	geditor->paint();
}
