/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/datamanipulator.hh>
#include <toad/control.hh>
#include <map>
#include <cstdio>

#define DBM(A)

TDataManipulator::~TDataManipulator()
{
}

TStringManipulator::~TStringManipulator()
{
}

TIntManipulator::~TIntManipulator()
{
}

TBoolManipulator::~TBoolManipulator()
{
}

// join pointers
//---------------------------------------------------------------------------

typedef map<void*, TDataManipulator*> TPointerMap;
static TPointerMap pointermap;

void TDataManipulator::_Register(TDataInterface *di, TDataManipulator *dm)
{
	DBM(cout << "Register  : " << di->Pointer() << ", " << dm << endl;)
	void *ptr = di->Pointer();
	TPointerMap::iterator p = pointermap.find(ptr);
	if (p==pointermap.end()) {
		DBM(cout << "            first" << endl;)
		pointermap[ptr] = dm;
		dm->_next = NULL;
	} else {
		DBM(cout << "            not first" << endl;)
		dm->_next = (*p).second;
		(*p).second = dm;
	}
}

void TDataManipulator::_Unregister(TDataInterface *di, TDataManipulator *dm)
{
	DBM(cout << "Unregister: " << di->Pointer() << ", " << dm <<endl;)

	void *ptr = di->Pointer();
	TPointerMap::iterator mp = pointermap.find(ptr);
	if (mp==pointermap.end()) {
		cerr << "TDataManipulator::_Unregister: no such pointer\n";
		return;
	}
	TDataManipulator *p = (*mp).second;
	if (p==dm) {
		if (p->_next==NULL) {
			DBM(cout << "            removing last entry\n";)
			pointermap.erase(mp);
		} else {
			(*mp).second = p->_next;
		}
	} else {
		while(p) {
			if (p->_next==dm) {
				DBM(cout << "            ok" << endl;)
				p->_next = p->_next->_next;
				return;
			}
			p = p->_next;
		}
		cerr << "TDataManipulator::_Unregister: no such data manipulator\n";
	}
}

void TDataManipulator::_Assimilate(TDataInterface *di, TDataManipulator *dm)
{
	void *ptr = di->Pointer();
	DBM(cout << "_Assimilate: " << di->Pointer()<< ", " << dm  << endl;)

	TPointerMap::iterator mp = pointermap.find(ptr);
	if (mp==pointermap.end()) {
		cerr << "TDataManipulator::_Assimilate: no such pointer\n";
		return;
	}
	TDataManipulator *p = (*mp).second;
	while(p) {
		if (p!=dm) {
			p->_assimilate();
		}
		p = p->_next;
	}
}

void TDataManipulator::Assimilate(const void *ptr)
{
	TPointerMap::const_iterator mp = pointermap.find(const_cast<void*>(ptr));
	if (mp==pointermap.end()) {
		cerr << "TDataManipulator::Assimilate: no such pointer\n";
		return;
	}
	DBM(cout << "Assimilate: " << ptr << ", " << (*mp).second << endl;)
	TDataManipulator *p = (*mp).second;
#if 0	
	// simulate a `_interface->SetX(data)'
	p->Interface()->_SetX(ptr);
	// now we have to convert the value behind `ptr' and copy it to
	// `TDataInterface::_global' but i don't know the type of `_global'
	// but the `p' object...?
	//
	// imagine `ptr' is a pointer to `int' and `p' is a string manipulator:
	// p->_interface->Allocate() 
	
	
	while(p) {
		p->_assimilate();
		p = p->_next;
	}
#else
	while(p) {
		#warning "using Reset() instead of _assimilate(), what's better?"
		p->Reset();
		p = p->_next;
	}
#endif
}

void TDataManipulator::Enable(const void *ptr)
{
	TPointerMap::const_iterator mp = pointermap.find(const_cast<void*>(ptr));
	if (mp==pointermap.end()) {
		cerr << "TDataManipulator::Enable: no such pointer\n";
		return;
	}
	TDataManipulator *p = (*mp).second;
	while(p) {
		TControl *ctrl = dynamic_cast<TControl*>(p);
		if (ctrl)
			ctrl->SetEnabled(true);
		p = p->_next;
	}
}

void TDataManipulator::Disable(const void *ptr)
{
	TPointerMap::const_iterator mp = pointermap.find(const_cast<void*>(ptr));
	if (mp==pointermap.end()) {
		cerr << "TDataManipulator::Enable: no such pointer\n";
		return;
	}
	TDataManipulator *p = (*mp).second;
	while(p) {
		TControl *ctrl = dynamic_cast<TControl*>(p);
		if (ctrl)
			ctrl->SetEnabled(false);
		p = p->_next;
	}
}
