/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/gadget.hh>
#include <toad/gadget/line.hh>

//!TGadget
//.<B>Attention: This class and is still under construction</B>
//?

void TGadget::InitStorage()
{
	serialize.SetVersion(3);
	serialize.Register(new TGText(),			"TOAD:TGText");
	serialize.Register(new TGFrame(),			"TOAD:TGFrame");
	serialize.Register(new TGLine(),			"TOAD:TGLine");
	serialize.Register(new TGRectangle(), "TOAD:TGRectangle");
	serialize.Register(new TGCircle(),		"TOAD:TGCircle");
	serialize.Register(new TGGroup(),			"TOAD:TGGroup");
	serialize.Register(new TGWindow(),		"TOAD:TGWindow");
}

void TGadget::LoseStorage()
{
	serialize.UnregisterAll();
}

TSerializeBase TGadget::serialize;

TGadget::TGadget()
{
	filled = false;
	removeable = false;
}

TGadget::~TGadget()
{
}

//. Called from the gadget editor when the gadget is selected.
//. <P>
//. The default behaviour is to draw small rectangles at the positions
//. delivered by <I>getHandle</I> or at the corners of the rectangle
//. delivered by <I>getShape</I> when <I>getHandle</I> returns `false'
//. for handle 0.
void TGadget::paintSelection(TPen &pen)
{
	pen.SetColor(0,0,0);
	unsigned h=0;
	TPoint pt;
	while(true) {
		if ( !getHandle(h, pt) )
			break;
		pen.FillRectangle(pt.x-2,pt.y-2,5,5);
		h++;
	}
	if (h==0) {
		TRectangle r;
		getShape(r);
		pen.FillRectangle(r.x-2				,r.y-2,5,5);
		pen.FillRectangle(r.x+r.w-1-2	,r.y-2,5,5);
		pen.FillRectangle(r.x+r.w-1-2	,r.y+r.h-1-2,5,5);
		pen.FillRectangle(r.x-2				,r.y+r.h-1-2,5,5);
	}
}

//. Return <I>true</I> and the position of handle <I>n</I> in <I>p</I> or
//. <I>false</I> when there's no handle <I>n</I>.
//. <BR>
//. The first handle is 0.
bool TGadget::getHandle(unsigned n, TPoint &p)
{
	return false;
}

//. Set handle <I>handle</I> to position (x,y).
void TGadget::translateHandle(unsigned handle, int x, int y)
{
}

void TGadget::store(TOutObjectStream &file, ulong version)
{
	if (version>=2) {
		file.WriteByte(line_color.r);
		file.WriteByte(line_color.g);
		file.WriteByte(line_color.b);
		if (filled) {
			file.WriteByte(1);
			file.WriteByte(fill_color.r);
			file.WriteByte(fill_color.g);
			file.WriteByte(fill_color.b);
		} else {
			file.WriteByte(0);
		}
	}
}

void TGadget::restore(TInObjectStream &file, ulong version)
{
	if (version>=2) {
		line_color.r = file.ReadByte();
		line_color.g = file.ReadByte();
		line_color.b = file.ReadByte();
		if (file.ReadByte()) {
			filled = true;
			fill_color.r = file.ReadByte();
			fill_color.g = file.ReadByte();
			fill_color.b = file.ReadByte();
		} else {
			filled = false;
		}
	}
}

// Returns the distance of point (x,y) to the line (x1,y1)-(x2,y2).
double TGadget::Distance2Line(int x, int y, int x1, int y1, int x2, int y2)
{
	double bx = x2 - x1;
	double by = y2 - y1;
	double ax = x-x1;
	double ay = y-y1;
	double lb = bx*bx+by*by;
	double t = (bx * ax + by * ay ) / lb;
	if (t<0.0 || t>1.0)
		return OUT_OF_RANGE;
	return fabs(by * ax - bx * ay) / sqrt(lb);
}
