// $Id: DialogWnd.cpp,v 1.2 1997/04/17 03:19:44 jharris Exp $

#include <qapp.h>
#include <qdatetm.h>
#include <qdir.h>
#include <qtstream.h>
#include <qfile.h>
#include <qfiledlg.h>
#include <qkeycode.h>
#include <qpopmenu.h>
#include <qmsgbox.h>
#include <qpixmap.h>

#include "ProjectWnd.h"
#include "DialogWnd.h"
#include "GenerateDialog.h"
#include "DlgParser.h"

#include "widget/DlgWidget.h"

#include "bmp/bitmaps.h"

#include "prop/DialogPropDialog.h"

#define Inherited QFrame

DialogWnd::DialogWnd( Dialog* dialog,
                      ProjectWnd *project,
                      const char* name )
  : 
  Inherited( NULL ),
  itsLayout( this, QBoxLayout::Down ),
  itsMenu( this ),
  itsToolbar( this ),
  itsAlignToolbar( this ),
  itsStatusBar( 20, this ),
  theProjectWnd( project ),
  itsDialog( dialog )
{
  QPixmap pixmap;

  setCaption( "Qt Dialog Editor" );
  //setFrameStyle( QFrame::Panel | QFrame::Raised );

  pixmap.loadFromData( Dlgedit_bmp_data, Dlgedit_bmp_len );
  setIcon( pixmap );
  setIconText( caption() );

  itsMenu.setFrameStyle( WinPanel | Raised );

  // create a new widget frame
  itsActWidgetWnd = new WidgetFrame( this, "WidgetFrame" );
  itsActWidgetWnd->setFrameStyle( QFrame::Raised | QFrame::WinPanel );

  // Create new layout
  itsActLayout = new WidgetLayout( this, name );

  itsActLayout->SetDlgEditWnd( itsActWidgetWnd );
  itsActLayout->SetNoMove( itsActWidgetWnd );
  itsActLayout->EnableLayout();

  itsActWidgetWnd->Init( itsActLayout );
  itsActWidgetWnd->show();

  // Dialog knows what to do when we want to close
  connect( this, SIGNAL(Closed()), dialog, SLOT(Hide()) );
  
  // Best for us if layout reports changes directly to dialog
  connect( itsActLayout, SIGNAL(Changed()), dialog, SLOT(LayoutChanged()) );

  connect( itsActLayout, SIGNAL(WidgetWndChanged()),SLOT(WidgetWndChanged()) );
  connect( itsActLayout, SIGNAL(WidgetGeometryChanged(int,int,int,int)),
	   SLOT(WidgetGeometryChanged(int,int,int,int)) );
  connect( itsActLayout, SIGNAL(WidgetSelected(const QString&,const QString&)),
	   SLOT(WidgetSelected(const QString&, const QString&)) );
  connect( itsActLayout, SIGNAL(WidgetDeselected()),
           SLOT(WidgetDeselected()) );

  // setup menu items
  QPopupMenu* file = new QPopupMenu;
  file->insertItem( "Save", dialog, SLOT(Save()), CTRL+Key_S );
  file->insertItem( "Generate Files", dialog, SLOT(Generate()), CTRL+Key_G );
  file->insertSeparator();
  file->insertItem( "Close", this, SLOT(Close()) );

  QPopupMenu* align = new QPopupMenu;
  align->insertItem( "Align Top", itsActLayout, SLOT(AlignTop()) );
  align->insertItem( "Align Bottom", itsActLayout, SLOT(AlignBottom()) );
  align->insertItem( "Align Left", itsActLayout, SLOT(AlignLeft()) );
  align->insertItem( "Align Right", itsActLayout, SLOT(AlignRight()) );
  align->insertSeparator();
  align->insertItem( "Same Width", itsActLayout, SLOT(SizeHorizontal()) );
  align->insertItem( "Same Height", itsActLayout, SLOT(SizeVertical()) );
  align->insertItem( "Same Size", itsActLayout, SLOT(SizeBothHV()) );
  
  itsEditMenu = new QPopupMenu;
  cutMenuId = itsEditMenu->insertItem( "Cut", dialog, 
                                       SLOT(CutSelectedWidgets()) );
  copyMenuId = itsEditMenu->insertItem( "Copy", dialog, 
                                        SLOT(CopySelectedWidgets()) );
  pasteMenuId = itsEditMenu->insertItem( "Paste", dialog, 
                                         SLOT(PasteSelectedWidgets()) );
  itsEditMenu->insertSeparator();
  itsEditMenu->insertItem( "Raise", this, SLOT(RaiseSelectedWidget()) );
  itsEditMenu->insertItem( "Lower", this, SLOT(LowerSelectedWidget()) );
  itsEditMenu->insertItem( "Align", align );
  itsEditMenu->insertSeparator();
  itsEditMenu->insertItem( "Delete", this, SLOT(DeleteSelectedWidget()) );

  itsEditMenu->setItemEnabled( cutMenuId, FALSE );
  itsEditMenu->setItemEnabled( copyMenuId, FALSE );
  itsEditMenu->setItemEnabled( pasteMenuId, FALSE );

  QPopupMenu* newWidget = new QPopupMenu;
  newWidget->insertItem( "Button", this, SLOT(NewButton()) );
  newWidget->insertItem( "Button Group", this, SLOT(NewButtonGroup()) );
  newWidget->insertItem( "Check Box", this, SLOT(NewCheckBox()) );
  newWidget->insertItem( "Combo Box", this, SLOT(NewComboBox()) );
  newWidget->insertItem( "Frame", this, SLOT(NewFrame()) );
  newWidget->insertItem( "Group Box", this, SLOT(NewGroupBox()) );
  newWidget->insertItem( "LCD Number", this, SLOT(NewLCDNumber()) );
  newWidget->insertItem( "Label", this, SLOT(NewLabel()) );
  newWidget->insertItem( "Line Edit", this, SLOT(NewLineEdit()) );
  newWidget->insertItem( "List Box", this, SLOT(NewListBox()) );
  newWidget->insertItem( "Menu Bar", this, SLOT(NewMenuBar()) );
  newWidget->insertItem( "Multi Line Edit", this, SLOT(NewMultiLineEdit()) );
  newWidget->insertItem( "Push Button", this, SLOT(NewPushButton()) );
  newWidget->insertItem( "Radio Button", this, SLOT(NewRadioButton()) );
  newWidget->insertItem( "Scroll Bar", this, SLOT(NewScrollBar()) );
  newWidget->insertItem( "Slider", this, SLOT(NewSlider()) );
  newWidget->insertItem( "User Widget", this, SLOT(NewUser()) );
    
  QPopupMenu* options = new QPopupMenu;
  options->insertItem( "Properties...", this, 
                       SLOT(SelectedWidgetProperties()));
  options->insertItem( "Grid...", this, SLOT(OptionsGrid()));

  itsMenu.insertItem( "Dialog", file );
  itsMenu.insertItem( "Edit", itsEditMenu );
  itsMenu.insertItem( "Widget", newWidget ); 
  itsMenu.insertItem( "Options", options );

  // insert menu into layout
  itsLayout.setMenuBar( &itsMenu );
 
  // setup toolbar with pixmaps

  pixmap.loadFromData( SaveDialogs_bmp_data, SaveDialogs_bmp_len );
  itsToolbar.Insert( pixmap, dialog, SLOT(Save()),
		     "Save Dialog" );
  pixmap.loadFromData( Generate_bmp_data, Generate_bmp_len );
  itsToolbar.Insert( pixmap, dialog, SLOT(Generate()),
		     "Generate Dialog" );
  
  itsToolbar.InsertSeparator();
  
  //pixmap.loadFromData( Button_bmp_data, Button_bmp_len );
  //itsToolbar.Insert( pixmap, this, SLOT(NewButton()), 
  //"New QButton", "Create a new QButton" );
  pixmap.loadFromData( PushButton_bmp_data, PushButton_bmp_len );
  itsToolbar.Insert( pixmap, this, SLOT(NewPushButton()),
		     "New QPushButton", "Create a new QPushButton" );
  pixmap.loadFromData( CheckBox_bmp_data,CheckBox_bmp_len  );
  itsToolbar.Insert( pixmap, this, SLOT(NewCheckBox()), 
		     "New QCheckBox", "Create a new QCheckBox" );
  pixmap.loadFromData( RadioButton_bmp_data, RadioButton_bmp_len );
  itsToolbar.Insert( pixmap, this, SLOT(NewRadioButton()),
		     "New QRadioButton", "Create a new QRadioButton" );
  pixmap.loadFromData( ButtonGroup_bmp_data, ButtonGroup_bmp_len );
  itsToolbar.Insert( pixmap, this, SLOT(NewButtonGroup()),
		     "New QButtonGroup", "Create a new QButtonGroup" );
  pixmap.loadFromData( Label_bmp_data, Label_bmp_len );
  itsToolbar.Insert( pixmap, this, SLOT(NewLabel()),
		     "New QLabel", "Create a new QLabel" );
  pixmap.loadFromData( LCDNumber_bmp_data, LCDNumber_bmp_len );
  itsToolbar.Insert( pixmap, this, SLOT(NewLCDNumber()),
		     "New QLCDNumber", "Create a new QLCDNumber" );
  pixmap.loadFromData( LineEdit_bmp_data, LineEdit_bmp_len );
  itsToolbar.Insert( pixmap, this, SLOT(NewLineEdit()),
		     "New QLineEdit", "Create a new QLineEdit" );
  pixmap.loadFromData( MultiLineEdit_bmp_data, MultiLineEdit_bmp_len );
  itsToolbar.Insert( pixmap, this, SLOT(NewMultiLineEdit()),
		     "New QMultiLineEdit", "Create a new QMultiLineEdit" );
  pixmap.loadFromData( ComboBox_bmp_data, ComboBox_bmp_len );
  itsToolbar.Insert( pixmap, this, SLOT(NewComboBox()),
		     "New QComboBox", "Create a new QComboBox" );
  pixmap.loadFromData( ListBox_bmp_data, ListBox_bmp_len );
  itsToolbar.Insert( pixmap, this, SLOT(NewListBox()),
		     "New QListBox", "Create a new QListBox" );
  pixmap.loadFromData( ScrollBar_bmp_data, ScrollBar_bmp_len );
  itsToolbar.Insert( pixmap, this, SLOT(NewScrollBar()),
		     "New QScrollBar", "Create a new QScrollBar" );
  pixmap.loadFromData( Slider_bmp_data, Slider_bmp_len );
  itsToolbar.Insert( pixmap, this, SLOT(NewSlider()),
		     "New QSlider", "Create a new QSlider" );
  pixmap.loadFromData( Frame_bmp_data, Frame_bmp_len );
  itsToolbar.Insert( pixmap, this, SLOT(NewFrame()),
		     "New QFrame", "Create a new QFrame" );
  pixmap.loadFromData( MenuBar_bmp_data, MenuBar_bmp_len );
  itsToolbar.Insert( pixmap, this, SLOT(NewMenuBar()),
		     "New QMenuBar", "Create a new QMenuBar" );
  pixmap.loadFromData( User_bmp_data, User_bmp_len );
  itsToolbar.Insert( pixmap, this, SLOT(NewUser()),
		     "New User Widget", 
		     "Create a new user defineable widget" );
  
  connect( &itsToolbar.GetToolTipGroup(), SIGNAL(showTip(const char*)),
	   SLOT(ShowToolTip(const char*)) );
  connect( &itsToolbar.GetToolTipGroup(), SIGNAL(removeTip()),
	   SLOT(RemoveToolTip()) );

  itsLayout.addSpacing( 3 );

  // add toolbar to layout
  itsLayout.addWidget( &itsToolbar );
  itsToolbar.setMinimumSize( itsToolbar.size() );
  //itsToolbar.setMinimumSize( 0, itsToolbar.geometry().height() );

  // setup alignment toolbar
  pixmap.loadFromData( AlignTop_bmp_data, AlignTop_bmp_len );
  itsAlignToolbar.Insert( pixmap, itsActLayout, SLOT(AlignTop()),
			  "Align Top", 
			  "Align selected widgets on the top" );
  pixmap.loadFromData( AlignBottom_bmp_data, AlignBottom_bmp_len );
  itsAlignToolbar.Insert( pixmap, itsActLayout, SLOT(AlignBottom()),
			  "Align Bottom",
			  "Align selected widgets on the bottom" );
  pixmap.loadFromData( AlignLeft_bmp_data, AlignLeft_bmp_len );
  itsAlignToolbar.Insert( pixmap, itsActLayout, SLOT(AlignLeft()),
			  "Align Left",
			  "Align selected widgets on the left" );
  pixmap.loadFromData( AlignRight_bmp_data, AlignRight_bmp_len );
  itsAlignToolbar.Insert( pixmap, itsActLayout, SLOT(AlignRight()),
			  "Align Right",
			  "Align selected widgets on the right" );
  itsAlignToolbar.InsertSeparator();
  pixmap.loadFromData( SizeHoriz_bmp_data, SizeHoriz_bmp_len );
  itsAlignToolbar.Insert( pixmap, itsActLayout, SLOT(SizeHorizontal()),
			  "Size Horizontally",
			  "Resize selected widgets horizontally" );
  pixmap.loadFromData( SizeVertical_bmp_data, SizeVertical_bmp_len );
  itsAlignToolbar.Insert( pixmap, itsActLayout, SLOT(SizeVertical()),
			  "Size Vertically",
			  "Resize selected widgets vertically" );
  pixmap.loadFromData( SizeHV_bmp_data, SizeHV_bmp_len );
  itsAlignToolbar.Insert( pixmap, itsActLayout, SLOT(SizeBothHV()),
			  "Size Horizontally and Vertically",
			  "Resize selected widgets horizontally and vertically" );
  

  connect( &itsAlignToolbar.GetToolTipGroup(), SIGNAL(showTip(const char*)),
	   SLOT(ShowToolTip(const char*)) );
  connect( &itsAlignToolbar.GetToolTipGroup(), SIGNAL(removeTip()),
	   SLOT(RemoveToolTip()) );

  // add toolbar to layout
  itsLayout.addWidget( &itsAlignToolbar );
  itsAlignToolbar.setMinimumSize( itsAlignToolbar.size() );
  //itsAlignToolbar.setMinimumSize( 0, itsAlignToolbar.geometry().height() );  

  itsLayout.addSpacing( 5 );

  // create a new layout to handle horizontal spacing of WidgetFrame
  QBoxLayout* dlgLayout = new QBoxLayout( QBoxLayout::LeftToRight, 5 );
  itsLayout.addLayout( dlgLayout, 1 );

  // set layout of horizontal layout
  dlgLayout->addSpacing( 5 );
  dlgLayout->addWidget( itsActWidgetWnd, 1, AlignTop );	
  itsActWidgetWnd->setFixedSize( 400, 300 );
  dlgLayout->addSpacing( 5 );
  dlgLayout->addStretch( 1 );

  itsLayout.addSpacing( 5 );
  itsLayout.addStretch( 1 );

  // setup status bar
  itsStatusMsg = itsStatusBar.InsertTextRegion( 1 );
  itsStatusBar.InsertSpacing( 5 );
  itsStatusPos = itsStatusBar.InsertTextRegion( 0, "X:000 Y:000" );
  itsStatusBar.SetText( itsStatusPos, "X:    Y:   " );
  itsStatusSize = itsStatusBar.InsertTextRegion( 0, "W:000 H:000");
  itsStatusBar.SetText( itsStatusSize, "W:    H:   " );
  
  // add status bar to layout
  itsLayout.addWidget( &itsStatusBar );
  itsStatusBar.setMinimumSize( 0, itsStatusBar.geometry().height() );

    // Start snapping
  itsActWidgetWnd->SetGrid( 10 );

  itsLayout.activate();

  // resize to minimum size
  resize( 0,0 );
}


DialogWnd::~DialogWnd()
{
}

void DialogWnd::resizeEvent
(
    QResizeEvent*	//event
)
{
    itsActWidgetWnd->resize( itsActWidgetWnd->maximumSize() );
    // itsWidgetFrame.setGeometry(QRect( itsWidgetFrame.geometry().topLeft(),
    //			      mapFromParent(geometry().bottomRight()) - QPoint(3,3)));
}


void DialogWnd::closeEvent
(
    QCloseEvent*	event
)
{
  // shut up
  event = event;
      
  emit Closed();
}


int DialogWnd::DoPropertyDialog( void )
{
    DialogPropDialog dlg( itsDialog );
    
    return dlg.exec();
}


void DialogWnd::NewButton()
{
    itsActLayout->AddWidget( DlgWidget::DW_Button );
}


void DialogWnd::NewButtonGroup()
{
    itsActLayout->AddWidget( DlgWidget::DW_ButtonGroup );
}


void DialogWnd::NewCheckBox()
{
    itsActLayout->AddWidget( DlgWidget::DW_CheckBox );
}


void DialogWnd::NewComboBox()
{
    itsActLayout->AddWidget( DlgWidget::DW_ComboBox );
}


void DialogWnd::NewFrame()
{
    itsActLayout->AddWidget( DlgWidget::DW_Frame );
}


void DialogWnd::NewGroupBox()
{
    itsActLayout->AddWidget( DlgWidget::DW_GroupBox );
}


void DialogWnd::NewLCDNumber()
{
    itsActLayout->AddWidget( DlgWidget::DW_LCDNumber );
}


void DialogWnd::NewLabel()
{
    itsActLayout->AddWidget( DlgWidget::DW_Label );
}


void DialogWnd::NewLineEdit()
{
    itsActLayout->AddWidget( DlgWidget::DW_LineEdit );
}


void DialogWnd::NewListBox()
{
    itsActLayout->AddWidget( DlgWidget::DW_ListBox );
}


void DialogWnd::NewMenuBar()
{
    itsActLayout->AddWidget( DlgWidget::DW_MenuBar );
}


void DialogWnd::NewMultiLineEdit()
{
    itsActLayout->AddWidget( DlgWidget::DW_MultiLineEdit );
}


void DialogWnd::NewPushButton()
{
    itsActLayout->AddWidget( DlgWidget::DW_PushButton );
}


void DialogWnd::NewRadioButton()
{
    itsActLayout->AddWidget( DlgWidget::DW_RadioButton );
}


void DialogWnd::NewScrollBar()
{
    itsActLayout->AddWidget( DlgWidget::DW_ScrollBar );
}


void DialogWnd::NewSlider()
{
    itsActLayout->AddWidget( DlgWidget::DW_Slider );
}


void DialogWnd::NewUser()
{
    itsActLayout->AddWidget( DlgWidget::DW_User );
}


void DialogWnd::RaiseSelectedWidget()
{
  if( itsActLayout )
    itsActLayout->RaiseSelectedWidget();
}

void DialogWnd::LowerSelectedWidget()
{
  if( itsActLayout )
    itsActLayout->LowerSelectedWidget();
}

void DialogWnd::DeleteSelectedWidget()
{
  if( itsActLayout )
    itsActLayout->DeleteSelectedWidget();
}


void DialogWnd::SelectedWidgetProperties()
{
  if( itsActLayout )
    itsActLayout->SelectedWidgetProperties();
}

void DialogWnd::OptionsGrid()
{
  if( itsActLayout )
    itsActLayout->OptionsGrid();
}

void DialogWnd::Close()
{
  // Not really closing the dialog here. Masterclass Dialog will hide us 
  // instead
  emit Closed();
}


void DialogWnd::WidgetWndChanged()
{
    itsLayout.activate();
}


void DialogWnd::WidgetGeometryChanged( int x, int y,
				       int width, int height )
{
    QString str;

    str.sprintf( "X:%3d Y:%3d", x, y );
    itsStatusBar.SetText( itsStatusPos, str );

    str.sprintf( "W:%3d H:%3d", width, height );
    itsStatusBar.SetText( itsStatusSize, str );
}


void DialogWnd::WidgetSelected( const QString&	widgetName,
				const QString&	varName )
{
    QString msg = widgetName.copy();

    if( !varName.isEmpty() )
    {
	msg += " (" + varName + ")";
    }

    itsLastStatusMsg = msg;
    itsStatusBar.SetText( itsStatusMsg, msg );

  if( theProjectWnd )
  {
    itsEditMenu->setItemEnabled( cutMenuId, TRUE );
    itsEditMenu->setItemEnabled( copyMenuId, TRUE );
  }
}

void DialogWnd::WidgetDeselected()
{
    itsLastStatusMsg = "";
    itsStatusBar.SetText( itsStatusMsg, itsLastStatusMsg );

    itsEditMenu->setItemEnabled( cutMenuId, FALSE );
    itsEditMenu->setItemEnabled( copyMenuId, FALSE );
}

void DialogWnd::ShowToolTip( const char* tip )
{
    itsStatusBar.SetText( itsStatusMsg, tip );
}


void DialogWnd::RemoveToolTip()
{
    itsStatusBar.SetText( itsStatusMsg, itsLastStatusMsg );
}

void DialogWnd::CPAvailable( bool av )
{
  itsEditMenu->setItemEnabled( pasteMenuId, av );
}
