// $Id: DialogWnd.h,v 1.2 1997/04/17 03:19:44 jharris Exp $

#ifndef DialogWnd_included
#define DialogWnd_included

#include <qframe.h>
#include <qmenubar.h>
#include <qstring.h>
#include <qlayout.h>

#include "WidgetLayout.h"
#include "WidgetFrame.h"
#include "Toolbar.h"
#include "StatusBar.h"

class Dialog;
class DlgParser;
class ProjectWnd;

class DialogWnd : public QFrame
{
    Q_OBJECT

public:
    DialogWnd
    ( 
	Dialog*,
	ProjectWnd *,
	const char* name = NULL 
    );

    virtual ~DialogWnd();

    int DoPropertyDialog( void );
    // show the property dialog

    WidgetLayout *GetLayout();
      
    void CPAvailable( bool );
    // C&P data available or not

public slots:

    void Close();
    // close window

signals:

    void Closed();
        
private: // methods

    void resizeEvent
    (
	QResizeEvent*	event
    );

    void closeEvent
    (
	QCloseEvent*	event
    );

    void ResetContents( void );
    // clear and reset the dialog

private slots:
         
    void NewButton();
    void NewButtonGroup();
    void NewCheckBox();
    void NewComboBox();
    void NewFrame();
    void NewGroupBox();
    void NewLCDNumber();
    void NewLabel();
    void NewLineEdit();
    void NewListBox();
    void NewMenuBar();
    void NewMultiLineEdit();
    void NewPushButton();
    void NewRadioButton();
    void NewScrollBar();
    void NewSlider();
    void NewUser();

    void RaiseSelectedWidget();
    void LowerSelectedWidget();
    void DeleteSelectedWidget();

    void SelectedWidgetProperties();
    void OptionsGrid();

    void WidgetWndChanged();

    void WidgetGeometryChanged( int, int, int, int );

    void WidgetSelected( const QString& widgetName, 
			 const QString& varName );
  void WidgetDeselected();

    void ShowToolTip( const char* );
    void RemoveToolTip();

private: // attributes

    QBoxLayout	itsLayout;
    // geometry layout manager

    QMenuBar		itsMenu;
    // the menu

    WidgetFrame* itsActWidgetWnd;
    // frame to hold the widgets

    WidgetLayout*	itsActLayout;
    // handles the layout of widgets on the window

    Toolbar	itsToolbar;
    // toolbar for the window

    Toolbar	itsAlignToolbar;
    // toolbar for alignment

    StatusBar	itsStatusBar;
    // status bar of the window

    uint	itsStatusMsg;
    uint	itsStatusPos;
    uint	itsStatusSize;
    // identifiers for status bar regions

    QString	itsLastStatusMsg;
    // the last status message that was not a tool tip

    QPopupMenu *itsEditMenu;
    // Have to remember it, because we want to disable items inside
          
    int cutMenuId, copyMenuId, pasteMenuId;
    // Menu ids
 
    ProjectWnd *theProjectWnd;
    // The application

    Dialog *itsDialog;
    // Its master class
};

    
typedef QList<DialogWnd> DlgList;


inline WidgetLayout *DialogWnd::GetLayout()
{
    return itsActLayout;
}

#endif // DialogWnd_included


