// $Id: DlgObject.cpp,v 1.3 1997/04/23 03:04:43 jharris Exp $

#include <qfile.h>
#include <qfiledlg.h>

#include "Dialog.h"
#include "Project.h"
#include "DlgObject.h"
#include "DlgParser.h"

QIntDict<char> DlgObject::itsExtensionDict;


/* Some of this code is not really used for now:
 *   - Enter/Leave Project are aware that a object could be in different 
 *     projects. This isn't implemented anywhere else.
 *   - Based upon this, Remove knows that the project from which it should
 *     remove the object has to be the first (and only) one in the list.
 *
 */ 

DlgObject *DlgObject::NewObject( ProjectWnd &prjWnd, const QString &fileName )
{
  DlgParser *itsParser = new DlgParser( fileName );
  DlgObject *retObj = NULL;

  if( ! itsParser->IsInitialized() )
    return NULL;

  QString type = itsParser->GetObjectType();
  
  if( type == "Dialog" )
    retObj = new Dialog( prjWnd, "" );
  else if( type == "Project" )
    retObj = new Project( prjWnd, "" );

  return retObj;
}

QPopupMenu &DlgObject::GetListPopup()
{
  QPopupMenu *retPopup = NULL;

  if( InProject() )
  {
    if( status == DlgObject_Hidden )
      retPopup = boundHiddenPopup;
    else
      retPopup = boundPopup;
  } else
  {
    if( status == DlgObject_Hidden )
      retPopup = unboundHiddenPopup;
    else
      retPopup = unboundPopup;
  }

  if( ! retPopup )
    fatal( "DlgObject (Type %d) misconfigured, %s in Project, status = %d",
           (int)GetObjType(), (InProject() ? "" : "not"), status );
           
  return *retPopup;
}


bool DlgObject::Remove()
{
  // XXXX Until I'm not absolut clear if this new style casts work OK under
  //      other c++ compilers, we have to leave them out, sigh...
  //  Project *prj = dynamic_cast<Project*>( itsProjects.first() );

  Project *prj = (Project *) itsProjects.first();
  if( ! prj )
    return FALSE;

  prj->RemoveFromProject( this );

  itsProjects.remove( prj );
  return TRUE;
}

bool DlgObject::SaveAs()
{
  QString name = QFileDialog::getSaveFileName( NULL, "*." + GetExtension() );

  if( name.isEmpty() )
    return FALSE;

  SetName( name );

  return Save();
}

bool DlgObject::EnterProject( const Project *prj )
{
  bool retVal = TRUE;

  if( itsProjects.findRef( prj ) == -1 )
    itsProjects.append( prj );
  else
    retVal = FALSE;

  return retVal;
}

bool DlgObject::LeaveProject( const Project *prj )
{
  return itsProjects.remove( prj );
}

bool DlgObject::InProject( const Project *prj )
{
  if( prj )
    return (itsProjects.findRef( prj ) != -1 );
  else
    return ! itsProjects.isEmpty();

  return FALSE;
}

DlgObject::DlgObject( ProjectWnd &prj, const QString &name )
  : QObject( NULL, name ),
    itsProjectWnd( prj )
{
  unboundPopup = NULL;
  unboundHiddenPopup = NULL;
  boundPopup = NULL;
  boundHiddenPopup = NULL;

  itsProjects.setAutoDelete( FALSE );

  status = DlgObject_Init;
}

DlgObject::~DlgObject()
{
  delete unboundPopup;
  delete boundPopup;
}


QString DlgObject::GetExtension( DlgObjectType	type )
{
    if( itsExtensionDict.isEmpty() )
    {
	itsExtensionDict.insert( DlgObject_Dialog, "dlg" );
	itsExtensionDict.insert( DlgObject_Project, "prj" );
    }
    
    return itsExtensionDict[ type ];
}
