// $Id: DlgParser.cpp,v 1.2 1997/04/17 03:19:45 jharris Exp $

#include <qmsgbox.h>

#include "DlgParser.h"

DlgParser *gDlgParser = NULL;

extern FILE *yyin;

DlgParser::DlgParser( const QString &inFile, char *name )
  : QObject( NULL, name )
{
  // Input stream OK ?
  if( ! (input = fopen( inFile, "r" ) ))
  {
    QString msg = "Couldn't open " + inFile + " for reading";
    QMessageBox::message( "Error...", msg, "OK" );
    initialized = FALSE;
    return;
  }

  // Read first line to retrieve version and type
  char line[256];
  fgets( line, 255, input );
  char *ptr = strtok( line, ":" );
  if( ! ptr )
  {
    // Old version, no information available
    QMessageBox::message( "Error...", 
                          "Please update this input file using DlgEditUpd",
                          "OK" );
    initialized = FALSE;
    return;
  }
  if( strcmp( ptr, "DlgEdit" ) )
  {
    // Unknown version, no information available
    QMessageBox::message( "Error...", 
                          "Unknown header",
                          "OK" );
    initialized = FALSE;
    return;
  }
  ptr = strtok( NULL, ":" );
  if( ! ptr )
  {
    // Unknown version, no information available
    QMessageBox::message( "Error...", 
                          "Header mismatch, No version or type information",
                          "OK" );
    initialized = FALSE;
    return;
  }
  version = ptr;
  ptr = strtok( NULL, ":" );
  if( ! ptr )
  {
    // Unknown version, no information available
    QMessageBox::message( "Error...", 
                          "Header mismatch, No version or type information",
                          "OK" );
    initialized = FALSE;
    return;
  }
  type = ptr;
  
  gDlgParser = this;

  yyin = input;

  // No Action
  action = FALSE;

  fileInfo.setFile( inFile );
  initialized = TRUE;
}

DlgParser::~DlgParser()
{
  if( input )
    fclose( input );
}

QString DlgParser::GetVersion()
{
  return version;
}

QString DlgParser::GetObjectType()
{
  return type;
}

void DlgParser::StartParsing( )
{
  // Action starting
  action = TRUE;

  // Parse until ready
  bool ready = FALSE;
  
  while( ! ready && action )
  {
    int retCode = yylex();
    
    switch( retCode )
    {
    case EndOfInput: 
      ready = TRUE;
      continue;
    case ProjectDataStart:
      emit NewProject();
      break;
    case DialogDataStart:
      emit NewDialog();
      break;
    case LayoutDataStart:
      emit NewLayout();
      break;
    case WidgetDataStart:
      emit NewWidget( widgetType );
      break;
    case ProjectDataEnd:
      emit EndDialog();
      break;
    case DialogDataEnd:
      emit EndDialog();
      break;
    case WidgetDataEnd:
      emit EndWidget( );
      break;
    case LayoutDataEnd:
      emit EndLayout( );
      break;
    case ProjectData:
      emit ProjectKeyValue( key, value );
      break;
    case DialogData:
      emit DlgKeyValue( key, value );
      break;
    case LayoutData:
      emit LayoutKeyValue( key, value );
      break;
    case WidgetData:
      emit WidgetKeyValue( key, value );
      break;
    case ErrorInInput:
      break;
    }

  }
}
void DlgParser::StopParsing()
{
  action = FALSE;
}
