// $Id: DlgParser.h,v 1.2 1997/04/17 03:19:45 jharris Exp $

#ifndef DlgParser_included
#define DlgParser_included

#include <stdio.h>
#include <qobject.h>
#include <qstring.h>
#include <qfileinf.h>

enum ParserRetCodes {
  EndOfInput,
  ProjectDataStart,
  ProjectData,
  ProjectDataEnd,
  DialogDataStart,
  DialogData,
  DialogDataEnd,
  LayoutDataStart,
  LayoutData,
  LayoutDataEnd,
  WidgetDataStart,
  WidgetData,
  WidgetDataEnd,

  ErrorInInput
};

class DlgParser : public QObject
{
  Q_OBJECT
public: 
  // Methods
  DlgParser( const QString &inFile, char *name = NULL );

  ~DlgParser();

  QString GetVersion();
  QString GetObjectType();

  void StartParsing();
  void StopParsing();

  bool IsInitialized() const;

  const QFileInfo &GetInfo() const;

signals:
  void NewProject();
  void ProjectKeyValue( QString &, QString & );
  void EndProject();
  void NewDialog();
  void DlgKeyValue( QString &, QString & );
  void EndDialog();
  void NewLayout();
  void LayoutKeyValue( QString &, QString & );
  void EndLayout();
  void NewWidget( QString & );
  void WidgetKeyValue( QString &, QString & );
  void EndWidget();
  
private:
  // Attributes
  QString type, version;
  // Type and version of the file 
  
  QString widgetType, key, value;
  int lineNumber, errorCount;
  // Attributes which are used by the generated lexer

  FILE *input;
  // Input file

  friend int yylex();
  // The generated lexer

  bool action;
  // Action

  QFileInfo fileInfo;
  // some Infos about the file

  bool initialized;
  // ctor says everything's ok
};

extern DlgParser *gDlgParser;

inline bool DlgParser::IsInitialized() const
{
  return initialized;
}

inline const QFileInfo &DlgParser::GetInfo() const
{
  return fileInfo;
}

#endif
